/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.osgi.filter.impl;

import java.util.Map;
import org.eclipse.buckminster.osgi.filter.impl.FilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubstringFilterImpl
extends FilterImpl {
    private final String[] m_value;

    SubstringFilterImpl(boolean topLevel, String attr, String[] value) {
        super(topLevel, 6, attr);
        this.m_value = value;
    }

    @Override
    String getValueAsString() {
        StringBuilder bld = new StringBuilder();
        int size = this.m_value.length;
        int i = 0;
        while (i < size) {
            String substr = this.m_value[i];
            if (substr == null) {
                bld.append('*');
            } else {
                bld.append(substr);
            }
            ++i;
        }
        return bld.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    boolean internalCompare(Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        String string = (String)value;
        int pos = 0;
        int i = 0;
        int size = this.m_value.length;
        while (i < size) {
            String substr = this.m_value[i];
            if (i + 1 < size) {
                if (substr == null) {
                    String substr2 = this.m_value[i + 1];
                    if (substr2 != null) {
                        int index = string.indexOf(substr2, pos);
                        if (index == -1) {
                            return false;
                        }
                        pos = index + substr2.length();
                        if (i + 2 < size) {
                            ++i;
                        }
                    }
                } else {
                    int len = substr.length();
                    if (!string.regionMatches(pos, substr, 0, len)) return false;
                    pos += len;
                }
            } else {
                if (substr != null) return string.endsWith(substr);
                return true;
            }
            ++i;
        }
        return true;
    }

    @Override
    boolean match0(Map<String, ? extends Object> properties) {
        Object prop = properties == null ? null : properties.get(this.getAttr());
        return prop instanceof String ? this.compare(prop) : false;
    }

    @Override
    void toString(StringBuilder sb) {
        sb.append('(');
        sb.append(this.getAttr());
        sb.append('=');
        int i = 0;
        int size = this.m_value.length;
        while (i < size) {
            String substr = this.m_value[i];
            if (substr == null) {
                sb.append('*');
            } else {
                sb.append(SubstringFilterImpl.encodeValue(substr));
            }
            ++i;
        }
        sb.append(')');
    }
}

