/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.buckminster.ant.types.FileSetGroup;
import org.eclipse.buckminster.pde.ant.TargetPlatformTask;
import org.eclipse.buckminster.pde.tasks.CreateProductBase;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CreateProductBaseTask
extends TargetPlatformTask {
    private boolean m_copyJavaLauncher = true;
    private String m_launcherNameProperty;
    private File m_outputDir;
    private File m_productFile;
    private ArrayList<FileSet> m_fileSets;
    private ArrayList<FileSetGroup> m_fileSetGroups;

    public void setLauncherNameProperty(String property) {
        this.m_launcherNameProperty = property;
    }

    public void add(FileSetGroup fsGroup) throws BuildException {
        if (this.m_fileSetGroups == null) {
            this.m_fileSetGroups = new ArrayList();
        }
        this.m_fileSetGroups.add(fsGroup);
    }

    public void addFileset(FileSet fs) throws BuildException {
        if (this.m_fileSets == null) {
            this.m_fileSets = new ArrayList();
        }
        this.m_fileSets.add(fs);
    }

    public void execute() throws BuildException {
        try {
            List files;
            if (this.m_fileSetGroups != null) {
                for (FileSetGroup fsg : this.m_fileSetGroups) {
                    for (FileSet fs : fsg.getFileSets()) {
                        this.addFileset(fs);
                    }
                }
                this.m_fileSetGroups = null;
            }
            Project proj = this.getProject();
            if (this.m_fileSets == null) {
                files = Collections.emptyList();
            } else {
                files = new ArrayList();
                for (FileSet fs : this.m_fileSets) {
                    DirectoryScanner ds = fs.getDirectoryScanner(proj);
                    File dir = fs.getDir(proj);
                    for (String file : ds.getIncludedFiles()) {
                        files.add(new File(dir, file));
                    }
                }
            }
            CreateProductBase createProduct = new CreateProductBase(this.m_productFile, files, (IPath)new Path(this.m_outputDir.toString()), this.getTargetLocation(), this.m_copyJavaLauncher);
            String launcherName = createProduct.execute();
            if (this.m_launcherNameProperty != null) {
                proj.setUserProperty(this.m_launcherNameProperty, launcherName);
            }
            for (Map.Entry hint : createProduct.getHints().entrySet()) {
                proj.setUserProperty((String)hint.getKey(), (String)hint.getValue());
            }
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e, this.getLocation());
        }
    }

    public void setCopyJavaLauncher(boolean flag) {
        this.m_copyJavaLauncher = flag;
    }

    public void setOutputDir(File outputDir) {
        this.m_outputDir = outputDir;
    }

    public void setProductFile(File productFile) {
        this.m_productFile = productFile;
    }
}

