/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.ant;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.buckminster.pde.internal.ImportBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ImportBundleTask
extends Task {
    private URL m_siteURL;
    private File m_destdir;
    private String m_bundleName;

    public void execute() throws BuildException {
        try {
            if (this.m_bundleName == null) {
                throw this.missingAttribute("bundleName");
            }
            if (this.m_destdir == null) {
                throw this.missingAttribute("destdir");
            }
            if (this.m_siteURL == null) {
                throw this.missingAttribute("siteURL");
            }
            ImportBundle importBundle = new ImportBundle(this.m_bundleName, this.m_siteURL, (IPath)new Path(this.m_destdir.toString()));
            importBundle.execute();
        }
        catch (Exception e) {
            throw new BuildException(e.toString(), (Throwable)e, this.getLocation());
        }
    }

    public void setBundleName(String bundleName) {
        this.m_bundleName = bundleName;
    }

    public void setDestdir(File destDir) {
        this.m_destdir = destDir;
    }

    public void setSiteDir(File siteDir) throws BuildException {
        try {
            this.m_siteURL = siteDir.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new BuildException(e.toString(), (Throwable)e, this.getLocation());
        }
    }

    public void setSiteURL(String siteURL) throws BuildException {
        try {
            this.m_siteURL = new URL(siteURL);
        }
        catch (MalformedURLException e) {
            throw new BuildException(e.toString(), (Throwable)e, this.getLocation());
        }
    }

    protected BuildException missingAttribute(String property) {
        return new BuildException("Missing attribute \"" + property + '\"', this.getLocation());
    }
}

