/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.buckminster.ant.types.FileSetGroup;
import org.eclipse.buckminster.pde.tasks.SourceFeatureCreator;

public class SourceFeatureCreatorTask
extends Task {
    private ArrayList<FileSet> m_fileSets;
    private ArrayList<FileSetGroup> m_fileSetGroups;
    private File m_input;
    private File m_output;

    public void add(FileSetGroup fsGroup) throws BuildException {
        if (this.m_fileSetGroups == null) {
            this.m_fileSetGroups = new ArrayList();
        }
        this.m_fileSetGroups.add(fsGroup);
    }

    public void addFileset(FileSet fs) throws BuildException {
        if (this.m_fileSets == null) {
            this.m_fileSets = new ArrayList();
        }
        this.m_fileSets.add(fs);
    }

    public void execute() throws BuildException {
        try {
            List featuresAndPlugins;
            if (this.m_fileSetGroups != null) {
                for (FileSetGroup fsg : this.m_fileSetGroups) {
                    for (FileSet fs : fsg.getFileSets()) {
                        this.addFileset(fs);
                    }
                }
                this.m_fileSetGroups = null;
            }
            if (this.getInput() == null) {
                throw new BuildException("Missing attribute input", this.getLocation());
            }
            if (this.getOutput() == null) {
                throw new BuildException("Missing attribute output", this.getLocation());
            }
            Project proj = this.getProject();
            if (this.m_fileSets == null) {
                featuresAndPlugins = Collections.emptyList();
            } else {
                featuresAndPlugins = new ArrayList();
                for (FileSet fs : this.m_fileSets) {
                    DirectoryScanner ds = fs.getDirectoryScanner(proj);
                    File dir = fs.getDir(proj);
                    for (String file : ds.getIncludedFiles()) {
                        featuresAndPlugins.add(new File(dir, file));
                    }
                }
            }
            SourceFeatureCreator fc = new SourceFeatureCreator(this.getInput(), this.getOutput(), featuresAndPlugins);
            fc.run();
        }
        catch (Exception e) {
            throw new BuildException(e.toString(), (Throwable)e, this.getLocation());
        }
    }

    public File getInput() {
        return this.m_input;
    }

    public File getOutput() {
        return this.m_output;
    }

    public void setInputFile(File input) {
        this.m_input = input;
    }

    public void setOutputFile(File output) {
        this.m_output = output;
    }
}

