/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde;

import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.buckminster.pde.IPDEConstants;
import org.eclipse.buckminster.runtime.LogAwarePlugin;
import org.eclipse.buckminster.runtime.Logger;
import org.osgi.framework.BundleContext;

public class PDEPlugin
extends LogAwarePlugin
implements IPDEConstants {
    private static final HashSet<String> s_namesOfInterest = new HashSet();
    private static PDEPlugin s_plugin;
    private static BundleContext s_context;
    private ResourceBundle m_resourceBundle;

    static {
        s_namesOfInterest.add("plugin.xml".toLowerCase());
        s_namesOfInterest.add("feature.xml".toLowerCase());
        s_namesOfInterest.add("site.xml".toLowerCase());
        s_namesOfInterest.add("fragment.xml".toLowerCase());
        s_namesOfInterest.add("build.properties".toLowerCase());
        s_namesOfInterest.add("MANIFEST.MF".toLowerCase());
    }

    public static BundleContext getContext() {
        return s_context;
    }

    public static PDEPlugin getDefault() {
        return s_plugin;
    }

    public static Logger getLogger() {
        return s_plugin.getBundleLogger();
    }

    public static String getPluginId() {
        return s_plugin.getBundle().getSymbolicName();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PDEPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public PDEPlugin() {
        s_plugin = this;
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.m_resourceBundle == null) {
                this.m_resourceBundle = ResourceBundle.getBundle("org.eclipse.buckminster.pde.PdePluginResources");
            }
        }
        catch (MissingResourceException x) {
            this.m_resourceBundle = null;
        }
        return this.m_resourceBundle;
    }

    public void start(BundleContext context) throws Exception {
        s_context = context;
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        s_context = null;
        s_plugin = null;
        this.m_resourceBundle = null;
    }
}

