/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.cspecgen;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.cspec.model.UpToDatePolicy;
import org.eclipse.buckminster.core.helpers.FileHandle;
import org.eclipse.buckminster.core.helpers.FilterUtils;
import org.eclipse.buckminster.core.helpers.PropertiesParser;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.OSGiVersion;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.pde.IPDEConstants;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.internal.EclipsePlatformReaderType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.iproduct.ILauncherInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.product.ProductModel;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CSpecGenerator
implements IBuildPropertiesConstants,
IPDEConstants {
    public static final IPath OUTPUT_DIR_JAR = OUTPUT_DIR.append("jar");
    public static final IPath OUTPUT_DIR_SOURCE_JAR = OUTPUT_DIR.append("source.jar");
    public static final IPath OUTPUT_DIR_FRAGMENTS = OUTPUT_DIR.append("fragments");
    public static final IPath OUTPUT_DIR_SITE = OUTPUT_DIR.append("site");
    public static final IPath OUTPUT_DIR_TEMP = OUTPUT_DIR.append("temp");
    public static final String LAUNCHER_BUNDLE = "org.eclipse.equinox.launcher";
    public static final String LAUNCHER_FEATURE_3_2 = "org.eclipse.platform.launchers";
    public static final String LAUNCHER_FEATURE = "org.eclipse.equinox.executable";
    private final CSpecBuilder m_cspecBuilder;
    private final ICatalogReader m_reader;
    private Map<String, String> m_properties;

    public static String convertMatchRule(int pdeMatchRule, String version) throws CoreException {
        if (version == null || version.length() == 0 || version.equals("0.0.0")) {
            return null;
        }
        char c = version.charAt(0);
        if (c == '[' || c == '(') {
            return version;
        }
        OSGiVersion v = (OSGiVersion)VersionFactory.OSGiType.fromString(version);
        boolean qualifierTag = "qualifier".equals(v.getQualifier());
        if (qualifierTag) {
            v = (OSGiVersion)v.replaceQualifier(null);
        }
        StringBuilder vbld = new StringBuilder();
        switch (pdeMatchRule) {
            case 3: {
                vbld.append('[');
                vbld.append(v);
                if (qualifierTag) {
                    vbld.append(".0,");
                    vbld.append(v.getMajor());
                    vbld.append('.');
                    vbld.append(v.getMinor());
                    vbld.append('.');
                    vbld.append(v.getMicro() + 1);
                    vbld.append(')');
                    break;
                }
                vbld.append(',');
                vbld.append(v);
                vbld.append(']');
                break;
            }
            case 1: {
                vbld.append('[');
                vbld.append(v);
                if (qualifierTag) {
                    vbld.append(".0");
                }
                vbld.append(',');
                vbld.append(v.getMajor());
                vbld.append('.');
                vbld.append(v.getMinor() + 1);
                vbld.append(".0)");
                break;
            }
            case 2: {
                vbld.append('[');
                vbld.append(v);
                if (qualifierTag) {
                    vbld.append(".0");
                }
                vbld.append(',');
                vbld.append(v.getMajor() + 1);
                vbld.append(".0.0)");
                break;
            }
            default: {
                vbld.append(v);
                if (!qualifierTag) break;
                vbld.append(".0");
            }
        }
        return vbld.toString();
    }

    protected static String buildArtifactName(String id, String ver, boolean asJar) {
        StringBuilder bld = new StringBuilder();
        bld.append(id);
        if (ver != null) {
            bld.append('_');
            bld.append(ver);
        }
        if (asJar) {
            bld.append(".jar");
        } else {
            bld.append('/');
        }
        return bld.toString();
    }

    protected CSpecGenerator(CSpecBuilder cspecBuilder, ICatalogReader reader) {
        this.m_cspecBuilder = cspecBuilder;
        this.m_reader = reader;
    }

    public abstract void generate(IProgressMonitor var1) throws CoreException;

    public CSpecBuilder getCSpec() {
        return this.m_cspecBuilder;
    }

    public ICatalogReader getReader() {
        return this.m_reader;
    }

    protected ActionBuilder addAntAction(String actionName, String targetName, boolean asPublic) throws CoreException {
        ActionBuilder action = this.m_cspecBuilder.addAction(actionName, asPublic, "ant", false);
        action.addActorProperty("targets", targetName, false);
        action.addActorProperty("buildFileId", "buckminster.pdetasks", false);
        return action;
    }

    protected void addBundleHostDependency(IFragmentModel fragmentModel) throws CoreException {
        IFragment fragment = fragmentModel.getFragment();
        ComponentRequestBuilder bundleHostDep = this.m_cspecBuilder.createDependencyBuilder();
        bundleHostDep.setName(fragment.getPluginId());
        bundleHostDep.setVersionDesignator(fragment.getPluginVersion(), "OSGi");
        bundleHostDep.setComponentTypeID("osgi.bundle");
        try {
            bundleHostDep.setFilter(FilterFactory.newInstance((String)"(bundleHost=true)"));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        this.addDependency(bundleHostDep);
    }

    protected boolean addDependency(ComponentRequestBuilder dependency) throws CoreException {
        return this.m_cspecBuilder.addDependency((IComponentRequest)dependency);
    }

    protected void addExternalPrerequisite(GroupBuilder group, String component, String type, String name, boolean optional) throws CoreException {
        PrerequisiteBuilder pqBld = group.createPrerequisiteBuilder();
        pqBld.setComponentName(component);
        pqBld.setComponentType(type);
        pqBld.setName(name);
        pqBld.setOptional(optional);
        group.addPrerequisite(pqBld);
    }

    protected void addProducts(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 2000);
        try {
            List productConfigs = this.m_reader.getRootFiles(PRODUCT_CONFIGURATION_FILE_PATTERN, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)500));
            if (productConfigs.size() > 0) {
                int ticksPerConfig = 1500 / productConfigs.size();
                for (FileHandle productConfig : productConfigs) {
                    this.addProduct(productConfig, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)ticksPerConfig));
                }
            }
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        monitor.done();
    }

    protected ActionBuilder createCopyPluginsAction() throws CoreException {
        ActionBuilder copyPlugins = this.addAntAction("copy.plugins", "copy.group", false);
        copyPlugins.addLocalPrerequisite("bundle.jars");
        copyPlugins.setPrerequisitesAlias("action.requirements");
        copyPlugins.setProductAlias("action.output");
        copyPlugins.setProductBase(OUTPUT_DIR_SITE.append("plugins"));
        copyPlugins.setUpToDatePolicy(UpToDatePolicy.MAPPER);
        return copyPlugins;
    }

    protected ActionBuilder createCopySourcePluginsAction() throws CoreException {
        ActionBuilder copyPlugins = this.addAntAction("copy.source.plugins", "copy.group", false);
        copyPlugins.addLocalPrerequisite("source.bundle.jars");
        copyPlugins.setPrerequisitesAlias("action.requirements");
        copyPlugins.setProductAlias("action.output");
        copyPlugins.setProductBase(OUTPUT_DIR_SITE.append("plugins"));
        copyPlugins.setUpToDatePolicy(UpToDatePolicy.MAPPER);
        return copyPlugins;
    }

    protected ComponentRequestBuilder createDependency(IPluginReference pluginReference, String category) throws CoreException {
        return this.createDependency(pluginReference.getId(), category, pluginReference.getVersion(), pluginReference.getMatch(), null);
    }

    protected ComponentRequestBuilder createDependency(String name, String componentType, String versionDesignator, Filter filter) throws CoreException {
        if (versionDesignator != null && (versionDesignator.length() == 0 || versionDesignator.equals("0.0.0"))) {
            versionDesignator = null;
        }
        ComponentRequestBuilder bld = this.getCSpec().createDependencyBuilder();
        bld.setName(name);
        bld.setComponentTypeID(componentType);
        bld.setVersionDesignator(versionDesignator, "OSGi");
        bld.setFilter(filter);
        return bld;
    }

    protected ComponentRequestBuilder createDependency(String name, String componentType, String version, int pdeMatchRule, Filter filter) throws CoreException {
        return this.createDependency(name, componentType, CSpecGenerator.convertMatchRule(pdeMatchRule, version), filter);
    }

    protected String expand(String value) throws CoreException {
        String expValue;
        if ((value = TextUtils.notEmptyTrimmedString((String)value)) == null) {
            return null;
        }
        if (value.charAt(0) != '%') {
            return value;
        }
        if (this.m_properties == null) {
            try {
                this.m_properties = (Map)this.m_reader.readFile(this.getPropertyFileName(), (IStreamConsumer)new PropertiesParser(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (FileNotFoundException e) {
                this.m_properties = Collections.emptyMap();
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        if ((expValue = this.m_properties.get(value.substring(1))) != null) {
            value = expValue;
        }
        return value;
    }

    protected AttributeBuilder generateRemoveDirAction(String dirTag, IPath dirPath, boolean publ) throws CoreException {
        return this.generateRemoveDirAction(dirTag, dirPath, publ, "buckminster.rm." + dirTag + ".dir");
    }

    protected AttributeBuilder generateRemoveDirAction(String dirTag, IPath dirPath, boolean publ, String actionName) throws CoreException {
        ActionBuilder rmDir = this.addAntAction(actionName, "delete.dir", publ);
        rmDir.addProperty("dir.to.delete", dirPath.toPortableString(), false);
        return rmDir;
    }

    protected abstract String getProductOutputFolder(String var1);

    protected abstract String getPropertyFileName();

    protected Set<String> getRequiredBundleNames(BundleDescription bundleDesc) {
        BundleSpecification[] rqBundles;
        HashSet<String> requiredBundles = null;
        if (bundleDesc != null && (rqBundles = bundleDesc.getRequiredBundles()) != null && rqBundles.length > 0) {
            requiredBundles = new HashSet<String>();
            BundleSpecification[] bundleSpecificationArray = rqBundles;
            int n = rqBundles.length;
            int n2 = 0;
            while (n2 < n) {
                BundleSpecification rqBundle = bundleSpecificationArray[n2];
                requiredBundles.add(rqBundle.getName());
                ++n2;
            }
        }
        return requiredBundles;
    }

    protected void setFilter(String filterStr) throws CoreException {
        if ((filterStr = TextUtils.notEmptyTrimmedString((String)filterStr)) == null) {
            return;
        }
        try {
            Filter filter = FilterFactory.newInstance((String)filterStr);
            this.getCSpec().setFilter(FilterUtils.replaceAttributeNames((Filter)filter, (String)"osgi", (String)"target"));
        }
        catch (InvalidSyntaxException e) {
            NodeQuery query = this.m_reader.getNodeQuery();
            Status status = new Status(2, PDEPlugin.getPluginId(), String.valueOf(Messages.manifest_has_malformed_LDAP_rule_for) + "Eclipse-PlatformFilter" + ": " + e.getMessage());
            RMContext ctx = query.getContext();
            if (!ctx.isContinueOnError()) {
                throw new CoreException((IStatus)status);
            }
            ctx.addRequestStatus((IComponentRequest)query.getComponentRequest(), (IStatus)status);
        }
    }

    protected boolean skipComponent(ComponentQuery query, ComponentRequestBuilder bld) {
        return query.skipComponent(new ComponentName(bld.getName(), bld.getComponentTypeID()));
    }

    private void addProduct(FileHandle productConfig, IProgressMonitor monitor) throws CoreException, IOException {
        BufferedInputStream stream = null;
        try {
            IPluginModelBase launcherBundle;
            IVersion version;
            ComponentRequestBuilder dep;
            IProductFeature[] iProductFeatureArray;
            stream = new BufferedInputStream(new FileInputStream(productConfig.getFile()));
            ProductModel model = new ProductModel();
            model.load((InputStream)stream, true);
            IProduct product = model.getProduct();
            CSpecBuilder cspec = this.getCSpec();
            ActionBuilder createProduct = this.addAntAction("create." + product.getId(), "create.eclipse.product", true);
            ILauncherInfo info = product.getLauncherInfo();
            if (info != null && "_removethisfile".equalsIgnoreCase(info.getLauncherName())) {
                createProduct.addProperty("buckminster.eclipse.deleteuilauncher", "true", false);
            }
            createProduct.addProperty("buckminster.eclipse.productFile", productConfig.getName(), false);
            AttributeBuilder rootFiles = cspec.getAttribute("product.root.files");
            ComponentQuery query = this.m_reader.getNodeQuery().getComponentQuery();
            GroupBuilder bundleJars = cspec.getRequiredGroup("bundle.jars");
            if (product.useFeatures()) {
                iProductFeatureArray = product.getFeatures();
                int n = iProductFeatureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProductFeature feature = iProductFeatureArray[n2];
                    dep = this.createDependency(feature.getId(), "eclipse.feature", feature.getVersion(), 3, null);
                    if (dep.getName().equals(cspec.getName())) {
                        createProduct.addLocalPrerequisite("feature.exports");
                    } else if (!this.skipComponent(query, dep)) {
                        this.addDependency(dep);
                        createProduct.addExternalPrerequisite(dep.getName(), dep.getComponentTypeID(), "feature.exports");
                    }
                    ++n2;
                }
            } else {
                iProductFeatureArray = product.getPlugins();
                int n = iProductFeatureArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IProductFeature plugin = iProductFeatureArray[n3];
                    dep = this.createDependency(plugin.getId(), "osgi.bundle", null, null);
                    if (!dep.getName().equals(cspec.getName()) && !this.skipComponent(query, dep) && this.addDependency(dep)) {
                        bundleJars.addExternalPrerequisite(dep.getName(), dep.getComponentTypeID(), "bundle.jars");
                    }
                    ++n3;
                }
                GroupBuilder featureExports = cspec.addGroup("feature.exports", true);
                featureExports.addLocalPrerequisite((AttributeBuilder)this.createCopyPluginsAction());
                featureExports.setPrerequisiteRebase(OUTPUT_DIR_SITE);
                createProduct.addLocalPrerequisite((AttributeBuilder)featureExports);
                IFeatureModel launcherFeature = EclipsePlatformReaderType.getBestFeature(LAUNCHER_FEATURE, null, null);
                if (launcherFeature == null) {
                    launcherFeature = EclipsePlatformReaderType.getBestFeature(LAUNCHER_FEATURE_3_2, null, null);
                }
                if (launcherFeature != null) {
                    IFeature feature = launcherFeature.getFeature();
                    version = VersionFactory.OSGiType.fromString(feature.getVersion());
                    dep = this.createDependency(feature.getId(), "eclipse.feature", version.toString(), 3, null);
                    if (this.addDependency(dep)) {
                        if (rootFiles == null) {
                            rootFiles = cspec.addGroup("product.root.files", true);
                        }
                        ((GroupBuilder)rootFiles).addExternalPrerequisite(dep.getName(), dep.getComponentTypeID(), "product.root.files");
                        featureExports.addExternalPrerequisite(dep.getName(), dep.getComponentTypeID(), "feature.exports");
                    }
                }
            }
            boolean hasLauncherFeature = false;
            for (ComponentRequestBuilder dep2 : cspec.getDependencies()) {
                if (dep2.getComponentTypeID() != "eclipse.feature" || !dep2.getName().equals(LAUNCHER_FEATURE) && !dep2.getName().equals(LAUNCHER_FEATURE_3_2)) continue;
                hasLauncherFeature = true;
                break;
            }
            if (!hasLauncherFeature && (launcherBundle = EclipsePlatformReaderType.getBestPlugin(LAUNCHER_BUNDLE, null, null)) != null) {
                IPluginBase plugin = launcherBundle.getPluginBase();
                version = VersionFactory.OSGiType.fromString(plugin.getVersion());
                dep = this.createDependency(plugin.getId(), "osgi.bundle", version.toString(), 3, null);
                if (this.addDependency(dep)) {
                    bundleJars.addExternalPrerequisite(dep.getName(), dep.getComponentTypeID(), "bundle.jars");
                }
            }
            if (rootFiles != null) {
                createProduct.addLocalPrerequisite(rootFiles);
            }
            createProduct.setPrerequisitesAlias("action.requirements");
            createProduct.setProductAlias("action.output");
            createProduct.setProductBase(OUTPUT_DIR);
            createProduct.setUpToDatePolicy(UpToDatePolicy.NOT_EMPTY);
            String outputFolder = TextUtils.notEmptyTrimmedString((String)this.getProductOutputFolder(product.getId()));
            if (outputFolder == null) {
                ILauncherInfo launcherInfo = product.getLauncherInfo();
                if (launcherInfo != null && (outputFolder = TextUtils.notEmptyTrimmedString((String)launcherInfo.getLauncherName())) != null && outputFolder.endsWith(".exe")) {
                    outputFolder = outputFolder.substring(0, outputFolder.length() - 4);
                }
                if (outputFolder == null) {
                    outputFolder = "eclipse";
                }
            }
            createProduct.addProductPath(Path.fromPortableString((String)outputFolder).addTrailingSeparator());
        }
        catch (Throwable throwable) {
            IOUtils.close(stream);
            if (productConfig.isTemporary()) {
                productConfig.getFile().delete();
            }
            throw throwable;
        }
        IOUtils.close((Closeable)stream);
        if (productConfig.isTemporary()) {
            productConfig.getFile().delete();
        }
    }
}

