/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.cspecgen.bundle;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.ctype.MissingCSpecSourceException;
import org.eclipse.buckminster.core.helpers.AccessibleByteArrayOutputStream;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.opml.builder.OPMLBuilder;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.cspecgen.CSpecGenerator;
import org.eclipse.buckminster.pde.cspecgen.PDEBuilder;
import org.eclipse.buckminster.pde.cspecgen.bundle.CSpecFromBinary;
import org.eclipse.buckminster.pde.cspecgen.bundle.CSpecFromSource;
import org.eclipse.buckminster.pde.internal.EclipseImportReader;
import org.eclipse.buckminster.pde.internal.EclipsePlatformReader;
import org.eclipse.buckminster.pde.internal.model.ExternalBuildModel;
import org.eclipse.buckminster.pde.internal.model.ExternalBundleModel;
import org.eclipse.buckminster.pde.internal.model.ExternalExtensionsModel;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.core.bundle.BundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;

public class BundleBuilder
extends PDEBuilder
implements IBuildPropertiesConstants {
    public static IPluginModelBase parsePluginModelBase(ICatalogReader reader, boolean forResolutionAidOnly, IProgressMonitor monitor) throws CoreException {
        if (reader instanceof EclipsePlatformReader) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            try {
                return ((EclipsePlatformReader)reader).getPluginModelBase();
            }
            catch (IllegalStateException e) {
                throw new MissingCSpecSourceException(reader.getProviderMatch());
            }
        }
        monitor.beginTask(null, 7000);
        try {
            boolean fragment = false;
            ExternalBundleModel model = new ExternalBundleModel();
            BundleBuilder.loadModel(reader, "META-INF/MANIFEST.MF", (IModel)model, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
            if (model.getBundle().getHeader("Bundle-SymbolicName") == null) {
                throw new FileNotFoundException(Messages.not_an_OSGi_manifest);
            }
            fragment = model.isFragmentModel();
            BundleFragmentModel bmodel = fragment ? new BundleFragmentModel() : new BundlePluginModel();
            bmodel.setBundleModel((IBundleModel)model);
            bmodel.setEnabled(true);
            if (forResolutionAidOnly) {
                BundleFragmentModel bundleFragmentModel = bmodel;
                return bundleFragmentModel;
            }
            try {
                String extensionsFile = fragment ? "fragment.xml" : "plugin.xml";
                ExternalExtensionsModel extModel = new ExternalExtensionsModel();
                BundleBuilder.loadModel(reader, extensionsFile, (IModel)extModel, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
                bmodel.setExtensionsModel((ISharedExtensionsModel)extModel);
            }
            catch (FileNotFoundException extensionsFile) {
                // empty catch block
            }
            try {
                ExternalBuildModel buildModel = new ExternalBuildModel();
                BundleBuilder.loadModel(reader, "build.properties", (IModel)buildModel, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
                bmodel.setBuildModel((IBuildModel)buildModel);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            BundleFragmentModel bundleFragmentModel = bmodel;
            return bundleFragmentModel;
        }
        catch (FileNotFoundException fragment) {
            try {
                ExternalPluginModel pm = new ExternalPluginModel();
                BundleBuilder.loadModel(reader, "plugin.xml", (IModel)pm, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
                ExternalPluginModel externalPluginModel = pm;
                return externalPluginModel;
            }
            catch (FileNotFoundException pm) {
                try {
                    ExternalFragmentModel pm2 = new ExternalFragmentModel();
                    BundleBuilder.loadModel(reader, "fragment.xml", (IModel)pm2, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
                    ExternalFragmentModel externalFragmentModel = pm2;
                    return externalFragmentModel;
                }
                catch (FileNotFoundException e1) {
                    throw new MissingCSpecSourceException(reader.getProviderMatch());
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void loadModel(ICatalogReader reader, String file, final IModel model, IProgressMonitor monitor) throws CoreException, FileNotFoundException {
        try {
            reader.readFile(file, (IStreamConsumer)new IStreamConsumer<Object>(){

                public Object consumeStream(IComponentReader fileReader, String streamName, InputStream stream, IProgressMonitor mon) throws CoreException {
                    byte[] buf = new byte[4096];
                    AccessibleByteArrayOutputStream bld = new AccessibleByteArrayOutputStream();
                    try {
                        int len;
                        while ((len = stream.read(buf)) > 0) {
                            int idx = 0;
                            while (idx < len) {
                                byte b = buf[idx];
                                if (b != 13) {
                                    bld.write((int)b);
                                }
                                ++idx;
                            }
                        }
                    }
                    catch (IOException e) {
                        throw BuckminsterException.wrap((Throwable)e);
                    }
                    model.load(bld.getInputStream(), true);
                    return null;
                }
            }, monitor);
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public String getComponentTypeID() {
        return "osgi.bundle";
    }

    protected void parseFile(CSpecBuilder cspecBuilder, boolean forResolutionAidOnly, ICatalogReader reader, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 100);
        try {
            IPluginBase pluginBase = BundleBuilder.parsePluginModelBase(reader, forResolutionAidOnly, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50)).getPluginBase();
            cspecBuilder.setName(pluginBase.getId());
            cspecBuilder.setComponentTypeID(this.getComponentTypeID());
            cspecBuilder.setVersion(pluginBase.getVersion(), "OSGi");
            if (forResolutionAidOnly) {
                return;
            }
            IPluginModelBase model = pluginBase.getPluginModel();
            this.setModel((IModel)model);
            IBuildModel buildModel = model.getBuildModel();
            boolean fromProject = buildModel != null;
            CSpecGenerator generator = fromProject ? new CSpecFromSource(cspecBuilder, reader, pluginBase, buildModel) : new CSpecFromBinary(cspecBuilder, reader, pluginBase);
            generator.generate(monitor);
        }
        finally {
            monitor.done();
        }
    }

    protected Resolution createResolution(IComponentReader reader, CSpecBuilder cspecBuilder, OPMLBuilder opmlBuilder) throws CoreException {
        if (reader instanceof EclipseImportReader) {
            EclipseImportReader eclipseImportReader = (EclipseImportReader)reader;
            return super.createResolution(reader, cspecBuilder, opmlBuilder, eclipseImportReader.isUnpack());
        }
        return super.createResolution(reader, cspecBuilder, opmlBuilder);
    }
}

