/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.cspecgen.bundle;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.model.ComponentName;
import org.eclipse.buckminster.core.cspec.model.UpToDatePolicy;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.pde.cspecgen.CSpecGenerator;
import org.eclipse.buckminster.pde.internal.model.ExternalBundleModel;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;

public class CSpecFromBinary
extends CSpecGenerator {
    private static final String SYSTEM_BUNDLE = "org.eclipse.osgi";
    private static final ComponentName SYSTEM_BUNDLE_CNAME = new ComponentName("org.eclipse.osgi", "osgi.bundle");
    private final IPluginBase m_plugin;

    public CSpecFromBinary(CSpecBuilder cspecBuilder, ICatalogReader reader, IPluginBase plugin) {
        super(cspecBuilder, reader);
        this.m_plugin = plugin;
    }

    public void generate(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 20);
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder classpath = cspec.addGroup("java.binaries", true);
        GroupBuilder bundleJars = cspec.addGroup("bundle.jars", true);
        GroupBuilder bundleAndFragments = cspec.addGroup("bundle.and.fragments", true);
        bundleJars.addLocalPrerequisite((AttributeBuilder)bundleAndFragments);
        cspec.addGroup("bundle.and.fragments.source", true);
        IPluginModelBase model = this.m_plugin.getPluginModel();
        if (model instanceof IFragmentModel) {
            this.addBundleHostDependency((IFragmentModel)model);
        } else {
            ActionBuilder copyTargetFragments = cspec.addAction("target.fragments", false, "copyTargetFragments", false);
            copyTargetFragments.setProductAlias("action.output");
            copyTargetFragments.setProductBase(OUTPUT_DIR_FRAGMENTS);
            copyTargetFragments.setUpToDatePolicy(UpToDatePolicy.ACTOR);
            bundleAndFragments.addLocalPrerequisite((AttributeBuilder)copyTargetFragments);
        }
        this.addImports();
        MonitorUtils.worked((IProgressMonitor)monitor, (int)10);
        Path parentDir = new Path("..");
        String location = model.getInstallLocation();
        File locationFile = location != null ? new File(location) : null;
        boolean isFile = locationFile != null && locationFile.isFile();
        cspec.setShortDesc(this.expand(this.m_plugin.getName()));
        if (isFile) {
            cspec.addGroup(ATTRIBUTE_FULL_CLEAN, true);
            ArtifactBuilder pluginExport = cspec.addArtifact("bundle.jar", true, "bundle.jar", null);
            pluginExport.addPath((IPath)new Path(this.buildArtifactName(true)));
            pluginExport.setBase((IPath)parentDir);
            classpath.addLocalPrerequisite((AttributeBuilder)pluginExport);
            bundleAndFragments.addLocalPrerequisite((AttributeBuilder)pluginExport);
        } else {
            ActionBuilder bundleExport;
            IBundle bundle;
            block21: {
                bundle = null;
                if (this.m_plugin instanceof BundlePluginBase) {
                    bundle = ((BundlePluginBase)this.m_plugin).getBundle();
                } else if (locationFile != null && locationFile.isDirectory()) {
                    BufferedInputStream input = null;
                    try {
                        try {
                            input = new BufferedInputStream(new FileInputStream(new File(locationFile, "META-INF/MANIFEST.MF")));
                            ExternalBundleModel ebm = new ExternalBundleModel();
                            ebm.load(input, false);
                            bundle = ebm.getBundle();
                        }
                        catch (IOException ebm) {
                            IOUtils.close(input);
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(input);
                        throw throwable;
                    }
                    IOUtils.close((Closeable)input);
                }
            }
            String bundleClassPath = null;
            if (bundle != null) {
                bundleClassPath = bundle.getHeader("Bundle-ClassPath");
                this.setFilter(bundle.getHeader("Eclipse-PlatformFilter"));
            }
            String jarName = this.buildArtifactName(true);
            boolean isImportedBundle = false;
            ArtifactBuilder bundleClasspath = null;
            if (bundleClassPath == null) {
                classpath.addSelfRequirement();
            } else {
                bundleClasspath = cspec.addArtifact("bundle.classpath", false, "java.binaries", null);
                StringTokenizer tokens = new StringTokenizer(bundleClassPath, ",");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken().trim();
                    if (token.equals(jarName)) {
                        isImportedBundle = true;
                    }
                    bundleClasspath.addPath((IPath)new Path(token));
                }
                classpath.addLocalPrerequisite((AttributeBuilder)bundleClasspath);
            }
            if (!isImportedBundle) {
                bundleExport = this.addAntAction("bundle.jar", "recreate.jar", true);
                bundleExport.addProductPath(Path.fromPortableString((String)jarName));
                bundleExport.getPrerequisitesBuilder().addSelfRequirement();
            } else {
                bundleExport = this.addAntAction("bundle.jar", "copy.group", true);
                if (bundleClasspath.getPaths().size() == 1) {
                    bundleExport.getPrerequisitesBuilder().addLocalPrerequisite((AttributeBuilder)bundleClasspath);
                } else {
                    ArtifactBuilder importedJar = cspec.addArtifact("imported.jar", false, "java.binaries", null);
                    importedJar.addPath(Path.fromPortableString((String)jarName));
                    bundleExport.getPrerequisitesBuilder().addLocalPrerequisite((AttributeBuilder)importedJar);
                }
            }
            bundleExport.setProductAlias("action.output");
            bundleExport.setProductBase(OUTPUT_DIR);
            bundleExport.setPrerequisitesAlias("action.requirements");
            bundleAndFragments.addLocalPrerequisite((AttributeBuilder)bundleExport);
            this.generateRemoveDirAction("build", OUTPUT_DIR, true, ATTRIBUTE_FULL_CLEAN);
        }
        monitor.done();
    }

    protected String getProductOutputFolder(String productId) {
        return null;
    }

    protected String getPropertyFileName() {
        return "plugin.properties";
    }

    private void addImports() throws CoreException {
        IPluginModelBase model = this.m_plugin.getPluginModel();
        Set<String> requiredBundles = this.getRequiredBundleNames(model.getBundleDescription());
        IPluginImport[] imports = this.m_plugin.getImports();
        boolean isFragment = model.isFragmentModel();
        ComponentQuery query = this.getReader().getNodeQuery().getComponentQuery();
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder reExports = cspec.getRequiredGroup("java.binaries");
        GroupBuilder bundleJars = cspec.getRequiredGroup("bundle.jars");
        if (imports == null || imports.length == 0) {
            if (!(isFragment || SYSTEM_BUNDLE.equals(cspec.getName()) || query.skipComponent(SYSTEM_BUNDLE_CNAME))) {
                cspec.addDependency((IComponentRequest)this.createDependency(SYSTEM_BUNDLE, "osgi.bundle", null, null));
            }
            return;
        }
        IPluginImport[] iPluginImportArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentRequestBuilder dependency;
            String pluginId;
            IPluginImport pluginImport = iPluginImportArray[n2];
            if (!(pluginImport.isOptional() || (pluginId = pluginImport.getId()).equals("system.bundle") || requiredBundles != null && !requiredBundles.contains(pluginId) || this.skipComponent(query, dependency = this.createDependency((IPluginReference)pluginImport, "osgi.bundle")) || !this.addDependency(dependency))) {
                String component = dependency.getName();
                this.addExternalPrerequisite(bundleJars, component, "osgi.bundle", "bundle.jars", false);
                if (pluginImport.isReexported()) {
                    this.addExternalPrerequisite(reExports, component, "osgi.bundle", "java.binaries", false);
                }
            }
            ++n2;
        }
    }

    private String buildArtifactName(boolean asJar) {
        StringBuilder bld = new StringBuilder();
        bld.append(this.m_plugin.getId());
        String ver = this.m_plugin.getVersion();
        if (ver != null) {
            bld.append('_');
            bld.append(ver);
        }
        if (asJar) {
            bld.append(".jar");
        } else {
            bld.append('/');
        }
        return bld.toString();
    }
}

