/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.cspecgen.bundle;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.WellknownActions;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.model.UpToDatePolicy;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.ProjectDescReader;
import org.eclipse.buckminster.core.version.OSGiVersion;
import org.eclipse.buckminster.jdt.ClasspathReader;
import org.eclipse.buckminster.pde.cspecgen.CSpecGenerator;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.core.bundle.BundlePlugin;
import org.eclipse.pde.internal.core.ibundle.IBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSpecFromSource
extends CSpecGenerator {
    private static final String ATTRIBUTE_BUNDLE_EXTRAJARS = "bundle.extrajars";
    private static final String ATTRIBUTE_ECLIPSE_BUILD = WellknownActions.ECLIPSE.BUILD.toString();
    private static final String ATTRIBUTE_ECLIPSE_BUILD_REQUIREMENTS = String.valueOf(ATTRIBUTE_ECLIPSE_BUILD) + ".requirements";
    private static final String ATTRIBUTE_ECLIPSE_BUILD_SOURCE = String.valueOf(ATTRIBUTE_ECLIPSE_BUILD) + ".source";
    private static final String ATTRIBUTE_ECLIPSE_CLEAN = WellknownActions.ECLIPSE.CLEAN.toString();
    private static final String PREFIX_CREATE_JAR = "create.";
    private static final String PREFIX_ECLIPSE_BUILD_OUTPUT = "eclipse.build.output.";
    private static final String PREFIX_ROUGE_SOURCE = "rouge.sources.";
    private static final IClasspathEntry[] s_emptyClasspath = new IClasspathEntry[0];
    private final IBuildModel m_buildModel;
    private final IPluginBase m_plugin;
    private IProjectDescription m_projectDesc;

    private static String getArtifactName(IPath buildOutput) {
        return PREFIX_ECLIPSE_BUILD_OUTPUT + CSpecFromSource.pathToName(buildOutput);
    }

    private static String pathToName(IPath path) {
        if ((path = path.setDevice(null).makeRelative()).segmentCount() > 2) {
            path = path.removeFirstSegments(path.segmentCount() - 2);
        }
        return path.removeTrailingSeparator().toPortableString().replace('/', '.');
    }

    public CSpecFromSource(CSpecBuilder cspecBuilder, ICatalogReader reader, IPluginBase plugin, IBuildModel buildModel) {
        super(cspecBuilder, reader);
        this.m_plugin = plugin;
        this.m_buildModel = buildModel;
    }

    @Override
    public void generate(IProgressMonitor monitor) throws CoreException {
        ActionBuilder buildPlugin;
        Path binInclude;
        int n;
        boolean versionExpansion;
        IPath output;
        IClasspathEntry[] classPath;
        monitor.beginTask(null, 100);
        boolean localReader = "local".equals(this.getReader().getReaderType().getId());
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder classpath = cspec.addGroup("java.binaries", true);
        GroupBuilder fullClean = cspec.addGroup(ATTRIBUTE_FULL_CLEAN, true);
        GroupBuilder bundleJars = cspec.addGroup("bundle.jars", true);
        if (localReader) {
            this.m_projectDesc = ProjectDescReader.getProjectDescription((IComponentReader)this.getReader(), (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)15));
        } else {
            this.m_projectDesc = null;
            MonitorUtils.worked((IProgressMonitor)monitor, (int)15);
        }
        this.addImports();
        MonitorUtils.worked((IProgressMonitor)monitor, (int)5);
        try {
            classPath = ClasspathReader.getClasspath((IComponentReader)this.getReader(), (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)45));
        }
        catch (CoreException e) {
            classPath = null;
        }
        if (classPath == null) {
            classPath = new IClasspathEntry[]{};
        }
        fullClean.addLocalPrerequisite(this.generateRemoveDirAction("build", OUTPUT_DIR, false));
        fullClean.addLocalPrerequisite((AttributeBuilder)cspec.addInternalAction(ATTRIBUTE_ECLIPSE_CLEAN, false));
        ActionBuilder eclipseBuild = this.getAttributeEclipseBuild();
        IPath[] projectRootReplacement = new IPath[1];
        HashMap<IPath, ArtifactBuilder> eclipseBuildProducts = new HashMap<IPath, ArtifactBuilder>();
        IPath componentHome = Path.fromPortableString((String)"${buckminster.home}");
        IPath defaultOutputLocation = null;
        GroupBuilder ebSrcBld = null;
        int cnt = 0;
        IClasspathEntry[] iClasspathEntryArray = classPath;
        int n2 = classPath.length;
        int n3 = 0;
        while (n3 < n2) {
            IClasspathEntry cpe = iClasspathEntryArray[n3];
            if (cpe.getEntryKind() == 3) {
                IPath cpePath = this.asProjectRelativeFolder(cpe.getPath(), projectRootReplacement);
                ArtifactBuilder ab = cspec.addArtifact(String.valueOf(ATTRIBUTE_ECLIPSE_BUILD_SOURCE) + '_' + cnt++, false, "java.sources", projectRootReplacement[0]);
                ab.addPath(cpePath);
                if (ebSrcBld == null) {
                    ebSrcBld = this.getGroupEclipseBuildSource(true);
                }
                ebSrcBld.addLocalPrerequisite((AttributeBuilder)ab);
                output = cpe.getOutputLocation();
                if (output == null) {
                    if (defaultOutputLocation == null) {
                        defaultOutputLocation = this.getDefaultOutputLocation(classPath, projectRootReplacement);
                    }
                    output = defaultOutputLocation;
                } else {
                    output = this.asProjectRelativeFolder(output, projectRootReplacement);
                }
                if (output != null && !eclipseBuildProducts.containsKey(output)) {
                    IPath absPath = output;
                    IPath base = projectRootReplacement[0];
                    if (base == null && !output.isAbsolute()) {
                        base = componentHome.append(output);
                        absPath = null;
                    }
                    ArtifactBuilder ab2 = eclipseBuild.addProductArtifact(CSpecFromSource.getArtifactName(output), false, "java.binaries", base);
                    if (absPath != null) {
                        ab2.addPath(absPath);
                    }
                    eclipseBuildProducts.put(output, ab2);
                }
            }
            ++n3;
        }
        if (ebSrcBld != null) {
            this.normalizeGroup(ebSrcBld);
        }
        classpath.addLocalPrerequisite((AttributeBuilder)eclipseBuild);
        boolean simpleBundle = false;
        IBuild build = this.m_buildModel.getBuild();
        ArrayList<String> jarsToCompile = null;
        output = build.getBuildEntries();
        int ab = ((IBuildEntry[])output).length;
        int cpePath = 0;
        while (cpePath < ab) {
            IBuildEntry entry = output[cpePath];
            String name = entry.getName();
            if (name.startsWith("source.")) {
                if (name.length() == 8 && name.charAt(7) == '.') {
                    simpleBundle = true;
                } else if (name.endsWith(".jar") && name.length() > 11) {
                    if (jarsToCompile == null) {
                        jarsToCompile = new ArrayList<String>();
                    }
                    jarsToCompile.add(name.substring(7));
                }
            }
            ++cpePath;
        }
        String bundleClassPath = null;
        if (this.m_plugin instanceof BundlePlugin) {
            IBundle bundle = ((BundlePlugin)this.m_plugin).getBundle();
            this.setFilter(bundle.getHeader("Eclipse-PlatformFilter"));
            cspec.setShortDesc(this.expand(bundle.getHeader("Bundle-Name")));
            bundleClassPath = bundle.getHeader("Bundle-ClassPath");
            if (bundleClassPath != null) {
                cnt = 0;
                GroupBuilder eaBld = null;
                StringTokenizer tokens = new StringTokenizer(bundleClassPath, ",");
                while (tokens.hasMoreTokens()) {
                    String token = tokens.nextToken().trim();
                    if (simpleBundle && token.equals(".") || token.equals("./") || jarsToCompile != null && jarsToCompile.contains(token)) continue;
                    ArtifactBuilder ab2 = cspec.addArtifact("bundle.extrajars_" + cnt++, false, "java.binaries", null);
                    IPath eaPath = this.resolveLink(Path.fromPortableString((String)token), projectRootReplacement);
                    ab2.setBase(projectRootReplacement[0]);
                    ab2.addPath(eaPath);
                    if (eaBld == null) {
                        eaBld = this.getGroupExtraJars();
                    }
                    eaBld.addLocalPrerequisite((AttributeBuilder)ab2);
                }
                if (eaBld != null) {
                    this.normalizeGroup(eaBld);
                }
            }
        }
        IPath manifestFolder = this.resolveLink(new Path("META-INF").append("MANIFEST.MF"), null).removeLastSegments(1).addTrailingSeparator();
        Object manifest = null;
        OSGiVersion version = (OSGiVersion)cspec.getVersion();
        String versionQualifier = version.getQualifier();
        boolean bl = versionExpansion = versionQualifier != null ? versionQualifier.startsWith("qualifier") : false;
        if (versionExpansion) {
            cspec.addArtifact("build.properties", true, null, null).addPath((IPath)new Path("build.properties"));
            Path manifestPath = new Path("MANIFEST.MF");
            ArtifactBuilder artifactBuilder = cspec.addArtifact("raw.manifest", false, null, manifestFolder);
            artifactBuilder.addPath((IPath)manifestPath);
            ActionBuilder versionExpansionAction = this.addAntAction("manifest", "expand.bundle.version", false);
            versionExpansionAction.addLocalPrerequisite("raw.manifest", "manifest");
            versionExpansionAction.addLocalPrerequisite("build.properties", "properties");
            versionExpansionAction.setProductAlias("action.output");
            versionExpansionAction.setProductBase(OUTPUT_DIR_TEMP);
            versionExpansionAction.addProductPath((IPath)manifestPath);
            manifest = versionExpansionAction;
            ActionBuilder sourceManifestAction = this.addAntAction("source.manifest", "create.source.manifest", false);
            sourceManifestAction.addLocalPrerequisite("raw.manifest", "manifest");
            sourceManifestAction.addLocalPrerequisite("build.properties", "properties");
            sourceManifestAction.setProductAlias("action.output");
            sourceManifestAction.setProductBase(OUTPUT_DIR_TEMP);
            Path sourceManifestPath = new Path("SOURCE_MANIFEST.MF");
            sourceManifestAction.addProductPath((IPath)sourceManifestPath);
        } else {
            ArtifactBuilder rawManifest = cspec.addArtifact("manifest", true, null, manifestFolder);
            rawManifest.addPath((IPath)new Path("MANIFEST.MF"));
            manifest = rawManifest;
        }
        HashSet<Object> derivedArtifacts = new HashSet<Object>();
        if (jarsToCompile != null) {
            for (String string : jarsToCompile) {
                derivedArtifacts.add(this.createJarAction(string, classPath, build));
            }
            if (simpleBundle) {
                for (IPath iPath : derivedArtifacts) {
                    eclipseBuildProducts.remove(iPath);
                }
            }
        }
        if (simpleBundle) {
            derivedArtifacts.add(new Path("."));
            derivedArtifacts.add(new Path("./"));
        }
        GroupBuilder groupBuilder = this.getAttributeJarContents();
        boolean includeBuildProps = false;
        IBuildEntry binIncludesEntry = build.getEntry("bin.includes");
        if (binIncludesEntry != null) {
            GroupBuilder binIncludesSource = null;
            cnt = 0;
            String[] stringArray = binIncludesEntry.getTokens();
            n = stringArray.length;
            int n4 = 0;
            while (n4 < n) {
                String token = stringArray[n4];
                if (token.length() != 0 && !"META-INF/MANIFEST.MF".equalsIgnoreCase(token)) {
                    if (versionExpansion && "build.properties".equals(token)) {
                        includeBuildProps = true;
                    } else {
                        binInclude = new Path(token);
                        if (!derivedArtifacts.contains(binInclude)) {
                            if (binIncludesSource == null) {
                                binIncludesSource = cspec.addGroup("bin.includes", false);
                            }
                            IPath biPath = this.resolveLink((IPath)binInclude, projectRootReplacement);
                            ArtifactBuilder ab3 = cspec.addArtifact("bin.includes_" + cnt++, false, null, projectRootReplacement[0]);
                            ab3.addPath(biPath);
                            binIncludesSource.addLocalPrerequisite((AttributeBuilder)ab3);
                        }
                    }
                }
                ++n4;
            }
            if (binIncludesSource != null) {
                this.normalizeGroup(binIncludesSource);
                groupBuilder.addLocalPrerequisite("bin.includes");
            }
            if (includeBuildProps) {
                groupBuilder.addLocalPrerequisite("build.properties");
            }
        }
        GroupBuilder srcIncludesSource = null;
        IBuildEntry srcIncludesEntry = build.getEntry("src.includes");
        if (srcIncludesEntry != null) {
            cnt = 0;
            binInclude = srcIncludesEntry.getTokens();
            int n5 = ((String[])binInclude).length;
            n = 0;
            while (n < n5) {
                String token = binInclude[n];
                if (token.length() != 0) {
                    Path srcInclude = new Path(token);
                    if (srcIncludesSource == null) {
                        srcIncludesSource = cspec.addGroup("src.includes", false);
                    }
                    IPath biPath = this.resolveLink((IPath)srcInclude, projectRootReplacement);
                    ArtifactBuilder ab4 = cspec.addArtifact("src.includes_" + cnt++, false, null, projectRootReplacement[0]);
                    ab4.addPath(biPath);
                    srcIncludesSource.addLocalPrerequisite((AttributeBuilder)ab4);
                }
                ++n;
            }
        }
        if (simpleBundle) {
            for (ArtifactBuilder product : eclipseBuildProducts.values()) {
                groupBuilder.addLocalPrerequisite((AttributeBuilder)product);
            }
        }
        String jarName = String.valueOf(this.m_plugin.getId()) + '_' + this.m_plugin.getVersion() + ".jar";
        IPath jarPath = Path.fromPortableString((String)jarName);
        if (localReader && (this.getReader().exists(jarName, (IProgressMonitor)new NullProgressMonitor()) || this.getLinkDescriptions().containsKey(jarPath))) {
            buildPlugin = this.addAntAction("bundle.jar", "copy.group", true);
            buildPlugin.setPrerequisitesAlias("action.requirements");
            IPath resolvedJarPath = this.resolveLink(jarPath, projectRootReplacement);
            ArtifactBuilder importedJar = cspec.addArtifact("imported.jar", false, "java.binaries", projectRootReplacement[0]);
            importedJar.addPath(resolvedJarPath);
            buildPlugin.getPrerequisitesBuilder().addLocalPrerequisite((AttributeBuilder)importedJar);
        } else {
            buildPlugin = this.addAntAction("bundle.jar", "create.bundle.jar", true);
            buildPlugin.addLocalPrerequisite(manifest.getName(), "manifest");
            buildPlugin.addLocalPrerequisite(groupBuilder.getName(), "action.requirements");
        }
        buildPlugin.setProductAlias("action.output");
        buildPlugin.setProductBase(OUTPUT_DIR_JAR);
        buildPlugin.setUpToDatePolicy(UpToDatePolicy.COUNT);
        buildPlugin.setProductFileCount(1);
        GroupBuilder bundleAndFragments = cspec.addGroup("bundle.and.fragments", true);
        IPluginModelBase model = this.m_plugin.getPluginModel();
        if (model instanceof IFragmentModel) {
            this.addBundleHostDependency((IFragmentModel)model);
        } else {
            ActionBuilder copyTargetFragments = cspec.addAction("target.fragments", false, "copyTargetFragments", false);
            copyTargetFragments.setProductAlias("action.output");
            copyTargetFragments.setProductBase(OUTPUT_DIR_FRAGMENTS);
            copyTargetFragments.addLocalPrerequisite((AttributeBuilder)this.getAttributeEclipseBuild());
            copyTargetFragments.setUpToDatePolicy(UpToDatePolicy.ACTOR);
            copyTargetFragments.addProperty("fragment.attribute", "bundle.jar", false);
            bundleAndFragments.addLocalPrerequisite((AttributeBuilder)copyTargetFragments);
        }
        bundleAndFragments.addLocalPrerequisite((AttributeBuilder)buildPlugin);
        bundleJars.addLocalPrerequisite((AttributeBuilder)bundleAndFragments);
        GroupBuilder bundleAndFragmentsSource = cspec.addGroup("bundle.and.fragments.source", true);
        if (!(model instanceof IFragmentModel)) {
            ActionBuilder copyTargetFragmentsSource = cspec.addAction("target.fragments.source", false, "copyTargetFragments", false);
            copyTargetFragmentsSource.setProductAlias("action.output");
            copyTargetFragmentsSource.setProductBase(OUTPUT_DIR_FRAGMENTS);
            copyTargetFragmentsSource.setUpToDatePolicy(UpToDatePolicy.ACTOR);
            copyTargetFragmentsSource.addProperty("fragment.attribute", "source.bundle.jar", false);
            bundleAndFragmentsSource.addLocalPrerequisite((AttributeBuilder)copyTargetFragmentsSource);
        }
        if (srcIncludesSource != null) {
            this.normalizeGroup(srcIncludesSource);
            ActionBuilder sourceBundleAction = this.addAntAction("source.bundle.jar", "create.bundle.jar", true);
            sourceBundleAction.addLocalPrerequisite("src.includes", "action.requirements");
            sourceBundleAction.addLocalPrerequisite("source.manifest", "manifest");
            sourceBundleAction.setProductAlias("action.output");
            sourceBundleAction.setProductBase(OUTPUT_DIR_SOURCE_JAR);
            bundleAndFragmentsSource.addLocalPrerequisite((AttributeBuilder)sourceBundleAction);
        } else {
            cspec.addGroup("source.bundle.jar", true);
        }
        this.addProducts(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
        monitor.done();
    }

    protected void addImports() throws CoreException {
        IPluginImport[] imports = this.m_plugin.getImports();
        if (imports == null || imports.length == 0) {
            return;
        }
        Set<String> requiredBundles = this.getRequiredBundleNames(this.m_plugin.getPluginModel().getBundleDescription());
        ComponentQuery query = this.getReader().getNodeQuery().getComponentQuery();
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder fullClean = cspec.getRequiredGroup(ATTRIBUTE_FULL_CLEAN);
        GroupBuilder reExports = cspec.getRequiredGroup("java.binaries");
        GroupBuilder bundleJars = cspec.getRequiredGroup("bundle.jars");
        IPluginImport[] iPluginImportArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentRequestBuilder dependency;
            IPluginImport pluginImport = iPluginImportArray[n2];
            String pluginId = pluginImport.getId();
            if (!pluginId.equals("system.bundle") && (requiredBundles == null || requiredBundles.contains(pluginId)) && !this.skipComponent(query, dependency = this.createDependency((IPluginReference)pluginImport, "osgi.bundle")) && this.addDependency(dependency)) {
                String component = dependency.getName();
                boolean optional = pluginImport.isOptional();
                this.addExternalPrerequisite(fullClean, component, "osgi.bundle", ATTRIBUTE_FULL_CLEAN, optional);
                this.addExternalPrerequisite(bundleJars, component, "osgi.bundle", "bundle.jars", optional);
                this.addExternalPrerequisite(this.getAttributeBuildRequirements(), component, "osgi.bundle", "java.binaries", optional);
                if (pluginImport.isReexported()) {
                    this.addExternalPrerequisite(reExports, component, "osgi.bundle", "java.binaries", optional);
                }
            }
            ++n2;
        }
    }

    @Override
    protected String getProductOutputFolder(String productId) {
        String[] tokens;
        IBuildEntry entry = this.m_buildModel.getBuild().getEntry(String.valueOf(productId) + ".topfolder");
        if (entry != null && (tokens = entry.getTokens()).length == 1) {
            return tokens[0];
        }
        return null;
    }

    @Override
    protected String getPropertyFileName() {
        return "plugin.properties";
    }

    private IPath asProjectRelativeFolder(IPath classpathEntryPath, IPath[] projectRootReplacement) {
        return this.resolveLink(classpathEntryPath.removeFirstSegments(1).addTrailingSeparator(), projectRootReplacement);
    }

    private IPath createJarAction(String jarName, IClasspathEntry[] classPath, IBuild build) throws CoreException {
        int n;
        CSpecBuilder cspec = this.getCSpec();
        Path jarPath = new Path(jarName);
        String jarFlatName = CSpecFromSource.pathToName((IPath)jarPath);
        ActionBuilder action = this.addAntAction(PREFIX_CREATE_JAR + jarFlatName, "create.jar", false);
        action.setProductBase(OUTPUT_DIR_TEMP);
        action.addProductPath((IPath)jarPath);
        action.setProductAlias("action.output");
        action.setPrerequisitesAlias("action.requirements");
        this.getAttributeJarContents().addLocalPrerequisite((AttributeBuilder)action);
        IPath[][] missingEntriesRet = new IPath[1][];
        IClasspathEntry[] srcEntries = this.getSourceEntries(classPath, jarName, build, missingEntriesRet);
        IPath[] missingEntries = missingEntriesRet[0];
        if (missingEntries.length > 0) {
            ArtifactBuilder rougeSources = cspec.addArtifact(PREFIX_ROUGE_SOURCE + jarFlatName, false, "java.sources", null);
            IPath[] iPathArray = missingEntries;
            n = missingEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IPath notFound = iPathArray[n2];
                rougeSources.addPath(notFound);
                ++n2;
            }
            action.addLocalPrerequisite((AttributeBuilder)rougeSources);
        }
        IPath[] projectRootReplacement = new IPath[1];
        IPath defaultOutputLocation = this.getDefaultOutputLocation(classPath, projectRootReplacement);
        IClasspathEntry[] iClasspathEntryArray = srcEntries;
        int n3 = srcEntries.length;
        n = 0;
        while (n < n3) {
            block6: {
                String artifactName;
                IPath output;
                block5: {
                    block4: {
                        IClasspathEntry cpe = iClasspathEntryArray[n];
                        output = cpe.getOutputLocation();
                        if (output != null) break block4;
                        output = defaultOutputLocation;
                        if (output != null) break block5;
                        break block6;
                    }
                    output = this.asProjectRelativeFolder(output, projectRootReplacement);
                }
                if (action.getPrerequisite(artifactName = CSpecFromSource.getArtifactName(output)) == null) {
                    action.addLocalPrerequisite(artifactName);
                }
            }
            ++n;
        }
        return jarPath;
    }

    private GroupBuilder getAttributeBuildRequirements() throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder eclipseBuildReqs = cspec.getGroup(ATTRIBUTE_ECLIPSE_BUILD_REQUIREMENTS);
        if (eclipseBuildReqs == null) {
            eclipseBuildReqs = cspec.addGroup(ATTRIBUTE_ECLIPSE_BUILD_REQUIREMENTS, false);
            this.getAttributeEclipseBuild().addLocalPrerequisite((AttributeBuilder)eclipseBuildReqs);
        }
        return eclipseBuildReqs;
    }

    private ActionBuilder getAttributeEclipseBuild() throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        ActionBuilder eclipseBuild = cspec.getActionBuilder(ATTRIBUTE_ECLIPSE_BUILD);
        if (eclipseBuild == null) {
            eclipseBuild = cspec.addInternalAction(ATTRIBUTE_ECLIPSE_BUILD, false);
        }
        return eclipseBuild;
    }

    private GroupBuilder getAttributeJarContents() throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder jarContent = cspec.getGroup("jar.contents");
        if (jarContent == null) {
            jarContent = cspec.addGroup("jar.contents", false);
        }
        return jarContent;
    }

    private IPath getDefaultOutputLocation(IClasspathEntry[] classPath, IPath[] projectRootReplacement) {
        IClasspathEntry[] iClasspathEntryArray = classPath;
        int n = classPath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (cpe.getContentKind() == 10) {
                return this.asProjectRelativeFolder(cpe.getPath(), projectRootReplacement);
            }
            ++n2;
        }
        return null;
    }

    private GroupBuilder getGroupEclipseBuildSource(boolean createIfMissing) throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder buildSource = cspec.getGroup(ATTRIBUTE_ECLIPSE_BUILD_SOURCE);
        if (buildSource == null && createIfMissing) {
            buildSource = cspec.addGroup(ATTRIBUTE_ECLIPSE_BUILD_SOURCE, true);
            this.getAttributeEclipseBuild().addLocalPrerequisite(ATTRIBUTE_ECLIPSE_BUILD_SOURCE);
        }
        return buildSource;
    }

    private GroupBuilder getGroupExtraJars() throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder extraJars = cspec.getGroup(ATTRIBUTE_BUNDLE_EXTRAJARS);
        if (extraJars == null) {
            extraJars = cspec.addGroup(ATTRIBUTE_BUNDLE_EXTRAJARS, false);
            cspec.getRequiredGroup("java.binaries").addLocalPrerequisite(ATTRIBUTE_BUNDLE_EXTRAJARS);
            this.getAttributeBuildRequirements().addLocalPrerequisite(ATTRIBUTE_BUNDLE_EXTRAJARS);
        }
        return extraJars;
    }

    private Map<IPath, LinkDescription> getLinkDescriptions() {
        HashMap linkDescriptors = null;
        if (this.m_projectDesc instanceof ProjectDescription) {
            linkDescriptors = ((ProjectDescription)this.m_projectDesc).getLinks();
        }
        if (linkDescriptors == null) {
            linkDescriptors = Collections.emptyMap();
        }
        return linkDescriptors;
    }

    private IClasspathEntry[] getSourceEntries(IClasspathEntry[] classPath, String jarName, IBuild build, IPath[][] notFound) {
        IBuildEntry srcIncl = build.getEntry("source." + jarName);
        if (srcIncl == null) {
            notFound[0] = Trivial.EMPTY_PATH_ARRAY;
            return s_emptyClasspath;
        }
        ArrayList<IClasspathEntry> cpEntries = null;
        ArrayList<IPath> missingEntries = null;
        if (classPath == null) {
            String[] stringArray = srcIncl.getTokens();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String src = stringArray[n2];
                if (missingEntries == null) {
                    missingEntries = new ArrayList<IPath>();
                }
                missingEntries.add(this.resolveLink(Path.fromPortableString((String)src).addTrailingSeparator(), null));
                ++n2;
            }
        } else {
            String[] stringArray = srcIncl.getTokens();
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String src = stringArray[n3];
                boolean found = false;
                IPath srcPath = this.resolveLink(Path.fromPortableString((String)src), null).addTrailingSeparator();
                IClasspathEntry[] iClasspathEntryArray = classPath;
                int n4 = classPath.length;
                int n5 = 0;
                while (n5 < n4) {
                    IPath cePath;
                    IClasspathEntry ce = iClasspathEntryArray[n5];
                    if (ce.getEntryKind() == 3 && (cePath = this.asProjectRelativeFolder(ce.getPath(), null)).equals((Object)srcPath)) {
                        found = true;
                        if (cpEntries == null) {
                            cpEntries = new ArrayList<IClasspathEntry>();
                        }
                        cpEntries.add(ce);
                        break;
                    }
                    ++n5;
                }
                if (!found) {
                    if (missingEntries == null) {
                        missingEntries = new ArrayList();
                    }
                    missingEntries.add(srcPath);
                }
                ++n3;
            }
        }
        notFound[0] = missingEntries == null ? Trivial.EMPTY_PATH_ARRAY : missingEntries.toArray(new IPath[missingEntries.size()]);
        return cpEntries == null ? s_emptyClasspath : cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
    }

    private void normalizeGroup(GroupBuilder bld) throws CoreException {
        if (bld == null) {
            return;
        }
        List preqs = bld.getPrerequisites();
        if (preqs.size() == 0) {
            return;
        }
        boolean singleCanReplace = true;
        CSpecBuilder cspec = this.getCSpec();
        HashMap<IPath, ArtifactBuilder> byBase = new HashMap<IPath, ArtifactBuilder>();
        for (PrerequisiteBuilder pq : new ArrayList(preqs)) {
            if (pq.getComponentName() != null) {
                singleCanReplace = false;
                continue;
            }
            AttributeBuilder ab = cspec.getAttribute(pq.getName());
            if (!(ab instanceof ArtifactBuilder)) {
                singleCanReplace = false;
                continue;
            }
            ArtifactBuilder arb = (ArtifactBuilder)ab;
            ArtifactBuilder prev = (ArtifactBuilder)byBase.get(arb.getBase());
            if (prev == null) {
                byBase.put(arb.getBase(), arb);
                continue;
            }
            for (IPath path : arb.getPaths()) {
                prev.addPath(path);
            }
            bld.removePrerequisite(pq.toString());
            cspec.removeAttribute(arb.getName());
        }
        if (singleCanReplace && byBase.size() == 1) {
            ArtifactBuilder ab = (ArtifactBuilder)byBase.values().iterator().next();
            String name = bld.getName();
            cspec.removeAttribute(name);
            cspec.removeAttribute(ab.getName());
            ab.setName(name);
            this.getCSpec().addAttribute((IAttribute)ab);
        }
    }

    private IPath resolveLink(IPath path, IPath[] projectRootReplacement) {
        if (projectRootReplacement != null) {
            projectRootReplacement[0] = null;
        }
        if (path == null || path.isAbsolute() || path.isEmpty()) {
            return path;
        }
        for (Map.Entry<IPath, LinkDescription> entry : this.getLinkDescriptions().entrySet()) {
            IPath linkSource = entry.getKey();
            if (!linkSource.isPrefixOf(path)) continue;
            IPath linkTarget = FileUtil.toPath((URI)entry.getValue().getLocationURI());
            int sourceSegs = linkSource.segmentCount();
            if (projectRootReplacement != null && linkTarget.setDevice(null).removeFirstSegments(linkTarget.segmentCount() - sourceSegs).equals((Object)linkSource)) {
                projectRootReplacement[0] = linkTarget.removeLastSegments(sourceSegs);
                break;
            }
            if (sourceSegs == path.segmentCount()) {
                if (path.hasTrailingSeparator()) {
                    path = linkTarget.addTrailingSeparator();
                    break;
                }
                path = linkTarget;
                break;
            }
            path = linkTarget.append(path.removeFirstSegments(sourceSegs));
            break;
        }
        return path;
    }
}

