/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.cspecgen.feature;

import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.buckminster.core.cspec.IAttribute;
import org.eclipse.buckminster.core.cspec.IComponentRequest;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.AttributeBuilder;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.cspec.builder.ComponentRequestBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.builder.PrerequisiteBuilder;
import org.eclipse.buckminster.core.cspec.model.UpToDatePolicy;
import org.eclipse.buckminster.core.helpers.FilterUtils;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.query.model.ComponentQuery;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.cspecgen.CSpecGenerator;
import org.eclipse.buckminster.pde.cspecgen.feature.FeatureBuilder;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSpecFromSource
extends CSpecGenerator {
    private static final String ACTION_COPY_FEATURES = "copy.features";
    private static final String ACTION_COPY_SOURCE_FEATURES = "copy.source.features";
    private static final String ATTRIBUTE_FEATURE_REFS = "feature.references";
    private static final String ATTRIBUTE_SOURCE_FEATURE_REFS = "source.feature.references";
    private static final String ATTRIBUTE_INTERNAL_PRODUCT_ROOT = "internal.product.root";
    private final Map<String, String> m_buildProperties;
    private final IFeature m_feature;

    private static boolean isListOK(String list, Object item) {
        if (list == null || list.length() == 0) {
            return true;
        }
        StringTokenizer tokens = new StringTokenizer(list, ",");
        while (tokens.hasMoreTokens()) {
            if (!item.equals("*") && !item.equals(tokens.nextElement())) continue;
            return true;
        }
        return false;
    }

    protected CSpecFromSource(CSpecBuilder cspecBuilder, ICatalogReader reader, IFeature feature, Map<String, String> buildProperties) {
        super(cspecBuilder, reader);
        this.m_feature = feature;
        this.m_buildProperties = buildProperties;
    }

    @Override
    public void generate(IProgressMonitor monitor) throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        cspec.setName(this.m_feature.getId());
        cspec.setVersion(this.m_feature.getVersion(), "OSGi");
        cspec.setComponentTypeID("eclipse.feature");
        cspec.setFilter(FilterUtils.createFilter((String)this.m_feature.getOS(), (String)this.m_feature.getWS(), (String)this.m_feature.getArch(), (String)this.m_feature.getNL()));
        GroupBuilder featureRefs = cspec.addGroup(ATTRIBUTE_FEATURE_REFS, true);
        cspec.addGroup(ATTRIBUTE_SOURCE_FEATURE_REFS, true);
        cspec.addGroup("bundle.jars", true);
        cspec.addGroup("source.bundle.jars", true);
        cspec.addGroup("feature.exports", true);
        cspec.addGroup("feature.exports.with.source", true);
        cspec.addGroup("product.root.files", true);
        this.generateRemoveDirAction("build", OUTPUT_DIR, true, ATTRIBUTE_FULL_CLEAN);
        this.addFeatures();
        this.addPlugins();
        MonitorUtils.begin((IProgressMonitor)monitor, (int)100);
        if (this.m_buildProperties == null) {
            ArtifactBuilder binIncludes = null;
            for (String path : this.getReader().list(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20))) {
                if ("feature.xml".equals(path)) continue;
                if (binIncludes == null) {
                    binIncludes = this.getCSpec().addArtifact("jar.contents", false, null, null);
                }
                binIncludes.addPath((IPath)new Path(path));
            }
        } else {
            List preqs;
            cspec.addArtifact("build.properties", false, null, null).addPath((IPath)new Path("build.properties"));
            for (Map.Entry<String, String> entry : this.m_buildProperties.entrySet()) {
                String key = entry.getKey();
                if ("bin.includes".equals(key)) {
                    this.createBinIncludesArtifact(entry.getValue());
                    continue;
                }
                if (!key.startsWith("root")) continue;
                Filter filter = null;
                String[] permSpec = null;
                String permStr = null;
                if (key.length() > "root".length()) {
                    if (key.charAt("root".length()) != '.') continue;
                    String[] s = TextUtils.split((String)key.substring("root".length() + 1), (String)".");
                    switch (s.length) {
                        case 2: {
                            permStr = s[1];
                            break;
                        }
                        case 3: {
                            filter = FilterUtils.createFilter((String)s[0], (String)s[1], (String)s[2], null);
                            break;
                        }
                        case 5: {
                            permSpec = s;
                            permStr = s[4];
                        }
                    }
                }
                if (permStr != null) {
                    FeatureBuilder.addRootsPermissions((Map<String, String>)featureRefs.getInstallerHintsForAdd(), permStr, entry.getValue(), permSpec);
                    continue;
                }
                this.createRootsArtifact(entry.getValue(), filter);
            }
            GroupBuilder productRoots = cspec.getGroup(ATTRIBUTE_INTERNAL_PRODUCT_ROOT);
            if (productRoots != null && (preqs = productRoots.getPrerequisites()).size() == 1) {
                String prName = productRoots.getName();
                ArtifactBuilder artifact = cspec.getArtifactBuilder(((PrerequisiteBuilder)preqs.iterator().next()).getName());
                cspec.removeAttribute(prName);
                cspec.removeAttribute(artifact.getName());
                artifact.setName(prName);
                cspec.addAttribute((IAttribute)artifact);
            }
            MonitorUtils.worked((IProgressMonitor)monitor, (int)20);
        }
        this.createFeatureManifestAction();
        this.createFeatureJarAction();
        this.createFeatureSourceManifestAction();
        this.createFeatureSourceJarAction();
        this.createFeatureExportsAction();
        this.createFeatureExportsWithSourceAction();
        this.addProducts(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)80));
        MonitorUtils.done((IProgressMonitor)monitor);
    }

    @Override
    protected String getProductOutputFolder(String productId) {
        return this.m_buildProperties == null ? null : this.m_buildProperties.get(String.valueOf(productId) + ".topfolder");
    }

    @Override
    protected String getPropertyFileName() {
        return "feature.properties";
    }

    void addFeatures() throws CoreException {
        IFeatureChild[] features = this.m_feature.getIncludedFeatures();
        if (features == null || features.length == 0) {
            return;
        }
        ComponentQuery query = this.getReader().getNodeQuery().getComponentQuery();
        CSpecBuilder cspec = this.getCSpec();
        ActionBuilder fullClean = cspec.getRequiredAction(ATTRIBUTE_FULL_CLEAN);
        GroupBuilder featureRefs = cspec.getRequiredGroup(ATTRIBUTE_FEATURE_REFS);
        GroupBuilder featureSourceRefs = cspec.getRequiredGroup(ATTRIBUTE_SOURCE_FEATURE_REFS);
        GroupBuilder bundleJars = cspec.getRequiredGroup("bundle.jars");
        GroupBuilder sourceBundleJars = cspec.getRequiredGroup("source.bundle.jars");
        GroupBuilder productRootFiles = cspec.getRequiredGroup("product.root.files");
        IFeatureChild[] iFeatureChildArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureChild feature = iFeatureChildArray[n2];
            ComponentRequestBuilder dep = this.createDependency(feature);
            if (!this.skipComponent(query, dep)) {
                cspec.addDependency((IComponentRequest)dep);
                featureRefs.addExternalPrerequisite(dep.getName(), "eclipse.feature", "feature.jars");
                featureSourceRefs.addExternalPrerequisite(dep.getName(), "eclipse.feature", "source.feature.jars");
                bundleJars.addExternalPrerequisite(dep.getName(), "eclipse.feature", "bundle.jars");
                sourceBundleJars.addExternalPrerequisite(dep.getName(), "eclipse.feature", "source.bundle.jars");
                fullClean.addExternalPrerequisite(dep.getName(), "eclipse.feature", ATTRIBUTE_FULL_CLEAN);
                productRootFiles.addExternalPrerequisite(dep.getName(), "eclipse.feature", "product.root.files");
            }
            ++n2;
        }
    }

    void addPlugins() throws CoreException {
        IFeaturePlugin[] plugins = this.m_feature.getPlugins();
        if (plugins == null || plugins.length == 0) {
            return;
        }
        Map props = this.getReader().getNodeQuery().getProperties();
        Object os = props.get("target.os");
        Object ws = props.get("target.ws");
        Object arch = props.get("target.arch");
        ComponentQuery query = this.getReader().getNodeQuery().getComponentQuery();
        CSpecBuilder cspec = this.getCSpec();
        ActionBuilder fullClean = cspec.getRequiredAction(ATTRIBUTE_FULL_CLEAN);
        GroupBuilder bundleJars = cspec.getRequiredGroup("bundle.jars");
        GroupBuilder sourceBundleJars = cspec.getRequiredGroup("source.bundle.jars");
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        String id = this.m_feature.getId();
        boolean hasBogusFragments = "org.eclipse.platform".equals(id) || "org.eclipse.equinox.executable".equals(id) || "org.eclipse.rcp".equals(id);
        IFeaturePlugin[] iFeaturePluginArray = plugins;
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentRequestBuilder dep;
            IFeaturePlugin plugin = iFeaturePluginArray[n2];
            if ((CSpecFromSource.isListOK(plugin.getOS(), os) && CSpecFromSource.isListOK(plugin.getWS(), ws) && CSpecFromSource.isListOK(plugin.getArch(), arch) || manager.findEntry(plugin.getId()) != null) && (!hasBogusFragments || plugin.getOS() == null && plugin.getWS() == null && plugin.getArch() == null || manager.findEntry(plugin.getId()) != null) && !this.skipComponent(query, dep = this.createDependency(plugin)) && this.addDependency(dep)) {
                bundleJars.addExternalPrerequisite(dep.getName(), "osgi.bundle", "bundle.and.fragments");
                sourceBundleJars.addExternalPrerequisite(dep.getName(), "osgi.bundle", "bundle.and.fragments.source");
                fullClean.addExternalPrerequisite(dep.getName(), "osgi.bundle", ATTRIBUTE_FULL_CLEAN);
            }
            ++n2;
        }
    }

    ComponentRequestBuilder createDependency(IFeatureChild feature) throws CoreException {
        Filter filter = FilterUtils.createFilter((String)feature.getOS(), (String)feature.getWS(), (String)feature.getArch(), (String)feature.getNL());
        return this.createDependency(feature.getId(), "eclipse.feature", feature.getVersion(), feature.getMatch(), filter);
    }

    ComponentRequestBuilder createDependency(IFeaturePlugin plugin) throws CoreException {
        Filter filter = FilterUtils.createFilter((String)plugin.getOS(), (String)plugin.getWS(), (String)plugin.getArch(), (String)plugin.getNL());
        return this.createDependency(plugin.getId(), "osgi.bundle", plugin.getVersion(), 3, filter);
    }

    private void createBinIncludesArtifact(String binIncludesStr) throws CoreException {
        ArtifactBuilder binIncludes = null;
        StringTokenizer tokens = new StringTokenizer(binIncludesStr, ",");
        while (tokens.hasMoreTokens()) {
            String path = tokens.nextToken().trim();
            if ("feature.xml".equals(path) || "build.properties".equals(path)) continue;
            if (binIncludes == null) {
                binIncludes = this.getCSpec().addArtifact("jar.contents", false, null, null);
            }
            binIncludes.addPath((IPath)new Path(path));
        }
    }

    private ActionBuilder createCopyFeaturesAction() throws CoreException {
        ActionBuilder copyFeatures = this.addAntAction(ACTION_COPY_FEATURES, "copy.group", false);
        copyFeatures.addLocalPrerequisite("feature.jars");
        copyFeatures.setPrerequisitesAlias("action.requirements");
        copyFeatures.setProductAlias("action.output");
        copyFeatures.setProductBase(OUTPUT_DIR_SITE.append("features"));
        copyFeatures.setUpToDatePolicy(UpToDatePolicy.MAPPER);
        return copyFeatures;
    }

    private ActionBuilder createCopySourceFeaturesAction() throws CoreException {
        ActionBuilder copyFeatures = this.addAntAction(ACTION_COPY_SOURCE_FEATURES, "copy.group", false);
        copyFeatures.addLocalPrerequisite("source.feature.jars");
        copyFeatures.setPrerequisitesAlias("action.requirements");
        copyFeatures.setProductAlias("action.output");
        copyFeatures.setProductBase(OUTPUT_DIR_SITE.append("features"));
        copyFeatures.setUpToDatePolicy(UpToDatePolicy.MAPPER);
        return copyFeatures;
    }

    private void createFeatureExportsAction() throws CoreException {
        GroupBuilder featureExports = this.getCSpec().getRequiredGroup("feature.exports");
        featureExports.addLocalPrerequisite((AttributeBuilder)this.createCopyFeaturesAction());
        featureExports.addLocalPrerequisite((AttributeBuilder)this.createCopyPluginsAction());
        featureExports.setPrerequisiteRebase(OUTPUT_DIR_SITE);
    }

    private void createFeatureExportsWithSourceAction() throws CoreException {
        GroupBuilder featureExports = this.getCSpec().getRequiredGroup("feature.exports.with.source");
        featureExports.addLocalPrerequisite(ACTION_COPY_FEATURES);
        featureExports.addLocalPrerequisite("copy.plugins");
        featureExports.addLocalPrerequisite((AttributeBuilder)this.createCopySourceFeaturesAction());
        featureExports.addLocalPrerequisite((AttributeBuilder)this.createCopySourcePluginsAction());
        featureExports.setPrerequisiteRebase(OUTPUT_DIR_SITE);
    }

    private void createFeatureJarAction() throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        ActionBuilder featureJarBuilder = this.addAntAction("feature.jar", "create.feature.jar", false);
        featureJarBuilder.addLocalPrerequisite("manifest", "manifest");
        if (cspec.getArtifactBuilder("jar.contents") != null) {
            featureJarBuilder.addLocalPrerequisite("jar.contents");
        }
        featureJarBuilder.setPrerequisitesAlias("action.requirements");
        featureJarBuilder.setProductAlias("action.output");
        featureJarBuilder.setProductBase(OUTPUT_DIR_JAR);
        featureJarBuilder.setUpToDatePolicy(UpToDatePolicy.COUNT);
        featureJarBuilder.setProductFileCount(1);
        GroupBuilder featureJars = cspec.addGroup("feature.jars", true);
        featureJars.addLocalPrerequisite((AttributeBuilder)featureJarBuilder);
        featureJars.addLocalPrerequisite(ATTRIBUTE_FEATURE_REFS);
    }

    private void createFeatureManifestAction() throws CoreException {
        Path featureFile = new Path("feature.xml");
        ArtifactBuilder rawManifest = this.getCSpec().addArtifact("raw.manifest", false, null, null);
        rawManifest.addPath((IPath)featureFile);
        ActionBuilder manifest = this.addAntAction("manifest", "expand.feature.version", true);
        manifest.addLocalPrerequisite("raw.manifest", "manifest");
        manifest.addLocalPrerequisite("bundle.jars", "bundles");
        manifest.addLocalPrerequisite(ATTRIBUTE_FEATURE_REFS, "features");
        if (this.getCSpec().getAttribute("build.properties") != null) {
            manifest.addLocalPrerequisite("build.properties", "properties");
        }
        manifest.setProductAlias("action.output");
        manifest.setProductBase(OUTPUT_DIR_TEMP);
        manifest.addProductPath((IPath)featureFile);
    }

    private void createFeatureSourceJarAction() throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        ActionBuilder featureJarBuilder = this.addAntAction("source.feature.jar", "create.feature.jar", false);
        featureJarBuilder.addLocalPrerequisite("source.manifest", "manifest");
        if (cspec.getArtifactBuilder("jar.contents") != null) {
            featureJarBuilder.addLocalPrerequisite("jar.contents");
        }
        featureJarBuilder.setPrerequisitesAlias("action.requirements");
        featureJarBuilder.setProductAlias("action.output");
        featureJarBuilder.setProductBase(OUTPUT_DIR_SOURCE_JAR);
        featureJarBuilder.setUpToDatePolicy(UpToDatePolicy.COUNT);
        featureJarBuilder.setProductFileCount(1);
        GroupBuilder featureJars = cspec.addGroup("source.feature.jars", true);
        featureJars.addLocalPrerequisite((AttributeBuilder)featureJarBuilder);
        featureJars.addLocalPrerequisite(ATTRIBUTE_SOURCE_FEATURE_REFS);
    }

    private void createFeatureSourceManifestAction() throws CoreException {
        ActionBuilder manifest = this.addAntAction("source.manifest", "create.source.feature", true);
        manifest.addLocalPrerequisite("manifest", "manifest");
        manifest.addLocalPrerequisite("source.bundle.jars", "bundles");
        manifest.addLocalPrerequisite(ATTRIBUTE_SOURCE_FEATURE_REFS, "features");
        manifest.setProductAlias("action.output");
        manifest.setProductBase(OUTPUT_DIR_TEMP);
        manifest.addProductPath((IPath)new Path("source.feature.xml"));
    }

    private void createRootsArtifact(String filesAndFolders, Filter filter) throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        StringTokenizer tokenizer = new StringTokenizer(filesAndFolders, ",");
        GroupBuilder productRoots = null;
        while (tokenizer.hasMoreTokens()) {
            Path path;
            String token = tokenizer.nextToken().trim();
            if (token.startsWith("absolute:")) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.component_0_contains_absolute_path_in_buildproperties, (Object)this.getCSpec().getName()), (Object[])new Object[0]);
            }
            boolean isFile = token.startsWith("file:");
            if (isFile) {
                if ("file:bin/win32/win32/x86/eclipse.exe".equals(token)) {
                    token = "file:bin/win32/win32/x86/launcher.exe";
                } else if ("file:bin/wpf/win32/x86/eclipse.exe".equals(token)) {
                    token = "file:bin/wpf/win32/x86/launcher.exe";
                }
                path = new Path(token.substring(5));
            } else {
                path = new Path(token);
            }
            Path leaf = null;
            path = path.makeRelative().setDevice(null);
            if (isFile) {
                leaf = new Path(path.lastSegment());
                path = path.removeLastSegments(1);
            }
            path = path.addTrailingSeparator();
            if (productRoots == null) {
                productRoots = this.getInternalProductRoot();
            }
            ArtifactBuilder productRoot = null;
            List preqs = productRoots.getPrerequisites();
            for (PrerequisiteBuilder preq : preqs) {
                ArtifactBuilder ag = cspec.getRequiredArtifact(preq.getName());
                if (!ag.getBase().equals((Object)path)) continue;
                productRoot = ag;
                break;
            }
            if (productRoot == null) {
                int n = preqs.size();
                productRoot = cspec.addArtifact("internal.product.root." + n, false, null, (IPath)path);
                productRoot.setFilter(filter);
                productRoots.addLocalPrerequisite((AttributeBuilder)productRoot);
            }
            if (!isFile) continue;
            productRoot.addPath((IPath)leaf);
        }
    }

    private GroupBuilder getInternalProductRoot() throws CoreException {
        CSpecBuilder cspec = this.getCSpec();
        GroupBuilder productRoot = cspec.getGroup(ATTRIBUTE_INTERNAL_PRODUCT_ROOT);
        if (productRoot == null) {
            productRoot = cspec.addGroup(ATTRIBUTE_INTERNAL_PRODUCT_ROOT, false);
            cspec.getRequiredGroup("product.root.files").addLocalPrerequisite((AttributeBuilder)productRoot);
        }
        return productRoot;
    }
}

