/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.cspecgen.feature;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.buckminster.core.cspec.builder.CSpecBuilder;
import org.eclipse.buckminster.core.ctype.IResolutionBuilder;
import org.eclipse.buckminster.core.ctype.MissingCSpecSourceException;
import org.eclipse.buckminster.core.helpers.PropertiesParser;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.pde.cspecgen.PDEBuilder;
import org.eclipse.buckminster.pde.cspecgen.feature.CSpecFromSource;
import org.eclipse.buckminster.pde.internal.EclipsePlatformReader;
import org.eclipse.buckminster.pde.internal.FeatureModelReader;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureBuilder
extends PDEBuilder {
    public static void addRootsPermissions(Map<String, String> hints, String perm, String filesAndFolders, String[] spec) {
        StringBuilder bld = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(filesAndFolders, ",");
        while (tokenizer.hasMoreTokens()) {
            if (bld.length() > 0) {
                bld.append(',');
            }
            bld.append(tokenizer.nextToken().trim());
            bld.append(':');
            bld.append(perm);
        }
        if (bld.length() > 0) {
            String key = spec != null && spec.length >= 3 ? String.format("%s/%s.%s.%s", "permissions", spec[0], spec[1], spec[2]) : "permissions";
            String permissions = hints.get(key);
            if (permissions != null) {
                bld.append(',');
                bld.append(permissions);
            }
            hints.put(key, bld.toString());
        }
    }

    public int compareTo(IResolutionBuilder other) {
        return 1;
    }

    public String getComponentTypeID() {
        return "eclipse.feature";
    }

    @Override
    protected void parseFile(CSpecBuilder cspecBuilder, boolean forResolutionAidOnly, ICatalogReader reader, IProgressMonitor monitor) throws CoreException {
        IFeature feature;
        monitor.beginTask(null, 100);
        try {
            IFeatureModel model;
            if (reader instanceof EclipsePlatformReader) {
                model = ((EclipsePlatformReader)reader).getFeatureModel();
                MonitorUtils.worked((IProgressMonitor)monitor, (int)40);
            } else {
                try {
                    model = (IFeatureModel)reader.readFile("feature.xml", (IStreamConsumer)new FeatureModelReader(), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)40));
                }
                catch (FileNotFoundException e) {
                    model = null;
                }
            }
            if (model == null) {
                throw new MissingCSpecSourceException(reader.getProviderMatch());
            }
            this.setModel((IModel)model);
            feature = model.getFeature();
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        Map buildProperties = null;
        if (!forResolutionAidOnly) {
            try {
                buildProperties = (Map)reader.readFile("build.properties", (IStreamConsumer)new PropertiesParser(), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)40));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        CSpecFromSource generator = new CSpecFromSource(cspecBuilder, reader, feature, buildProperties);
        generator.generate(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)20));
        monitor.done();
    }
}

