/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.internal.EclipseImportReaderType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EclipseImportBase {
    static final String PARAM_IMPORT_TYPE = "importType";
    static final String IMPORT_TYPE_BINARY = "binary";
    static final String IMPORT_TYPE_LINKED = "linked";
    static final String IMPORT_TYPE_SOURCE = "source";
    private final int m_type;
    private final boolean m_platform;
    private final boolean m_feature;
    private final Key m_key;
    private final String m_query;
    private final File m_location;
    private final URL m_remoteLocation;
    private boolean m_unpack = false;
    private static final UUID CACHE_IMPORT_BASE_CACHE = UUID.randomUUID();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EclipseImportBase obtain(NodeQuery query, String repositoryURI) throws CoreException {
        Map<Key, EclipseImportBase> cache;
        Key key = new Key(repositoryURI, query.getComponentRequest());
        Map<Key, EclipseImportBase> map = cache = EclipseImportBase.getImportBaseCacheCache(query.getContext().getUserCache());
        synchronized (map) {
            EclipseImportBase importBase = cache.get(key);
            if (importBase == null) {
                importBase = new EclipseImportBase(key);
                cache.put(key, importBase);
            }
            return importBase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<Key, EclipseImportBase> getImportBaseCacheCache(Map<UUID, Object> ctxUserCache) {
        Map<UUID, Object> map = ctxUserCache;
        synchronized (map) {
            Map listCache = (Map)ctxUserCache.get(CACHE_IMPORT_BASE_CACHE);
            if (listCache == null) {
                listCache = Collections.synchronizedMap(new HashMap());
                ctxUserCache.put(CACHE_IMPORT_BASE_CACHE, listCache);
            }
            return listCache;
        }
    }

    private EclipseImportBase(Key key) throws CoreException {
        URI uri;
        try {
            uri = new URI(key.getRepositoryURI());
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.fromMessage((String)e.getMessage(), (Object[])new Object[0]);
        }
        String scheme = uri.getScheme();
        String path = uri.getPath();
        URL remoteLocation = null;
        File location = null;
        boolean platform = false;
        if (scheme == null) {
            if (path == null || path.length() == 0) {
                platform = true;
            } else {
                location = new File(path);
            }
        } else if ("file".equalsIgnoreCase(scheme)) {
            location = new File(path);
        } else {
            try {
                if (!(path.endsWith("/") || path.endsWith(".map") || path.endsWith(".xml") || path.endsWith(".jar"))) {
                    path = String.valueOf(path) + '/';
                }
                remoteLocation = new URL(scheme, uri.getHost(), path);
            }
            catch (MalformedURLException e) {
                throw BuckminsterException.fromMessage((String)e.getMessage(), (Object[])new Object[0]);
            }
        }
        this.m_location = location;
        this.m_remoteLocation = remoteLocation;
        this.m_platform = platform;
        this.m_query = uri.getQuery();
        this.m_key = key;
        this.m_feature = "eclipse.feature".equals(key.getRequest().getComponentTypeID());
        Map params = URLUtils.queryAsParameters((String)uri.getQuery());
        String importType = (String)params.get(PARAM_IMPORT_TYPE);
        if (importType == null || IMPORT_TYPE_BINARY.equalsIgnoreCase(importType)) {
            this.m_type = 1;
        } else if (IMPORT_TYPE_LINKED.equalsIgnoreCase(importType)) {
            this.m_type = 2;
        } else if (IMPORT_TYPE_SOURCE.equalsIgnoreCase(importType)) {
            this.m_type = 3;
        } else {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.invalid_import_type_0, (Object)importType), (Object[])new Object[0]);
        }
    }

    public boolean equals(Object o) {
        return o == this || o instanceof EclipseImportBase && ((EclipseImportBase)o).m_key.equals(this.m_key);
    }

    public int hashCode() {
        return this.m_key.hashCode();
    }

    String getComponentName() {
        return this.m_key.getRequest().getName();
    }

    List<IFeatureModel> getFeatureModels(EclipseImportReaderType readerType, IProgressMonitor monitor) throws CoreException {
        return readerType.getFeatureModels(this.getLocation(), this.getComponentName(), monitor);
    }

    Key getKey() {
        return this.m_key;
    }

    final File getLocation() throws CoreException {
        if (this.m_location == null && !this.m_platform) {
            throw BuckminsterException.fromMessage((String)Messages.site_is_not_local, (Object[])new Object[0]);
        }
        return this.m_location;
    }

    List<IPluginModelBase> getPluginModels(EclipseImportReaderType readerType, IProgressMonitor monitor) throws CoreException {
        return readerType.getPluginModels(this.getLocation(), this.getComponentName(), monitor);
    }

    String getQuery() {
        return this.m_query;
    }

    final URL getRemoteLocation() throws CoreException {
        if (this.m_remoteLocation == null) {
            try {
                return this.m_location.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        return this.m_remoteLocation;
    }

    int getType() {
        return this.m_type;
    }

    boolean isFeature() {
        return this.m_feature;
    }

    boolean isLocal() {
        return this.m_remoteLocation == null;
    }

    boolean isUnpack() {
        return this.m_unpack;
    }

    void setUnpack(boolean unpack) {
        this.m_unpack = unpack;
    }

    static class Key {
        private final String m_repositoryURI;
        private final ComponentRequest m_request;

        Key(String repositoryURI, ComponentRequest request) {
            this.m_repositoryURI = repositoryURI;
            this.m_request = request;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Key && this.m_repositoryURI.equals(((Key)o).m_repositoryURI) && this.m_request.equals((Object)((Key)o).m_request);
        }

        public String getRepositoryURI() {
            return this.m_repositoryURI;
        }

        public ComponentRequest getRequest() {
            return this.m_request;
        }

        public int hashCode() {
            return this.m_repositoryURI.hashCode() * 37 + this.m_request.hashCode();
        }
    }
}

