/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.AbstractVersionFinder;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.internal.EclipseImportBase;
import org.eclipse.buckminster.pde.internal.EclipseImportReaderType;
import org.eclipse.buckminster.runtime.BuckminsterPreferences;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.FeatureDownloadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseImportFinder
extends AbstractVersionFinder {
    private final EclipseImportReaderType m_readerType;
    private final EclipseImportBase m_base;
    private final NodeQuery m_query;
    private static final UUID CACHE_KEY_PLUGIN_ENTRIES_CACHE = UUID.randomUUID();
    private final int m_connectionRetryCount = BuckminsterPreferences.getConnectionRetryCount();
    private final long m_connectionRetryDelay = (long)BuckminsterPreferences.getConnectionRetryDelay() * 1000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ISiteFeatureReference[] getSiteFeatureReferences(URL location, IProgressMonitor monitor) throws CoreException {
        Class<SiteManager> clazz = SiteManager.class;
        synchronized (SiteManager.class) {
            ISite site = SiteManager.getSite((URL)location, (boolean)true, (IProgressMonitor)monitor);
            if (site == null) {
                throw new OperationCanceledException();
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return site.getFeatureReferences();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<URL, IPluginEntry[]> getPluginEntriesCache(Map<UUID, Object> ctxUserCache) {
        Map<UUID, Object> map = ctxUserCache;
        synchronized (map) {
            Map cache = (Map)ctxUserCache.get(CACHE_KEY_PLUGIN_ENTRIES_CACHE);
            if (cache == null) {
                cache = Collections.synchronizedMap(new HashMap());
                ctxUserCache.put(CACHE_KEY_PLUGIN_ENTRIES_CACHE, cache);
            }
            return cache;
        }
    }

    public EclipseImportFinder(EclipseImportReaderType readerType, Provider provider, IComponentType ctype, NodeQuery query) throws CoreException {
        super(provider, ctype, query);
        this.m_base = EclipseImportBase.obtain(query, provider.getURI(query.getProperties()));
        this.m_readerType = readerType;
        this.m_query = query;
    }

    public VersionMatch getBestVersion(IProgressMonitor monitor) throws CoreException {
        return this.m_base.isFeature() ? this.getBestFeatureVersion(monitor) : this.getBestPluginVersion(monitor);
    }

    private void addFeaturePluginEntries(HashMap<VersionedIdentifier, IPluginEntry> entries, HashSet<VersionedIdentifier> seenFeatures, IFeature feature, IProgressMonitor monitor) throws CoreException {
        IPluginEntry[] iPluginEntryArray = feature.getRawPluginEntries();
        int n = iPluginEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginEntry entry = iPluginEntryArray[n2];
            entries.put(entry.getVersionedIdentifier(), entry);
            ++n2;
        }
        IIncludedFeatureReference[] includedFeatures = feature.getIncludedFeatureReferences();
        if (includedFeatures.length == 0) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return;
        }
        monitor.beginTask(null, includedFeatures.length * 100);
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray = includedFeatures;
        int n3 = includedFeatures.length;
        n = 0;
        while (n < n3) {
            IIncludedFeatureReference ref = iIncludedFeatureReferenceArray[n];
            VersionedIdentifier vid = ref.getVersionedIdentifier();
            if (seenFeatures.contains(vid)) {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)100);
            } else {
                seenFeatures.add(vid);
                IFeature includedFeature = this.obtainFeature((IFeatureReference)ref, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                if (feature != null) {
                    this.addFeaturePluginEntries(entries, seenFeatures, includedFeature, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                }
            }
            ++n;
        }
        monitor.done();
    }

    private VersionMatch getBestFeatureVersion(IProgressMonitor monitor) throws CoreException {
        return this.m_base.isLocal() ? this.getBestLocalFeatureVersion(monitor) : this.getBestRemoteFeatureVersion(monitor);
    }

    private VersionMatch getBestLocalFeatureVersion(IProgressMonitor monitor) throws CoreException {
        IVersion bestFit = null;
        for (IFeatureModel model : this.m_base.getFeatureModels(this.m_readerType, monitor)) {
            IVersion version = VersionFactory.OSGiType.fromString(model.getFeature().getVersion());
            if (!this.getQuery().isMatch(version, null) || bestFit != null && version.compareTo((Object)bestFit) <= 0) continue;
            bestFit = version;
        }
        if (bestFit == null) {
            return null;
        }
        return new VersionMatch(bestFit, null, -1L, null, null);
    }

    private VersionMatch getBestLocalPluginVersion(IProgressMonitor monitor) throws CoreException {
        IVersion bestFit = null;
        for (IPluginModelBase model : this.m_base.getPluginModels(this.m_readerType, monitor)) {
            IVersion version = VersionFactory.OSGiType.fromString(model.getBundleDescription().getVersion().toString());
            if (!this.getQuery().isMatch(version, null)) continue;
            if (bestFit == null) {
                bestFit = version;
                continue;
            }
            if (version.compareTo((Object)bestFit) <= 0) continue;
            this.logDecision(ResolverDecisionType.VERSION_REJECTED, new Object[]{bestFit, NLS.bind((String)Messages._0_is_higher, (Object)version)});
            bestFit = version;
        }
        if (bestFit == null) {
            return null;
        }
        return new VersionMatch(bestFit, null, -1L, null, null);
    }

    private VersionMatch getBestPluginVersion(IProgressMonitor monitor) throws CoreException {
        return this.m_base.isLocal() ? this.getBestLocalPluginVersion(monitor) : this.getBestRemotePluginVersion(monitor);
    }

    private VersionMatch getBestRemoteFeatureVersion(IProgressMonitor monitor) throws CoreException {
        IVersion bestFit = null;
        monitor.beginTask(null, 100);
        monitor.subTask(Messages.fetching_remote_feature_references);
        try {
            ISiteFeatureReference[] iSiteFeatureReferenceArray = EclipseImportFinder.getSiteFeatureReferences(this.m_base.getRemoteLocation(), monitor);
            int n = iSiteFeatureReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISiteFeatureReference model = iSiteFeatureReferenceArray[n2];
                if (model.getVersionedIdentifier().getIdentifier().equals(this.m_base.getComponentName())) {
                    IFeature feature = model.getFeature(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)5));
                    IVersion version = VersionFactory.OSGiType.fromString(feature.getVersionedIdentifier().getVersion().toString());
                    if (this.getQuery().isMatch(version, null)) {
                        if (bestFit == null) {
                            bestFit = version;
                        } else if (version.compareTo((Object)bestFit) > 0) {
                            this.logDecision(ResolverDecisionType.VERSION_REJECTED, new Object[]{bestFit, NLS.bind((String)Messages._0_is_higher, (Object)version)});
                            bestFit = version;
                        }
                    }
                }
                ++n2;
            }
            if (bestFit == null) {
                return null;
            }
            VersionMatch versionMatch = new VersionMatch(bestFit, null, -1L, null, null);
            return versionMatch;
        }
        finally {
            monitor.done();
        }
    }

    private VersionMatch getBestRemotePluginVersion(IProgressMonitor monitor) throws CoreException {
        IVersion bestFit = null;
        IPluginEntry[] iPluginEntryArray = this.getSitePluginEntries(this.m_base.getRemoteLocation(), this.getConnectContext(), this.m_query, monitor);
        int n = iPluginEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginEntry model = iPluginEntryArray[n2];
            if (model.getVersionedIdentifier().getIdentifier().equals(this.m_base.getComponentName())) {
                IVersion version = VersionFactory.OSGiType.fromString(model.getVersionedIdentifier().getVersion().toString());
                if (this.getQuery().isMatch(version, null)) {
                    if (bestFit == null) {
                        bestFit = version;
                    } else if (version.compareTo((Object)bestFit) > 0) {
                        this.logDecision(ResolverDecisionType.VERSION_REJECTED, new Object[]{bestFit, NLS.bind((String)Messages._0_is_higher, (Object)version)});
                        bestFit = version;
                    }
                }
            }
            ++n2;
        }
        if (bestFit == null) {
            return null;
        }
        return new VersionMatch(bestFit, null, -1L, null, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private IPluginEntry[] getSitePluginEntries(URL location, IConnectContext cctx, NodeQuery query, IProgressMonitor monitor) throws CoreException {
        String string = location.toString().intern();
        synchronized (string) {
            Map<URL, IPluginEntry[]> cache = EclipseImportFinder.getPluginEntriesCache(query.getContext().getUserCache());
            Object[] entries = cache.get(location);
            if (entries != null) {
                return entries;
            }
            if (location.getPath().endsWith(".map")) {
                MonitorUtils.complete((IProgressMonitor)monitor);
                entries = EclipseImportReaderType.getMapPluginEntries(location, cctx);
                cache.put(location, (IPluginEntry[])entries);
                return entries;
            }
            MonitorUtils.begin((IProgressMonitor)monitor, (int)100);
            Class<SiteManager> clazz = SiteManager.class;
            synchronized (SiteManager.class) {
                Object[] objectArray;
                Object[] objectArray2;
                ISite site = SiteManager.getSite((URL)location, (boolean)true, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                if (site == null) {
                    throw new OperationCanceledException();
                }
                try {
                    entries = site.getPluginEntries();
                    cache.put(location, (IPluginEntry[])entries);
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
                    objectArray2 = entries;
                }
                catch (UnsupportedOperationException uoe) {
                    HashMap<VersionedIdentifier, IPluginEntry> entryCache = new HashMap<VersionedIdentifier, IPluginEntry>();
                    HashSet<VersionedIdentifier> seenFeatures = new HashSet<VersionedIdentifier>();
                    ISiteFeatureReference[] refs = EclipseImportFinder.getSiteFeatureReferences(location, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10));
                    IProgressMonitor itemsMonitor = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)40);
                    itemsMonitor.beginTask(null, refs.length * 100);
                    ISiteFeatureReference[] iSiteFeatureReferenceArray = refs;
                    int n = refs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFeature feature;
                        ISiteFeatureReference ref = iSiteFeatureReferenceArray[n2];
                        VersionedIdentifier vid = ref.getVersionedIdentifier();
                        if (seenFeatures.add(vid) && (feature = this.obtainFeature((IFeatureReference)ref, MonitorUtils.subMonitor((IProgressMonitor)itemsMonitor, (int)50))) != null) {
                            this.addFeaturePluginEntries(entryCache, seenFeatures, feature, MonitorUtils.subMonitor((IProgressMonitor)itemsMonitor, (int)50));
                        }
                        ++n2;
                    }
                    entries = entryCache.values().toArray(new IPluginEntry[entryCache.size()]);
                    cache.put(location, (IPluginEntry[])entries);
                    objectArray = entries;
                }
                MonitorUtils.done((IProgressMonitor)monitor);
                // ** MonitorExit[var9_8] (shouldn't be in output)
                return objectArray2;
                MonitorUtils.done((IProgressMonitor)monitor);
                // ** MonitorExit[var9_8] (shouldn't be in output)
                return objectArray;
                {
                    catch (Throwable throwable) {
                        MonitorUtils.done((IProgressMonitor)monitor);
                        throw throwable;
                    }
                }
            }
        }
    }

    private IFeature obtainFeature(IFeatureReference ref, IProgressMonitor monitor) {
        Throwable e;
        Logger logger = PDEPlugin.getLogger();
        int retryCount = 0;
        while (true) {
            try {
                logger.debug("Downloading %s", new Object[]{ref.getURL()});
                return ref.getFeature(monitor);
            }
            catch (FeatureDownloadException ex) {
                block7: {
                    Throwable t;
                    if (retryCount < this.m_connectionRetryCount && (t = ex.getStatus().getException()) instanceof IOException && !(t instanceof FileNotFoundException)) {
                        ++retryCount;
                        try {
                            Thread.sleep(this.m_connectionRetryDelay);
                            logger.warning(NLS.bind((String)Messages.connection_to_0_failed_on_1_retry_attempt_2_started, (Object[])new Object[]{ref.getURL(), t.getMessage(), new Integer(retryCount)}), new Object[0]);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break block7;
                        }
                        continue;
                    }
                }
                e = ex;
            }
            catch (Exception ex) {
                e = ex;
            }
            break;
        }
        logger.warning(e, e.getMessage(), new Object[0]);
        return null;
    }
}

