/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.buckminster.core.helpers.FileHandle;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.reader.AbstractRemoteReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.pde.IPDEConstants;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.internal.EclipseImportBase;
import org.eclipse.buckminster.pde.internal.EclipseImportReaderType;
import org.eclipse.buckminster.pde.internal.imports.FeatureImportOperation;
import org.eclipse.buckminster.pde.internal.imports.PluginImportOperation;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class EclipseImportReader
extends AbstractRemoteReader
implements IPDEConstants {
    private EclipseImportBase m_base;
    private IModel m_model;

    protected EclipseImportReader(EclipseImportReaderType readerType, ProviderMatch rInfo) throws CoreException {
        super((IReaderType)readerType, rInfo);
        this.m_base = EclipseImportBase.obtain(rInfo.getNodeQuery(), rInfo.getRepositoryURI());
        IVersion version = rInfo.getVersionMatch().getVersion();
        Object object = this.m_model = this.m_base.isFeature() ? this.getFeatureModel(version, (IProgressMonitor)new NullProgressMonitor()) : this.getPluginModel(version, (IProgressMonitor)new NullProgressMonitor());
        if (this.m_model == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_load_model_for_0, (Object)this.m_base.getComponentName()), (Object[])new Object[0]);
        }
    }

    public IInstallableUnit getCachedInstallableUnit() throws CoreException {
        return ((EclipseImportReaderType)this.getReaderType()).getCachedInstallableUnit(this.getProviderMatch());
    }

    public void innerMaterialize(IPath destination, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 1000);
        try {
            boolean isPlugin = this.m_model instanceof IPluginModelBase;
            this.localize(isPlugin, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)800));
            IWorkspaceRunnable job = isPlugin ? this.getPluginImportJob((IPluginModelBase)this.m_model, destination) : this.getFeatureImportJob((IFeatureModel)this.m_model, destination);
            ResourcesPlugin.getWorkspace().run(job, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)200));
        }
        finally {
            monitor.done();
        }
    }

    public boolean isUnpack() {
        return this.m_base.isUnpack();
    }

    protected FileHandle innerGetContents(String fileName, IProgressMonitor monitor) throws CoreException, IOException {
        FileHandle fileHandle;
        monitor.beginTask(null, 1000);
        File destFile = null;
        FileOutputStream output = null;
        try {
            boolean isPlugin = this.m_model instanceof IPluginModelBase;
            this.localize(isPlugin, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)890));
            destFile = this.createTempFile();
            output = new FileOutputStream(destFile);
            MonitorUtils.worked((IProgressMonitor)monitor, (int)10);
            InputStream input = null;
            try {
                File source = this.getInstallLocation();
                if (source.isDirectory()) {
                    input = new FileInputStream(new File(source, fileName));
                } else {
                    ZipFile zipFile = new ZipFile(source);
                    ZipEntry entry = zipFile.getEntry(fileName);
                    if (entry == null) {
                        throw new FileNotFoundException(String.valueOf(source.getName()) + '!' + fileName);
                    }
                    input = zipFile.getInputStream(entry);
                }
                FileUtils.copyFile((InputStream)input, (OutputStream)output, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            }
            catch (Throwable throwable) {
                IOUtils.close(input);
                throw throwable;
            }
            IOUtils.close((Closeable)input);
            FileHandle fh = new FileHandle(fileName, destFile, true);
            destFile = null;
            fileHandle = fh;
        }
        catch (Throwable throwable) {
            IOUtils.close(output);
            if (destFile != null) {
                destFile.delete();
            }
            throw throwable;
        }
        IOUtils.close((Closeable)output);
        if (destFile != null) {
            destFile.delete();
        }
        return fileHandle;
    }

    IPluginModelBase getPluginModel(IVersion version, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, this.m_base.isLocal() ? 1000 : 2000);
        monitor.subTask(NLS.bind((String)Messages.downloading_0, (Object)this.m_base.getComponentName()));
        try {
            EclipseImportReaderType readerType = (EclipseImportReaderType)this.getReaderType();
            if (!this.m_base.isLocal()) {
                this.localize(true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
            }
            IPluginModelBase model = null;
            for (IPluginModelBase candidate : this.m_base.getPluginModels(readerType, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000))) {
                if (version != null && !version.toString().equals(candidate.getBundleDescription().getVersion().toString())) continue;
                model = candidate;
                break;
            }
            IPluginModelBase iPluginModelBase = model;
            return iPluginModelBase;
        }
        finally {
            monitor.done();
        }
    }

    private IWorkspaceRunnable getFeatureImportJob(IFeatureModel model, IPath destination) {
        return new FeatureImportOperation((EclipseImportReaderType)this.getReaderType(), model, this.getNodeQuery(), destination, this.m_base.getType() == 1);
    }

    private IFeatureModel getFeatureModel(IVersion version, IProgressMonitor monitor) throws CoreException {
        IFeatureModel model = null;
        monitor.beginTask(null, this.m_base.isLocal() ? 1000 : 3000);
        try {
            if (!this.m_base.isLocal()) {
                this.localize(false, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000));
            }
            EclipseImportReaderType readerType = (EclipseImportReaderType)this.getReaderType();
            for (IFeatureModel candidate : this.m_base.getFeatureModels(readerType, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1000))) {
                if (version != null && !version.toString().equals(candidate.getFeature().getVersion())) continue;
                model = candidate;
                break;
            }
            IFeatureModel iFeatureModel = model;
            return iFeatureModel;
        }
        finally {
            monitor.done();
        }
    }

    private File getInstallLocation() {
        String location = this.m_model instanceof IPluginModelBase ? ((IPluginModelBase)this.m_model).getInstallLocation() : ((IFeatureModel)this.m_model).getInstallLocation();
        return new File(location);
    }

    private IWorkspaceRunnable getPluginImportJob(IPluginModelBase model, IPath destination) {
        PluginImportOperation job = new PluginImportOperation(model, this.getNodeQuery(), destination, this.m_base.getType());
        job.setClasspathCollector((EclipseImportReaderType)this.getReaderType());
        return job;
    }

    private void localize(boolean isPlugin, IProgressMonitor monitor) throws CoreException {
        if (this.m_base.isLocal()) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return;
        }
        monitor.beginTask(null, 1000);
        ProviderMatch ri = this.getProviderMatch();
        this.m_base = ((EclipseImportReaderType)this.getReaderType()).localizeContents(ri, isPlugin, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)950));
        IVersion version = ri.getVersionMatch().getVersion();
        IProgressMonitor subMon = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50);
        Object object = this.m_model = isPlugin ? this.getPluginModel(version, subMon) : this.getFeatureModel(version, subMon);
        if (this.m_model == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_load_localized_model_for_0, (Object)this.m_base.getComponentName()), (Object[])new Object[0]);
        }
        monitor.done();
    }
}

