/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.core.reader.CatalogReaderType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.pde.IPDEConstants;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.internal.EclipseImportBase;
import org.eclipse.buckminster.pde.internal.EclipseImportFinder;
import org.eclipse.buckminster.pde.internal.EclipseImportReader;
import org.eclipse.buckminster.pde.internal.P2VersionFinder;
import org.eclipse.buckminster.pde.internal.imports.PluginImportOperation;
import org.eclipse.buckminster.pde.mapfile.MapFile;
import org.eclipse.buckminster.pde.mapfile.MapFileEntry;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IFileInfo;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRequest;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryIO;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRequest;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepHandler;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.jarprocessor.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseImportReaderType
extends CatalogReaderType
implements IPDEConstants {
    private static final UUID CACHE_KEY_SITE_CACHE = UUID.randomUUID();
    private static final UUID CACHE_KEY_MDR_CACHE = UUID.randomUUID();
    private final Map<IProject, IClasspathEntry[]> m_classpaths = new HashMap<IProject, IClasspathEntry[]>();
    private final HashMap<File, IFeatureModel[]> m_featureCache = new HashMap();
    private final HashMap<File, IPluginModelBase[]> m_pluginCache = new HashMap();

    public static IArtifactRepository getArtifactRepository(URI repoLocation, IProgressMonitor monitor) throws CoreException {
        URL repoURL;
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)PDEPlugin.getContext(), (String)IArtifactRepositoryManager.class.getName());
        if (manager == null) {
            throw new IllegalStateException("No metadata repository manager found");
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        try {
            repoURL = repoLocation.toURL();
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        try {
            IArtifactRepository iArtifactRepository = manager.loadRepository(repoURL, (IProgressMonitor)subMon.newChild(100));
            return iArtifactRepository;
        }
        catch (ProvisionException e) {
            IArtifactRepository iArtifactRepository = manager.refreshRepository(repoURL, (IProgressMonitor)subMon.newChild(100));
            return iArtifactRepository;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTempSite(Map<UUID, Object> ucache) throws CoreException {
        Map<String, File> siteCache;
        Map<String, File> map = siteCache = EclipseImportReaderType.getSiteCache(ucache);
        synchronized (map) {
            String key = String.valueOf(EclipseImportReaderType.class.getSimpleName()) + ":tempSite";
            File tempSite = siteCache.get(key);
            if (tempSite != null) {
                return tempSite;
            }
            tempSite = FileUtils.createTempFolder((String)"bmsite", (String)".tmp");
            new File(tempSite, "plugins").mkdir();
            new File(tempSite, "features").mkdir();
            siteCache.put(key, tempSite);
            return tempSite;
        }
    }

    static URL createRemoteComponentURL(URL remoteLocation, IConnectContext cctx, String name, IVersion version, String subDir) throws MalformedURLException, CoreException {
        if (remoteLocation.getPath().endsWith(".jar")) {
            return remoteLocation;
        }
        if (remoteLocation.getPath().endsWith(".map")) {
            RemotePluginEntry[] remotePluginEntryArray = EclipseImportReaderType.getMapPluginEntries(remoteLocation, cctx);
            int n = remotePluginEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                RemotePluginEntry entry = remotePluginEntryArray[n2];
                VersionedIdentifier vid = entry.getVersionedIdentifier();
                if (name.equals(vid.getIdentifier()) && version.equalsUnqualified(VersionFactory.OSGiType.coerce((Object)vid.getVersion()))) {
                    return entry.getRemoteLocation();
                }
                ++n2;
            }
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_find_0_in_map_1, (Object)name, (Object)remoteLocation), (Object[])new Object[0]);
        }
        return new URL(remoteLocation, String.valueOf(subDir) + '/' + name + '_' + version + ".jar");
    }

    /*
     * Loose catch block
     */
    static RemotePluginEntry[] getMapPluginEntries(URL location, IConnectContext cctx) throws CoreException {
        RemotePluginEntry[] remotePluginEntryArray;
        InputStream input = null;
        try {
            ArrayList<MapFileEntry> mapEntries = new ArrayList<MapFileEntry>();
            input = DownloadManager.read((URL)location, (IConnectContext)cctx);
            MapFile.parse(input, location.toString(), mapEntries);
            ArrayList<RemotePluginEntry> entries = new ArrayList<RemotePluginEntry>();
            for (MapFileEntry entry : mapEntries) {
                RemotePluginEntry pluginEntry;
                Map<String, String> props;
                String src;
                ComponentIdentifier cid = entry.getComponentIdentifier();
                if (!"osgi.bundle".equals(cid.getComponentTypeID()) || !"url".equals(entry.getReaderType().getId()) || (src = (props = entry.getProperties()).get("src")) == null || !src.endsWith(".jar") && !src.endsWith(".zip")) continue;
                try {
                    pluginEntry = new RemotePluginEntry(new URL(src));
                }
                catch (MalformedURLException e) {
                    continue;
                }
                pluginEntry.setPluginIdentifier(cid.getName());
                if (cid.getVersion() != null) {
                    pluginEntry.setPluginVersion(cid.getVersion().toString());
                }
                pluginEntry.setUnpack(Boolean.parseBoolean(props.get("unpack")));
                entries.add(pluginEntry);
            }
            remotePluginEntryArray = entries.toArray(new RemotePluginEntry[entries.size()]);
        }
        catch (FileNotFoundException e) {
            RemotePluginEntry[] remotePluginEntryArray2 = new RemotePluginEntry[]{};
            IOUtils.close((Closeable)input);
            return remotePluginEntryArray2;
        }
        catch (IOException e2) {
            throw BuckminsterException.wrap((Throwable)e2);
            {
                catch (Throwable throwable) {
                    IOUtils.close(input);
                    throw throwable;
                }
            }
        }
        IOUtils.close((Closeable)input);
        return remotePluginEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, File> getSiteCache(Map<UUID, Object> ctxUserCache) {
        Map<UUID, Object> map = ctxUserCache;
        synchronized (map) {
            Map siteCache = (Map)ctxUserCache.get(CACHE_KEY_SITE_CACHE);
            if (siteCache == null) {
                siteCache = Collections.synchronizedMap(new HashMap());
                ctxUserCache.put(CACHE_KEY_SITE_CACHE, siteCache);
            }
            return siteCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, IMetadataRepository> getMDRCache(Map<UUID, Object> ctxUserCache) {
        Map<UUID, Object> map = ctxUserCache;
        synchronized (map) {
            Map cache = (Map)ctxUserCache.get(CACHE_KEY_MDR_CACHE);
            if (cache == null) {
                cache = Collections.synchronizedMap(new HashMap());
                ctxUserCache.put(CACHE_KEY_MDR_CACHE, cache);
            }
            return cache;
        }
    }

    public synchronized void addProjectClasspath(IProject project, IClasspathEntry[] classPath) {
        this.m_classpaths.put(project, classPath);
    }

    public URI getArtifactURL(Resolution resolution, RMContext context) throws CoreException {
        try {
            URL siteURL = new URL(resolution.getRepository());
            String sitePath = siteURL.getPath();
            if (!(sitePath.endsWith(".map") || sitePath.endsWith(".xml") || sitePath.endsWith(".jar"))) {
                siteURL = URLUtils.appendTrailingSlash((URL)siteURL);
            }
            String subDir = "eclipse.feature".equals(resolution.getComponentTypeId()) ? "features" : "plugins";
            return EclipseImportReaderType.createRemoteComponentURL(siteURL, null, resolution.getName(), resolution.getVersion(), subDir).toURI();
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public IComponentReader getReader(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new EclipseImportReader(this, providerMatch);
    }

    /*
     * Loose catch block
     */
    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery nodeQuery, IProgressMonitor monitor) throws CoreException {
        String base;
        String url = provider.getURI(nodeQuery.getProperties());
        URI uri = URI.create(url);
        String path = uri.getPath();
        if (path.endsWith(".jar") || path.endsWith(".map") || path.endsWith(".zip") || path.endsWith(".xml")) {
            MonitorUtils.complete((IProgressMonitor)monitor);
            return new EclipseImportFinder(this, provider, ctype, nodeQuery);
        }
        StringBuilder bld = new StringBuilder(path);
        if (!path.endsWith("/")) {
            bld.append('/');
        }
        String string = base = bld.toString().intern();
        synchronized (string) {
            P2VersionFinder p2VersionFinder;
            Map<String, IMetadataRepository> mdrCache = EclipseImportReaderType.getMDRCache(nodeQuery.getContext().getUserCache());
            IMetadataRepository mdr = mdrCache.get(base);
            if (mdr != null) {
                MonitorUtils.complete((IProgressMonitor)monitor);
                return new P2VersionFinder(provider, ctype, nodeQuery, mdr);
            }
            if (mdrCache.containsKey(base)) {
                MonitorUtils.complete((IProgressMonitor)monitor);
                return new EclipseImportFinder(this, provider, ctype, nodeQuery);
            }
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)2000);
            bld.append("content");
            int len = bld.length();
            bld.append(".jar");
            IFileInfo[] fiHandle = new IFileInfo[1];
            InputStream in = null;
            try {
                URL location = new URL(uri.getScheme(), uri.getHost(), uri.getPort(), bld.toString());
                in = DownloadManager.getCache().open(location, provider.getConnectContext(), null, fiHandle, (IProgressMonitor)subMon.newChild(800));
                JarInputStream jarStream = new JarInputStream(in);
                JarEntry jarEntry = jarStream.getNextJarEntry();
                String entryName = "content.xml";
                while (jarEntry != null && !entryName.equals(jarEntry.getName())) {
                    jarEntry = jarStream.getNextJarEntry();
                }
                if (jarEntry == null) {
                    throw new FileNotFoundException();
                }
                MetadataRepositoryIO mdrIO = new MetadataRepositoryIO();
                mdr = mdrIO.read(location, (InputStream)jarStream, (IProgressMonitor)subMon.newChild(200));
                mdrCache.put(base, mdr);
                p2VersionFinder = new P2VersionFinder(provider, ctype, nodeQuery, mdr);
            }
            catch (Exception e) {
                Utils.close(in);
                in = null;
                bld.setLength(len);
                bld.append(".xml");
                URL location = new URL(uri.getScheme(), uri.getHost(), uri.getPort(), bld.toString());
                in = DownloadManager.getCache().open(location, provider.getConnectContext(), null, fiHandle, (IProgressMonitor)subMon.newChild(800));
                MetadataRepositoryIO mdrIO = new MetadataRepositoryIO();
                mdr = mdrIO.read(location, in, (IProgressMonitor)subMon.newChild(200));
                mdrCache.put(base, mdr);
                P2VersionFinder p2VersionFinder2 = new P2VersionFinder(provider, ctype, nodeQuery, mdr);
                Utils.close((Object)in);
                if (monitor != null) {
                    monitor.done();
                }
                return p2VersionFinder2;
                {
                    catch (Exception e2) {
                        EclipseImportFinder eclipseImportFinder;
                        try {
                            mdrCache.put(base, null);
                            eclipseImportFinder = new EclipseImportFinder(this, provider, ctype, nodeQuery);
                        }
                        catch (Throwable throwable) {
                            Utils.close(in);
                            if (monitor != null) {
                                monitor.done();
                            }
                            throw throwable;
                        }
                        Utils.close((Object)in);
                        if (monitor != null) {
                            monitor.done();
                        }
                        return eclipseImportFinder;
                    }
                }
            }
            Utils.close((Object)in);
            if (monitor != null) {
                monitor.done();
            }
            return p2VersionFinder;
        }
    }

    public synchronized void postMaterialization(MaterializationContext context, IProgressMonitor monitor) throws CoreException {
        PluginImportOperation.setClasspaths(monitor, this.m_classpaths);
        this.m_pluginCache.clear();
        this.m_featureCache.clear();
        this.m_classpaths.clear();
    }

    IInstallableUnit getCachedInstallableUnit(ProviderMatch providerMatch) throws CoreException {
        Collector c;
        NodeQuery query = providerMatch.getNodeQuery();
        URI uri = URI.create(providerMatch.getRepositoryURI());
        String path = uri.getPath();
        if (path.endsWith(".jar") || path.endsWith(".map") || path.endsWith(".zip") || path.endsWith(".xml")) {
            return null;
        }
        StringBuilder bld = new StringBuilder(path);
        if (!path.endsWith("/")) {
            bld.append('/');
        }
        String base = bld.toString();
        Map<String, IMetadataRepository> mdrCache = EclipseImportReaderType.getMDRCache(query.getContext().getUserCache());
        IMetadataRepository mdr = mdrCache.get(base);
        if (mdr == null) {
            return null;
        }
        IVersion bv = providerMatch.getVersionMatch().getVersion();
        if (bv == null) {
            return null;
        }
        Version v = Version.parseVersion((String)bv.toString());
        VersionRange vr = new VersionRange(v, true, v, true);
        ComponentRequest cr = query.getComponentRequest();
        String name = cr.getName();
        if ("eclipse.feature".equals(cr.getComponentTypeID()) && !name.endsWith(".feature.group")) {
            name = String.valueOf(name) + ".feature.group";
        }
        if ((c = mdr.query((Query)new InstallableUnitQuery(name, vr), new Collector(), null)).isEmpty()) {
            return null;
        }
        return (IInstallableUnit)c.iterator().next();
    }

    IFeatureModel getFeatureModel(ProviderMatch rInfo, IProgressMonitor monitor) throws CoreException {
        IFeatureModel model = null;
        EclipseImportBase localBase = this.localizeContents(rInfo, false, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
        String version = rInfo.getVersionMatch().getVersion().toString();
        for (IFeatureModel candidate : localBase.getFeatureModels(this, monitor)) {
            if (!version.equals(candidate.getFeature().getVersion())) continue;
            model = candidate;
            break;
        }
        return model;
    }

    List<IFeatureModel> getFeatureModels(File location, String featureName, IProgressMonitor monitor) throws CoreException {
        ArrayList<IFeatureModel> candidates = new ArrayList<IFeatureModel>();
        IFeatureModel[] iFeatureModelArray = this.getSiteFeatures(location, monitor);
        int n = iFeatureModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            if (model.getFeature().getId().equals(featureName)) {
                candidates.add(model);
            }
            ++n2;
        }
        return candidates;
    }

    IPluginModelBase getPluginModel(ProviderMatch rInfo, IProgressMonitor monitor) throws CoreException {
        IPluginModelBase model = null;
        EclipseImportBase localBase = this.localizeContents(rInfo, true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)90));
        String version = rInfo.getVersionMatch().getVersion().toString();
        for (IPluginModelBase candidate : localBase.getPluginModels(this, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)10))) {
            if (!version.equals(candidate.getBundleDescription().getVersion().toString())) continue;
            model = candidate;
            break;
        }
        return model;
    }

    List<IPluginModelBase> getPluginModels(File location, String pluginName, IProgressMonitor monitor) throws CoreException {
        ArrayList<IPluginModelBase> candidates = new ArrayList<IPluginModelBase>();
        IPluginModelBase[] iPluginModelBaseArray = this.getSitePlugins(location, monitor);
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            if (model.getPluginBase().getId().equals(pluginName)) {
                candidates.add(model);
            }
            ++n2;
        }
        return candidates;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    EclipseImportBase localizeContents(ProviderMatch rInfo, boolean isPlugin, IProgressMonitor monitor) throws CoreException {
        NodeQuery query = rInfo.getNodeQuery();
        EclipseImportBase base = EclipseImportBase.obtain(query, rInfo.getRepositoryURI());
        if (base.isLocal()) {
            return base;
        }
        EclipseImportBase eclipseImportBase = base;
        synchronized (eclipseImportBase) {
            Map userCache = query.getContext().getUserCache();
            String name = base.getComponentName();
            monitor.beginTask(null, 1000);
            monitor.subTask(NLS.bind((String)Messages.localizing_0, (Object)name));
            try {
                String jarName;
                File jarFile;
                IConnectContext cctx = rInfo.getConnectContext();
                String typeDir = isPlugin ? "plugins" : "features";
                File tempSite = EclipseImportReaderType.getTempSite(userCache);
                File subDir = new File(tempSite, typeDir);
                VersionMatch vm = rInfo.getVersionMatch();
                if (vm.getArtifactInfo() != null) {
                    IArtifactKey ak = ArtifactKey.parse((String)vm.getArtifactInfo());
                    IArtifactRepository ar = EclipseImportReaderType.getArtifactRepository(base.getRemoteLocation().toURI(), monitor);
                    IStatus status = ar.getArtifacts(new IArtifactRequest[]{new CopyRequest(ar, ak, jarFile = new File(subDir, jarName = String.valueOf(ak.getId()) + '_' + ak.getVersion() + ".jar"))}, monitor);
                    if (!status.isOK()) {
                        throw new CoreException(status);
                    }
                } else {
                    URL pluginURL = EclipseImportReaderType.createRemoteComponentURL(base.getRemoteLocation(), cctx, rInfo.getComponentName(), vm.getVersion(), typeDir);
                    IPath path = Path.fromPortableString((String)pluginURL.getPath());
                    jarName = path.lastSegment();
                    if (!jarName.endsWith(".jar") && !jarName.endsWith(".zip")) {
                        throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.invalid_url_fore_remote_import_0, (Object)pluginURL), (Object[])new Object[0]);
                    }
                    jarFile = new File(subDir, jarName);
                    InputStream input = null;
                    try {
                        input = DownloadManager.getCache().open(pluginURL, cctx, null, null, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)900));
                        FileUtils.copyFile((InputStream)input, (File)subDir, (String)jarName, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)900));
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(input);
                        throw throwable;
                    }
                    IOUtils.close((Closeable)input);
                }
                EclipseImportBase.Key remoteKey = base.getKey();
                base = EclipseImportBase.obtain(query, new URI("file", null, tempSite.toURI().getPath(), base.getQuery(), name).toString());
                File destDir = null;
                boolean unpack = true;
                ConflictResolution cres = ConflictResolution.REPLACE;
                if (jarName.endsWith(".zip")) {
                    destDir = subDir;
                    cres = ConflictResolution.UPDATE;
                } else {
                    if (!base.isFeature()) {
                        JarFile jf = new JarFile(jarFile);
                        Manifest mf = jf.getManifest();
                        if (mf != null) {
                            String[] classPath = TextUtils.split((String)mf.getMainAttributes().getValue("Bundle-ClassPath"), (String)",");
                            int top = classPath.length;
                            unpack = top > 0;
                            int idx = 0;
                            while (idx < top) {
                                if (classPath[idx].trim().equals(".")) {
                                    unpack = false;
                                    break;
                                }
                                ++idx;
                            }
                        }
                        jf.close();
                    }
                    if (unpack) {
                        String vcName = jarName.substring(0, jarName.length() - 4);
                        destDir = new File(subDir, vcName);
                    }
                }
                if (unpack) {
                    FileInputStream input = new FileInputStream(jarFile);
                    try {
                        FileUtils.unzip((InputStream)input, null, (File)destDir, (ConflictResolution)cres, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                    }
                    finally {
                        IOUtils.close((Closeable)input);
                    }
                    jarFile.delete();
                }
                base.setUnpack(unpack);
                EclipseImportBase.getImportBaseCacheCache(userCache).put(remoteKey, base);
                EclipseImportBase eclipseImportBase2 = base;
                return eclipseImportBase2;
            }
            catch (URISyntaxException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
            finally {
                monitor.done();
            }
        }
    }

    private CoreException createException(ArrayList<IStatus> resultStatus) {
        int errCount = resultStatus.size();
        if (errCount == 1) {
            return new CoreException(resultStatus.get(0));
        }
        IStatus[] children = resultStatus.toArray(new IStatus[errCount]);
        MultiStatus multiStatus = new MultiStatus(PDEPlugin.getPluginId(), 0, children, Messages.problems_loading_feature, null);
        return new CoreException((IStatus)multiStatus);
    }

    private IFeatureModel[] getPlatformFeatures() {
        return PDECore.getDefault().getFeatureModelManager().getModels();
    }

    private IPluginModelBase[] getPlatformPlugins() {
        return PDECore.getDefault().getModelManager().getExternalModels();
    }

    private synchronized IFeatureModel[] getSiteFeatures(File location, IProgressMonitor monitor) throws CoreException {
        if (location == null) {
            return this.getPlatformFeatures();
        }
        IFeatureModel[] result = this.m_featureCache.get(location);
        if (result != null) {
            return result;
        }
        File[] dirs = (location = new File(location, "features")).listFiles();
        if (dirs == null || dirs.length == 0) {
            return new IFeatureModel[0];
        }
        monitor.beginTask(null, dirs.length);
        monitor.subTask(NLS.bind((String)Messages.building_feature_list_for_site_0, (Object)location));
        ArrayList<ExternalFeatureModel> models = new ArrayList<ExternalFeatureModel>(dirs.length);
        ArrayList<IStatus> resultStatus = null;
        File[] fileArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                File dir = fileArray[n2];
                File manifest = new File(dir, "feature.xml");
                FileInputStream manifestInput = null;
                try {
                    manifestInput = new FileInputStream(manifest);
                    ExternalFeatureModel model = new ExternalFeatureModel();
                    model.setInstallLocation(dir.getAbsolutePath());
                    model.load((InputStream)manifestInput, false);
                    if (!model.isValid()) {
                        throw new CoreException((IStatus)new Status(2, PDEPlugin.getPluginId(), 0, NLS.bind((String)Messages.import_location_0_contains_invalid_feature, (Object)dir), null));
                    }
                    models.add(model);
                }
                catch (FileNotFoundException model) {
                    IOUtils.close(manifestInput);
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                    break block13;
                }
                catch (CoreException e) {
                    try {
                        if (resultStatus == null) {
                            resultStatus = new ArrayList<IStatus>();
                        }
                        resultStatus.add(e.getStatus());
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(manifestInput);
                        MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                        throw throwable;
                    }
                    IOUtils.close((Closeable)manifestInput);
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                    break block13;
                }
                IOUtils.close((Closeable)manifestInput);
                MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
            }
            ++n2;
        }
        if (resultStatus != null) {
            throw this.createException(resultStatus);
        }
        result = models.toArray(new IFeatureModel[models.size()]);
        this.m_featureCache.put(location, result);
        return result;
    }

    private synchronized IPluginModelBase[] getSitePlugins(File location, IProgressMonitor monitor) throws CoreException {
        if (location == null) {
            return this.getPlatformPlugins();
        }
        monitor.beginTask(null, 2);
        monitor.subTask(NLS.bind((String)Messages.building_plugin_list_for_site_0, (Object)location));
        try {
            File pluginsRoot = new File(location, "plugins");
            if (!pluginsRoot.isDirectory()) {
                IPluginModelBase[] iPluginModelBaseArray = new IPluginModelBase[]{};
                return iPluginModelBaseArray;
            }
            File[] files = pluginsRoot.listFiles();
            int idx = files.length;
            IPluginModelBase[] plugins = this.m_pluginCache.get(location);
            if (plugins != null && plugins.length == idx) {
                IPluginModelBase[] iPluginModelBaseArray = plugins;
                return iPluginModelBaseArray;
            }
            URL[] pluginURLs = new URL[idx];
            while (--idx >= 0) {
                pluginURLs[idx] = files[idx].toURI().toURL();
            }
            MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
            PDEState state = new PDEState(pluginURLs, false, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            IPluginModelBase[] workspace = state.getWorkspaceModels();
            IPluginModelBase[] target = state.getTargetModels();
            IPluginModelBase[] all = new IPluginModelBase[workspace.length + target.length];
            if (workspace.length > 0) {
                System.arraycopy(workspace, 0, all, 0, workspace.length);
            }
            if (target.length > 0) {
                System.arraycopy(target, 0, all, workspace.length, target.length);
            }
            plugins = all;
            this.m_pluginCache.put(location, plugins);
            IPluginModelBase[] iPluginModelBaseArray = plugins;
            return iPluginModelBaseArray;
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            monitor.done();
        }
    }

    public static class CopyRequest
    extends ArtifactRequest {
        private final File m_destination;

        public CopyRequest(IArtifactRepository src, IArtifactKey key, File destination) {
            super(key);
            this.setSourceRepository(src);
            this.m_destination = destination;
        }

        public void perform(IProgressMonitor monitor) {
            monitor.subTask(NLS.bind((String)Messages.downloading_0, (Object)this.getArtifactKey().getId()));
            IArtifactDescriptor optimized = null;
            IArtifactDescriptor canonical = null;
            IArtifactDescriptor desc = null;
            IArtifactDescriptor[] descriptors = this.source.getArtifactDescriptors(this.getArtifactKey());
            if (descriptors.length > 0) {
                int i = 0;
                while (i < descriptors.length) {
                    if (descriptors[i].getProperty("format") == null) {
                        canonical = descriptors[i];
                    } else if (ProcessingStepHandler.canProcess((IArtifactDescriptor)descriptors[i])) {
                        optimized = descriptors[i];
                    }
                    ++i;
                }
                boolean chooseCanonical = this.source.getLocation().equals("file");
                IArtifactDescriptor iArtifactDescriptor = desc = chooseCanonical ? canonical : optimized;
                if (desc == null) {
                    IArtifactDescriptor iArtifactDescriptor2 = desc = !chooseCanonical ? canonical : optimized;
                }
            }
            if (desc == null) {
                this.setResult((IStatus)new Status(4, PDEPlugin.getPluginId(), NLS.bind((String)Messages.artifact_not_found_0, (Object)this.getArtifactKey())));
                return;
            }
            IStatus status = this.transfer(desc, monitor);
            if (monitor.isCanceled()) {
                this.setResult(Status.CANCEL_STATUS);
                return;
            }
            if (status.isOK() || status.getSeverity() == 8) {
                this.setResult(status);
                return;
            }
            if (desc == canonical || canonical == null) {
                this.setResult(status);
                return;
            }
            this.setResult(this.transfer(canonical, monitor));
        }

        private IStatus transfer(IArtifactDescriptor desc, IProgressMonitor monitor) {
            IStatus status;
            while ((status = this.transferSingle(desc, monitor)).getSeverity() == 4 && status.getCode() == 13) {
            }
            return status;
        }

        private IStatus transferSingle(IArtifactDescriptor desc, IProgressMonitor monitor) {
            IStatus status;
            block5: {
                FileOutputStream destination = null;
                status = null;
                try {
                    try {
                        destination = new FileOutputStream(this.m_destination);
                        status = this.source.getArtifact(desc, (OutputStream)destination, monitor);
                    }
                    catch (IOException e) {
                        status = BuckminsterException.createStatus((Throwable)e);
                        Utils.close((Object)destination);
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    Utils.close(destination);
                    throw throwable;
                }
                Utils.close((Object)destination);
            }
            return status;
        }
    }

    public static class RemotePluginEntry
    extends PluginEntry {
        private final URL m_remoteLocation;

        public RemotePluginEntry(URL remoteLocation) {
            this.m_remoteLocation = remoteLocation;
        }

        public URL getRemoteLocation() {
            return this.m_remoteLocation;
        }
    }
}

