/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.buckminster.core.metadata.MissingComponentException;
import org.eclipse.buckminster.core.reader.AbstractCatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IStreamConsumer;
import org.eclipse.buckminster.core.rmap.model.MalformedProviderURIException;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.internal.EclipsePlatformReaderType;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipsePlatformReader
extends AbstractCatalogReader {
    private final String m_componentName;
    private IModel m_model;
    private final InstalledType m_type;

    public EclipsePlatformReader(IReaderType readerType, ProviderMatch rInfo) throws CoreException {
        super(readerType, rInfo);
        String uri = rInfo.getRepositoryURI();
        Path path = new Path(uri);
        if (path.segmentCount() == 2) {
            this.m_type = InstalledType.valueOf(path.segment(0).toUpperCase());
            if (this.m_type != null) {
                this.m_componentName = path.segment(1);
                return;
            }
        }
        throw new MalformedProviderURIException(readerType, uri);
    }

    public boolean canMaterialize() {
        return false;
    }

    public synchronized IFeatureModel getFeatureModel() {
        if (this.m_type != InstalledType.FEATURE) {
            return null;
        }
        if (this.m_model == null) {
            this.m_model = this.getBestFeature();
        }
        return (IFeatureModel)this.m_model;
    }

    public synchronized IPluginModelBase getPluginModelBase() throws CoreException {
        if (this.m_type != InstalledType.PLUGIN) {
            throw new IllegalStateException(Messages.plugin_requested_from_feature_reader);
        }
        if (this.m_model == null) {
            this.m_model = this.getBestPlugin();
            if (this.m_model == null) {
                throw new MissingComponentException(this.m_componentName);
            }
        }
        return (IPluginModelBase)this.m_model;
    }

    public InstalledType getType() {
        return this.m_type;
    }

    public void innerMaterialize(IPath destination, IProgressMonitor monitor) {
        throw new UnsupportedOperationException("checkout");
    }

    protected String getResolvedFile(String relativeFile, InputStream[] isReturn) throws IOException, CoreException {
        String fileName;
        File modelRoot = this.getModelRoot();
        if (modelRoot == null) {
            throw new FileNotFoundException(relativeFile);
        }
        if (modelRoot.isDirectory()) {
            File wantedFile = new File(modelRoot, relativeFile);
            fileName = wantedFile.toString();
            if (!wantedFile.exists()) {
                throw new FileNotFoundException(fileName);
            }
            if (isReturn != null) {
                isReturn[0] = new FileInputStream(wantedFile);
            }
        } else {
            if (!modelRoot.getName().endsWith(".jar")) {
                throw new FileNotFoundException(modelRoot.toString());
            }
            fileName = String.valueOf(modelRoot.getName()) + '!' + relativeFile;
            final JarFile jf = new JarFile(modelRoot);
            JarEntry entry = jf.getJarEntry(relativeFile);
            if (entry == null) {
                jf.close();
                throw new FileNotFoundException(fileName);
            }
            if (isReturn == null) {
                jf.close();
            } else {
                isReturn[0] = new FilterInputStream(jf.getInputStream(entry)){

                    public void close() throws IOException {
                        try {
                            super.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        jf.close();
                    }
                };
            }
        }
        return fileName;
    }

    protected boolean innerExists(String fileName, IProgressMonitor monitor) throws CoreException {
        try {
            this.getResolvedFile(fileName, null);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    protected void innerList(List<String> files, IProgressMonitor monitor) throws CoreException {
        block13: {
            File modelRoot = this.getModelRoot();
            if (modelRoot == null) {
                return;
            }
            File[] content = modelRoot.listFiles();
            if (content != null) {
                File[] fileArray = content;
                int n = content.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    String name = file.getName();
                    if (file.isDirectory()) {
                        name = String.valueOf(name) + "/";
                    }
                    files.add(name);
                    ++n2;
                }
                return;
            }
            if (!modelRoot.getName().endsWith(".jar")) {
                return;
            }
            ZipInputStream zi = null;
            try {
                try {
                    ZipEntry ze;
                    zi = new ZipInputStream(new BufferedInputStream(new FileInputStream(modelRoot)));
                    while ((ze = zi.getNextEntry()) != null) {
                        String name = ze.getName();
                        if (name.endsWith("/")) {
                            name = name.substring(name.length() - 1);
                        }
                        if (name.indexOf(47, 1) >= 0) continue;
                        if (ze.isDirectory()) {
                            name = String.valueOf(name) + "/";
                        }
                        files.add(name);
                    }
                }
                catch (IOException iOException) {
                    IOUtils.close(zi);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close(zi);
                throw throwable;
            }
            IOUtils.close((Closeable)zi);
        }
    }

    protected <T> T innerReadFile(String fileName, IStreamConsumer<T> consumer, IProgressMonitor monitor) throws CoreException, IOException {
        Object object;
        BufferedInputStream input = null;
        try {
            InputStream[] isHolder = new InputStream[1];
            String systemId = this.getResolvedFile(fileName, isHolder);
            input = new BufferedInputStream(isHolder[0]);
            object = consumer.consumeStream((IComponentReader)this, systemId, (InputStream)input, monitor);
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close((Closeable)input);
        return (T)object;
    }

    private IFeatureModel getBestFeature() {
        return EclipsePlatformReaderType.getBestFeature(this.m_componentName, this.getDesiredVersion(), null);
    }

    private IPluginModelBase getBestPlugin() {
        return EclipsePlatformReaderType.getBestPlugin(this.m_componentName, this.getDesiredVersion(), null);
    }

    private IVersionDesignator getDesiredVersion() {
        IVersion version;
        IVersionDesignator desiredVersion = null;
        ProviderMatch vsMatch = this.getProviderMatch();
        if (vsMatch != null && (version = vsMatch.getVersionMatch().getVersion()) != null) {
            desiredVersion = VersionFactory.createExplicitDesignator((IVersion)version);
        }
        return desiredVersion;
    }

    private File getModelRoot() throws CoreException {
        String installLocation;
        if (this.m_type == InstalledType.PLUGIN) {
            IPluginModelBase model;
            try {
                model = this.getPluginModelBase();
            }
            catch (IllegalStateException e) {
                return null;
            }
            installLocation = model.getInstallLocation();
        } else {
            IFeatureModel model = this.getFeatureModel();
            if (model == null) {
                return null;
            }
            installLocation = model.getInstallLocation();
        }
        return new File(installLocation);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstalledType {
        FEATURE,
        PLUGIN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PluginFilter
    implements FilenameFilter {
        private final ArrayList<IVersion> m_collector;
        private final Pattern m_pattern;

        PluginFilter(String componentName, ArrayList<IVersion> collector) {
            this.m_pattern = Pattern.compile(String.valueOf('^') + Pattern.quote(componentName) + "_(.*?)(?:\\.jar)?$");
            this.m_collector = collector;
        }

        @Override
        public boolean accept(File directory, String pathname) {
            Matcher m = this.m_pattern.matcher(pathname);
            if (!m.matches()) {
                return false;
            }
            try {
                this.m_collector.add(VersionFactory.OSGiType.fromString(m.group(1)));
                return true;
            }
            catch (CoreException e) {
                return false;
            }
        }
    }
}

