/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.common.model.Format;
import org.eclipse.buckminster.core.cspec.IComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.metadata.model.BOMNode;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.core.reader.CatalogReaderType;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.reader.IVersionFinder;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.resolver.ResolverDecisionType;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.site.ISiteFeatureConverter;
import org.eclipse.buckminster.core.site.SaxableSite;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.internal.EclipsePlatformReader;
import org.eclipse.buckminster.pde.internal.EclipsePlatformVersionFinder;
import org.eclipse.buckminster.pde.internal.model.EditableFeatureModel;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.ExtendedSite;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipsePlatformReaderType
extends CatalogReaderType
implements ISiteFeatureConverter {
    private static final String TEMP_FEATURE_ID = "buckminster.temp";
    private static final String TEMP_FEATURE_VERSION = "'0.1.0.'yyyyMMddHHmmss";

    public static IFeatureModel getBestFeature(String componentName, IVersionDesignator versionDesignator, NodeQuery query) {
        IFeatureModel candidate = null;
        IVersion candidateVersion = null;
        IFeatureModel[] iFeatureModelArray = PDECore.getDefault().getFeatureModelManager().findFeatureModels(componentName);
        int n = iFeatureModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel model = iFeatureModelArray[n2];
            IFeature feature = model.getFeature();
            String ov = feature.getVersion();
            if (ov == null) {
                if (candidate == null && versionDesignator == null) {
                    candidate = model;
                }
            } else {
                IVersion v = VersionFactory.OSGiType.coerce((Object)ov);
                if (versionDesignator != null && !versionDesignator.designates(v)) {
                    if (query != null) {
                        query.logDecision(ResolverDecisionType.VERSION_REJECTED, new Object[]{v, NLS.bind((String)Messages.not_designated_by_0, (Object)versionDesignator)});
                    }
                } else if (candidateVersion == null || candidateVersion.compareTo((Object)v) < 0) {
                    candidate = model;
                    candidateVersion = v;
                }
            }
            ++n2;
        }
        return candidate;
    }

    public static IPluginModelBase getBestPlugin(String componentName, IVersionDesignator versionDesignator, NodeQuery query) {
        IPluginModelBase candidate = null;
        IVersion candidateVersion = null;
        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getActiveModels();
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            BundleDescription desc = model.getBundleDescription();
            if (desc != null && desc.getSymbolicName().equals(componentName)) {
                Version ov = desc.getVersion();
                if (ov == null) {
                    if (candidate == null && versionDesignator == null) {
                        candidate = model;
                    }
                } else {
                    IVersion v = VersionFactory.OSGiType.coerce((Object)ov);
                    if (versionDesignator != null && !versionDesignator.designates(v)) {
                        if (query != null) {
                            query.logDecision(ResolverDecisionType.VERSION_REJECTED, new Object[]{v, NLS.bind((String)Messages.not_designated_by_0, (Object)versionDesignator)});
                        }
                    } else if (candidateVersion == null || candidateVersion.compareTo((Object)v) < 0) {
                        candidate = model;
                        candidateVersion = v;
                    }
                }
            }
            ++n2;
        }
        return candidate;
    }

    private static String getArtifactURLString(RMContext context, Resolution res) throws CoreException {
        URI artifactURI = res.getArtifactURI(context);
        if (artifactURI == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_obtain_URI_for_0, (Object)res.getComponentIdentifier()), (Object[])new Object[0]);
        }
        try {
            URL artifactURL = artifactURI.toURL();
            return artifactURL.toString();
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.fromMessage((Throwable)e, (String)NLS.bind((String)Messages.unable_to_obtain_URL_for_0, (Object)res.getComponentIdentifier()), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Resolution> convertToSiteFeatures(RMContext context, File siteFolder, List<Resolution> features, List<Resolution> plugins) throws CoreException {
        void var9_12;
        List<Resolution> topFeatures = this.getTopFeatures(features);
        HashSet<ComponentIdentifier> pluginNames = new HashSet<ComponentIdentifier>();
        HashMap<String, ArrayList<Resolution>> siteAndFeatures = new HashMap<String, ArrayList<Resolution>>();
        for (Resolution res : features) {
            String urlString = EclipsePlatformReaderType.getArtifactURLString(context, res);
            int idx = urlString.indexOf("/features/");
            if (idx < 0) continue;
            String siteURL = urlString.substring(0, idx);
            if (topFeatures.contains(res)) {
                ArrayList<Resolution> featuresOnSite = (ArrayList<Resolution>)siteAndFeatures.get(siteURL);
                if (featuresOnSite == null) {
                    featuresOnSite = new ArrayList<Resolution>();
                    siteAndFeatures.put(siteURL, featuresOnSite);
                }
                featuresOnSite.add(res);
            }
            for (ComponentRequest dep : res.getCSpec().getDependencies()) {
                if (!"osgi.bundle".equals(dep.getComponentTypeID())) continue;
                IVersionDesignator vd = dep.getVersionDesignator();
                if (vd == null) {
                    CorePlugin.getLogger().warning(NLS.bind((String)Messages.bogus_ref_to_0_in_1_at_2, (Object[])new Object[]{dep.getName(), res.getComponentIdentifier(), siteURL}), new Object[0]);
                    continue;
                }
                pluginNames.add(new ComponentIdentifier(dep.getName(), "osgi.bundle", vd.getVersion()));
            }
        }
        ArrayList<Resolution> siteFeatureResolutions = new ArrayList<Resolution>();
        for (Map.Entry entry : siteAndFeatures.entrySet()) {
            String siteURL = (String)entry.getKey();
            IComponentType siteFeatureType = CorePlugin.getDefault().getComponentType("site.feature");
            Provider provider = new Provider(null, "site.feature", new String[]{"site.feature"}, null, new Format(siteURL), null, null, null, false, false, null, null);
            for (Resolution res : (List)entry.getValue()) {
                ProviderMatch orig = res.getProviderMatch(context);
                NodeQuery nq = new NodeQuery(context, new ComponentRequest(res.getName(), siteFeatureType.getId(), res.getVersionDesignator()), null);
                ProviderMatch pm = new ProviderMatch(provider, siteFeatureType, orig.getVersionMatch(), nq);
                BOMNode node = siteFeatureType.getResolution(pm, (IProgressMonitor)new NullProgressMonitor());
                Resolution siteFeatureResolution = node.getResolution();
                if (siteFeatureResolution == null) continue;
                siteFeatureResolutions.add(siteFeatureResolution);
            }
        }
        Object var9_11 = null;
        IFeature generatedFeature = null;
        String generatedFeatureJar = null;
        ExtendedSite site = null;
        for (Resolution res : plugins) {
            String vStr;
            ComponentIdentifier ci = res.getComponentIdentifier();
            String id = ci.getName();
            IVersion v = ci.getVersion();
            String string = vStr = v == null ? "0.0.0" : v.toString();
            if (pluginNames.contains(ci)) continue;
            if (site == null) {
                site = new ExtendedSite();
                site.setSupportsPack200(true);
            }
            ArchiveReferenceModel arf = new ArchiveReferenceModel();
            arf.setPath("plugins/" + id + '_' + vStr + ".jar");
            arf.setURLString(EclipsePlatformReaderType.getArtifactURLString(context, res));
            site.addArchiveReferenceModel(arf);
            pluginNames.add(ci);
            if (generatedFeature == null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(TEMP_FEATURE_VERSION);
                String featureVer = dateFormat.format(new Date());
                generatedFeatureJar = "buckminster.temp_" + featureVer + ".jar";
                EditableFeatureModel editableFeatureModel = new EditableFeatureModel(null);
                generatedFeature = editableFeatureModel.getFeature();
                generatedFeature.setId(TEMP_FEATURE_ID);
                generatedFeature.setLabel(Messages.placeholder_feature);
                generatedFeature.setVersion(featureVer);
            }
            FeaturePlugin plugin = new FeaturePlugin();
            plugin.setModel((IFeatureModel)var9_12);
            plugin.setId(id);
            plugin.setVersion(vStr);
            plugin.setUnpack(res.isUnpack());
            generatedFeature.addPlugins(new IFeaturePlugin[]{plugin});
        }
        if (site == null) {
            return siteFeatureResolutions;
        }
        JarOutputStream featureOutput = null;
        try {
            try {
                File featureFolder = new File(siteFolder, "features");
                featureFolder.mkdir();
                featureOutput = new JarOutputStream(new FileOutputStream(new File(featureFolder, generatedFeatureJar)));
                featureOutput.putNextEntry(new JarEntry("feature.xml"));
                var9_12.save(featureOutput);
                featureOutput.closeEntry();
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable ci) {
            IOUtils.close(featureOutput);
            throw ci;
        }
        IOUtils.close((Closeable)featureOutput);
        SiteFeatureReferenceModel model = new SiteFeatureReferenceModel();
        model.setSiteModel((SiteModel)site);
        model.setFeatureIdentifier(generatedFeature.getId());
        model.setFeatureVersion(generatedFeature.getVersion());
        model.setLabel(generatedFeature.getLabel());
        model.setURLString("features/" + generatedFeatureJar);
        model.setType("org.eclipse.update.core.packaged");
        site.addFeatureReferenceModel(model);
        SaxableSite saxSite = new SaxableSite((Site)site);
        BufferedOutputStream output = null;
        try {
            try {
                output = new BufferedOutputStream(new FileOutputStream(new File(siteFolder, "site.xml")));
                Utils.serialize((ISaxable)saxSite, (OutputStream)output);
            }
            catch (Exception e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable vStr) {
            IOUtils.close(output);
            throw vStr;
        }
        IOUtils.close((Closeable)output);
        try {
            IComponentType siteFeatureType = CorePlugin.getDefault().getComponentType("site.feature");
            Provider provider = new Provider(null, "site.feature", new String[]{"site.feature"}, null, new Format(siteFolder.toURI().toURL().toString()), null, null, null, false, false, null, null);
            IVersion version = VersionFactory.OSGiType.fromString(generatedFeature.getVersion());
            VersionMatch vm = new VersionMatch(version, null, -1L, null, null);
            ComponentRequest cr = new ComponentRequest(generatedFeature.getId(), siteFeatureType.getId(), VersionFactory.createExplicitDesignator((IVersion)version));
            NodeQuery nq = new NodeQuery(context, cr, null);
            ProviderMatch pm = new ProviderMatch(provider, siteFeatureType, vm, nq);
            BOMNode node = siteFeatureType.getResolution(pm, (IProgressMonitor)new NullProgressMonitor());
            Resolution siteFeatureResolution = node.getResolution();
            if (siteFeatureResolution != null) {
                siteFeatureResolutions.add(siteFeatureResolution);
            }
        }
        catch (MalformedURLException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        return siteFeatureResolutions;
    }

    public URI getArtifactURL(Resolution resolution, RMContext context) throws CoreException {
        return null;
    }

    public IPath getFixedLocation(Resolution cr) {
        String location;
        IFeatureModel model;
        IVersion version = cr.getVersion();
        IVersionDesignator vd = version == null ? null : VersionFactory.createExplicitDesignator((IVersion)version);
        ComponentRequest rq = cr.getRequest();
        if ("eclipse.feature".equals(rq.getComponentTypeID())) {
            model = EclipsePlatformReaderType.getBestFeature(rq.getName(), vd, null);
            if (model == null) {
                return null;
            }
            location = model.getInstallLocation();
        } else {
            model = EclipsePlatformReaderType.getBestPlugin(rq.getName(), vd, null);
            if (model == null) {
                return null;
            }
            location = model.getInstallLocation();
        }
        Path path = null;
        if (location != null && (path = new Path(location)).toFile().isDirectory()) {
            path = path.addTrailingSeparator();
        }
        return path;
    }

    public IComponentReader getReader(ProviderMatch providerMatch, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new EclipsePlatformReader((IReaderType)this, providerMatch);
    }

    public IVersionFinder getVersionFinder(Provider provider, IComponentType ctype, NodeQuery nodeQuery, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.complete((IProgressMonitor)monitor);
        return new EclipsePlatformVersionFinder((IReaderType)this, provider, ctype, nodeQuery);
    }

    private List<Resolution> getTopFeatures(List<Resolution> features) {
        ArrayList<Resolution> topFeatures = new ArrayList<Resolution>();
        topFeatures.addAll(features);
        ArrayList<Resolution> includedFeatures = new ArrayList<Resolution>();
        for (Resolution res : features) {
            for (ComponentRequest dep : res.getCSpec().getDependencies()) {
                if (!"eclipse.feature".equals(dep.getComponentTypeID())) continue;
                for (Resolution featureRes : features) {
                    if (!dep.designates((IComponentIdentifier)featureRes.getComponentIdentifier())) continue;
                    includedFeatures.add(featureRes);
                }
            }
        }
        topFeatures.removeAll(includedFeatures);
        return topFeatures;
    }
}

