/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal;

import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.MalformedProviderURIException;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.AbstractVersionFinder;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.pde.internal.EclipsePlatformReaderType;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class EclipsePlatformVersionFinder
extends AbstractVersionFinder {
    private final String m_componentName;
    private final InstalledType m_type;

    public EclipsePlatformVersionFinder(IReaderType readerType, Provider provider, IComponentType ctype, NodeQuery query) throws CoreException {
        super(provider, ctype, query);
        String uri = provider.getURI(query.getProperties());
        Path path = new Path(uri);
        if (path.segmentCount() == 2) {
            this.m_type = InstalledType.valueOf(path.segment(0).toUpperCase());
            if (this.m_type != null) {
                this.m_componentName = path.segment(1);
                return;
            }
        }
        throw new MalformedProviderURIException(readerType, uri);
    }

    public VersionMatch getBestVersion(IProgressMonitor monitor) throws CoreException {
        IVersion v = null;
        NodeQuery query = this.getQuery();
        IVersionDesignator dsg = query.getVersionDesignator();
        if (this.m_type == InstalledType.PLUGIN) {
            IPluginModelBase plugin = EclipsePlatformReaderType.getBestPlugin(this.m_componentName, dsg, query);
            if (plugin != null) {
                v = VersionFactory.OSGiType.coerce((Object)plugin.getBundleDescription().getVersion());
            }
        } else {
            IFeatureModel feature = EclipsePlatformReaderType.getBestFeature(this.m_componentName, dsg, query);
            if (feature != null) {
                v = VersionFactory.OSGiType.fromString(feature.getFeature().getVersion());
            }
        }
        return v == null ? null : new VersionMatch(v, null, -1L, null, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InstalledType {
        FEATURE,
        PLUGIN;

    }
}

