/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal;

import java.util.Iterator;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.AbstractVersionFinder;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.service.resolver.VersionRange;

public class P2VersionFinder
extends AbstractVersionFinder {
    private static final String FEATURE_JAR = ".feature.jar";
    private static final String FEATURE_CLASSIFIER = "org.eclipse.update.feature";
    private static final String BUNDLE_CLASSIFIER = "osgi.bundle";
    private final IMetadataRepository m_mdr;

    public P2VersionFinder(Provider provider, IComponentType componentType, NodeQuery query, IMetadataRepository mdr) {
        super(provider, componentType, query);
        this.m_mdr = mdr;
    }

    public VersionMatch getBestVersion(IProgressMonitor monitor) throws CoreException {
        Collector c;
        IVersionDesignator designator;
        NodeQuery query = this.getQuery();
        ComponentRequest request = query.getComponentRequest();
        IComponentType ctype = request.getComponentType();
        String ctypeId = ctype == null ? BUNDLE_CLASSIFIER : ctype.getId();
        String name = request.getName();
        VersionRange vr = null;
        boolean isFeature = ctypeId.equals("eclipse.feature");
        if (isFeature) {
            if (!name.endsWith(".feature.group")) {
                name = String.valueOf(name) + ".feature.group";
            }
        } else if (!ctypeId.equals(BUNDLE_CLASSIFIER)) {
            return null;
        }
        if ((designator = request.getVersionDesignator()) != null) {
            if (!designator.getVersion().getType().getId().equals("OSGi")) {
                return null;
            }
            vr = new VersionRange(designator.toString());
        }
        if ((c = this.m_mdr.query((Query)new InstallableUnitQuery(name, vr), new Collector(), monitor)).isEmpty()) {
            return null;
        }
        Iterator itor = c.iterator();
        IInstallableUnit best = null;
        while (itor.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)itor.next();
            if (best != null && best.getVersion().compareTo((Object)iu.getVersion()) >= 0) continue;
            best = iu;
        }
        IArtifactKey[] artifacts = best.getArtifacts();
        IArtifactKey wanted = null;
        int idx = artifacts.length;
        while (--idx >= 0) {
            IArtifactKey ak = artifacts[idx];
            if (isFeature) {
                if (!ak.getClassifier().equals(FEATURE_CLASSIFIER)) continue;
                wanted = ak;
                break;
            }
            if (!ak.getClassifier().equals(BUNDLE_CLASSIFIER)) continue;
            wanted = ak;
            break;
        }
        if (wanted == null) {
            if (!isFeature) {
                return null;
            }
            String featureJarName = String.valueOf(name.substring(0, name.length() - ".feature.group".length())) + FEATURE_JAR;
            RequiredCapability found = null;
            RequiredCapability[] requiredCapabilityArray = best.getRequiredCapabilities();
            int n = requiredCapabilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                RequiredCapability rqc = requiredCapabilityArray[n2];
                if ("org.eclipse.equinox.p2.iu".equals(rqc.getNamespace()) && featureJarName.equals(rqc.getName())) {
                    found = rqc;
                    break;
                }
                ++n2;
            }
            if (found == null) {
                return null;
            }
            c = new Collector();
            this.m_mdr.query((Query)new InstallableUnitQuery(found.getName(), found.getRange()), c, monitor);
            if (c.isEmpty()) {
                return null;
            }
            itor = c.iterator();
            IInstallableUnit bestJar = null;
            while (itor.hasNext()) {
                IInstallableUnit iu = (IInstallableUnit)itor.next();
                if (bestJar != null && bestJar.getVersion().compareTo((Object)iu.getVersion()) >= 0) continue;
                bestJar = iu;
            }
            artifacts = bestJar.getArtifacts();
            idx = artifacts.length;
            while (--idx >= 0) {
                IArtifactKey ak = artifacts[idx];
                if (!ak.getClassifier().equals(FEATURE_CLASSIFIER)) continue;
                wanted = ak;
                break;
            }
            if (wanted == null) {
                return null;
            }
        }
        return new VersionMatch(VersionFactory.OSGiType.fromString(best.getVersion().toString()), null, -1L, null, wanted.toExternalForm());
    }
}

