/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.core.ITargetPlatform;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.helpers.AbstractExtension;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionType;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDETargetPlatform
extends AbstractExtension
implements ITargetPlatform {
    public String getArch() {
        return TargetPlatform.getOSArch();
    }

    public List<ComponentIdentifier> getComponents() throws CoreException {
        IVersion version;
        PDECore pdeCore = PDECore.getDefault();
        IFeatureModel[] featureModels = pdeCore.getFeatureModelManager().getModels();
        IPluginModelBase[] pluginModels = pdeCore.getModelManager().getActiveModels();
        ArrayList<ComponentIdentifier> bld = new ArrayList<ComponentIdentifier>(featureModels.length + pluginModels.length);
        IVersionType osgiType = VersionFactory.OSGiType;
        IFeatureModel[] iFeatureModelArray = featureModels;
        int n = featureModels.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureModel featureModel = iFeatureModelArray[n2];
            IFeature feature = featureModel.getFeature();
            version = osgiType.fromString(feature.getVersion());
            bld.add(new ComponentIdentifier(feature.getId(), "eclipse.feature", version));
            ++n2;
        }
        iFeatureModelArray = pluginModels;
        n = pluginModels.length;
        n2 = 0;
        while (n2 < n) {
            IFeatureModel pluginModel = iFeatureModelArray[n2];
            BundleDescription desc = pluginModel.getBundleDescription();
            if (desc != null) {
                version = osgiType.coerce((Object)desc.getVersion());
                bld.add(new ComponentIdentifier(desc.getSymbolicName(), "osgi.bundle", version));
            }
            ++n2;
        }
        return bld;
    }

    public File getLocation() {
        String location = TargetPlatform.getLocation();
        return location == null || location.length() == 0 ? null : new File(location);
    }

    public String getNL() {
        return TargetPlatform.getNL();
    }

    public String getOS() {
        return TargetPlatform.getOS();
    }

    public String getWS() {
        return TargetPlatform.getWS();
    }
}

