/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal.imports;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.internal.datatransfer.IImportStructureProvider;
import org.eclipse.buckminster.pde.internal.datatransfer.ImportOperation;
import org.eclipse.buckminster.pde.internal.datatransfer.ZipFileStructureProvider;
import org.eclipse.buckminster.pde.internal.dialogs.IOverwriteQuery;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.core.util.CoreUtility;

public abstract class JarImportOperation
implements IWorkspaceRunnable {
    protected void collectAdditionalResources(ZipFileStructureProvider provider, Object element, ArrayList collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr)) {
                    if (!this.folderContainsFileExtension(provider, curr, ".java")) {
                        collected.add(curr);
                    }
                } else if (!provider.getLabel(curr).endsWith(".java")) {
                    collected.add(curr);
                }
                ++i;
            }
        }
    }

    protected void collectJavaFiles(ZipFileStructureProvider provider, Object element, ArrayList collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) && provider.getLabel(curr).equals("src")) {
                    ArrayList list = new ArrayList();
                    this.collectResources(provider, curr, false, list);
                    collected.addAll(list);
                }
                ++i;
            }
        }
    }

    protected void collectJavaResources(ZipFileStructureProvider provider, Object element, ArrayList collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) && this.isClassFolder(provider, curr)) {
                    ArrayList list = new ArrayList();
                    this.collectResources(provider, curr, false, list);
                    collected.addAll(list);
                }
                ++i;
            }
        }
    }

    protected void collectJavaSource(ZipFileStructureProvider provider, Object element, List ignoreFolders, ArrayList collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr)) {
                    ArrayList<IPath> ignoreSubFolders = new ArrayList<IPath>();
                    boolean ignoreThisChild = false;
                    for (IPath currentPath : ignoreFolders) {
                        if (!provider.getLabel(curr).equals(currentPath.segment(0))) continue;
                        if (currentPath.segmentCount() > 1) {
                            ignoreSubFolders.add(currentPath.removeFirstSegments(1));
                            continue;
                        }
                        ignoreThisChild = true;
                        break;
                    }
                    if (!ignoreThisChild) {
                        this.collectJavaSource(provider, curr, ignoreSubFolders, collected);
                    }
                } else if (!provider.getLabel(curr).endsWith(".class")) {
                    collected.add(curr);
                }
                ++i;
            }
        }
    }

    protected void collectJavaSourceFromRoot(ZipFileStructureProvider provider, List ignoreFolders, ArrayList collected) {
        List children = provider.getChildren(provider.getRoot());
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) && this.folderContainsFileExtension(provider, curr, ".java")) {
                    ArrayList<IPath> ignoreSubFolders = new ArrayList<IPath>();
                    boolean ignoreThisChild = false;
                    for (IPath currentPath : ignoreFolders) {
                        if (!provider.getLabel(curr).equals(currentPath.segment(0))) continue;
                        if (currentPath.segmentCount() > 1) {
                            ignoreSubFolders.add(currentPath.removeFirstSegments(1));
                            continue;
                        }
                        ignoreThisChild = true;
                        break;
                    }
                    if (!ignoreThisChild) {
                        this.collectJavaSource(provider, curr, ignoreSubFolders, collected);
                    }
                }
                ++i;
            }
        }
    }

    protected void collectNonJavaResources(ZipFileStructureProvider provider, Object element, ArrayList collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr)) {
                    if (!provider.getLabel(curr).equals("src") && !this.isClassFolder(provider, curr)) {
                        ArrayList list = new ArrayList();
                        this.collectResources(provider, curr, false, list);
                        collected.addAll(list);
                    }
                } else if (!provider.getLabel(curr).endsWith(".class")) {
                    collected.add(curr);
                }
                ++i;
            }
        }
    }

    protected void collectResourcesFromFolder(ZipFileStructureProvider provider, Object element, IPath folderPath, ArrayList collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) && provider.getLabel(curr).equals(folderPath.segment(0))) {
                    if (folderPath.segmentCount() > 1) {
                        this.collectResourcesFromFolder(provider, curr, folderPath.removeFirstSegments(1), collected);
                    } else {
                        this.collectResources(provider, curr, false, collected);
                    }
                }
                ++i;
            }
        }
    }

    protected boolean containsCode(File file) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            boolean bl = this.containsCode(new ZipFileStructureProvider(zipFile));
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    protected boolean containsCode(ZipFileStructureProvider provider) {
        List children = provider.getChildren(provider.getRoot());
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) && this.isClassFolder(provider, curr)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void extractJavaResources(File file, IResource dest, IProgressMonitor monitor) throws CoreException {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
                ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                ArrayList collected = new ArrayList();
                this.collectJavaResources(provider, provider.getRoot(), collected);
                this.importContent(provider.getRoot(), dest.getFullPath(), provider, collected, monitor);
            }
            catch (IOException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void extractJavaSource(File file, List excludeFolders, IResource dest, IProgressMonitor monitor) throws CoreException {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
                ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                ArrayList collected = new ArrayList();
                this.collectJavaSourceFromRoot(provider, excludeFolders, collected);
                this.importContent(provider.getRoot(), dest.getFullPath(), provider, collected, monitor);
            }
            catch (IOException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void extractResources(File file, IResource dest, IProgressMonitor monitor) throws CoreException {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
                ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                ArrayList collected = new ArrayList();
                this.collectResources(provider, provider.getRoot(), true, collected);
                this.importContent(provider.getRoot(), dest.getFullPath(), provider, collected, monitor);
            }
            catch (IOException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void extractResourcesFromFolder(File file, IPath folderPath, IResource dest, IProgressMonitor monitor) throws CoreException {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
                ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                ArrayList collected = new ArrayList();
                this.collectResourcesFromFolder(provider, provider.getRoot(), folderPath, collected);
                this.importContent(provider.getRoot(), dest.getFullPath(), provider, collected, monitor);
            }
            catch (IOException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void extractZipFile(File file, IPath destPath, IProgressMonitor monitor) throws CoreException {
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(file);
                ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                this.importContent(provider.getRoot(), destPath, provider, null, monitor);
            }
            catch (IOException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected String[] getTopLevelResources(File file) {
        ArrayList<String> result;
        block21: {
            result = new ArrayList<String>();
            ZipFile zipFile = null;
            try {
                try {
                    zipFile = new ZipFile(file);
                    ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
                    List children = provider.getChildren(provider.getRoot());
                    if (children != null && !children.isEmpty()) {
                        int i = 0;
                        while (i < children.size()) {
                            Object curr = children.get(i);
                            if (provider.isFolder(curr)) {
                                if (!this.isClassFolder(provider, curr)) {
                                    result.add(String.valueOf(provider.getLabel(curr)) + "/");
                                } else if (!result.contains(".")) {
                                    result.add(".");
                                }
                            } else {
                                result.add(provider.getLabel(curr));
                            }
                            ++i;
                        }
                    }
                }
                catch (IOException iOException) {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    protected boolean hasEmbeddedSource(ZipFileStructureProvider provider) {
        List children = provider.getChildren(provider.getRoot());
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) && provider.getLabel(curr).equals("src")) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void importArchive(IProject project, File archive, IPath destPath) throws CoreException {
        try {
            if (destPath.segmentCount() > 2) {
                CoreUtility.createFolder((IFolder)project.getFolder(destPath.removeLastSegments(1)));
            }
            IFile file = project.getFile(destPath);
            FileInputStream fstream = new FileInputStream(archive);
            if (file.exists()) {
                file.setContents((InputStream)fstream, true, false, null);
            } else {
                file.create((InputStream)fstream, true, null);
            }
            fstream.close();
        }
        catch (IOException e) {
            Status status = new Status(4, PDEPlugin.getPluginId(), 0, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    protected void importContent(Object source, IPath destPath, IImportStructureProvider provider, List filesToImport, IProgressMonitor monitor) throws CoreException {
        IStatus status;
        IOverwriteQuery query = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        ImportOperation op = new ImportOperation(destPath, source, provider, query);
        op.setCreateContainerStructure(false);
        if (filesToImport != null) {
            op.setFilesToImport(filesToImport);
        }
        if ((status = op.runInWorkspace(monitor)).getSeverity() == 4) {
            throw new CoreException(status);
        }
    }

    private void collectResources(ZipFileStructureProvider provider, Object element, boolean excludeMeta, ArrayList collected) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr)) {
                    if (!excludeMeta || !provider.getLabel(curr).equals("META-INF")) {
                        this.collectResources(provider, curr, excludeMeta, collected);
                    }
                } else if (!provider.getLabel(curr).endsWith(".class")) {
                    collected.add(curr);
                }
                ++i;
            }
        }
    }

    private boolean folderContainsFileExtension(ZipFileStructureProvider provider, Object element, String fileExtension) {
        List children = provider.getChildren(element);
        if (children != null && !children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                Object curr = children.get(i);
                if (provider.isFolder(curr) ? this.folderContainsFileExtension(provider, curr, fileExtension) : provider.getLabel(curr).endsWith(fileExtension)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isClassFolder(ZipFileStructureProvider provider, Object element) {
        return this.folderContainsFileExtension(provider, element, ".class");
    }
}

