/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal.imports;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.buckminster.core.cspec.IComponentName;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.materializer.MaterializationContext;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.internal.EclipseImportReaderType;
import org.eclipse.buckminster.pde.internal.datatransfer.FileSystemStructureProvider;
import org.eclipse.buckminster.pde.internal.datatransfer.ZipFileStructureProvider;
import org.eclipse.buckminster.pde.internal.imports.JarImportOperation;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginImportOperation
extends JarImportOperation {
    public static final int IMPORT_BINARY = 1;
    public static final int IMPORT_BINARY_WITH_LINKS = 2;
    public static final int IMPORT_WITH_SOURCE = 3;
    private static final Method ClasspathComputer_getClasspath;
    private static final boolean ClasspathComputer_is35;
    private static final String GET_CLASSPATH = "getClasspath";
    private IProject m_project;
    private EclipseImportReaderType m_classpathCollector;
    private final IPath m_destination;
    private final int m_importType;
    private final IPluginModelBase m_model;
    private final NodeQuery m_query;

    static {
        Method getClasspath;
        boolean is35 = false;
        try {
            getClasspath = ClasspathComputer.class.getDeclaredMethod(GET_CLASSPATH, IProject.class, IPluginModelBase.class, Map.class, Boolean.TYPE, Boolean.TYPE);
            is35 = true;
        }
        catch (NoSuchMethodException e) {
            try {
                getClasspath = ClasspathComputer.class.getDeclaredMethod(GET_CLASSPATH, IProject.class, IPluginModelBase.class, Boolean.TYPE, Boolean.TYPE);
            }
            catch (NoSuchMethodException e1) {
                throw new ExceptionInInitializerError(e);
            }
        }
        catch (SecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
        ClasspathComputer_getClasspath = getClasspath;
        ClasspathComputer_is35 = is35;
    }

    public static void setClasspaths(IProgressMonitor monitor, Map<IProject, IClasspathEntry[]> classpaths) throws JavaModelException {
        MonitorUtils.begin((IProgressMonitor)monitor, (int)classpaths.size());
        try {
            for (Map.Entry<IProject, IClasspathEntry[]> entry : classpaths.entrySet()) {
                IClasspathEntry[] classpath = entry.getValue();
                if (classpath == null) continue;
                JavaCore.create((IProject)entry.getKey()).setRawClasspath(classpath, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            }
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    public PluginImportOperation(IPluginModelBase model, NodeQuery query, IPath destination, int importType) {
        this.m_model = model;
        this.m_query = query;
        this.m_importType = importType;
        this.m_destination = destination;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importPlugin(IProgressMonitor monitor) throws CoreException {
        MaterializationContext context = (MaterializationContext)this.m_query.getContext();
        ComponentRequest request = this.m_query.getComponentRequest();
        String projectName = request.getProjectName();
        String id = this.m_model.getPluginBase().getId();
        MonitorUtils.begin((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.importing_plugin_0, (Object)id), (int)7);
        try {
            IProject project;
            ConflictResolution conflictResolution = context.getMaterializationSpec().getConflictResolution((IComponentName)request);
            BundleDescription desc = this.m_model.getBundleDescription();
            if (desc != null) {
                IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
                String[] envs = desc.getExecutionEnvironments();
                boolean found = false;
                int i = 0;
                while (i < envs.length) {
                    if (manager.getEnvironment(envs[i]) != null) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (envs.length > 0 && !found) {
                    PDEPlugin.getLogger().info(NLS.bind((String)Messages.execution_env_misfit_skipping_plugin_0, (Object)id), new Object[0]);
                    return;
                }
            }
            if ((project = this.findProject(projectName)).exists()) {
                switch (conflictResolution) {
                    case FAIL: {
                        throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.project_0_already_exists, (Object)projectName), (Object[])new Object[0]);
                    }
                    case KEEP: {
                        return;
                    }
                }
                if (RepositoryProvider.isShared((IProject)project)) {
                    RepositoryProvider.unmap((IProject)project);
                }
                if (!project.exists()) {
                    project.create(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                }
                project.delete(true, true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            } else {
                MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProjectDescription description = workspace.newProjectDescription(projectName);
            FileUtils.prepareDestination((File)this.m_destination.toFile(), (ConflictResolution)conflictResolution, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            if (!workspace.getRoot().getLocation().equals((Object)this.m_destination.removeLastSegments(1))) {
                description.setLocation(this.m_destination);
            }
            project.create(description, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            project.open(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            this.m_project = project;
            IProgressMonitor importMonitor = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)4);
            switch (this.m_importType) {
                case 1: {
                    this.importAsBinary(true, importMonitor);
                    break;
                }
                case 2: {
                    if (id.startsWith("org.eclipse.swt") && !this.isJARd()) {
                        this.importAsBinary(true, importMonitor);
                        break;
                    }
                    this.importAsBinaryWithLinks(importMonitor);
                    break;
                }
                case 3: {
                    if (this.isExempt()) {
                        this.importAsBinary(true, importMonitor);
                        break;
                    }
                    this.importAsSource(importMonitor);
                }
            }
            this.setProjectDescription();
            if (this.m_classpathCollector != null && project.hasNature("org.eclipse.jdt.core.javanature") && project.findMember(".classpath") == null) {
                this.m_classpathCollector.addProjectClasspath(project, this.getClasspath(project));
            }
            project.delete(false, true, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
            return;
        }
        finally {
            monitor.done();
        }
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        this.importPlugin(monitor);
        MonitorUtils.testCancelStatus((IProgressMonitor)monitor);
    }

    public void setClasspathCollector(EclipseImportReaderType classpathCollector) {
        this.m_classpathCollector = classpathCollector;
    }

    protected void collectAdditionalResources(ZipFileStructureProvider provider, Object element, ArrayList<ZipEntry> collected, IProject project) {
        this.collectAdditionalResources(provider, element, collected);
        ListIterator<ZipEntry> li = collected.listIterator();
        while (li.hasNext()) {
            ZipEntry ze = li.next();
            String name = ze.getName();
            if (this.m_project.findMember(name) == null) continue;
            li.remove();
        }
    }

    @Override
    protected void collectNonJavaResources(ZipFileStructureProvider provider, Object element, ArrayList collected) {
        super.collectNonJavaResources(provider, element, collected);
        ListIterator li = collected.listIterator();
        while (li.hasNext()) {
            ZipEntry ze = (ZipEntry)li.next();
            String name = ze.getName();
            if (name.startsWith("META-INF/") && (name.endsWith(".RSA") || name.endsWith(".DSA") || name.endsWith(".SF"))) {
                li.remove();
                continue;
            }
            if (this.m_importType != 1 || !"build.properties".equals(ze.getName())) continue;
            li.remove();
        }
    }

    private String addBuildEntry(WorkspaceBuildModel model, String key, String value) throws CoreException {
        String[] tokens;
        IBuild build = model.getBuild(true);
        IBuildEntry entry = build.getEntry(key);
        if (entry == null) {
            entry = model.getFactory().createEntry(key);
            entry.addToken(value);
            build.add(entry);
        }
        return (tokens = entry.getTokens()).length > 0 ? tokens[0] : "src/";
    }

    private void configureBinIncludes(WorkspaceBuildModel buildModel) throws CoreException {
        IBuild build = buildModel.getBuild(true);
        IBuildEntry entry = build.getEntry("bin.includes");
        HashMap<String, String> libraryDirs = this.getSourceDirectories(build);
        if (entry == null) {
            entry = buildModel.getFactory().createEntry("bin.includes");
            File location = new File(this.m_model.getInstallLocation());
            if (location.isDirectory()) {
                File[] files = location.listFiles();
                int i = 0;
                while (i < files.length) {
                    String token = files[i].getName();
                    if (this.m_project.findMember(token) != null || build.getEntry("source." + token) != null) {
                        if (files[i].isDirectory() && libraryDirs.containsKey(token = String.valueOf(token) + "/")) {
                            token = libraryDirs.get(token).toString();
                        }
                        entry.addToken(token);
                    }
                    ++i;
                }
            } else {
                String[] tokens = this.getTopLevelResources(location);
                int i = 0;
                while (i < tokens.length) {
                    IResource res = this.m_project.findMember(tokens[i]);
                    if (!(res == null && build.getEntry("source." + tokens[i]) == null || res instanceof IFolder && libraryDirs.containsKey(tokens[i]))) {
                        entry.addToken(tokens[i]);
                    }
                    ++i;
                }
            }
            buildModel.getBuild().add(entry);
        }
    }

    private void configureSrcIncludes(WorkspaceBuildModel buildModel, List<String> list) throws CoreException {
        IBuildEntry entry = buildModel.getBuild(true).getEntry("src.includes");
        if (entry == null) {
            entry = buildModel.getFactory().createEntry("src.includes");
            int i = 0;
            while (i < list.size()) {
                entry.addToken(list.get(i));
                ++i;
            }
            buildModel.getBuild().add(entry);
        }
    }

    private void extractJARdPlugin(IProgressMonitor monitor) throws CoreException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.m_model.getInstallLocation());
            ZipFileStructureProvider provider = new ZipFileStructureProvider(zipFile);
            if (!this.containsCode(provider)) {
                this.extractZipFile(new File(this.m_model.getInstallLocation()), this.m_project.getFullPath(), monitor);
                return;
            }
            try {
                ArrayList collected = new ArrayList();
                this.collectNonJavaResources(provider, provider.getRoot(), collected);
                this.importContent(provider.getRoot(), this.m_project.getFullPath(), provider, collected, monitor);
                File file = new File(this.m_model.getInstallLocation());
                if (this.hasEmbeddedSource(provider) && this.m_importType == 3) {
                    collected = new ArrayList();
                    this.collectJavaFiles(provider, provider.getRoot(), collected);
                    this.importContent(provider.getRoot(), this.m_project.getFullPath(), provider, collected, monitor);
                    collected = new ArrayList();
                    this.collectJavaResources(provider, provider.getRoot(), collected);
                    this.importContent(provider.getRoot(), this.m_project.getFullPath().append("src"), provider, collected, monitor);
                } else {
                    if (this.m_importType == 2) {
                        this.m_project.getFile(file.getName()).createLink((IPath)new Path(file.getAbsolutePath()), 0, null);
                    } else {
                        this.importArchive(this.m_project, file, (IPath)new Path(file.getName()));
                    }
                    if (!this.hasEmbeddedSource(provider)) {
                        if (this.m_importType == 2) {
                            this.linkSourceArchives((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            this.importSourceArchives((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                }
                if (this.m_importType != 3) {
                    this.modifyBundleClasspathHeader(this.m_model);
                } else {
                    this.removeSignedHeaders();
                }
                this.setPermissions();
            }
            catch (IOException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private IProject findProject(String id) {
        IResource resource;
        IPluginModelBase model;
        ModelEntry entry = PDECore.getDefault().getModelManager().findEntry(id);
        if (entry != null && (model = entry.getModel()) != null && (resource = model.getUnderlyingResource()) != null) {
            return resource.getProject();
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(id);
    }

    private IClasspathEntry[] getClasspath(IProject project) throws CoreException {
        try {
            return (IClasspathEntry[])(ClasspathComputer_is35 ? ClasspathComputer_getClasspath.invoke(null, project, this.m_model, null, Boolean.TRUE, Boolean.FALSE) : ClasspathComputer_getClasspath.invoke(null, project, this.m_model, Boolean.TRUE, Boolean.FALSE));
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    private IPath getDefaultSourceNameForProject() {
        return new Path(ClasspathUtilCore.getSourceZipName((String)new File(this.m_model.getInstallLocation()).getName()));
    }

    private IFragment[] getFragmentsFor() {
        return new IFragment[0];
    }

    private String[] getLibraryNames(boolean expand) {
        IPluginLibrary[] libraries = this.m_model.getPluginBase().getLibraries();
        int top = libraries.length;
        if (top == 0 && this.isJARd()) {
            return new String[]{"."};
        }
        String[] list = new String[top];
        int i = 0;
        while (i < top) {
            list[i] = expand ? ClasspathUtilCore.expandLibraryName((String)libraries[i].getName()) : libraries[i].getName();
            ++i;
        }
        return list;
    }

    private HashMap<String, String> getSourceDirectories(IBuild build) {
        HashMap<String, String> set = new HashMap<String, String>();
        IBuildEntry[] entries = build.getBuildEntries();
        int i = 0;
        while (i < entries.length) {
            String name = entries[i].getName();
            if (name.startsWith("source.")) {
                name = name.substring(7);
                String[] tokens = entries[i].getTokens();
                int j = 0;
                while (j < tokens.length) {
                    set.put(tokens[j], name);
                    ++j;
                }
            }
            ++i;
        }
        return set;
    }

    private List<String> importAdditionalResources(IProgressMonitor monitor) throws CoreException {
        SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
        File location = manager.findSourcePlugin(this.m_model.getPluginBase());
        if (location != null) {
            if (location.isDirectory()) {
                ArrayList<File> list = new ArrayList<File>();
                File root = location;
                File[] children = location.listFiles();
                if (children != null) {
                    int i = 0;
                    while (i < children.length) {
                        String name = children[i].getName();
                        if (!this.m_project.exists((IPath)new Path(name)) && !"src.zip".equals(name)) {
                            list.add(children[i]);
                        }
                        ++i;
                    }
                    this.importContent(root, this.m_project.getFullPath(), FileSystemStructureProvider.INSTANCE, list, monitor);
                    ArrayList<String> srcEntryList = new ArrayList<String>(list.size());
                    ListIterator iterator = list.listIterator();
                    while (iterator.hasNext()) {
                        File current = (File)iterator.next();
                        String entry = current.getName();
                        if (current.isDirectory()) {
                            entry = String.valueOf(entry) + "/";
                        }
                        srcEntryList.add(entry);
                    }
                    return srcEntryList;
                }
            } else if (location.isFile()) {
                ArrayList<ZipEntry> list = new ArrayList<ZipEntry>();
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(location);
                    ZipFileStructureProvider zipProvider = new ZipFileStructureProvider(zipFile);
                    ZipEntry root = zipProvider.getRoot();
                    this.collectAdditionalResources(zipProvider, root, list, this.m_project);
                    this.importContent(root, this.m_project.getFullPath(), zipProvider, list, monitor);
                    ArrayList<String> srcEntryList = new ArrayList<String>(list.size());
                    for (ZipEntry current : list) {
                        String entry = current.getName();
                        srcEntryList.add(entry);
                    }
                    ArrayList<String> arrayList = srcEntryList;
                    return arrayList;
                }
                catch (IOException e) {
                    Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
                finally {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return new ArrayList<String>(0);
    }

    private void importAsBinary(boolean markAsBinary, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.begin((IProgressMonitor)monitor, (int)4);
        if (this.isJARd()) {
            this.extractJARdPlugin(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)3));
        } else {
            this.importContent(new File(this.m_model.getInstallLocation()), this.m_project.getFullPath(), FileSystemStructureProvider.INSTANCE, null, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            this.importSourceArchives(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
            IFragment[] fragments = this.getFragmentsFor();
            IPluginLibrary[] libraries = this.m_model.getPluginBase().getLibraries();
            IProgressMonitor fragmentMonitor = MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1);
            MonitorUtils.begin((IProgressMonitor)fragmentMonitor, (int)libraries.length);
            int i = 0;
            while (i < libraries.length) {
                String libraryName = libraries[i].getName();
                if (ClasspathUtilCore.containsVariables((String)libraryName) && !this.m_project.exists((IPath)new Path(ClasspathUtilCore.expandLibraryName((String)libraryName)))) {
                    int j = 0;
                    while (j < fragments.length) {
                        this.importJarFromFragment(fragments[j], libraryName);
                        this.importSourceFromFragment(fragments[j], libraryName, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                        ++j;
                    }
                } else {
                    MonitorUtils.worked((IProgressMonitor)monitor, (int)1);
                }
                ++i;
            }
        }
        if (markAsBinary) {
            this.m_project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "binary");
            this.importAdditionalResources(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
        } else {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }

    private void importAsBinaryWithLinks(IProgressMonitor monitor) throws CoreException {
        if (this.isJARd()) {
            this.extractJARdPlugin(monitor);
            return;
        }
        File installLocation = new File(this.m_model.getInstallLocation());
        File[] items = installLocation.listFiles();
        if (items == null) {
            MonitorUtils.begin((IProgressMonitor)monitor, (String)Messages.linking_imported_plugin, (int)1);
        } else {
            MonitorUtils.begin((IProgressMonitor)monitor, (String)Messages.linking_imported_plugin, (int)(items.length + 1));
            int i = 0;
            while (i < items.length) {
                File sourceFile = items[i];
                String name = sourceFile.getName();
                if (sourceFile.isDirectory()) {
                    this.m_project.getFolder(name).createLink((IPath)new Path(sourceFile.getPath()), 0, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                } else if (!name.equals(".project")) {
                    this.m_project.getFile(name).createLink((IPath)new Path(sourceFile.getPath()), 0, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
                } else {
                    ArrayList<File> filesToImport = new ArrayList<File>(1);
                    filesToImport.add(sourceFile);
                    this.importContent(installLocation, this.m_project.getFullPath(), FileSystemStructureProvider.INSTANCE, filesToImport, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                ++i;
            }
        }
        this.linkSourceArchives(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
        MonitorUtils.done((IProgressMonitor)monitor);
        try {
            RepositoryProvider.map((IProject)this.m_project, (String)"org.eclipse.pde.core.BinaryRepositoryProvider");
        }
        catch (TeamException teamException) {
            // empty catch block
        }
    }

    private void importAsSource(IProgressMonitor monitor) throws CoreException {
        MonitorUtils.begin((IProgressMonitor)monitor, (int)4);
        this.importAsBinary(false, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)2));
        List<String> list = this.importAdditionalResources(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)1));
        WorkspaceBuildModel buildModel = new WorkspaceBuildModel(this.m_project.getFile("build.properties"));
        if (!this.isJARd() || this.containsCode(new File(this.m_model.getInstallLocation()))) {
            String[] libraries = this.getLibraryNames(false);
            if (libraries.length == 0) {
                libraries = new String[]{"."};
            }
            int i = 0;
            while (i < libraries.length) {
                if (!ClasspathUtilCore.containsVariables((String)libraries[i])) {
                    String name = ClasspathUtilCore.expandLibraryName((String)libraries[i]);
                    Path libraryPath = name.equals(".") && this.isJARd() ? new Path(new File(this.m_model.getInstallLocation()).getName()) : new Path(name);
                    IResource jarFile = this.m_project.findMember((IPath)libraryPath);
                    if (jarFile != null) {
                        int extIndex;
                        String srcName = ClasspathUtilCore.getSourceZipName((String)libraryPath.lastSegment());
                        IResource srcZip = jarFile.getProject().findMember(srcName);
                        if (srcZip == null && (extIndex = srcName.lastIndexOf(46)) != -1) {
                            srcZip = jarFile.getProject().findMember(srcName.substring(0, extIndex));
                        }
                        if (srcZip == null && libraries[i].equals(".") && !this.isJARd()) {
                            srcZip = jarFile.getProject().findMember("src");
                        }
                        if (srcZip != null) {
                            String jarName = libraries[i].equals(".") ? "" : libraryPath.removeFileExtension().lastSegment();
                            String folder = this.addBuildEntry(buildModel, "source." + libraries[i], "src" + (jarName.length() == 0 ? "/" : "-" + jarName + "/"));
                            IFolder dest = jarFile.getProject().getFolder(folder);
                            if (srcZip instanceof IFolder) {
                                if (!srcZip.equals((Object)dest)) {
                                    if (dest.exists()) {
                                        dest.delete(true, null);
                                    }
                                    ((IFolder)srcZip).move(dest.getFullPath(), true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                            } else if (srcZip instanceof IFile) {
                                if (!dest.exists()) {
                                    dest.create(true, true, null);
                                }
                                this.extractZipFile(srcZip.getLocation().toFile(), dest.getFullPath(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                srcZip.delete(true, null);
                            } else {
                                monitor.worked(1);
                            }
                            if (jarFile instanceof IFile) {
                                if (this.isJARd()) {
                                    this.extractJavaResources(jarFile.getLocation().toFile(), (IResource)dest, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                } else {
                                    this.extractResources(jarFile.getLocation().toFile(), (IResource)dest, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                                jarFile.delete(true, null);
                            } else {
                                this.moveBinaryContents((IContainer)jarFile, dest, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                        }
                    } else if (name.equals(".") && this.m_project.getFolder("src").exists()) {
                        this.addBuildEntry(buildModel, "source..", "src/");
                    }
                }
                ++i;
            }
        }
        this.configureBinIncludes(buildModel);
        if (list.size() > 0) {
            this.configureSrcIncludes(buildModel, list);
        }
        buildModel.save();
    }

    private void importJarFromFragment(IFragment fragment, String name) throws CoreException {
        Path jarPath = new Path(ClasspathUtilCore.expandLibraryName((String)name));
        File jar = new File(fragment.getModel().getInstallLocation(), jarPath.toString());
        if (jar.exists()) {
            this.importArchive(this.m_project, jar, (IPath)jarPath);
        }
    }

    private void importSourceArchives(IProgressMonitor monitor) throws CoreException {
        String[] libraries = this.getLibraryNames(true);
        if (libraries.length == 0) {
            return;
        }
        MonitorUtils.begin((IProgressMonitor)monitor, (String)Messages.copying_source, (int)libraries.length);
        SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
        Set roots = null;
        if (manager.hasBundleManifestLocation(this.m_model.getPluginBase())) {
            roots = manager.findSourceRoots(this.m_model.getPluginBase());
        }
        String[] stringArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            String library = stringArray[n2];
            String zipName = ClasspathUtilCore.getSourceZipName((String)library);
            Path path = new Path(zipName);
            if (this.m_project.findMember((IPath)path) == null) {
                if (roots != null) {
                    String currentRoot;
                    IPath sourceLocation = manager.findSourcePath(this.m_model.getPluginBase(), null);
                    String string = currentRoot = ".".equals(library) ? "." : path.removeFileExtension().toString();
                    if (roots.contains(currentRoot)) {
                        if (".".equals(currentRoot)) {
                            IPath sourceName = this.getDefaultSourceNameForProject();
                            IFolder dest = this.m_project.getFolder(sourceName = sourceName.removeFileExtension());
                            if (!dest.exists()) {
                                dest.create(true, true, null);
                            }
                            Set allBundleRoots = manager.findAllSourceRootsInSourceLocation(this.m_model.getPluginBase());
                            ArrayList<Path> rootsToExclude = new ArrayList<Path>(allBundleRoots.size() - 1);
                            for (String rootString : allBundleRoots) {
                                if (".".equals(rootString)) continue;
                                rootsToExclude.add(new Path(rootString));
                            }
                            this.extractJavaSource(new File(sourceLocation.toOSString()), rootsToExclude, (IResource)dest, monitor);
                        } else {
                            this.extractResourcesFromFolder(new File(sourceLocation.toOSString()), (IPath)new Path(currentRoot), (IResource)this.m_project, monitor);
                        }
                    }
                } else {
                    IPath srcPath = manager.findSourcePath(this.m_model.getPluginBase(), (IPath)path);
                    if (srcPath != null) {
                        if ("src.zip".equals(zipName) && this.isJARd()) {
                            path = this.getDefaultSourceNameForProject();
                        }
                        this.importArchive(this.m_project, new File(srcPath.toOSString()), (IPath)path);
                    }
                }
            }
            monitor.worked(1);
            ++n2;
        }
        monitor.done();
    }

    private void importSourceFromFragment(IFragment fragment, String libraryName, IProgressMonitor monitor) throws CoreException {
        try {
            SourceLocationManager manager;
            IPath srcPath;
            Path jarPath = new Path(ClasspathUtilCore.expandLibraryName((String)libraryName));
            String zipName = ClasspathUtilCore.getSourceZipName((String)jarPath.toString());
            Path path = new Path(zipName);
            if (this.m_project.findMember((IPath)path) == null && (srcPath = (manager = PDECore.getDefault().getSourceLocationManager()).findSourcePath((IPluginBase)fragment, (IPath)path)) != null) {
                if (manager.hasBundleManifestLocation((IPluginBase)fragment)) {
                    this.extractResourcesFromFolder(new File(srcPath.toOSString()), path.removeFileExtension(), (IResource)this.m_project, monitor);
                } else {
                    this.importArchive(this.m_project, new File(srcPath.toOSString()), (IPath)path);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean isExempt() {
        String id = this.m_model.getPluginBase().getId();
        if ("org.apache.ant".equals(id) || "org.eclipse.osgi.util".equals(id) || "org.eclipse.osgi.services".equals(id) || "org.eclipse.core.runtime.compatibility.registry".equals(id)) {
            return true;
        }
        return "org.eclipse.swt".equals(id) && !this.isJARd();
    }

    private boolean isInterestingResource(String name) {
        return name.endsWith(".jnilib") || name.endsWith(".sl") || name.endsWith(".a") || name.indexOf(".so") != -1;
    }

    private boolean isJARd() {
        return new File(this.m_model.getInstallLocation()).isFile();
    }

    private void linkSourceArchives(IProgressMonitor monitor) throws CoreException {
        String[] libraries = this.getLibraryNames(true);
        monitor.beginTask(Messages.copying_imported_source, libraries.length);
        SourceLocationManager manager = PDECore.getDefault().getSourceLocationManager();
        if (manager.hasBundleManifestLocation(this.m_model.getPluginBase())) {
            Path path;
            IFile srcFile;
            IPath srcPath = manager.findSourcePath(this.m_model.getPluginBase(), null);
            if (srcPath != null && !(srcFile = this.m_project.getFile((path = new Path(String.valueOf(this.m_project.getName()) + "src.zip")).lastSegment())).exists()) {
                srcFile.createLink(srcPath, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            monitor.worked(libraries.length);
        } else {
            int i = 0;
            while (i < libraries.length) {
                IPath srcPath;
                String zipName = ClasspathUtilCore.getSourceZipName((String)libraries[i]);
                Path path = new Path(zipName);
                if (this.m_project.findMember((IPath)path) == null && (srcPath = manager.findSourcePath(this.m_model.getPluginBase(), (IPath)path)) != null) {
                    IFile zipFile;
                    if ("src.zip".equals(zipName) && this.isJARd()) {
                        path = new Path(ClasspathUtilCore.getSourceZipName((String)new File(this.m_model.getInstallLocation()).getName()));
                    }
                    if (!(zipFile = this.m_project.getFile(path.lastSegment())).exists()) {
                        zipFile.createLink(srcPath, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
                monitor.worked(1);
                ++i;
            }
        }
        monitor.done();
    }

    private void modifyBundleClasspathHeader(IPluginModelBase base) {
        IFile file = this.m_project.getFile("META-INF/MANIFEST.MF");
        if (file.exists()) {
            WorkspaceBundleModel bmodel = new WorkspaceBundleModel(file);
            IBundle bundle = bmodel.getBundle();
            String classpath = bundle.getHeader("Bundle-ClassPath");
            if (classpath == null) {
                bundle.setHeader("Bundle-ClassPath", ClasspathUtilCore.getFilename((IPluginModelBase)base));
            } else {
                try {
                    ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)classpath);
                    StringBuffer buffer = new StringBuffer();
                    int i = 0;
                    while (i < elements.length) {
                        if (buffer.length() > 0) {
                            buffer.append(",");
                            buffer.append(System.getProperty("line.separator"));
                            buffer.append(" ");
                        }
                        if (elements[i].getValue().equals(".")) {
                            buffer.append(ClasspathUtilCore.getFilename((IPluginModelBase)base));
                        } else {
                            buffer.append(elements[i].getValue());
                        }
                        ++i;
                    }
                    bundle.setHeader("Bundle-ClassPath", buffer.toString());
                }
                catch (BundleException bundleException) {
                    // empty catch block
                }
            }
            bmodel.save();
        }
    }

    private void moveBinaryContents(IContainer srcFolder, IFolder dest, IProgressMonitor monitor) {
        try {
            IResource[] children = dest.members();
            ArrayList<IResource> validFolders = new ArrayList<IResource>();
            int i = 0;
            while (i < children.length) {
                String folderName;
                IResource folder;
                if (children[i] instanceof IFolder && (folder = srcFolder.findMember(folderName = children[i].getName())) != null && folder instanceof IFolder) {
                    validFolders.add(folder);
                }
                ++i;
            }
            monitor.beginTask(new String(), validFolders.size());
            ListIterator li = validFolders.listIterator();
            while (li.hasNext()) {
                IFolder folder = (IFolder)li.next();
                int pathSegments = folder.getProjectRelativePath().segmentCount() - 1;
                Stack<IResource> stack = new Stack<IResource>();
                IResource[] resources = folder.members();
                int i2 = 0;
                while (i2 < resources.length) {
                    stack.push(resources[i2]);
                    ++i2;
                }
                while (!stack.isEmpty()) {
                    IResource res = (IResource)stack.pop();
                    if (res instanceof IFile) {
                        if (res.getName().endsWith(".class")) continue;
                        String pathName = res.getProjectRelativePath().removeFirstSegments(pathSegments).toString();
                        IFile destFile = dest.getFile(pathName);
                        if (!destFile.getParent().exists()) {
                            CoreUtility.createFolder((IFolder)((IFolder)destFile.getParent()));
                        }
                        if (destFile.exists()) {
                            destFile.delete(true, null);
                        }
                        res.move(destFile.getFullPath(), true, null);
                        continue;
                    }
                    resources = ((IFolder)res).members();
                    int i3 = 0;
                    while (i3 < resources.length) {
                        stack.push(resources[i3]);
                        ++i3;
                    }
                }
                folder.delete(true, null);
                monitor.worked(1);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private boolean needsJavaNature() {
        if (this.m_model.getPluginBase().getLibraries().length > 0) {
            return true;
        }
        BundleDescription desc = this.m_model.getBundleDescription();
        if (desc != null) {
            if (desc.getExportPackages().length > 0) {
                return true;
            }
            if (desc.getRequiredBundles().length > 0) {
                return true;
            }
            if (desc.getImportPackages().length > 0) {
                return true;
            }
        }
        return false;
    }

    private void removeSignedHeaders() {
        IFile file = this.m_project.getFile("META-INF/MANIFEST.MF");
        if (!file.exists()) {
            return;
        }
        WorkspaceBundleModel model = new WorkspaceBundleModel(file);
        model.save();
    }

    private void setPermissions() {
        try {
            IFragment fragment;
            if (!Platform.getOS().equals("win32") && this.m_model instanceof IFragmentModel && "org.eclipse.swt".equals((fragment = ((IFragmentModel)this.m_model).getFragment()).getPluginId())) {
                IResource[] children = this.m_project.members();
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IFile && this.isInterestingResource(children[i].getName())) {
                        Runtime.getRuntime().exec(new String[]{"chmod", "755", children[i].getLocation().toOSString()}).waitFor();
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setProjectDescription() throws CoreException {
        IProjectDescription desc = this.m_project.getDescription();
        if (!desc.hasNature("org.eclipse.pde.PluginNature")) {
            CoreUtility.addNatureToProject((IProject)this.m_project, (String)"org.eclipse.pde.PluginNature", null);
        }
        if (this.needsJavaNature() && !desc.hasNature("org.eclipse.jdt.core.javanature")) {
            CoreUtility.addNatureToProject((IProject)this.m_project, (String)"org.eclipse.jdt.core.javanature", null);
        }
    }
}

