/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.internal.model;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditableFeatureModel
extends ExternalFeatureModel
implements IEditableModel {
    private static final long serialVersionUID = 5818223312516456482L;
    private int m_contextQualifierLength = -1;
    private boolean m_dirty;
    private final File m_externalFile;
    private static final Pattern s_ctxQualLenPattern = Pattern.compile("\\scontextQualifierLength\\s*=\\s*(\\d+)\\s");

    public static int getContextQualifierLength(InputStream input) {
        int ctxQualLen = -1;
        Scanner scanner = new Scanner(input);
        if (scanner.findWithinHorizon(s_ctxQualLenPattern, 100) != null) {
            ctxQualLen = Integer.parseInt(scanner.match().group(1));
        }
        return ctxQualLen;
    }

    private static IPluginModelBase findModel(String id, String version) {
        IPluginModelBase unversioned = null;
        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getActiveModels();
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            BundleDescription desc = model.getBundleDescription();
            if (desc != null && desc.getSymbolicName().equals(id)) {
                Version v = desc.getVersion();
                if (v == null) {
                    if (version == null) {
                        return model;
                    }
                    unversioned = model;
                } else if (version == null || version.equals(v.toString())) {
                    return model;
                }
            }
            ++n2;
        }
        return unversioned;
    }

    public EditableFeatureModel(File externalFile) {
        this.m_externalFile = externalFile;
    }

    public void computeRequiredPlugins() throws CoreException {
        ArrayList<IFeatureImport> seen = new ArrayList<IFeatureImport>(this.feature.getImports().length);
        IFeaturePlugin[] iFeaturePluginArray = this.feature.getPlugins();
        int n = iFeaturePluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeaturePlugin fp = iFeaturePluginArray[n2];
            IPluginModelBase model = EditableFeatureModel.findModel(fp.getId(), fp.getVersion());
            if (model != null) {
                this.addRequirements(seen, model.getPluginBase());
                if (model.isFragmentModel()) {
                    HostSpecification hostSpec = model.getBundleDescription().getHost();
                    String id = hostSpec.getName();
                    String version = null;
                    int match = 0;
                    VersionRange versionRange = hostSpec.getVersionRange();
                    if (versionRange != null && !VersionRange.emptyRange.equals((Object)versionRange)) {
                        version = versionRange.getMinimum() != null ? versionRange.getMinimum().toString() : null;
                        match = PluginBase.getMatchRule((VersionRange)versionRange);
                    }
                    this.addRequirement(id, version, match, seen);
                }
            }
            ++n2;
        }
    }

    public int getContextQualifierLength() {
        return this.m_contextQualifierLength;
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public boolean isEditable() {
        return true;
    }

    public void load() throws CoreException {
        InputStream input = null;
        try {
            try {
                input = new BufferedInputStream(new FileInputStream(this.m_externalFile));
                this.load(input, true);
            }
            catch (FileNotFoundException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close((Closeable)input);
        if (this.feature == null) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_parse_feature_0, (Object)this.m_externalFile), (Object[])new Object[0]);
        }
        int ctxQualLen = -1;
        String version = this.feature.getVersion();
        if (version != null && version.indexOf(45) > 0) {
            try {
                try {
                    input = new FileInputStream(this.m_externalFile);
                    ctxQualLen = EditableFeatureModel.getContextQualifierLength(input);
                }
                catch (FileNotFoundException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
            finally {
                IOUtils.close((Closeable)input);
            }
            this.m_contextQualifierLength = ctxQualLen;
        }
    }

    public void save() {
        try {
            this.save(this.m_externalFile);
        }
        catch (FileNotFoundException e) {
            PDEPlugin.getLogger().error((Throwable)e, Messages.unable_to_save_feature_model, new Object[0]);
        }
    }

    public void save(File outputFile) throws FileNotFoundException {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(outputFile);
            this.save(output);
        }
        catch (Throwable throwable) {
            IOUtils.close(output);
            throw throwable;
        }
        IOUtils.close((Closeable)output);
    }

    public void save(OutputStream output) {
        try {
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(output, "UTF-8"));
            this.save(writer);
            writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            PDEPlugin.getLogger().error((Throwable)e, Messages.utf8_not_supported, new Object[0]);
            throw new RuntimeException(e);
        }
    }

    public void save(PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (this.getFeature().getVersion().indexOf(45) > 0 && this.m_contextQualifierLength != -1) {
            writer.println("<!-- contextQualifierLength=" + this.m_contextQualifierLength + " -->");
        }
        this.feature.write("", writer);
        this.setDirty(false);
    }

    public void setContextQualifierLength(int contextQualifierLength) {
        this.m_contextQualifierLength = contextQualifierLength;
    }

    public void setDirty(boolean dirty) {
        this.m_dirty = dirty;
    }

    private void addRequirement(String id, String version, int match, List<IFeatureImport> seen) throws CoreException {
        IFeatureImport bundle2;
        for (IFeatureImport bundle2 : seen) {
            if (!bundle2.getId().equals(id) || version != null && (!version.equals(bundle2.getVersion()) || match != bundle2.getMatch())) continue;
            return;
        }
        IFeaturePlugin[] iFeaturePluginArray = this.feature.getPlugins();
        int n = iFeaturePluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            bundle2 = iFeaturePluginArray[n2];
            if (VersionUtil.compare((String)bundle2.getId(), (String)bundle2.getVersion(), (String)id, (String)version, (int)match)) {
                return;
            }
            ++n2;
        }
        bundle2 = this.feature.getModel().getFactory().createImport();
        bundle2.setId(id);
        bundle2.setVersion(version);
        bundle2.setMatch(match);
        this.feature.addImports(new IFeatureImport[]{bundle2});
        seen.add(bundle2);
    }

    private void addRequirements(List<IFeatureImport> seen, IPluginBase plugin) throws CoreException {
        IPluginImport[] iPluginImportArray = plugin.getImports();
        int n = iPluginImportArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginImport bundle = iPluginImportArray[n2];
            this.addRequirement(bundle.getId(), bundle.getVersion(), bundle.getMatch(), seen);
            ++n2;
        }
    }
}

