/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.mapprovider;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.Format;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.cspec.model.ComponentRequest;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.reader.ICatalogReader;
import org.eclipse.buckminster.core.reader.IComponentReader;
import org.eclipse.buckminster.core.reader.IReaderType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.ProviderScore;
import org.eclipse.buckminster.core.rmap.model.SearchPath;
import org.eclipse.buckminster.core.rmap.model.VersionConverterDesc;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.core.version.IVersionDesignator;
import org.eclipse.buckminster.core.version.ProviderMatch;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.mapfile.MapFile;
import org.eclipse.buckminster.pde.mapfile.MapFileEntry;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDEMapProvider
extends Provider {
    public static final String BM_PDEMAP_PROVIDER_NS = "http://www.eclipse.org/buckminster/PDEMapProvider-1.0";
    public static final String BM_PDEMAP_PROVIDER_PREFIX = "pmp";

    private static void collectEntries(File mapFile, Map<ComponentIdentifier, MapFileEntry> map) throws CoreException {
        FileInputStream input = null;
        try {
            try {
                input = new FileInputStream(mapFile);
                ArrayList<MapFileEntry> list = new ArrayList<MapFileEntry>();
                MapFile.parse(input, mapFile.getCanonicalPath(), list);
                for (MapFileEntry entry : list) {
                    map.put(entry.getComponentIdentifier(), entry);
                }
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close((Closeable)input);
    }

    public PDEMapProvider(SearchPath searchPath, String remoteReaderType, String[] componentTypes, VersionConverterDesc vcDesc, Format uri, Filter resolutionFilter, boolean mutable, boolean source, Documentation documentation) {
        super(searchPath, remoteReaderType, componentTypes, vcDesc, uri, null, null, resolutionFilter, mutable, source, null, documentation);
    }

    public PDEMapProvider(String remoteReaderType, String[] componentTypes, String uri, Filter resolutionFilter) {
        super(remoteReaderType, componentTypes, uri, resolutionFilter);
    }

    public void addPrefixMappings(HashMap<String, String> prefixMappings) {
        super.addPrefixMappings(prefixMappings);
        prefixMappings.put(BM_PDEMAP_PROVIDER_PREFIX, BM_PDEMAP_PROVIDER_NS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProviderMatch findMatch(NodeQuery query, MultiStatus problemCollector, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 100);
        try {
            String providerURI = this.getURI(query.getProperties());
            String readerType = this.getReaderTypeId();
            ProviderScore score = query.getProviderScore(this.isMutable(), this.hasSource());
            if (score == ProviderScore.REJECTED) {
                String msg = NLS.bind((String)Messages.provider_0_for_1_score_below_treshold, (Object)readerType, (Object)providerURI);
                problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, msg, null));
                return null;
            }
            MapFileEntry tv = this.getMapFileEntry(query, problemCollector, this.getMap(query, problemCollector, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50)));
            if (tv == null) {
                return null;
            }
            Map<String, String> properties = tv.getProperties();
            IVersion v = null;
            String tag = properties.get("tag");
            VersionSelector vs = tag == null ? null : VersionSelector.tag((String)tag);
            ComponentRequest rq = query.getComponentRequest();
            IVersionConverter vc = this.getVersionConverter();
            if (vc != null) {
                v = vc.createVersion(vs);
                IVersionDesignator vd = query.getVersionDesignator();
                if (vd != null && !vd.designates(v)) {
                    return null;
                }
            }
            VersionMatch vm = new VersionMatch(v, vs, -1L, null, null);
            IReaderType rt = tv.getReaderType();
            String repoLocator = rt.convertFetchFactoryLocator(properties, rq.getName());
            Format uri = new Format(repoLocator);
            Provider delegated = new Provider(this.getSearchPath(), rt.getId(), this.getComponentTypeIDs(), this.getVersionConverterDesc(), uri, null, null, this.getResolutionFilter(), this.isMutable(), this.hasSource(), null, null);
            String ctypeID = rq.getComponentTypeID();
            if (ctypeID == null) {
                ProviderMatch providerMatch = delegated.findMatch(query, problemCollector, monitor);
                return providerMatch;
            }
            IComponentType ctype = tv.getComponentIdentifier().getComponentType();
            ProviderMatch pm = new ProviderMatch((Provider)this, ctype, vm, score, query);
            pm.setProvider(delegated);
            pm.setComponentType(ctype);
            ProviderMatch providerMatch = pm;
            return providerMatch;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<ComponentIdentifier, MapFileEntry> getMap(NodeQuery query, MultiStatus problemCollector, IProgressMonitor monitor) throws CoreException {
        Map userCache;
        monitor.beginTask(null, 700);
        Map map = userCache = query.getContext().getUserCache();
        synchronized (map) {
            File tempFolder;
            block19: {
                Map<ComponentIdentifier, MapFileEntry> map2;
                block20: {
                    Map<ComponentIdentifier, MapFileEntry> map3 = this.getCachedMap(userCache);
                    if (map3 != null) {
                        return map3;
                    }
                    tempFolder = null;
                    try {
                        ProviderMatch match = new ProviderMatch((Provider)this, CorePlugin.getDefault().getComponentType("unknown"), new VersionMatch(null, null, -1L, new Date(), null), ProviderScore.GOOD, query);
                        tempFolder = FileUtils.createTempFolder((String)"bucky", (String)".tmp");
                        IComponentReader reader = match.getReader(MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)100));
                        try {
                            ((ICatalogReader)reader).innerMaterialize((IPath)new Path(tempFolder.toString()), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)400));
                        }
                        finally {
                            IOUtils.close((Closeable)reader);
                        }
                        map3 = new HashMap<ComponentIdentifier, MapFileEntry>();
                        String[] mapFiles = tempFolder.list();
                        if (mapFiles == null || mapFiles.length == 0) break block19;
                        MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
                        int amountPerFile = 100 / mapFiles.length;
                        String[] stringArray = mapFiles;
                        int n = mapFiles.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) {
                                map3 = Collections.unmodifiableMap(map3);
                                this.cacheMap(userCache, map3);
                                map2 = map3;
                                if (tempFolder != null) {
                                    break;
                                }
                                break block20;
                            }
                            String file = stringArray[n2];
                            if (file.endsWith(".map")) {
                                PDEMapProvider.collectEntries(new File(tempFolder, file), map3);
                            }
                            MonitorUtils.worked((IProgressMonitor)monitor, (int)amountPerFile);
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        problemCollector.add(e.getStatus());
                        PDEPlugin.getLogger().debug(e.getMessage(), new Object[0]);
                    }
                    FileUtils.deleteRecursive((File)tempFolder, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                }
                monitor.done();
                return map2;
            }
            return null;
            finally {
                if (tempFolder != null) {
                    FileUtils.deleteRecursive(tempFolder, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                }
                monitor.done();
            }
        }
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        super.addAttributes(attrs);
        attrs.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi:type", "CDATA", "pmp:PDEMapProvider");
    }

    private void cacheMap(Map<UUID, Object> userCache, Map<ComponentIdentifier, MapFileEntry> map) {
        userCache.put(this.getId(), map);
    }

    private Map<ComponentIdentifier, MapFileEntry> getCachedMap(Map<UUID, Object> userCache) {
        return (Map)userCache.get(this.getId());
    }

    private MapFileEntry getMapFileEntry(NodeQuery query, MultiStatus problemCollector, Map<ComponentIdentifier, MapFileEntry> map) {
        if (map == null) {
            return null;
        }
        ComponentRequest wanted = query.getComponentRequest();
        String name = wanted.getName();
        String ctype = wanted.getComponentTypeID();
        IVersionDesignator vd = wanted.getVersionDesignator();
        ComponentIdentifier candidate = null;
        MapFileEntry candidateEntry = null;
        for (Map.Entry<ComponentIdentifier, MapFileEntry> entry : map.entrySet()) {
            ComponentIdentifier cn = entry.getKey();
            if (!cn.getName().equals(name) || !Trivial.equalsAllowNull((Object)ctype, (Object)cn.getComponentTypeID())) continue;
            IVersion v = cn.getVersion();
            if (vd != null && v != null && !vd.designates(v) || candidate != null && (v == null || candidate.getVersion() != null && candidate.getVersion().compareTo((Object)v) > 0)) continue;
            candidate = cn;
            candidateEntry = entry.getValue();
        }
        if (candidateEntry == null) {
            String msg = NLS.bind((String)Messages.PDEMapProvider_0_for_1_unable_to_find_2_in_map, (Object[])new Object[]{this.getReaderTypeId(), this.getURI(query.getProperties()), wanted});
            problemCollector.add((IStatus)new Status(4, CorePlugin.getID(), 0, msg, null));
            PDEPlugin.getLogger().debug(msg, new Object[0]);
        }
        return candidateEntry;
    }
}

