/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.prefs;

import org.eclipse.buckminster.cmdline.BasicPreferenceHandler;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.PDECore;
import org.osgi.service.prefs.BackingStoreException;

abstract class TargetVariableHandler
extends BasicPreferenceHandler
implements ICoreConstants {
    private final String m_prefName;

    TargetVariableHandler(String prefName) {
        this.m_prefName = prefName;
    }

    public String get(String defaultValue) {
        return PDECore.getDefault().getPluginPreferences().getString(this.m_prefName);
    }

    public void set(String value) throws BackingStoreException {
        String[] stringArray = this.getKnownValues();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String knownValue = stringArray[n2];
            if (knownValue.equals(value)) {
                PDECore pdePlugin = PDECore.getDefault();
                pdePlugin.getPluginPreferences().setValue(this.m_prefName, value);
                pdePlugin.savePluginPreferences();
                return;
            }
            ++n2;
        }
        throw new BackingStoreException(NLS.bind((String)Messages._0_is_not_valid_setting_for_target_1_pref, (Object)value, (Object)this.m_prefName));
    }

    abstract String[] getKnownValues();
}

