/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.core.version.VersionSyntaxException;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.tasks.VersionConsolidator;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

public class BundleConsolidator
extends VersionConsolidator {
    private final byte[] m_bytes;

    public BundleConsolidator(File inputFile, File outputFile, File propertiesFile, String qualifier) throws CoreException {
        super(outputFile, propertiesFile, qualifier);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FileInputStream input = null;
        try {
            try {
                input = new FileInputStream(inputFile);
                IOUtils.copy((InputStream)input, (OutputStream)output, null);
            }
            catch (IOException e) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_manifest_from_0, (Object)inputFile), (Object[])new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close((Closeable)input);
        this.m_bytes = output.toByteArray();
    }

    public void run() throws IOException {
        Manifest manifest = new Manifest(new ByteArrayInputStream(this.m_bytes));
        Attributes a = manifest.getMainAttributes();
        String symbolicName = a.getValue("Bundle-SymbolicName");
        String id = null;
        IVersion newVersion = null;
        boolean changed = false;
        if (symbolicName != null) {
            try {
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicName);
                id = elements[0].getValue();
            }
            catch (BundleException be) {
                throw new IOException(be.getMessage());
            }
            String versionStr = a.getValue("Bundle-Version");
            if (versionStr != null) {
                try {
                    IVersion version = VersionFactory.OSGiType.fromString(versionStr);
                    ComponentIdentifier ci = new ComponentIdentifier(id, "osgi.bundle", version);
                    newVersion = this.replaceQualifier(ci, Collections.emptyList());
                    if (newVersion != null && !version.equals(newVersion)) {
                        a.put(new Attributes.Name("Bundle-Version"), newVersion.toString());
                        changed = true;
                    }
                }
                catch (VersionSyntaxException versionSyntaxException) {
                    // empty catch block
                }
            }
        }
        changed = this.treatManifest(manifest, id, newVersion) || changed;
        OutputStream out = null;
        try {
            out = new FileOutputStream(this.getOutputFile());
            if (changed) {
                out = new BufferedOutputStream(out);
                manifest.write(out);
            } else {
                ((OutputStream)out).write(this.m_bytes);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close((Closeable)out);
    }

    protected boolean treatManifest(Manifest manifest, String symbolicName, IVersion version) {
        return false;
    }
}

