/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.jar.JarFile;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.pde.internal.FeatureModelReader;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.osgi.framework.BundleException;

public class ConvertSiteToRuntime {
    private static final String FEATURES_DIR = "features";
    private static final String FEATURE_FILE = "feature.xml";
    private static final String PLUGINS_DIR = "plugins";
    private final File m_productRoot;

    public ConvertSiteToRuntime(File productRoot) {
        this.m_productRoot = productRoot;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean guessUnpack(File bundleJar) throws CoreException {
        try {
            block12: {
                jf = new JarFile(bundleJar);
                mf = jf.getManifest();
                if (mf == null) {
                    return false;
                }
                attrs = mf.getMainAttributes();
                value = attrs.getValue("Fragment-Host");
                if (value != null && (elements = ManifestElement.parseHeader((String)"Fragment-Host", (String)value)).length > 0 && "org.eclipse.equinox.launcher".equals(elements[0].getValue())) {
                    return true;
                }
                value = attrs.getValue("Bundle-ClassPath");
                if (value == null) break block12;
                var9_9 = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)value);
                var8_10 = var9_9.length;
                var7_11 = 0;
                if (true) ** GOTO lbl29
            }
            value = attrs.getValue("Eclipse-BundleShape");
            if (value == null) return false;
            var11_12 = value.equals("dir");
            return var11_12;
            finally {
                jf.close();
            }
            do {
                if ((elem = var9_9[var7_11]).getValue().equals(".")) {
                    return false;
                }
                ++var7_11;
lbl29:
                // 2 sources

            } while (var7_11 < var8_10);
            return true;
        }
        catch (BundleException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    public void run() throws CoreException {
        BufferedInputStream input;
        int n;
        int n2;
        Object[] objectArray;
        NullProgressMonitor nullMonitor = new NullProgressMonitor();
        File pluginsDir = new File(this.m_productRoot, PLUGINS_DIR);
        String[] pluginCandiates = pluginsDir.list();
        if (pluginCandiates == null) {
            return;
        }
        File featuresDir = new File(this.m_productRoot, FEATURES_DIR);
        String[] featureCandiates = featuresDir.list();
        ArrayList<String> pluginsToUnpack = null;
        HashSet<String> seenPlugins = new HashSet<String>();
        if (featureCandiates != null && featureCandiates.length > 0) {
            Object featureCandidate;
            objectArray = featureCandiates;
            n2 = featureCandiates.length;
            n = 0;
            while (n < n2) {
                featureCandidate = objectArray[n];
                if (((String)featureCandidate).endsWith(".jar")) {
                    File featureJar = new File(featuresDir, (String)featureCandidate);
                    File featureDir = new File(featuresDir, ((String)featureCandidate).substring(0, ((String)featureCandidate).length() - 4));
                    BufferedInputStream input2 = null;
                    try {
                        try {
                            input2 = new BufferedInputStream(new FileInputStream(featureJar));
                            FileUtils.unzip((InputStream)input2, null, (File)featureDir, (ConflictResolution)ConflictResolution.REPLACE, (IProgressMonitor)nullMonitor);
                        }
                        catch (IOException e) {
                            throw BuckminsterException.wrap((Throwable)e);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(input2);
                        featureJar.delete();
                        throw throwable;
                    }
                    IOUtils.close((Closeable)input2);
                    featureJar.delete();
                }
                ++n;
            }
            objectArray = featuresDir.listFiles();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                featureCandidate = objectArray[n];
                if (((File)featureCandidate).isDirectory()) {
                    input = null;
                    try {
                        input = new BufferedInputStream(new FileInputStream(new File((File)featureCandidate, FEATURE_FILE)));
                        IFeatureModel feature = FeatureModelReader.readFeatureModel(input);
                        IFeaturePlugin[] iFeaturePluginArray = feature.getFeature().getPlugins();
                        int n3 = iFeaturePluginArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IFeaturePlugin plugin = iFeaturePluginArray[n4];
                            String fullName = String.valueOf(plugin.getId()) + '_' + plugin.getVersion();
                            if (!seenPlugins.contains(fullName)) {
                                seenPlugins.add(fullName);
                                if (plugin.isUnpack()) {
                                    if (pluginsToUnpack == null) {
                                        pluginsToUnpack = new ArrayList();
                                    }
                                    pluginsToUnpack.add(fullName);
                                }
                            }
                            ++n4;
                        }
                    }
                    catch (FileNotFoundException feature) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }
        objectArray = pluginCandiates;
        n2 = pluginCandiates.length;
        n = 0;
        while (n < n2) {
            String fullName;
            String pluginCandidate = objectArray[n];
            if (pluginCandidate.endsWith(".jar") && !seenPlugins.contains(fullName = pluginCandidate.substring(0, pluginCandidate.length() - 4))) {
                seenPlugins.add(fullName);
                File pluginJar = new File(pluginsDir, pluginCandidate);
                if (this.guessUnpack(pluginJar)) {
                    if (pluginsToUnpack == null) {
                        pluginsToUnpack = new ArrayList<String>();
                    }
                    pluginsToUnpack.add(fullName);
                }
            }
            ++n;
        }
        if (pluginsToUnpack == null) {
            return;
        }
        for (String pluginToUnpack : pluginsToUnpack) {
            File pluginJar = new File(pluginsDir, String.valueOf(pluginToUnpack) + ".jar");
            File pluginDir = new File(pluginsDir, pluginToUnpack);
            input = null;
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(pluginJar));
                    FileUtils.unzip((InputStream)input, null, (File)pluginDir, (ConflictResolution)ConflictResolution.REPLACE, (IProgressMonitor)nullMonitor);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    IOUtils.close((Closeable)input);
                    pluginJar.delete();
                    continue;
                }
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable)input);
                pluginJar.delete();
                throw throwable;
            }
            IOUtils.close((Closeable)input);
            pluginJar.delete();
        }
    }
}

