/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.Prerequisite;
import org.eclipse.buckminster.core.helpers.BMProperties;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.core.helpers.TextUtils;
import org.eclipse.buckminster.core.metadata.model.IModelCache;
import org.eclipse.buckminster.core.mspec.ConflictResolution;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.osgi.filter.FilterFactory;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.cspecgen.feature.FeatureBuilder;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.build.BrandingIron;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.iproduct.ILauncherInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.core.iproduct.ISplashInfo;
import org.eclipse.pde.internal.core.product.ProductModel;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateProductBase {
    private final IActionContext m_actionContext;
    private final String m_arch;
    private Map<String, String> m_hints;
    private final boolean m_copyJavaLauncher;
    private final String m_os;
    private final IPath m_outputDir;
    private final IProduct m_product;
    private final IPath m_targetLocation;
    private final String m_ws;
    private final String m_nl;
    private final List<File> m_files;
    public static final String MACOSX_LAUNCHER_FOLDER = "Eclipse.app/Contents/MacOS";
    public static final String DEFAULT_LAUNCHER = "launcher";
    public static final String DEFAULT_LAUNCHER_WIN32 = "launcher.exe";
    private static final Pattern s_launcherPattern = Pattern.compile("^org\\.eclipse\\.equinox\\.launcher_(.+)\\.jar$");

    private static void appendExpandedPath(StringBuilder builder, String path) {
        if ((path = CreateProductBase.getExpandedPath(path)) != null) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(path);
        }
    }

    private static String getExpandedPath(String path) {
        IResource resource;
        String fullPath = null;
        if (path != null && path.length() > 0 && (resource = PDECore.getWorkspace().getRoot().findMember((IPath)new Path(path))) != null) {
            fullPath = resource.getLocation().toOSString();
        }
        return fullPath;
    }

    private static String getSolarisImages(ILauncherInfo info) {
        StringBuilder buffer = new StringBuilder();
        CreateProductBase.appendExpandedPath(buffer, info.getIconPath("solarisLarge"));
        CreateProductBase.appendExpandedPath(buffer, info.getIconPath("solarisMedium"));
        CreateProductBase.appendExpandedPath(buffer, info.getIconPath("solarisSmall"));
        CreateProductBase.appendExpandedPath(buffer, info.getIconPath("solarisTiny"));
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    private static Dictionary<String, String>[] getStatePlatformProperties(State state) {
        return state.getPlatformProperties();
    }

    private static String getWin32Images(ILauncherInfo info) {
        StringBuilder buffer = new StringBuilder();
        if (info.usesWinIcoFile()) {
            CreateProductBase.appendExpandedPath(buffer, info.getIconPath("icoFile"));
        } else {
            CreateProductBase.appendExpandedPath(buffer, info.getIconPath("winSmallLow"));
            CreateProductBase.appendExpandedPath(buffer, info.getIconPath("winSmallHigh"));
            CreateProductBase.appendExpandedPath(buffer, info.getIconPath("winMediumLow"));
            CreateProductBase.appendExpandedPath(buffer, info.getIconPath("winMediumHigh"));
            CreateProductBase.appendExpandedPath(buffer, info.getIconPath("winLargeLow"));
            CreateProductBase.appendExpandedPath(buffer, info.getIconPath("winLargeHigh"));
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    public CreateProductBase(File productFile, List<File> files, IPath outputDir, IPath targetLocation, boolean copyJavaLauncher) throws CoreException {
        if (outputDir == null) {
            throw new IllegalArgumentException(Messages.outputdir_can_not_be_null);
        }
        this.m_outputDir = outputDir.addTrailingSeparator();
        if (targetLocation == null) {
            throw new IllegalArgumentException(Messages.target_loc_cannot_be_null);
        }
        this.m_targetLocation = targetLocation.addTrailingSeparator();
        if (productFile == null) {
            throw new IllegalArgumentException(Messages.productFile_cannot_be_null);
        }
        this.m_files = files;
        this.m_actionContext = AbstractActor.getActiveContext();
        BufferedInputStream pfInput = null;
        try {
            try {
                pfInput = new BufferedInputStream(new FileInputStream(productFile));
                ProductModel productModel = new ProductModel();
                productModel.load((InputStream)pfInput, false);
                this.m_product = productModel.getProduct();
            }
            catch (IOException e) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_read_file_0, (Object)productFile), (Object[])new Object[0]);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(pfInput);
            throw throwable;
        }
        IOUtils.close((Closeable)pfInput);
        Map props = this.m_actionContext.getProperties();
        Object os = props.get("target.os");
        this.m_os = os == null || os.equals("*") ? TargetPlatform.getOS() : os.toString();
        Object ws = props.get("target.ws");
        this.m_ws = ws == null || ws.equals("*") ? TargetPlatform.getWS() : ws.toString();
        Object arch = props.get("target.arch");
        this.m_arch = arch == null || arch.equals("*") ? TargetPlatform.getOSArch() : arch.toString();
        Object nl = props.get("target.nl");
        this.m_nl = nl == null || nl.equals("*") ? TargetPlatform.getNL() : nl.toString();
        this.m_copyJavaLauncher = copyJavaLauncher;
    }

    public String execute() throws Exception {
        this.m_hints = null;
        File outputDir = this.m_outputDir.toFile();
        if (!outputDir.isDirectory()) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages._0_is_not_directory, (Object)outputDir), (Object[])new Object[0]);
        }
        if (this.m_copyJavaLauncher) {
            this.copyJavaLauncherToRoot();
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.createConfigIniFile(new File(outputDir, "configuration"), (IProgressMonitor)monitor);
        this.createEclipseProductFile(outputDir, (IProgressMonitor)monitor);
        this.createLauncherIniFile(outputDir, (IProgressMonitor)monitor);
        return this.createLauncher();
    }

    public Map<String, String> getHints() {
        if (this.m_hints == null || this.m_hints.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hints = new HashMap<String, String>();
        StringBuilder bld = new StringBuilder(100);
        bld.append("buckminster.install.");
        int pfLen = "buckminster.install.".length();
        for (Map.Entry<String, String> hint : this.m_hints.entrySet()) {
            bld.setLength(pfLen);
            bld.append(hint.getKey());
            bld.append('.');
            bld.append(this.m_product.getName());
            hints.put(bld.toString(), hint.getValue());
        }
        return hints;
    }

    private void addChmodHint(String perm, String filesAndFolders) {
        if (this.m_hints == null) {
            this.m_hints = new HashMap<String, String>();
        }
        FeatureBuilder.addRootsPermissions(this.m_hints, perm, filesAndFolders, null);
    }

    private void copyJavaLauncherToRoot() throws CoreException, IOException {
        File startupJar;
        File targetRoot = this.m_targetLocation.toFile();
        File pluginsDir = new File(targetRoot, "plugins");
        String[] names = pluginsDir.list();
        if (names == null) {
            throw new IOException(NLS.bind((String)Messages._0_is_not_directory, (Object)pluginsDir));
        }
        String found = null;
        IVersion foundVer = null;
        int idx = names.length;
        while (--idx >= 0) {
            String name = names[idx];
            Matcher matcher = s_launcherPattern.matcher(name);
            if (!matcher.matches()) continue;
            IVersion version = VersionFactory.OSGiType.fromString(matcher.group(1));
            if (foundVer != null && foundVer.compareTo((Object)version) <= 0) continue;
            found = name;
            foundVer = version;
        }
        if (found == null) {
            startupJar = new File(targetRoot, "startup.jar");
            if (!startupJar.exists()) {
                throw new FileNotFoundException(pluginsDir + "org.eclipse.equinox.launcher_<version>.jar");
            }
        } else {
            startupJar = new File(pluginsDir, found);
        }
        FileUtils.copyFile((File)startupJar, (File)this.m_outputDir.toFile(), (String)"startup.jar", (IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * Unable to fully structure code
     */
    private void copyLauncherExecutable() throws CoreException {
        homeDir = new File(TargetPlatform.getLocation());
        rootFiles = homeDir.listFiles();
        if (rootFiles == null) {
            return;
        }
        targetOs = TargetPlatform.getOS();
        isWin32 = "win32".equals(targetOs);
        isMac = "macosx".equals(targetOs);
        monitor = new NullProgressMonitor();
        dest = this.m_outputDir.toFile();
        var11_8 = rootFiles;
        var10_9 = rootFiles.length;
        var9_10 = 0;
        while (var9_10 < var10_9) {
            block12: {
                block13: {
                    rootFile = var11_8[var9_10];
                    if (!rootFile.isFile()) break block12;
                    name = rootFile.getName();
                    copyFile = false;
                    if (!"startup.jar".equals(name)) break block13;
                    copyFile = true;
                    ** GOTO lbl39
                }
                if (isMac) {
                    if ("Eclipse.app".equals(name)) {
                        FileUtils.deepCopy((File)rootFile, (File)new File(dest, name), (ConflictResolution)ConflictResolution.REPLACE, (IProgressMonitor)new NullProgressMonitor());
                    }
                } else {
                    if (isWin32) {
                        if ("eclipse.exe".equals(name)) {
                            copyFile = true;
                            name = "launcher.exe";
                        }
                    } else if ("eclipse".equals(name)) {
                        copyFile = true;
                        name = "launcher";
                        this.addChmodHint("755", this.getLauncherName());
                    } else if (name.startsWith("libXm.so") || name.startsWith("libcairo-swt.so")) {
                        copyFile = true;
                        this.addChmodHint("755", name);
                    }
lbl39:
                    // 6 sources

                    if (copyFile) {
                        FileUtils.copyFile((File)rootFile, (File)dest, (String)name, (IProgressMonitor)monitor);
                    }
                }
            }
            ++var9_10;
        }
    }

    private void createConfigIniFile(File outputDir, IProgressMonitor monitor) throws CoreException, IOException {
        FileUtils.prepareDestination((File)outputDir, (ConflictResolution)ConflictResolution.UPDATE, (IProgressMonitor)monitor);
        File custom = this.getCustomIniFile();
        if (custom != null) {
            FileUtils.copyFile((File)custom, (File)outputDir, (String)"config.ini", (IProgressMonitor)monitor);
            return;
        }
        String lineDelimiter = this.getLineDelimiter();
        FileWriter writer = null;
        try {
            writer = new FileWriter(new File(outputDir, "config.ini"));
            String location = this.getSplashLocation();
            writer.write("#Product Runtime Configuration File");
            writer.write(lineDelimiter);
            writer.write(lineDelimiter);
            if (location != null) {
                writer.write("osgi.splashPath=");
                writer.write(location);
                writer.write(lineDelimiter);
            }
            writer.write("eclipse.product=");
            writer.write(this.m_product.getId());
            writer.write(lineDelimiter);
            writer.write("osgi.bundles=");
            this.printBundleList(writer, TargetPlatform.getBundleList());
            writer.write(lineDelimiter);
            writer.write("osgi.bundles.defaultStartLevel=4");
            writer.write(lineDelimiter);
        }
        catch (Throwable throwable) {
            IOUtils.close(writer);
            throw throwable;
        }
        IOUtils.close((Closeable)writer);
    }

    private void createEclipseProductFile(File outputDir, IProgressMonitor monitor) throws CoreException, IOException {
        FileUtils.prepareDestination((File)outputDir, (ConflictResolution)ConflictResolution.UPDATE, (IProgressMonitor)monitor);
        HashMap<String, String> properties = new HashMap<String, String>();
        IPluginModelBase model = PluginRegistry.findModel((String)this.getBrandingPlugin());
        if (model != null) {
            properties.put("name", model.getResourceString(this.m_product.getName()));
        } else {
            properties.put("name", this.m_product.getName());
        }
        properties.put("id", this.m_product.getId());
        if (model != null) {
            properties.put("version", model.getPluginBase().getVersion());
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(outputDir, ".eclipseproduct"));
            BMProperties.store(properties, (OutputStream)out, (String)"Eclipse Product File");
        }
        catch (Throwable throwable) {
            IOUtils.close(out);
            throw throwable;
        }
        IOUtils.close((Closeable)out);
    }

    private String createLauncher() throws Exception {
        ILauncherInfo info;
        String launcherName = this.getLauncherName();
        boolean hasDeltaPack = this.hasDeltaPackFeature();
        if (hasDeltaPack) {
            boolean nameOK;
            boolean bl = nameOK = this.m_os.equals("win32") ? DEFAULT_LAUNCHER_WIN32.equalsIgnoreCase(launcherName) : DEFAULT_LAUNCHER.equals(launcherName);
            if (!(nameOK || this.m_os.equals("macosx") || this.m_os.equals("win32"))) {
                this.addChmodHint("755", launcherName);
            }
        } else {
            this.copyLauncherExecutable();
        }
        if ((info = this.m_product.getLauncherInfo()) == null) {
            return launcherName;
        }
        String images = null;
        if ("win32".equals(this.m_os)) {
            images = CreateProductBase.getWin32Images(info);
        } else if ("solaris".equals(this.m_os)) {
            images = CreateProductBase.getSolarisImages(info);
        } else if ("linux".equals(this.m_os)) {
            images = CreateProductBase.getExpandedPath(info.getIconPath("linuxIcon"));
        } else if ("macosx".equals(this.m_os)) {
            images = CreateProductBase.getExpandedPath(info.getIconPath("macosxIcon"));
        }
        BrandingIron bi = new BrandingIron();
        bi.setName(launcherName);
        bi.setOS(this.m_os);
        bi.setRoot(this.m_outputDir.toOSString());
        if (images != null) {
            bi.setIcons(images);
        }
        bi.brand();
        return launcherName;
    }

    private void createLauncherIniFile(File outputDir, IProgressMonitor monitor) throws CoreException, IOException {
        String programArgs = this.getProgramArguments(this.m_os);
        String vmArgs = this.getVMArguments(this.m_os);
        if (programArgs.length() == 0 && vmArgs.length() == 0) {
            return;
        }
        if ("macosx".equals(this.m_os)) {
            outputDir = new File(outputDir, MACOSX_LAUNCHER_FOLDER);
        }
        FileUtils.prepareDestination((File)outputDir, (ConflictResolution)ConflictResolution.UPDATE, (IProgressMonitor)monitor);
        String lineDelimiter = this.getLineDelimiter();
        FileWriter writer = null;
        try {
            writer = new FileWriter(new File(outputDir, String.valueOf(this.getLauncherName()) + ".ini"));
            ExecutionArguments args = new ExecutionArguments(vmArgs, programArgs);
            String[] stringArray = args.getProgramArgumentsArray();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                writer.write(arg);
                writer.write(lineDelimiter);
                ++n2;
            }
            String[] array = args.getVMArgumentsArray();
            if (array.length > 0) {
                writer.write("-vmargs");
                writer.write(lineDelimiter);
                String[] stringArray2 = array;
                int n3 = array.length;
                n = 0;
                while (n < n3) {
                    String arg = stringArray2[n];
                    writer.write(arg);
                    writer.write(lineDelimiter);
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(writer);
            throw throwable;
        }
        IOUtils.close((Closeable)writer);
    }

    private String getBrandingPlugin() {
        String id = this.m_product.getId();
        int lastDot = id.lastIndexOf(46);
        return lastDot < 0 ? id.substring(0, lastDot) : null;
    }

    private File getCustomIniFile() {
        File file;
        String path;
        IConfigurationFileInfo info = this.m_product.getConfigurationFileInfo();
        if (info != null && "custom".equals(info.getUse(this.m_os)) && (path = CreateProductBase.getExpandedPath(info.getPath(this.m_os))) != null && (file = new File(path)).exists() && file.isFile()) {
            return file;
        }
        return null;
    }

    private String getLauncherName() {
        String name;
        ILauncherInfo info = this.m_product.getLauncherInfo();
        if (info != null && (name = info.getLauncherName()) != null && name.length() > 0) {
            if ((name = name.trim()).endsWith(".exe")) {
                name = name.substring(0, name.length() - 4);
            }
            return name;
        }
        return DEFAULT_LAUNCHER;
    }

    private String getLineDelimiter() {
        return "win32".equals(this.m_os) ? "\r\n" : "\n";
    }

    private List<BundleDescription> getPluginModels() throws CoreException {
        BundleDescription bundle;
        ArrayList<BundleDescription> list = new ArrayList<BundleDescription>();
        State state = this.getState();
        if (this.m_files.size() == 0) {
            IProductPlugin[] iProductPluginArray = this.m_product.getPlugins();
            int n = iProductPluginArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProductPlugin plugin = iProductPluginArray[n2];
                BundleDescription bundle2 = state.getBundle(plugin.getId(), null);
                if (bundle2 != null) {
                    list.add(bundle2);
                }
                ++n2;
            }
        } else {
            for (File file : this.m_files) {
                File folder;
                String fileName = file.getName();
                if (!fileName.endsWith(".jar") || (folder = file.getParentFile()) == null || !"plugins".equals(folder.getName())) continue;
                try {
                    JarFile jf = new JarFile(file);
                    try {
                        Manifest mf = jf.getManifest();
                        if (mf == null) continue;
                        Attributes attrs = mf.getMainAttributes();
                        String value = attrs.getValue("Bundle-SymbolicName");
                        if (value == null) {
                            continue;
                        }
                        ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)value);
                        if (elements.length == 0) {
                            continue;
                        }
                        ManifestElement elem = elements[0];
                        BundleDescription bundle3 = state.getBundle(elem.getValue(), null);
                        if (bundle3 == null) continue;
                        list.add(bundle3);
                    }
                    finally {
                        jf.close();
                    }
                }
                catch (BundleException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
                catch (IOException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
        }
        IPluginModelBase launcherPlugin = PluginRegistry.findModel((String)"org.eclipse.equinox.launcher");
        if (launcherPlugin != null && (bundle = launcherPlugin.getBundleDescription()) != null && !list.contains(bundle)) {
            list.add(bundle);
            BundleDescription[] bundleDescriptionArray = bundle.getFragments();
            int n = bundleDescriptionArray.length;
            int n3 = 0;
            while (n3 < n) {
                BundleDescription fragment = bundleDescriptionArray[n3];
                if (!list.contains(fragment)) {
                    list.add(fragment);
                }
                ++n3;
            }
        }
        return list;
    }

    private String getProgramArguments(String os) {
        IArgumentsInfo info = this.m_product.getLauncherArguments();
        return info != null ? CoreUtility.normalize((String)info.getCompleteProgramArguments(os)) : "";
    }

    private String getSplashLocation() {
        ISplashInfo info = this.m_product.getSplashInfo();
        String plugin = null;
        if (info != null) {
            plugin = info.getLocation();
        }
        if (plugin == null || plugin.trim().length() == 0) {
            plugin = this.getBrandingPlugin();
        }
        if (plugin == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder("platform:/base/plugins/");
        buffer.append(plugin.trim());
        State state = this.getState();
        BundleDescription bundle = state.getBundle(plugin, null);
        if (bundle != null) {
            BundleDescription[] bundleDescriptionArray = bundle.getFragments();
            int n = bundleDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription fragment = bundleDescriptionArray[n2];
                String id = fragment.getSymbolicName();
                if (this.m_product.containsPlugin(id)) {
                    buffer.append(",platform:/base/plugins/");
                    buffer.append(id);
                }
                ++n2;
            }
        }
        return buffer.toString();
    }

    private State getState() {
        State main = TargetPlatformHelper.getState();
        if (this.m_os.equals(TargetPlatform.getOS()) && this.m_ws.equals(TargetPlatform.getWS()) && this.m_arch.equals(TargetPlatform.getOSArch())) {
            return main;
        }
        State stateCopy = main.getFactory().createState(main);
        stateCopy.setResolver(Platform.getPlatformAdmin().getResolver());
        stateCopy.setPlatformProperties(main.getPlatformProperties());
        Dictionary<String, String>[] dictionaryArray = CreateProductBase.getStatePlatformProperties(stateCopy);
        int n = dictionaryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Dictionary<String, String> properties = dictionaryArray[n2];
            properties.put("osgi.os", this.m_os);
            properties.put("osgi.ws", this.m_ws);
            properties.put("osgi.arch", this.m_arch);
            ++n2;
        }
        stateCopy.resolve(false);
        return stateCopy;
    }

    private String getVMArguments(String os) {
        IArgumentsInfo info = this.m_product.getLauncherArguments();
        return info != null ? CoreUtility.normalize((String)info.getCompleteVMArguments(os)) : "";
    }

    private boolean hasDeltaPackFeature() throws CoreException {
        CSpec cspec = this.m_actionContext.getCSpec();
        Attribute attr = cspec.getAttribute("product.root.files");
        if (attr == null) {
            return false;
        }
        for (Prerequisite pq : attr.getPrerequisites()) {
            String cname = pq.getComponentName();
            if (cname == null || !cname.equals("org.eclipse.equinox.executable") && !cname.equals("org.eclipse.platform.launchers")) continue;
            return pq.getReferencedAttribute(cspec, (IModelCache)this.m_actionContext) != null;
        }
        return false;
    }

    private void printBundleList(Writer writer, String bundleList) throws IOException, CoreException {
        Hashtable<String, String> environment = new Hashtable<String, String>(4);
        ((Dictionary)environment).put("osgi.os", this.m_os);
        ((Dictionary)environment).put("osgi.ws", this.m_ws);
        ((Dictionary)environment).put("osgi.arch", this.m_arch);
        ((Dictionary)environment).put("osgi.nl", this.m_nl);
        List<BundleDescription> pluginModels = this.getPluginModels();
        boolean first = true;
        int top = pluginModels.size();
        HashSet<String> includedBundles = new HashSet<String>(top);
        HashSet<String> processedBundles = new HashSet<String>(top);
        boolean dynamicDiscovery = false;
        int idx = 0;
        while (idx < top) {
            String id = pluginModels.get(idx).getSymbolicName();
            if ("org.eclipse.update.configurator".equals(id)) {
                dynamicDiscovery = true;
                break;
            }
            ++idx;
        }
        idx = 0;
        while (idx < top) {
            BundleDescription bundle = pluginModels.get(idx);
            String id = bundle.getSymbolicName();
            if (bundle.getHost() == null || !dynamicDiscovery) {
                includedBundles.add(id);
            } else {
                processedBundles.add(id);
            }
            ++idx;
        }
        processedBundles.add("org.eclipse.osgi");
        String[] stringArray = TextUtils.split((String)bundleList, (String)",");
        int id = stringArray.length;
        int n = 0;
        while (n < id) {
            String id2;
            String token = stringArray[n];
            int delimIdx = token.indexOf(64);
            String string = id2 = delimIdx >= 0 ? token.substring(0, delimIdx) : token;
            if (!processedBundles.contains(id2) && includedBundles.contains(id2)) {
                processedBundles.add(id2);
                if (first) {
                    first = false;
                } else {
                    writer.write(44);
                }
                writer.write(id2);
                if (delimIdx >= 0 && delimIdx < token.length() - 1) {
                    writer.write(token, delimIdx, token.length() - delimIdx);
                }
            }
            ++n;
        }
        for (BundleDescription bundle : pluginModels) {
            try {
                String id3 = bundle.getSymbolicName();
                if (processedBundles.contains(id3)) continue;
                processedBundles.add(id3);
                String filterSpec = bundle.getPlatformFilter();
                if (filterSpec != null && !FilterFactory.newInstance((String)filterSpec).match(environment)) continue;
                if (first) {
                    first = false;
                } else {
                    writer.write(",");
                }
                writer.write(id3);
                if ("org.eclipse.equinox.app".equals(id3)) {
                    writer.write("@start");
                    continue;
                }
                if (!"org.eclipse.equinox.common".equals(id3) && !"org.eclipse.update.configurator".equals(id3)) continue;
                writer.write("@2:start");
            }
            catch (InvalidSyntaxException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
    }
}

