/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.OSGiVersion;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.core.version.VersionSyntaxException;
import org.eclipse.buckminster.pde.IPDEConstants;
import org.eclipse.buckminster.pde.Messages;
import org.eclipse.buckminster.pde.PDEPlugin;
import org.eclipse.buckminster.pde.internal.FeatureModelReader;
import org.eclipse.buckminster.pde.internal.model.EditableFeatureModel;
import org.eclipse.buckminster.pde.internal.model.ExternalBundleModel;
import org.eclipse.buckminster.pde.tasks.VersionConsolidator;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.core.bundle.BundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureConsolidator
extends VersionConsolidator
implements IModelChangedListener,
IPDEConstants,
IBuildPropertiesConstants {
    private static final String BASE_64_ENCODING = "-0123456789_ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final int QUALIFIER_SUFFIX_VERSION = 1;
    private final Map<String, Integer> m_contextQualifierLengths = new HashMap<String, Integer>();
    private final EditableFeatureModel m_featureModel;
    private final Map<String, OSGiVersion[]> m_featureVersions = new HashMap<String, OSGiVersion[]>();
    private final boolean m_generateVersionSuffix;
    private final int m_maxVersionSuffixLength;
    private final Map<String, OSGiVersion[]> m_pluginVersions = new HashMap<String, OSGiVersion[]>();
    private final int m_significantDigits;

    static InputStream getInput(File dirOrZip, String fileName) throws CoreException, FileNotFoundException {
        if (dirOrZip.isDirectory()) {
            return new BufferedInputStream(new FileInputStream(new File(dirOrZip, fileName)));
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(dirOrZip);
            JarEntry entry = jarFile.getJarEntry(fileName);
            if (entry == null) {
                throw new FileNotFoundException(String.format("%s[%s]", dirOrZip, fileName));
            }
            final JarFile innerJarFile = jarFile;
            jarFile = null;
            FilterInputStream filterInputStream = new FilterInputStream(innerJarFile.getInputStream(entry)){

                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    innerJarFile.close();
                }
            };
            return filterInputStream;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw BuckminsterException.fromMessage((Throwable)e, (String)NLS.bind((String)Messages.unable_to_read_0, (Object)dirOrZip), (Object[])new Object[0]);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    PDEPlugin.getLogger().error((Throwable)e, NLS.bind((String)Messages.error_while_closing_0, (Object)dirOrZip), new Object[0]);
                }
            }
        }
    }

    private static void addVersion(Map<String, OSGiVersion[]> versionMap, String id, String versionStr) throws VersionSyntaxException {
        if (versionStr == null) {
            return;
        }
        OSGiVersion version = (OSGiVersion)VersionFactory.OSGiType.fromString(versionStr);
        OSGiVersion[] arr = versionMap.get(id);
        if (arr == null) {
            arr = new OSGiVersion[]{version};
        } else {
            OSGiVersion[] oSGiVersionArray = arr;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                OSGiVersion old = oSGiVersionArray[n2];
                if (old.equals(version)) {
                    return;
                }
                ++n2;
            }
            OSGiVersion[] newArr = new OSGiVersion[arr.length + 1];
            System.arraycopy(arr, 0, newArr, 0, arr.length);
            newArr[arr.length] = version;
            arr = newArr;
        }
        versionMap.put(id, arr);
    }

    private static void appendEncodedCharacter(StringBuilder buffer, int c) {
        while (c > 62) {
            buffer.append('z');
            c -= 63;
        }
        buffer.append(FeatureConsolidator.base64Character(c));
    }

    private static char base64Character(int number) {
        return number < 0 || number > 63 ? (char)' ' : BASE_64_ENCODING.charAt(number);
    }

    private static int charValue(char c) {
        int index = BASE_64_ENCODING.indexOf(c);
        return index + 1;
    }

    private static OSGiVersion findBestVersion(Map<String, OSGiVersion[]> versionMap, String id, String componentType, String refId, String versionStr) throws CoreException {
        OSGiVersion version;
        try {
            version = (OSGiVersion)VersionFactory.OSGiType.fromString(versionStr);
            if (version.toString().equals("0.0.0")) {
                version = null;
            }
        }
        catch (VersionSyntaxException e) {
            version = null;
        }
        OSGiVersion candidate = null;
        OSGiVersion[] versions = versionMap.get(refId);
        if (versions != null) {
            OSGiVersion[] oSGiVersionArray = versions;
            int n = versions.length;
            int n2 = 0;
            while (n2 < n) {
                OSGiVersion v = oSGiVersionArray[n2];
                if (v != null) {
                    if (version == null) {
                        if (candidate == null || v.compareTo((IVersion)candidate) > 0) {
                            candidate = v;
                        }
                    } else if (version.getMajor() == v.getMajor() && version.getMinor() == v.getMinor() && version.getMicro() == v.getMicro() && (candidate == null || v.compareTo((IVersion)candidate) > 0)) {
                        candidate = v;
                    }
                }
                ++n2;
            }
        }
        if (candidate == null) {
            candidate = version;
        }
        return candidate;
    }

    private static String lengthPrefixBase64(long number) {
        int length = 7;
        int i = 0;
        while (i < 7) {
            if (number < 1L << i * 6 + 3) {
                length = i;
                break;
            }
            ++i;
        }
        StringBuilder result = new StringBuilder(length + 1);
        result.append(FeatureConsolidator.base64Character((length << 3) + (int)(number >> 6 * length & 7L)));
        while (--length >= 0) {
            result.append(FeatureConsolidator.base64Character((int)(number >> 6 * length & 0x3FL)));
        }
        return result.toString();
    }

    public FeatureConsolidator(File inputFile, File outputFile, File propertiesFile, List<File> featuresAndBundles, String qualifier, boolean generateVersionSuffix, int maxVersionSuffixLength, int significantDigits) throws CoreException {
        super(outputFile, propertiesFile, qualifier);
        this.m_featureModel = FeatureModelReader.readEditableFeatureModel(inputFile);
        this.m_featureModel.addModelChangedListener(this);
        this.m_generateVersionSuffix = generateVersionSuffix;
        if (significantDigits == -1) {
            significantDigits = Integer.MAX_VALUE;
        }
        if (maxVersionSuffixLength == -1) {
            maxVersionSuffixLength = 28;
        }
        this.m_significantDigits = this.getIntProperty("significantVersionDigits", significantDigits);
        this.m_maxVersionSuffixLength = this.getIntProperty("generatedVersionLength", maxVersionSuffixLength);
        for (File featureOrBundle : featuresAndBundles) {
            Object model2;
            InputStream input = null;
            try {
                input = FeatureConsolidator.getInput(featureOrBundle, "feature.xml");
                model2 = FeatureModelReader.readFeatureModel(input);
                IFeature feature = model2.getFeature();
                String id = feature.getId();
                String version = feature.getVersion();
                int ctxQualLen = -1;
                if (version.indexOf(45) > 0) {
                    IOUtils.close((Closeable)input);
                    input = FeatureConsolidator.getInput(featureOrBundle, "feature.xml");
                    ctxQualLen = EditableFeatureModel.getContextQualifierLength(input);
                }
                this.m_contextQualifierLengths.put(id, ctxQualLen);
                FeatureConsolidator.addVersion(this.m_featureVersions, id, version);
            }
            catch (FileNotFoundException model2) {
                try {
                    input = FeatureConsolidator.getInput(featureOrBundle, "META-INF/MANIFEST.MF");
                    model2 = new ExternalBundleModel();
                    model2.load(input, true);
                    BundleFragmentModel bmodel = model2.isFragmentModel() ? new BundleFragmentModel() : new BundlePluginModel();
                    bmodel.setEnabled(true);
                    bmodel.setBundleModel((IBundleModel)model2);
                    IPluginBase pb = bmodel.getPluginBase();
                    FeatureConsolidator.addVersion(this.m_pluginVersions, pb.getId(), pb.getVersion());
                }
                catch (FileNotFoundException model3) {
                    IPluginBase pb;
                    try {
                        input = FeatureConsolidator.getInput(featureOrBundle, "plugin.xml");
                        model2 = new ExternalPluginModel();
                        model2.load(input, true);
                        pb = model2.getPluginBase();
                        FeatureConsolidator.addVersion(this.m_pluginVersions, pb.getId(), pb.getVersion());
                    }
                    catch (FileNotFoundException model4) {
                        try {
                            input = FeatureConsolidator.getInput(featureOrBundle, "fragment.xml");
                            model2 = new ExternalFragmentModel();
                            model2.load(input, true);
                            pb = model2.getPluginBase();
                            FeatureConsolidator.addVersion(this.m_pluginVersions, pb.getId(), pb.getVersion());
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                    }
                }
            }
            finally {
                IOUtils.close((Closeable)input);
            }
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        this.m_featureModel.setDirty(true);
    }

    public void run() throws CoreException, FileNotFoundException {
        ComponentIdentifier cid;
        IFeatureChild ref;
        IFeature feature = this.m_featureModel.getFeature();
        String id = feature.getId();
        ArrayList<ComponentIdentifier> deps = new ArrayList<ComponentIdentifier>();
        IFeatureChild[] iFeatureChildArray = feature.getIncludedFeatures();
        int n = iFeatureChildArray.length;
        int n2 = 0;
        while (n2 < n) {
            ref = iFeatureChildArray[n2];
            cid = this.replaceFeatureReferenceVersion(id, ref);
            if (cid != null) {
                deps.add(cid);
            }
            ++n2;
        }
        iFeatureChildArray = feature.getPlugins();
        n = iFeatureChildArray.length;
        n2 = 0;
        while (n2 < n) {
            ref = iFeatureChildArray[n2];
            cid = this.replacePluginReferenceVersion(id, (IFeaturePlugin)ref);
            if (cid != null) {
                deps.add(cid);
            }
            ++n2;
        }
        this.consolidateFeatureVersion(deps);
        this.m_featureModel.save(this.getOutputFile());
    }

    private void consolidateFeatureVersion(List<ComponentIdentifier> deps) throws CoreException {
        String suffix;
        IVersion version;
        IFeature feature = this.m_featureModel.getFeature();
        String versionStr = feature.getVersion();
        if (versionStr == null) {
            return;
        }
        try {
            version = VersionFactory.OSGiType.fromString(versionStr);
        }
        catch (VersionSyntaxException e) {
            return;
        }
        if (versionStr.endsWith("qualifier")) {
            ComponentIdentifier ci = new ComponentIdentifier(feature.getId(), "eclipse.feature", version);
            IVersion newVersion = this.replaceQualifier(ci, deps);
            if (newVersion != null && !version.equals(newVersion)) {
                String newVersionStr = newVersion.toString();
                feature.setVersion(newVersionStr);
                if (this.isContextReplacement()) {
                    int lastDot = versionStr.lastIndexOf(".");
                    this.m_featureModel.setContextQualifierLength(newVersionStr.length() - lastDot - 1);
                }
                version = newVersion;
            }
            if (this.isUsingGenerator(ci)) {
                return;
            }
        }
        if ((suffix = this.generateFeatureVersionSuffix()) == null) {
            return;
        }
        String qualifier = version.getQualifier();
        if (qualifier == null) {
            qualifier = suffix;
        } else {
            StringBuilder bld = new StringBuilder();
            bld.append(qualifier, 0, this.m_featureModel.getContextQualifierLength());
            bld.append('-');
            bld.append(suffix);
            qualifier = bld.toString();
        }
        feature.setVersion(version.replaceQualifier(qualifier).toString());
    }

    private String generateFeatureVersionSuffix() throws CoreException {
        if (!this.m_generateVersionSuffix || this.m_maxVersionSuffixLength <= 0 || this.m_featureModel.getContextQualifierLength() == -1) {
            return null;
        }
        long majorSum = 0L;
        long minorSum = 0L;
        long serviceSum = 0L;
        ++majorSum;
        IFeature feature = this.m_featureModel.getFeature();
        String versionStr = feature.getVersion();
        if (versionStr == null) {
            return null;
        }
        IFeatureChild[] referencedFeatures = feature.getIncludedFeatures();
        IFeaturePlugin[] pluginList = feature.getPlugins();
        int numElements = pluginList.length + referencedFeatures.length;
        if (numElements == 0) {
            return null;
        }
        String[] qualifiers = new String[numElements];
        int idx = 0;
        IFeatureChild[] iFeatureChildArray = referencedFeatures;
        int n = referencedFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureChild refFeature = iFeatureChildArray[n2];
            OSGiVersion version = (OSGiVersion)VersionFactory.OSGiType.fromString(refFeature.getVersion());
            majorSum += (long)version.getMajor();
            minorSum += (long)version.getMinor();
            serviceSum += (long)version.getMicro();
            String qualifier = version.getQualifier();
            Integer ctxLen = this.m_contextQualifierLengths.get(refFeature.getId());
            int contextLength = ctxLen == null ? -1 : ctxLen;
            if (qualifier != null && qualifier.length() > ++contextLength) {
                qualifier = qualifier.substring(contextLength);
            }
            qualifiers[idx++] = qualifier;
            ++n2;
        }
        iFeatureChildArray = pluginList;
        n = pluginList.length;
        n2 = 0;
        while (n2 < n) {
            IFeatureChild entry = iFeatureChildArray[n2];
            String vstr = entry.getVersion();
            if (vstr.endsWith("qualifier")) {
                int resultingLength = vstr.length() - "qualifier".length();
                if (vstr.charAt(resultingLength - 1) == '.') {
                    --resultingLength;
                }
                vstr = vstr.substring(0, resultingLength);
            }
            OSGiVersion version = (OSGiVersion)VersionFactory.OSGiType.fromString(vstr);
            majorSum += (long)version.getMajor();
            minorSum += (long)version.getMinor();
            serviceSum += (long)version.getMicro();
            qualifiers[idx++] = version.getQualifier();
            ++n2;
        }
        int longestQualifier = 0;
        while (--idx >= 0) {
            String qualifier = qualifiers[idx];
            if (qualifier == null) continue;
            if (qualifier.length() > this.m_significantDigits) {
                qualifiers[idx] = qualifier = qualifier.substring(0, this.m_significantDigits);
            }
            if (qualifier.length() <= longestQualifier) continue;
            longestQualifier = qualifier.length();
        }
        StringBuilder result = new StringBuilder();
        result.append(FeatureConsolidator.lengthPrefixBase64(majorSum));
        result.append(FeatureConsolidator.lengthPrefixBase64(minorSum));
        result.append(FeatureConsolidator.lengthPrefixBase64(serviceSum));
        if (longestQualifier > 0) {
            int[] qualifierSums = new int[longestQualifier];
            idx = 0;
            while (idx < numElements) {
                String qualifier = qualifiers[idx];
                if (qualifier != null) {
                    int top = qualifier.length();
                    int j = 0;
                    while (j < top) {
                        int n3 = j;
                        qualifierSums[n3] = qualifierSums[n3] + FeatureConsolidator.charValue(qualifier.charAt(j));
                        ++j;
                    }
                }
                ++idx;
            }
            int carry = 0;
            int k = longestQualifier - 1;
            while (k >= 1) {
                int n4 = k;
                qualifierSums[n4] = qualifierSums[n4] + carry;
                carry = qualifierSums[k] / 65;
                qualifierSums[k] = qualifierSums[k] % 65;
                --k;
            }
            qualifierSums[0] = qualifierSums[0] + carry;
            result.append(FeatureConsolidator.lengthPrefixBase64(qualifierSums[0]));
            int m = 1;
            while (m < longestQualifier) {
                FeatureConsolidator.appendEncodedCharacter(result, qualifierSums[m]);
                ++m;
            }
        }
        if (result.length() > this.m_maxVersionSuffixLength) {
            result.setLength(this.m_maxVersionSuffixLength);
        }
        int len = result.length();
        while (len > 0 && result.charAt(len - 1) == '-') {
            result.setLength(--len);
        }
        return result.toString();
    }

    private int getIntProperty(String property, int defaultValue) {
        int result = defaultValue;
        Object value = this.getProperties().get(property);
        if (value instanceof String) {
            try {
                result = Integer.parseInt((String)value);
                if (result < 1) {
                    result = defaultValue;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private ComponentIdentifier replaceFeatureReferenceVersion(String id, IFeatureChild ref) throws CoreException {
        OSGiVersion version = FeatureConsolidator.findBestVersion(this.m_featureVersions, id, "feature", ref.getId(), ref.getVersion());
        if (version != null) {
            String newVer = version.toString();
            if (!newVer.equals(ref.getVersion())) {
                ref.setVersion(newVer);
            }
            return new ComponentIdentifier(ref.getId(), "eclipse.feature", (IVersion)version);
        }
        return null;
    }

    private ComponentIdentifier replacePluginReferenceVersion(String id, IFeaturePlugin ref) throws CoreException {
        OSGiVersion version = FeatureConsolidator.findBestVersion(this.m_pluginVersions, id, "plugin", ref.getId(), ref.getVersion());
        if (version != null) {
            String newVer = version.toString();
            if (!newVer.equals(ref.getVersion())) {
                ref.setVersion(newVer);
            }
            return new ComponentIdentifier(ref.getId(), "osgi.bundle", (IVersion)version);
        }
        return null;
    }
}

