/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.pde.tasks.SAXModel;
import org.eclipse.buckminster.sax.ISaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNLPModel
extends SAXModel {
    private String m_codeBase = "$$codebase";
    private String m_description;
    private String m_href = "$$name";
    private boolean m_offLineAllowed = true;
    private Map<String, Resource> m_resourceById = new HashMap<String, Resource>();
    private Map<String, List<Resource>> m_resourcesByPlatform = new LinkedHashMap<String, List<Resource>>();
    private String m_specVersion = "1.5+";
    private String m_title;
    private String m_vendor;
    private String m_version;

    public Map<String, Resource> getResources() {
        return this.m_resourceById;
    }

    public void setCodeBase(String codeBase) {
        this.m_codeBase = codeBase;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setHref(String href) {
        this.m_href = href;
    }

    public void setOffLineAllowed(boolean offLineAllowed) {
        this.m_offLineAllowed = offLineAllowed;
    }

    public void setSpecVersion(String specVersion) {
        this.m_specVersion = specVersion;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setVendor(String vendor) {
        this.m_vendor = vendor;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        receiver.startDocument();
        AttributesImpl attrs = new AttributesImpl();
        if (this.m_specVersion != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"spec", (String)this.m_specVersion);
        }
        if (this.m_codeBase != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"codebase", (String)this.m_codeBase);
        }
        if (this.m_version != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"version", (String)this.m_version);
        }
        if (this.m_href != null) {
            Utils.addAttribute((AttributesImpl)attrs, (String)"href", (String)this.m_href);
        }
        JNLPModel.startElement(receiver, "jnlp", attrs);
        this.emitInformation(receiver);
        this.emitSecurity(receiver);
        JNLPModel.emitBooleanElement(receiver, "component-desc");
        this.emitResources(receiver);
        JNLPModel.endElement(receiver, "jnlp");
        receiver.endDocument();
    }

    Map<String, String> createResource(String id, String os, String arch, String tag) {
        Resource resource = new Resource(os, arch, tag);
        List<Resource> resources = this.m_resourcesByPlatform.get(resource.getKey());
        if (resources == null) {
            resources = new ArrayList<Resource>();
            this.m_resourcesByPlatform.put(resource.getKey(), resources);
        }
        resources.add(resource);
        if (id != null) {
            this.m_resourceById.put(id, resource);
        }
        return resource;
    }

    void emitInformation(ContentHandler receiver) throws SAXException {
        JNLPModel.startElement(receiver, "information");
        if (this.m_title != null) {
            JNLPModel.emitTextElement(receiver, "title", this.m_title);
        }
        if (this.m_vendor != null) {
            JNLPModel.emitTextElement(receiver, "vendor", this.m_vendor);
        }
        if (this.m_description != null) {
            JNLPModel.emitTextElement(receiver, "description", this.m_description);
        }
        if (this.m_offLineAllowed) {
            JNLPModel.emitBooleanElement(receiver, "offline-allowed");
        }
        JNLPModel.endElement(receiver, "information");
    }

    void emitResources(ContentHandler receiver) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        for (List<Resource> resourceList : this.m_resourcesByPlatform.values()) {
            int top = resourceList.size();
            if (top == 0) continue;
            Resource first = resourceList.get(0);
            if (first.getOs() != null) {
                Utils.addAttribute((AttributesImpl)attrs, (String)"os", (String)first.getOs());
            }
            if (first.getArch() != null) {
                Utils.addAttribute((AttributesImpl)attrs, (String)"arch", (String)first.getArch());
            }
            JNLPModel.startElement(receiver, "resources", attrs);
            int idx = 0;
            while (idx < top) {
                Resource resource = resourceList.get(idx);
                resource.toSax(receiver, null, null, resource.getDefaultTag());
                ++idx;
            }
            JNLPModel.endElement(receiver, "resources");
            attrs.clear();
        }
    }

    void emitSecurity(ContentHandler receiver) throws SAXException {
        JNLPModel.startElement(receiver, "security");
        JNLPModel.emitBooleanElement(receiver, "all-permissions");
        JNLPModel.endElement(receiver, "security");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Resource
    extends HashMap<String, String>
    implements ISaxableElement {
        private final String m_arch;
        private final String m_key;
        private final String m_os;
        private final String m_tag;

        Resource(String os, String arch, String tag) {
            this.m_os = os;
            this.m_arch = arch;
            this.m_tag = tag;
            StringBuilder bld = new StringBuilder();
            if (this.m_os != null) {
                bld.append(this.m_os);
            }
            bld.append('/');
            if (this.m_arch != null) {
                bld.append(this.m_arch);
            }
            this.m_key = bld.toString();
        }

        public String getArch() {
            return this.m_arch;
        }

        public String getDefaultTag() {
            return this.m_tag;
        }

        public String getKey() {
            return this.m_key;
        }

        public String getOs() {
            return this.m_os;
        }

        public void toSax(ContentHandler receiver, String namespace, String prefix, String localName) throws SAXException {
            AttributesImpl attrs = new AttributesImpl();
            for (Map.Entry attribute : this.entrySet()) {
                Utils.addAttribute((AttributesImpl)attrs, (String)((String)attribute.getKey()), (String)((String)attribute.getValue()));
            }
            JNLPModel.startElement(receiver, localName, attrs);
            JNLPModel.endElement(receiver, localName);
        }
    }
}

