/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.buckminster.pde.internal.FeatureModelReader;
import org.eclipse.buckminster.pde.tasks.JNLPGenerator;
import org.eclipse.buckminster.pde.tasks.JNLPModel;
import org.eclipse.buckminster.pde.tasks.JNLPVersionModel;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.osgi.framework.BundleException;
import org.xml.sax.SAXException;

public class JNLPSiteGenerator {
    private final HashMap<String, JNLPModel.Resource> m_jnlpResources = new HashMap();
    private final File m_directory;

    private static void emitFolderVersions(File folder, JNLPVersionModel folderVersions) throws CoreException {
        if (folderVersions == null) {
            return;
        }
        File versionsFile = new File(folder, "version.xml");
        BufferedOutputStream output = null;
        try {
            try {
                output = new BufferedOutputStream(new FileOutputStream(versionsFile));
                Utils.serialize((ISaxable)folderVersions, (OutputStream)output);
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
            catch (SAXException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(output);
            throw throwable;
        }
        IOUtils.close((Closeable)output);
    }

    public JNLPSiteGenerator(File directory) {
        this.m_directory = directory;
    }

    public void run() throws CoreException {
        try {
            JNLPVersionModel folderVersions = null;
            File featuresFolder = new File(this.m_directory, "features");
            File[] files = featuresFolder.listFiles();
            if (files == null) {
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                block30: {
                    IFeature feature;
                    block31: {
                        File file;
                        block34: {
                            file = fileArray[n2];
                            if (!file.isDirectory()) break block34;
                            File featureFile = new File(file, "feature.xml");
                            if (!featureFile.exists()) break block30;
                            BufferedInputStream input = null;
                            try {
                                input = new BufferedInputStream(new FileInputStream(featureFile));
                                IFeatureModel model = FeatureModelReader.readFeatureModel(input);
                                feature = model.getFeature();
                            }
                            catch (Throwable throwable) {
                                IOUtils.close(input);
                                throw throwable;
                            }
                            IOUtils.close((Closeable)input);
                            break block31;
                        }
                        String leafName = file.getName();
                        if (leafName.endsWith(".jar")) {
                            JarFile jarFile = null;
                            try {
                                jarFile = new JarFile(file);
                                JarEntry entry = jarFile.getJarEntry("feature.xml");
                                if (entry == null) break block30;
                                IFeatureModel model = FeatureModelReader.readFeatureModel(jarFile.getInputStream(entry));
                                feature = model.getFeature();
                                break block31;
                            }
                            finally {
                                if (jarFile != null) {
                                    jarFile.close();
                                }
                            }
                        }
                        break block30;
                    }
                    if (folderVersions == null) {
                        folderVersions = new JNLPVersionModel();
                    }
                    this.generateFromFeature(folderVersions, featuresFolder, feature);
                }
                ++n2;
            }
            File launcherJar = new File(this.m_directory, "startup.jar");
            if (launcherJar.exists()) {
                String version;
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(launcherJar);
                    Manifest mf = jarFile.getManifest();
                    version = mf.getMainAttributes().getValue("Bundle-Version");
                }
                finally {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                if (version == null) {
                    version = "0.1.0";
                }
                if (folderVersions == null) {
                    folderVersions = new JNLPVersionModel();
                }
                folderVersions.addResource("startup.jar", "startup.jar", version);
            }
            JNLPSiteGenerator.emitFolderVersions(this.m_directory, folderVersions);
            folderVersions = null;
            File pluginsFolder = new File(this.m_directory, "plugins");
            files = pluginsFolder.listFiles();
            if (files == null) {
                return;
            }
            File[] fileArray2 = files;
            int n3 = files.length;
            int n4 = 0;
            while (n4 < n3) {
                File file = fileArray2[n4];
                String leafName = file.getName();
                if (leafName.endsWith(".jar")) {
                    JarFile jarFile = null;
                    try {
                        jarFile = new JarFile(file);
                        Manifest mf = jarFile.getManifest();
                        String symbolicName = mf.getMainAttributes().getValue("Bundle-SymbolicName");
                        if (symbolicName != null) {
                            if (folderVersions == null) {
                                folderVersions = new JNLPVersionModel();
                            }
                            this.generateFromBundle(folderVersions, leafName, mf);
                        }
                    }
                    finally {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                }
                ++n4;
            }
            JNLPSiteGenerator.emitFolderVersions(pluginsFolder, folderVersions);
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    private void generateFromBundle(JNLPVersionModel folderVersions, String file, Manifest mf) throws CoreException {
        String id;
        Attributes a = mf.getMainAttributes();
        try {
            ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)a.getValue("Bundle-SymbolicName"));
            id = elements[0].getValue();
        }
        catch (BundleException be) {
            throw BuckminsterException.wrap((Throwable)be);
        }
        String version = a.getValue("Bundle-Version");
        if (version == null) {
            version = "0.0.0";
        }
        folderVersions.addResource(file, String.valueOf(id) + ".jar", version);
    }

    private void generateFromFeature(JNLPVersionModel folderVersions, File featuresFolder, IFeature feature) throws CoreException {
        String arch;
        String id = feature.getId();
        String version = feature.getVersion();
        String file = String.valueOf(id) + '_' + version + ".jnlp";
        JNLPVersionModel.Resource resource = folderVersions.addResource(file, String.valueOf(id) + ".jnlp", version);
        String os = feature.getOS();
        if (os == null) {
            os = feature.getWS();
        }
        if ((os = JNLPGenerator.convertOS(os)) != null) {
            resource.addOs(os);
        }
        if ((arch = JNLPGenerator.convertArch(feature.getArch())) != null) {
            resource.addArch(arch);
        }
        JNLPGenerator jnlpGen = new JNLPGenerator(feature);
        JNLPModel jnlp = jnlpGen.generateJNLP();
        this.m_jnlpResources.putAll(jnlp.getResources());
        File jnlpFile = new File(featuresFolder.getParentFile(), file);
        BufferedOutputStream jnlpOut = null;
        try {
            try {
                jnlpOut = new BufferedOutputStream(new FileOutputStream(jnlpFile));
                Utils.serialize((ISaxable)jnlp, (OutputStream)jnlpOut);
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
            catch (SAXException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(jnlpOut);
            throw throwable;
        }
        IOUtils.close((Closeable)jnlpOut);
    }
}

