/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.buckminster.pde.tasks.SAXModel;
import org.eclipse.buckminster.sax.ISaxableElement;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNLPVersionModel
extends SAXModel {
    private final ArrayList<Resource> m_resources = new ArrayList();

    private static void emitTextElements(ContentHandler receiver, String tag, List<String> values) throws SAXException {
        if (values != null) {
            for (String value : values) {
                JNLPVersionModel.emitTextElement(receiver, tag, value);
            }
        }
    }

    public Platform addPlatform(String file, String name, String versionId, String productVersionId) {
        Platform platform = new Platform(file, name, versionId, productVersionId);
        this.m_resources.add(platform);
        return platform;
    }

    public Resource addResource(String file, String name, String versionId) {
        Resource resource = new Resource(file, name, versionId);
        this.m_resources.add(resource);
        return resource;
    }

    public void toSax(ContentHandler receiver) throws SAXException {
        receiver.startDocument();
        JNLPVersionModel.startElement(receiver, "jnlp-versions");
        for (Resource resource : this.m_resources) {
            resource.toSax(receiver, null, null, resource.getDefaultTag());
        }
        JNLPVersionModel.endElement(receiver, "jnlp-versions");
        receiver.endDocument();
    }

    public static class Platform
    extends Resource {
        private final String m_productVersionId;

        Platform(String file, String name, String versionId, String productVersionId) {
            super(file, name, versionId);
            this.m_productVersionId = productVersionId;
        }

        public String getDefaultTag() {
            return "platform";
        }

        void emitContent(ContentHandler receiver) throws SAXException {
            super.emitContent(receiver);
            JNLPVersionModel.emitTextElement(receiver, "product-version-id", this.m_productVersionId);
        }
    }

    public static class Resource
    implements ISaxableElement {
        private final String m_name;
        private final String m_file;
        private final String m_versionId;
        private List<String> m_oss;
        private List<String> m_archs;
        private List<String> m_locales;

        Resource(String file, String name, String versionId) {
            this.m_file = file;
            this.m_name = name;
            this.m_versionId = versionId;
        }

        public void addArch(String arch) {
            if (this.m_archs == null) {
                this.m_archs = new ArrayList<String>();
            }
            this.m_archs.add(arch);
        }

        public void addLocale(String locale) {
            if (this.m_locales == null) {
                this.m_locales = new ArrayList<String>();
            }
            this.m_locales.add(locale);
        }

        public void addOs(String os) {
            if (this.m_oss == null) {
                this.m_oss = new ArrayList<String>();
            }
            this.m_oss.add(os);
        }

        public String getDefaultTag() {
            return "resource";
        }

        public void toSax(ContentHandler receiver, String namespace, String prefix, String localName) throws SAXException {
            JNLPVersionModel.startElement(receiver, localName);
            this.emitContent(receiver);
            JNLPVersionModel.endElement(receiver, localName);
        }

        void emitContent(ContentHandler receiver) throws SAXException {
            JNLPVersionModel.startElement(receiver, "pattern");
            JNLPVersionModel.emitTextElement(receiver, "name", this.m_name);
            JNLPVersionModel.emitTextElement(receiver, "version-id", this.m_versionId);
            JNLPVersionModel.emitTextElements(receiver, "os", this.m_oss);
            JNLPVersionModel.emitTextElements(receiver, "arch", this.m_archs);
            JNLPVersionModel.emitTextElements(receiver, "locale", this.m_locales);
            JNLPVersionModel.endElement(receiver, "pattern");
            JNLPVersionModel.emitTextElement(receiver, "file", this.m_file);
        }
    }
}

