/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.buckminster.pde.IPDEConstants;
import org.eclipse.buckminster.pde.internal.FeatureModelReader;
import org.eclipse.buckminster.pde.internal.model.EditableFeatureModel;
import org.eclipse.buckminster.pde.internal.model.ExternalBundleModel;
import org.eclipse.buckminster.pde.tasks.FeatureConsolidator;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.core.bundle.BundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.feature.FeatureChild;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFeatureCreator
implements IPDEConstants,
IBuildPropertiesConstants {
    private static final String FEATURE_SUFFIX = ".feature";
    private static final String SOURCE_SUFFIX = ".source";
    private final File m_inputFile;
    private final File m_outputFile;
    private List<File> m_featuresAndBundles;

    public SourceFeatureCreator(File inputFile, File outputFile, List<File> featuresAndBundles) {
        this.m_inputFile = inputFile;
        this.m_outputFile = outputFile;
        this.m_featuresAndBundles = featuresAndBundles;
    }

    public void run() throws CoreException, FileNotFoundException {
        IFeature originalFeature = FeatureModelReader.readEditableFeatureModel(this.m_inputFile).getFeature();
        EditableFeatureModel featureModel = new EditableFeatureModel(this.m_outputFile);
        featureModel.setDirty(true);
        IFeature sourceFeature = featureModel.getFeature();
        String originalId = originalFeature.getId();
        StringBuilder sourceIdBld = new StringBuilder();
        if (originalId.endsWith(FEATURE_SUFFIX)) {
            sourceIdBld.append(originalId, 0, originalId.length() - FEATURE_SUFFIX.length());
            sourceIdBld.append(SOURCE_SUFFIX);
            sourceIdBld.append(FEATURE_SUFFIX);
        } else {
            sourceIdBld.append(originalId);
            sourceIdBld.append(SOURCE_SUFFIX);
        }
        sourceFeature.setId(sourceIdBld.toString());
        sourceFeature.setVersion(originalFeature.getVersion());
        sourceFeature.setLabel("Source bundles for " + originalFeature.getLabel());
        sourceFeature.setOS(originalFeature.getOS());
        sourceFeature.setArch(originalFeature.getArch());
        sourceFeature.setWS(originalFeature.getWS());
        sourceFeature.setNL(originalFeature.getNL());
        sourceFeature.setProviderName(originalFeature.getProviderName());
        sourceFeature.setURL(originalFeature.getURL());
        for (File featureOrBundle : this.m_featuresAndBundles) {
            Object model2;
            InputStream input = null;
            try {
                input = FeatureConsolidator.getInput(featureOrBundle, "feature.xml");
                model2 = FeatureModelReader.readFeatureModel(input);
                IFeature feature = model2.getFeature();
                FeatureChild fc = new FeatureChild();
                fc.loadFrom(model2.getFeature());
                fc.setModel((IFeatureModel)featureModel);
                fc.setArch(feature.getArch());
                fc.setOS(feature.getOS());
                fc.setWS(feature.getWS());
                fc.setNL(feature.getNL());
                fc.setLabel(feature.getLabel());
                sourceFeature.addIncludedFeatures(new IFeatureChild[]{fc});
            }
            catch (FileNotFoundException model2) {
                try {
                    input = FeatureConsolidator.getInput(featureOrBundle, "META-INF/MANIFEST.MF");
                    model2 = new ExternalBundleModel();
                    model2.load(input, true);
                    BundleFragmentModel bmodel = model2.isFragmentModel() ? new BundleFragmentModel() : new BundlePluginModel();
                    bmodel.setEnabled(true);
                    bmodel.setBundleModel((IBundleModel)model2);
                    FeaturePlugin fp = new FeaturePlugin();
                    IPluginBase plugin = bmodel.getPluginBase();
                    fp.loadFrom(plugin);
                    fp.setModel((IFeatureModel)featureModel);
                    fp.setUnpack(false);
                    String ver = plugin.getVersion();
                    String id = plugin.getId();
                    if (id.endsWith(SOURCE_SUFFIX)) {
                        String origId = id.substring(0, id.length() - SOURCE_SUFFIX.length());
                        IFeaturePlugin[] iFeaturePluginArray = originalFeature.getPlugins();
                        int n = iFeaturePluginArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFeaturePlugin originalPlugin = iFeaturePluginArray[n2];
                            if (originalPlugin.getId().equals(origId) && originalPlugin.getVersion().equals(ver)) {
                                fp.setArch(originalPlugin.getArch());
                                fp.setOS(originalPlugin.getOS());
                                fp.setWS(originalPlugin.getWS());
                                fp.setNL(originalPlugin.getNL());
                                break;
                            }
                            ++n2;
                        }
                    }
                    sourceFeature.addPlugins(new IFeaturePlugin[]{fp});
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            finally {
                IOUtils.close((Closeable)input);
            }
        }
        featureModel.save();
    }
}

