/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.pde.tasks;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.buckminster.core.actor.AbstractActor;
import org.eclipse.buckminster.core.actor.IActionContext;
import org.eclipse.buckminster.core.cspec.IGroup;
import org.eclipse.buckminster.core.cspec.IPrerequisite;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.ComponentIdentifier;
import org.eclipse.buckminster.core.site.SaxableSite;
import org.eclipse.buckminster.core.site.SiteReader;
import org.eclipse.buckminster.core.version.IVersion;
import org.eclipse.buckminster.core.version.IVersionType;
import org.eclipse.buckminster.core.version.VersionFactory;
import org.eclipse.buckminster.pde.internal.FeatureModelReader;
import org.eclipse.buckminster.pde.tasks.VersionConsolidator;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.sax.ISaxable;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.ExtendedSite;
import org.eclipse.update.internal.core.UpdateSiteFeatureReference;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSiteGenerator
extends VersionConsolidator {
    private final List<File> m_features;
    private final IActionContext m_actionContext;
    private final SaxableSite m_saxableSite;

    private static boolean categoryExists(CategoryModel[] categories, String categoryName) {
        int idx = categories.length;
        while (--idx >= 0) {
            if (!categories[idx].getName().equals(categoryName)) continue;
            return true;
        }
        return false;
    }

    public UpdateSiteGenerator(List<File> features, File template, File outputFile, File propertiesFile, String qualifier) throws CoreException, IOException {
        super(outputFile, propertiesFile, qualifier);
        this.m_features = features;
        this.m_actionContext = AbstractActor.getActiveContext();
        this.m_saxableSite = template != null ? SiteReader.getSite((File)template) : new SaxableSite((Site)new ExtendedSite());
    }

    public IVersion run(boolean generateQualifier) throws CoreException {
        BufferedOutputStream output = null;
        try {
            File outputFile;
            CSpec cspec = this.m_actionContext.getCSpec();
            IVersionType osgiType = VersionFactory.OSGiType;
            ArrayList<ComponentIdentifier> deps = null;
            if (generateQualifier) {
                deps = new ArrayList<ComponentIdentifier>();
            }
            if ((outputFile = this.getOutputFile()) != null) {
                output = new BufferedOutputStream(new FileOutputStream(outputFile));
            } else if (!generateQualifier) {
                return null;
            }
            for (File file : this.m_features) {
                String leafName = file.getName();
                if (!leafName.endsWith(".jar")) continue;
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(file);
                    JarEntry entry = jarFile.getJarEntry("feature.xml");
                    if (entry == null) continue;
                    IFeatureModel model = FeatureModelReader.readFeatureModel(jarFile.getInputStream(entry));
                    IFeature feature = model.getFeature();
                    if (outputFile != null) {
                        this.generateFromFeature(cspec, file, feature);
                    }
                    if (!generateQualifier) continue;
                    deps.add(new ComponentIdentifier(feature.getId(), "eclipse.feature", osgiType.fromString(feature.getVersion())));
                }
                finally {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
            }
            if (outputFile != null) {
                Utils.serialize((ISaxable)this.m_saxableSite, (OutputStream)output);
            }
            ComponentIdentifier ci = cspec.getComponentIdentifier();
            IVersion iVersion = generateQualifier ? this.replaceQualifier(cspec.getComponentIdentifier(), deps) : ci.getVersion();
            IOUtils.close((Closeable)output);
            return iVersion;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        catch (SAXException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            IOUtils.close(output);
        }
    }

    private void generateFromFeature(CSpec cspec, File file, IFeature feature) throws CoreException {
        IVersionType osgiType = VersionFactory.OSGiType;
        String featureName = feature.getId();
        StringBuilder urlBuilder = new StringBuilder("features");
        urlBuilder.append('/');
        urlBuilder.append(file.getName());
        String verStr = feature.getVersion();
        if (verStr == null || verStr.length() == 0) {
            verStr = "0.0.0";
        }
        UpdateSiteFeatureReference model = null;
        Site site = this.m_saxableSite.getSite();
        SiteFeatureReferenceModel[] siteFeatureReferenceModelArray = site.getFeatureReferenceModels();
        int n = siteFeatureReferenceModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            SiteFeatureReferenceModel oldModel = siteFeatureReferenceModelArray[n2];
            if (featureName.equals(oldModel.getFeatureIdentifier())) {
                IVersion oldVer = osgiType.fromString(oldModel.getFeatureVersion());
                IVersion ver = osgiType.fromString(verStr);
                if (ver.equalsUnqualified(oldVer)) {
                    model = oldModel;
                    break;
                }
            }
            ++n2;
        }
        if (model == null) {
            CategoryModel[] categories = site.getCategoryModels();
            Collection attributes = cspec.getAttributes().values();
            model = new UpdateSiteFeatureReference();
            model.setFeatureIdentifier(featureName);
            block1: for (Attribute attr : attributes) {
                if (!(attr instanceof IGroup)) continue;
                String categoryName = attr.getName();
                if (!UpdateSiteGenerator.categoryExists(categories, attr.getName())) continue;
                for (IPrerequisite included : attr.getPrerequisites()) {
                    if (!featureName.equals(included.getComponentName())) continue;
                    model.addCategoryName(categoryName);
                    continue block1;
                }
            }
            site.addFeatureReferenceModel((SiteFeatureReferenceModel)model);
        }
        model.setURLString(urlBuilder.toString());
        model.setFeatureVersion(verStr);
        model.setSiteModel((SiteModel)site);
    }
}

