/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.engine.ProfileParser;
import org.eclipse.equinox.internal.p2.engine.ProfileWriter;
import org.eclipse.equinox.internal.p2.engine.ProfileXMLConstants;
import org.eclipse.equinox.internal.p2.engine.SurrogateProfileHandler;
import org.eclipse.equinox.internal.p2.persistence.XMLParser;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.ISurrogateProfileHandler;
import org.eclipse.equinox.internal.provisional.p2.engine.ProfileEvent;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimpleProfileRegistry
implements IProfileRegistry {
    private static final String PROFILE_EXT = ".profile";
    public static final String DEFAULT_STORAGE_DIR = "profileRegistry";
    private SoftReference profiles;
    private Map profileLocks = new HashMap();
    private String self;
    private boolean updateSelfProfile = true;
    private File store;
    ISurrogateProfileHandler surrogateProfileHandler;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public SimpleProfileRegistry(File registryDirectory, ISurrogateProfileHandler handler, boolean updateSelfProfile) {
        this.store = registryDirectory != null ? registryDirectory : SimpleProfileRegistry.getDefaultRegistryDirectory();
        this.surrogateProfileHandler = handler;
        this.self = EngineActivator.getContext().getProperty("eclipse.p2.profile");
        this.updateSelfProfile = updateSelfProfile;
    }

    public SimpleProfileRegistry() {
        this.store = SimpleProfileRegistry.getDefaultRegistryDirectory();
        this.surrogateProfileHandler = new SurrogateProfileHandler();
        this.self = EngineActivator.getContext().getProperty("eclipse.p2.profile");
    }

    private static File getDefaultRegistryDirectory() {
        File registryDirectory = null;
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AgentLocation agent = (AgentLocation)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        try {
            URL registryURL = new URL(agent.getDataArea("org.eclipse.equinox.p2.engine"), DEFAULT_STORAGE_DIR);
            registryDirectory = new File(registryURL.getPath());
            registryDirectory.mkdirs();
        }
        catch (MalformedURLException malformedURLException) {}
        return registryDirectory;
    }

    private void updateSelfProfile(Map profileMap) {
        if (profileMap == null) {
            return;
        }
        Profile selfProfile = (Profile)profileMap.get(this.self);
        if (selfProfile == null) {
            return;
        }
        boolean changed = false;
        if (Boolean.valueOf(selfProfile.getProperty("org.eclipse.equinox.p2.roaming")).booleanValue()) {
            changed = this.updateRoamingProfile(selfProfile);
        }
        if (this.surrogateProfileHandler != null && this.surrogateProfileHandler.isSurrogate(selfProfile)) {
            boolean bl = changed = changed || this.surrogateProfileHandler.updateProfile(selfProfile);
        }
        if (changed) {
            this.saveProfile(selfProfile);
        }
    }

    private boolean updateRoamingProfile(Profile selfProfile) {
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.osgi.service.datalocation.Location");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Location installLocation = (Location)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), (String)Location.INSTALL_FILTER);
        File location = new File(installLocation.getURL().getPath());
        boolean changed = false;
        if (!location.equals(new File(selfProfile.getProperty("org.eclipse.equinox.p2.installFolder")))) {
            selfProfile.setProperty("org.eclipse.equinox.p2.installFolder", location.getAbsolutePath());
            changed = true;
        }
        if (!location.equals(new File(selfProfile.getProperty("org.eclipse.equinox.p2.cache")))) {
            selfProfile.setProperty("org.eclipse.equinox.p2.cache", location.getAbsolutePath());
            changed = true;
        }
        return changed;
    }

    public synchronized String toString() {
        return this.getProfileMap().toString();
    }

    public synchronized IProfile getProfile(String id) {
        Profile profile = this.internalGetProfile(id);
        if (profile == null) {
            return null;
        }
        return profile.snapshot();
    }

    private Profile internalGetProfile(String id) {
        Profile profile;
        if ("_SELF_".equals(id)) {
            id = this.self;
        }
        if ((profile = (Profile)this.getProfileMap().get(id)) == null && this.self != null && this.self.equals(id)) {
            profile = this.createSurrogateProfile(id);
        }
        return profile;
    }

    private Profile createSurrogateProfile(String id) {
        if (this.surrogateProfileHandler == null) {
            return null;
        }
        Profile profile = this.surrogateProfileHandler.createProfile(id);
        if (profile == null) {
            return null;
        }
        this.saveProfile(profile);
        this.profiles = null;
        this.updateSelfProfile = true;
        return (Profile)this.getProfileMap().get(id);
    }

    public synchronized IProfile[] getProfiles() {
        Map profileMap = this.getProfileMap();
        IProfile[] result = new Profile[profileMap.size()];
        int i = 0;
        Iterator it = profileMap.values().iterator();
        while (it.hasNext()) {
            Profile profile = (Profile)it.next();
            result[i] = profile.snapshot();
            ++i;
        }
        return result;
    }

    protected Map getProfileMap() {
        LinkedHashMap result;
        if (this.profiles != null && (result = (Map)this.profiles.get()) != null) {
            return result;
        }
        result = this.restore();
        if (result == null) {
            result = new LinkedHashMap(8);
        }
        this.profiles = new SoftReference(result);
        if (this.updateSelfProfile) {
            this.updateSelfProfile = false;
            this.updateSelfProfile(result);
        }
        return result;
    }

    public synchronized void updateProfile(Profile profile) {
        String id = profile.getProfileId();
        Profile current = this.internalGetProfile(id);
        if (current == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.profile_does_not_exist, (Object)id));
        }
        Lock lock = (Lock)this.profileLocks.get(id);
        lock.checkLocked();
        current.clearLocalProperties();
        current.clearInstallableUnits();
        current.addProperties(profile.getLocalProperties());
        Collector collector = profile.query((Query)InstallableUnitQuery.ANY, new Collector(), null);
        Iterator collectorIt = collector.iterator();
        while (collectorIt.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)collectorIt.next();
            current.addInstallableUnit(iu);
            Map iuProperties = profile.getInstallableUnitProperties(iu);
            if (iuProperties == null) continue;
            current.addInstallableUnitProperties(iu, iuProperties);
        }
        this.saveProfile(current);
        profile.setTimestamp(current.getTimestamp());
        this.broadcastChangeEvent(id, (byte)2);
    }

    public IProfile addProfile(String id) throws ProvisionException {
        return this.addProfile(id, null, null);
    }

    public IProfile addProfile(String id, Map profileProperties) throws ProvisionException {
        return this.addProfile(id, profileProperties, null);
    }

    public synchronized IProfile addProfile(String id, Map profileProperties, String parentId) throws ProvisionException {
        Map profileMap;
        if ("_SELF_".equals(id)) {
            id = this.self;
        }
        if ((profileMap = this.getProfileMap()).get(id) != null) {
            throw new ProvisionException(NLS.bind((String)Messages.Profile_Duplicate_Root_Profile_Id, (Object)id));
        }
        Profile parent = null;
        if (parentId != null) {
            if ("_SELF_".equals(parentId)) {
                parentId = this.self;
            }
            if ((parent = (Profile)profileMap.get(parentId)) == null) {
                throw new ProvisionException(NLS.bind((String)Messages.Profile_Parent_Not_Found, (Object)parentId));
            }
        }
        Profile profile = new Profile(id, parent, profileProperties);
        if (this.surrogateProfileHandler != null && this.surrogateProfileHandler.isSurrogate(profile)) {
            profile.setSurrogateProfileHandler(this.surrogateProfileHandler);
        }
        profileMap.put(id, profile);
        this.saveProfile(profile);
        this.broadcastChangeEvent(id, (byte)0);
        return profile.snapshot();
    }

    public synchronized void removeProfile(String profileId) {
        Map profileMap;
        Profile profile;
        if ("_SELF_".equals(profileId)) {
            profileId = this.self;
        }
        if ((profile = (Profile)(profileMap = this.getProfileMap()).get(profileId)) == null) {
            return;
        }
        String[] subProfileIds = profile.getSubProfileIds();
        int i = 0;
        while (i < subProfileIds.length) {
            this.removeProfile(subProfileIds[i]);
            ++i;
        }
        this.internalLockProfile(profile);
        try {
            profile.setParent(null);
        }
        finally {
            this.internalUnlockProfile(profile);
        }
        profileMap.remove(profileId);
        this.profileLocks.remove(profileId);
        this.deleteProfile(profileId);
        this.broadcastChangeEvent(profileId, (byte)1);
    }

    private void broadcastChangeEvent(String profileId, byte reason) {
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ((IProvisioningEventBus)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())).publishEvent((EventObject)new ProfileEvent(profileId, reason));
    }

    private Map restore() {
        if (this.store == null || !this.store.isDirectory()) {
            throw new IllegalStateException(Messages.reg_dir_not_available);
        }
        Parser parser = new Parser(EngineActivator.getContext(), "org.eclipse.equinox.p2.engine");
        File[] profileDirectories = this.store.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(SimpleProfileRegistry.PROFILE_EXT) && pathname.isDirectory();
            }
        });
        int i = 0;
        while (i < profileDirectories.length) {
            File profileFile = this.findLatestProfileFile(profileDirectories[i]);
            if (profileFile != null) {
                try {
                    parser.parse(profileFile);
                }
                catch (IOException e) {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.error_parsing_profile, (Object)profileFile), (Throwable)e));
                }
            }
            ++i;
        }
        return parser.getProfileMap();
    }

    private File findLatestProfileFile(File profileDirectory) {
        File latest = null;
        long latestTimestamp = 0L;
        File[] profileFiles = profileDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(SimpleProfileRegistry.PROFILE_EXT) && !pathname.isDirectory();
            }
        });
        int i = 0;
        while (i < profileFiles.length) {
            File profileFile = profileFiles[i];
            String fileName = profileFile.getName();
            try {
                long timestamp = Long.parseLong(fileName.substring(0, fileName.indexOf(PROFILE_EXT)));
                if (timestamp > latestTimestamp) {
                    latestTimestamp = timestamp;
                    latest = profileFile;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            ++i;
        }
        return latest;
    }

    private void saveProfile(Profile profile) {
        block14: {
            File profileDirectory = new File(this.store, String.valueOf(SimpleProfileRegistry.escape(profile.getProfileId())) + PROFILE_EXT);
            profileDirectory.mkdir();
            long previousTimestamp = profile.getTimestamp();
            long currentTimestamp = System.currentTimeMillis();
            File profileFile = new File(profileDirectory, String.valueOf(Long.toString(currentTimestamp)) + PROFILE_EXT);
            profile.setTimestamp(currentTimestamp);
            profile.setChanged(false);
            OutputStream os = null;
            try {
                try {
                    os = new BufferedOutputStream(new FileOutputStream(profileFile));
                    Writer writer = new Writer(os);
                    writer.writeProfile(profile);
                }
                catch (IOException e) {
                    profile.setTimestamp(previousTimestamp);
                    profileFile.delete();
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.error_persisting_profile, (Object)profile.getProfileId()), (Throwable)e));
                    try {
                        if (os != null) {
                            os.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void deleteProfile(String profileId) {
        File profileDirectory = new File(this.store, String.valueOf(SimpleProfileRegistry.escape(profileId)) + PROFILE_EXT);
        FileUtils.deleteAll((File)profileDirectory);
    }

    private static String escape(String toEscape) {
        StringBuffer buffer = new StringBuffer();
        int length = toEscape.length();
        int i = 0;
        while (i < length) {
            char ch = toEscape.charAt(i);
            switch (ch) {
                case '\"': 
                case '%': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    buffer.append("%" + ch + ";");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public synchronized void lockProfile(Profile profile) {
        Profile internalProfile = this.internalGetProfile(profile.getProfileId());
        if (internalProfile == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.profile_not_registered, (Object)profile.getProfileId()));
        }
        if (profile.isChanged() || !this.checkTimestamps(profile, internalProfile)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.profile_not_current, (Object)profile.getProfileId()));
        }
        this.internalLockProfile(internalProfile);
    }

    private void internalLockProfile(IProfile profile) {
        Lock lock = (Lock)this.profileLocks.get(profile.getProfileId());
        if (lock == null) {
            lock = new Lock();
            this.profileLocks.put(profile.getProfileId(), lock);
        }
        lock.lock(this);
        if (profile.getParentProfile() != null) {
            this.internalLockProfile(profile.getParentProfile());
        }
    }

    private boolean checkTimestamps(IProfile profile, IProfile internalProfile) {
        if (profile.getTimestamp() == internalProfile.getTimestamp()) {
            if (profile.getParentProfile() == null) {
                return true;
            }
            return this.checkTimestamps(profile.getParentProfile(), internalProfile.getParentProfile());
        }
        return false;
    }

    public synchronized void unlockProfile(IProfile profile) {
        Profile internalProfile = this.internalGetProfile(profile.getProfileId());
        if (internalProfile == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.profile_not_registered, (Object)profile.getProfileId()));
        }
        this.internalUnlockProfile(internalProfile);
    }

    private void internalUnlockProfile(IProfile profile) {
        if (profile.getParentProfile() != null) {
            this.internalUnlockProfile(profile.getParentProfile());
        }
        Lock lock = (Lock)this.profileLocks.get(profile.getProfileId());
        lock.unlock(this);
    }

    static class Lock {
        private Thread lockHolder;
        private int lockedCount;

        Lock() {
        }

        /*
         * Exception decompiling
         */
        protected void lock(Object monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected void unlock(Object monitor) {
            Thread current = Thread.currentThread();
            if (this.lockHolder != current) {
                throw new IllegalStateException(Messages.thread_not_owner);
            }
            --this.lockedCount;
            if (this.lockedCount == 0) {
                this.lockHolder = null;
                monitor.notifyAll();
            }
        }

        protected synchronized void checkLocked() {
            Thread current = Thread.currentThread();
            if (this.lockHolder != current) {
                throw new IllegalStateException(Messages.thread_not_owner);
            }
        }
    }

    class Parser
    extends ProfileParser {
        private final Map profileHandlers = new HashMap();

        public Parser(BundleContext context, String bundleId) {
            super(context, bundleId);
        }

        public void parse(File file) throws IOException {
            this.parse(new BufferedInputStream(new FileInputStream(file)));
        }

        public synchronized void parse(InputStream stream) throws IOException {
            this.status = null;
            try {
                try {
                    this.getParser();
                    ProfileParser.ProfileHandler profileHandler = new ProfileParser.ProfileHandler();
                    this.xmlReader.setContentHandler((ContentHandler)((Object)new ProfileDocHandler("profile", profileHandler)));
                    this.xmlReader.parse(new InputSource(stream));
                    this.profileHandlers.put(profileHandler.getProfileId(), profileHandler);
                }
                catch (SAXException e) {
                    throw new IOException(e.getMessage());
                }
                catch (ParserConfigurationException e) {
                    throw new IOException(e.getMessage());
                }
            }
            finally {
                stream.close();
            }
        }

        protected Object getRootObject() {
            return this;
        }

        public Map getProfileMap() {
            HashMap profileMap = new HashMap();
            Iterator it = this.profileHandlers.keySet().iterator();
            while (it.hasNext()) {
                String profileId = (String)it.next();
                this.addProfile(profileId, profileMap);
            }
            return profileMap;
        }

        private void addProfile(String profileId, Map profileMap) {
            if (profileMap.containsKey(profileId)) {
                return;
            }
            ProfileParser.ProfileHandler profileHandler = (ProfileParser.ProfileHandler)((Object)this.profileHandlers.get(profileId));
            Profile parentProfile = null;
            String parentId = profileHandler.getParentId();
            if (parentId != null) {
                this.addProfile(parentId, profileMap);
                parentProfile = (Profile)profileMap.get(parentId);
            }
            Profile profile = new Profile(profileId, parentProfile, profileHandler.getProperties());
            if (SimpleProfileRegistry.this.surrogateProfileHandler != null && SimpleProfileRegistry.this.surrogateProfileHandler.isSurrogate(profile)) {
                profile.setSurrogateProfileHandler(SimpleProfileRegistry.this.surrogateProfileHandler);
            }
            profile.setTimestamp(profileHandler.getTimestamp());
            IInstallableUnit[] ius = profileHandler.getInstallableUnits();
            if (ius != null) {
                int i = 0;
                while (i < ius.length) {
                    IInstallableUnit iu = ius[i];
                    profile.addInstallableUnit(iu);
                    Map iuProperties = profileHandler.getIUProperties(iu);
                    if (iuProperties != null) {
                        Iterator it = iuProperties.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            String key = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            profile.setInstallableUnitProperty(iu, key, value);
                        }
                    }
                    ++i;
                }
            }
            profile.setChanged(false);
            profileMap.put(profileId, profile);
        }

        protected String getErrorMessage() {
            return Messages.SimpleProfileRegistry_Parser_Error_Parsing_Registry;
        }

        public String toString() {
            return null;
        }

        private final class ProfileDocHandler
        extends XMLParser.DocHandler {
            public ProfileDocHandler(String rootName, XMLParser.RootHandler rootHandler) {
                super((XMLParser)Parser.this, rootName, rootHandler);
            }

            public void processingInstruction(String target, String data) throws SAXException {
                Version repositoryVersion;
                if ("profile".equals(target) && !ProfileXMLConstants.XML_TOLERANCE.isIncluded(repositoryVersion = Parser.this.extractPIVersion(target, data))) {
                    throw new SAXException(NLS.bind((String)Messages.SimpleProfileRegistry_Parser_Has_Incompatible_Version, (Object)repositoryVersion, (Object)ProfileXMLConstants.XML_TOLERANCE));
                }
            }
        }
    }

    static class Writer
    extends ProfileWriter {
        public Writer(OutputStream output) throws IOException {
            XMLWriter.ProcessingInstruction[] processingInstructionArray = new XMLWriter.ProcessingInstruction[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.p2.engine.Profile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            processingInstructionArray[0] = XMLWriter.ProcessingInstruction.makeClassVersionInstruction((String)"profile", (Class)clazz, (Version)ProfileXMLConstants.CURRENT_VERSION);
            super(output, processingInstructionArray);
        }
    }
}

