/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.engine;

import java.util.EventObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.engine.BeginOperationEvent;
import org.eclipse.equinox.internal.provisional.p2.engine.CommitOperationEvent;
import org.eclipse.equinox.internal.provisional.p2.engine.EngineSession;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.Messages;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.engine.RollbackOperationEvent;
import org.osgi.framework.BundleContext;

public class Engine
implements IEngine {
    private final IProvisioningEventBus eventBus;
    static /* synthetic */ Class class$0;

    public Engine(IProvisioningEventBus eventBus) {
        this.eventBus = eventBus;
    }

    public IStatus perform(IProfile iprofile, PhaseSet phaseSet, Operand[] operands, ProvisioningContext context, IProgressMonitor monitor) {
        if (iprofile == null) {
            throw new IllegalArgumentException(Messages.null_profile);
        }
        if (phaseSet == null) {
            throw new IllegalArgumentException(Messages.null_phaseset);
        }
        if (operands == null) {
            throw new IllegalArgumentException(Messages.null_operands);
        }
        if (context == null) {
            context = new ProvisioningContext();
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        Profile profile = (Profile)iprofile;
        BundleContext bundleContext = EngineActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SimpleProfileRegistry profileRegistry = (SimpleProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        profileRegistry.lockProfile(profile);
        try {
            this.eventBus.publishEvent((EventObject)new BeginOperationEvent(profile, phaseSet, operands, this));
            EngineSession session = new EngineSession(profile, context);
            MultiStatus result = phaseSet.perform(session, profile, operands, context, monitor);
            if (result.matches(12)) {
                this.eventBus.publishEvent((EventObject)new RollbackOperationEvent(profile, phaseSet, operands, this, (IStatus)result));
                session.rollback();
            } else {
                if (profile.isChanged()) {
                    profileRegistry.updateProfile(profile);
                }
                this.eventBus.publishEvent((EventObject)new CommitOperationEvent(profile, phaseSet, operands, this));
                session.commit();
            }
            IStatus[] children = result.getChildren();
            MultiStatus multiStatus = children.length == 1 ? children[0] : result;
            return multiStatus;
        }
        finally {
            profileRegistry.unlockProfile(profile);
            profile.setChanged(false);
        }
    }
}

