/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository.io;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.repository.io.XMLConstants;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.internal.provisional.p2.metadata.Copyright;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.internal.provisional.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.internal.provisional.p2.metadata.License;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequirementChange;
import org.eclipse.equinox.internal.provisional.p2.metadata.TouchpointData;
import org.eclipse.equinox.internal.provisional.p2.metadata.TouchpointType;

public abstract class MetadataWriter
extends XMLWriter
implements XMLConstants {
    public MetadataWriter(OutputStream output, XMLWriter.ProcessingInstruction[] piElements) throws UnsupportedEncodingException {
        super(output, piElements);
    }

    protected void writeInstallableUnits(Iterator units, int size) {
        if (size == 0) {
            return;
        }
        this.start("units");
        this.attribute("size", size);
        while (units.hasNext()) {
            this.writeInstallableUnit((IInstallableUnit)units.next());
        }
        this.end("units");
    }

    protected void writeInstallableUnit(IInstallableUnit resolvedIU) {
        IInstallableUnit iu = resolvedIU.unresolved();
        this.start("unit");
        this.attribute("id", iu.getId());
        this.attribute("version", iu.getVersion());
        this.attribute("singleton", iu.isSingleton(), true);
        if (iu.isFragment() && iu instanceof IInstallableUnitFragment) {
            IInstallableUnitFragment fragment = (IInstallableUnitFragment)iu;
            this.writeHostRequiredCapabilities(fragment.getHost());
        }
        if (iu instanceof IInstallableUnitPatch) {
            IInstallableUnitPatch patch = (IInstallableUnitPatch)iu;
            this.writeApplicabilityScope(patch.getApplicabilityScope());
            this.writeRequirementsChange(patch.getRequirementsChange());
            this.writeLifeCycle(patch.getLifeCycle());
        }
        this.writeUpdateDescriptor(resolvedIU, resolvedIU.getUpdateDescriptor());
        this.writeProperties(iu.getProperties());
        this.writeProvidedCapabilities(iu.getProvidedCapabilities());
        this.writeRequiredCapabilities(iu.getRequiredCapabilities());
        this.writeTrimmedCdata("filter", iu.getFilter());
        this.writeArtifactKeys(iu.getArtifacts());
        this.writeTouchpointType(iu.getTouchpointType());
        this.writeTouchpointData(iu.getTouchpointData());
        this.writeLicenses(iu.getLicense());
        this.writeCopyright(iu.getCopyright());
        this.end("unit");
    }

    protected void writeLifeCycle(RequiredCapability capability) {
        if (capability == null) {
            return;
        }
        this.start("lifeCycle");
        this.writeRequiredCapability(capability);
        this.end("lifeCycle");
    }

    protected void writeHostRequiredCapabilities(RequiredCapability[] capabilities) {
        if (capabilities != null && capabilities.length > 0) {
            this.start("hostRequirements");
            this.attribute("size", capabilities.length);
            int i = 0;
            while (i < capabilities.length) {
                this.writeRequiredCapability(capabilities[i]);
                ++i;
            }
            this.end("hostRequirements");
        }
    }

    protected void writeProvidedCapabilities(ProvidedCapability[] capabilities) {
        if (capabilities != null && capabilities.length > 0) {
            this.start("provides");
            this.attribute("size", capabilities.length);
            int i = 0;
            while (i < capabilities.length) {
                this.start("provided");
                this.attribute("namespace", capabilities[i].getNamespace());
                this.attribute("name", capabilities[i].getName());
                this.attribute("version", capabilities[i].getVersion());
                this.end("provided");
                ++i;
            }
            this.end("provides");
        }
    }

    protected void writeRequiredCapabilities(RequiredCapability[] capabilities) {
        if (capabilities != null && capabilities.length > 0) {
            this.start("requires");
            this.attribute("size", capabilities.length);
            int i = 0;
            while (i < capabilities.length) {
                this.writeRequiredCapability(capabilities[i]);
                ++i;
            }
            this.end("requires");
        }
    }

    protected void writeUpdateDescriptor(IInstallableUnit iu, IUpdateDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        this.start("update");
        this.attribute("id", descriptor.getId());
        this.attribute("range", descriptor.getRange());
        this.attribute("severity", descriptor.getSeverity());
        this.attribute("description", descriptor.getDescription());
        this.end("update");
    }

    protected void writeApplicabilityScope(RequiredCapability[][] capabilities) {
        this.start("patchScope");
        int i = 0;
        while (i < capabilities.length) {
            this.start("scope");
            this.writeRequiredCapabilities(capabilities[i]);
            this.end("scope");
            ++i;
        }
        this.end("patchScope");
    }

    protected void writeRequirementsChange(RequirementChange[] changes) {
        this.start("changes");
        int i = 0;
        while (i < changes.length) {
            this.writeRequirementChange(changes[i]);
            ++i;
        }
        this.end("changes");
    }

    protected void writeRequirementChange(RequirementChange change) {
        this.start("change");
        if (change.applyOn() != null) {
            this.start("from");
            this.writeRequiredCapability(change.applyOn());
            this.end("from");
        }
        if (change.newValue() != null) {
            this.start("to");
            this.writeRequiredCapability(change.newValue());
            this.end("to");
        }
        this.end("change");
    }

    protected void writeRequiredCapability(RequiredCapability capability) {
        this.start("required");
        this.attribute("namespace", capability.getNamespace());
        this.attribute("name", capability.getName());
        this.attribute("range", capability.getRange());
        this.attribute("optional", capability.isOptional(), false);
        this.attribute("multiple", capability.isMultiple(), false);
        this.attribute("greedy", capability.isGreedy(), true);
        this.writeTrimmedCdata("filter", capability.getFilter());
        String[] selectors = capability.getSelectors();
        if (selectors.length > 0) {
            this.start("selectors");
            this.attribute("size", selectors.length);
            int j = 0;
            while (j < selectors.length) {
                this.writeTrimmedCdata("selector", selectors[j]);
                ++j;
            }
            this.end("selectors");
        }
        this.end("required");
    }

    protected void writeArtifactKeys(IArtifactKey[] artifactKeys) {
        if (artifactKeys != null && artifactKeys.length > 0) {
            this.start("artifacts");
            this.attribute("size", artifactKeys.length);
            int i = 0;
            while (i < artifactKeys.length) {
                this.start("artifact");
                this.attribute("classifier", artifactKeys[i].getClassifier());
                this.attribute("id", artifactKeys[i].getId());
                this.attribute("version", artifactKeys[i].getVersion());
                this.end("artifact");
                ++i;
            }
            this.end("artifacts");
        }
    }

    protected void writeTouchpointType(TouchpointType touchpointType) {
        this.start("touchpoint");
        this.attribute("id", touchpointType.getId());
        this.attribute("version", touchpointType.getVersion());
        this.end("touchpoint");
    }

    protected void writeTouchpointData(TouchpointData[] touchpointData) {
        if (touchpointData != null && touchpointData.length > 0) {
            this.start("touchpointData");
            this.attribute("size", touchpointData.length);
            int i = 0;
            while (i < touchpointData.length) {
                TouchpointData nextData = touchpointData[i];
                Map instructions = nextData.getInstructions();
                if (instructions.size() > 0) {
                    this.start("instructions");
                    this.attribute("size", instructions.size());
                    Iterator iter = instructions.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        this.start("instruction");
                        this.attribute("key", entry.getKey());
                        this.cdata((String)entry.getValue(), true);
                        this.end("instruction");
                    }
                }
                ++i;
            }
            this.end("touchpointData");
        }
    }

    private void writeTrimmedCdata(String element, String filter) {
        String trimmed;
        if (filter != null && (trimmed = filter.trim()).length() > 0) {
            this.start(element);
            this.cdata(trimmed);
            this.end(element);
        }
    }

    private void writeLicenses(License license) {
        if (license != null) {
            this.start("licenses");
            this.attribute("size", 1);
            this.start("license");
            if (license.getURL() != null) {
                this.attribute("url", license.getURL().toExternalForm());
            }
            this.cdata(license.getBody(), true);
            this.end("license");
            this.end("licenses");
        }
    }

    private void writeCopyright(Copyright copyright) {
        if (copyright != null) {
            this.start("copyright");
            try {
                if (copyright.getURL() != null) {
                    this.attribute("url", copyright.getURL().toExternalForm());
                }
            }
            catch (IllegalStateException illegalStateException) {
                LogHelper.log((IStatus)new Status(1, "org.eclipse.equinox.p2.metadata.repository", "Error writing the copyright URL: " + copyright.getURL()));
            }
            this.cdata(copyright.getBody(), true);
            this.end("copyright");
        }
    }
}

