/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.metadata;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class License {
    private final String body;
    private URL url;
    private BigInteger digest;

    public License(String urlString, String body) {
        if (body == null) {
            throw new IllegalArgumentException("body cannot be null");
        }
        if (urlString != null) {
            try {
                this.url = new URL(urlString);
            }
            catch (MalformedURLException malformedURLException) {
                this.url = null;
            }
        }
        this.body = body;
    }

    public URL getURL() {
        return this.url;
    }

    public String getBody() {
        return this.body;
    }

    public synchronized BigInteger getDigest() {
        if (this.digest == null) {
            this.digest = this.calculateLicenseDigest();
        }
        return this.digest;
    }

    public boolean equals(Object obj) {
        License other;
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof License && (other = (License)obj).getDigest().equals(this.getDigest());
    }

    public int hashCode() {
        return this.getDigest().hashCode();
    }

    private BigInteger calculateLicenseDigest() {
        String message = this.normalize(this.getBody());
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(message.getBytes("UTF-8"));
            byte[] digestBytes = algorithm.digest();
            return new BigInteger(1, digestBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String normalize(String license) {
        String text = license.trim();
        StringBuffer result = new StringBuffer();
        int length = text.length();
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            boolean foundWhitespace = false;
            while (Character.isWhitespace(c) && i < length) {
                foundWhitespace = true;
                c = text.charAt(++i);
            }
            if (foundWhitespace) {
                result.append(' ');
            }
            if (i < length) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }
}

