/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.util.ICacheEnumeration;
import org.eclipse.jdt.internal.core.util.ILRUCacheable;
import org.eclipse.jdt.internal.core.util.ToStringSorter;

public class LRUCache
implements Cloneable {
    protected int fCurrentSpace = 0;
    protected int fSpaceLimit;
    protected int fTimestampCounter = 0;
    protected Hashtable fEntryTable;
    protected LRUCacheEntry fEntryQueue = null;
    protected LRUCacheEntry fEntryQueueTail = null;
    protected static final int DEFAULT_SPACELIMIT = 100;

    public LRUCache() {
        this(100);
    }

    public LRUCache(int size) {
        this.fEntryTable = new Hashtable(size);
        this.fSpaceLimit = size;
    }

    public Object clone() {
        LRUCache newCache = this.newInstance(this.fSpaceLimit);
        LRUCacheEntry qEntry = this.fEntryQueueTail;
        while (qEntry != null) {
            newCache.privateAdd(qEntry._fKey, qEntry._fValue, qEntry._fSpace);
            qEntry = qEntry._fPrevious;
        }
        return newCache;
    }

    public double fillingRatio() {
        return (double)this.fCurrentSpace * 100.0 / (double)this.fSpaceLimit;
    }

    public void flush() {
        this.fCurrentSpace = 0;
        LRUCacheEntry entry = this.fEntryQueueTail;
        this.fEntryTable = new Hashtable();
        this.fEntryQueueTail = null;
        this.fEntryQueue = null;
        while (entry != null) {
            entry = entry._fPrevious;
        }
    }

    public void flush(Object key) {
        LRUCacheEntry entry = (LRUCacheEntry)this.fEntryTable.get(key);
        if (entry == null) {
            return;
        }
        this.privateRemoveEntry(entry, false);
    }

    public Object getKey(Object key) {
        LRUCacheEntry entry = (LRUCacheEntry)this.fEntryTable.get(key);
        if (entry == null) {
            return key;
        }
        return entry._fKey;
    }

    public Object get(Object key) {
        LRUCacheEntry entry = (LRUCacheEntry)this.fEntryTable.get(key);
        if (entry == null) {
            return null;
        }
        this.updateTimestamp(entry);
        return entry._fValue;
    }

    public int getCurrentSpace() {
        return this.fCurrentSpace;
    }

    public int getNewestTimestampCounter() {
        return this.fEntryQueue == null ? 0 : this.fEntryQueue._fTimestamp;
    }

    public int getOldestTimestampCounter() {
        return this.fEntryQueueTail == null ? 0 : this.fEntryQueueTail._fTimestamp;
    }

    public Object getOldestElement() {
        return this.fEntryQueueTail == null ? null : this.fEntryQueueTail._fKey;
    }

    public int getSpaceLimit() {
        return this.fSpaceLimit;
    }

    public Enumeration keys() {
        return this.fEntryTable.keys();
    }

    public ICacheEnumeration keysAndValues() {
        return new ICacheEnumeration(){
            Enumeration fValues;
            LRUCacheEntry fEntry;
            {
                this.fValues = LRUCache.this.fEntryTable.elements();
            }

            public boolean hasMoreElements() {
                return this.fValues.hasMoreElements();
            }

            public Object nextElement() {
                this.fEntry = (LRUCacheEntry)this.fValues.nextElement();
                return this.fEntry._fKey;
            }

            public Object getValue() {
                if (this.fEntry == null) {
                    throw new NoSuchElementException();
                }
                return this.fEntry._fValue;
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    protected boolean makeSpace(int space) {
        limit = this.getSpaceLimit();
        if (this.fCurrentSpace + space <= limit) {
            return true;
        }
        if (space <= limit) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            this.privateRemoveEntry(this.fEntryQueueTail, false);
lbl7:
            // 2 sources

            ** while (this.fCurrentSpace + space > limit && this.fEntryQueueTail != null)
        }
lbl8:
        // 1 sources

        return true;
    }

    protected LRUCache newInstance(int size) {
        return new LRUCache(size);
    }

    public Object peek(Object key) {
        LRUCacheEntry entry = (LRUCacheEntry)this.fEntryTable.get(key);
        if (entry == null) {
            return null;
        }
        return entry._fValue;
    }

    protected void privateAdd(Object key, Object value, int space) {
        LRUCacheEntry entry = new LRUCacheEntry(key, value, space);
        this.privateAddEntry(entry, false);
    }

    protected void privateAddEntry(LRUCacheEntry entry, boolean shuffle) {
        if (!shuffle) {
            this.fEntryTable.put(entry._fKey, entry);
            this.fCurrentSpace += entry._fSpace;
        }
        entry._fTimestamp = this.fTimestampCounter++;
        entry._fNext = this.fEntryQueue;
        entry._fPrevious = null;
        if (this.fEntryQueue == null) {
            this.fEntryQueueTail = entry;
        } else {
            this.fEntryQueue._fPrevious = entry;
        }
        this.fEntryQueue = entry;
    }

    protected void privateRemoveEntry(LRUCacheEntry entry, boolean shuffle) {
        LRUCacheEntry previous = entry._fPrevious;
        LRUCacheEntry next = entry._fNext;
        if (!shuffle) {
            this.fEntryTable.remove(entry._fKey);
            this.fCurrentSpace -= entry._fSpace;
        }
        if (previous == null) {
            this.fEntryQueue = next;
        } else {
            previous._fNext = next;
        }
        if (next == null) {
            this.fEntryQueueTail = previous;
        } else {
            next._fPrevious = previous;
        }
    }

    public Object put(Object key, Object value) {
        int newSpace = this.spaceFor(value);
        LRUCacheEntry entry = (LRUCacheEntry)this.fEntryTable.get(key);
        if (entry != null) {
            int oldSpace = entry._fSpace;
            int newTotal = this.getCurrentSpace() - oldSpace + newSpace;
            if (newTotal <= this.getSpaceLimit()) {
                this.updateTimestamp(entry);
                entry._fValue = value;
                entry._fSpace = newSpace;
                this.fCurrentSpace = newTotal;
                return value;
            }
            this.privateRemoveEntry(entry, false);
        }
        if (this.makeSpace(newSpace)) {
            this.privateAdd(key, value, newSpace);
        }
        return value;
    }

    public Object removeKey(Object key) {
        LRUCacheEntry entry = (LRUCacheEntry)this.fEntryTable.get(key);
        if (entry == null) {
            return null;
        }
        Object value = entry._fValue;
        this.privateRemoveEntry(entry, false);
        return value;
    }

    public void setSpaceLimit(int limit) {
        if (limit < this.fSpaceLimit) {
            this.makeSpace(this.fSpaceLimit - limit);
        }
        this.fSpaceLimit = limit;
    }

    protected int spaceFor(Object value) {
        if (value instanceof ILRUCacheable) {
            return ((ILRUCacheable)value).getCacheFootprint();
        }
        return 1;
    }

    public String toString() {
        return String.valueOf(this.toStringFillingRation("LRUCache")) + this.toStringContents();
    }

    protected String toStringContents() {
        StringBuffer result = new StringBuffer();
        int length = this.fEntryTable.size();
        Object[] unsortedKeys = new Object[length];
        String[] unsortedToStrings = new String[length];
        Enumeration e = this.keys();
        int i = 0;
        while (i < length) {
            Object key = e.nextElement();
            unsortedKeys[i] = key;
            unsortedToStrings[i] = key instanceof JavaElement ? ((JavaElement)key).getElementName() : key.toString();
            ++i;
        }
        ToStringSorter sorter = new ToStringSorter();
        sorter.sort(unsortedKeys, unsortedToStrings);
        int i2 = 0;
        while (i2 < length) {
            String toString = sorter.sortedStrings[i2];
            Object value = this.get(sorter.sortedObjects[i2]);
            result.append(toString);
            result.append(" -> ");
            result.append(value);
            result.append("\n");
            ++i2;
        }
        return result.toString();
    }

    public String toStringFillingRation(String cacheName) {
        StringBuffer buffer = new StringBuffer(cacheName);
        buffer.append('[');
        buffer.append(this.getSpaceLimit());
        buffer.append("]: ");
        buffer.append(NumberFormat.getInstance().format(this.fillingRatio()));
        buffer.append("% full");
        return buffer.toString();
    }

    protected void updateTimestamp(LRUCacheEntry entry) {
        entry._fTimestamp = this.fTimestampCounter++;
        if (this.fEntryQueue != entry) {
            this.privateRemoveEntry(entry, true);
            this.privateAddEntry(entry, true);
        }
    }

    protected static class LRUCacheEntry {
        public Object _fKey;
        public Object _fValue;
        public int _fTimestamp;
        public int _fSpace;
        public LRUCacheEntry _fPrevious;
        public LRUCacheEntry _fNext;

        public LRUCacheEntry(Object key, Object value, int space) {
            this._fKey = key;
            this._fValue = value;
            this._fSpace = space;
        }

        public String toString() {
            return "LRUCacheEntry [" + this._fKey + "-->" + this._fValue + "]";
        }
    }

    public class Stats {
        private int[] counters = new int[20];
        private long[] timestamps = new long[20];
        private int counterIndex = -1;

        private void add(int counter) {
            int i = 0;
            while (i <= this.counterIndex) {
                if (this.counters[i] == counter) {
                    return;
                }
                ++i;
            }
            int length = this.counters.length;
            if (++this.counterIndex == length) {
                int newLength = this.counters.length * 2;
                this.counters = new int[newLength];
                System.arraycopy(this.counters, 0, this.counters, 0, length);
                this.timestamps = new long[newLength];
                System.arraycopy(this.timestamps, 0, this.timestamps, 0, length);
            }
            this.counters[this.counterIndex] = counter;
            this.timestamps[this.counterIndex] = System.currentTimeMillis();
        }

        private String getAverageAge(long totalTime, int numberOfElements, long currentTime) {
            if (numberOfElements == 0) {
                return "N/A";
            }
            long time = totalTime / (long)numberOfElements;
            long age = currentTime - time;
            long ageInSeconds = age / 1000L;
            int seconds = 0;
            int minutes = 0;
            int hours = 0;
            int days = 0;
            if (ageInSeconds > 60L) {
                long ageInMin = ageInSeconds / 60L;
                seconds = (int)(ageInSeconds - 60L * ageInMin);
                if (ageInMin > 60L) {
                    long ageInHours = ageInMin / 60L;
                    minutes = (int)(ageInMin - 60L * ageInHours);
                    if (ageInHours > 24L) {
                        long ageInDays = ageInHours / 24L;
                        hours = (int)(ageInHours - 24L * ageInDays);
                        days = (int)ageInDays;
                    } else {
                        hours = (int)ageInHours;
                    }
                } else {
                    minutes = (int)ageInMin;
                }
            } else {
                seconds = (int)ageInSeconds;
            }
            StringBuffer buffer = new StringBuffer();
            if (days > 0) {
                buffer.append(days);
                buffer.append(" days ");
            }
            if (hours > 0) {
                buffer.append(hours);
                buffer.append(" hours ");
            }
            if (minutes > 0) {
                buffer.append(minutes);
                buffer.append(" minutes ");
            }
            buffer.append(seconds);
            buffer.append(" seconds");
            return buffer.toString();
        }

        private long getTimestamps(int counter) {
            int i = 0;
            while (i <= this.counterIndex) {
                if (this.counters[i] >= counter) {
                    return this.timestamps[i];
                }
                ++i;
            }
            return -1L;
        }

        public synchronized String printStats() {
            int numberOfElements = LRUCache.this.fCurrentSpace;
            if (numberOfElements == 0) {
                return "No elements in cache";
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("Number of elements in cache: ");
            buffer.append(numberOfElements);
            int numberOfElementsPerGroup = numberOfElements / 5;
            buffer.append("\n(");
            buffer.append(5);
            buffer.append(" groups of ");
            buffer.append(numberOfElementsPerGroup);
            buffer.append(" elements)");
            buffer.append("\n\nAverage age:");
            int groupNumber = 1;
            int elementCounter = 0;
            LRUCacheEntry entry = LRUCache.this.fEntryQueueTail;
            long currentTime = System.currentTimeMillis();
            long accumulatedTime = 0L;
            while (entry != null) {
                long timeStamps = this.getTimestamps(entry._fTimestamp);
                if (timeStamps > 0L) {
                    accumulatedTime += timeStamps;
                    ++elementCounter;
                }
                if (elementCounter >= numberOfElementsPerGroup && groupNumber < 5) {
                    buffer.append("\nGroup ");
                    buffer.append(groupNumber);
                    if (groupNumber == 1) {
                        buffer.append(" (oldest)\t: ");
                    } else {
                        buffer.append("\t\t: ");
                    }
                    ++groupNumber;
                    buffer.append(this.getAverageAge(accumulatedTime, elementCounter, currentTime));
                    elementCounter = 0;
                    accumulatedTime = 0L;
                }
                entry = entry._fPrevious;
            }
            buffer.append("\nGroup ");
            buffer.append(5);
            buffer.append(" (youngest)\t: ");
            buffer.append(this.getAverageAge(accumulatedTime, elementCounter, currentTime));
            return buffer.toString();
        }

        private void removeCountersOlderThan(int counter) {
            int i = 0;
            while (i <= this.counterIndex) {
                if (this.counters[i] >= counter) {
                    if (i > 0) {
                        int length = this.counterIndex - i + 1;
                        System.arraycopy(this.counters, i, this.counters, 0, length);
                        System.arraycopy(this.timestamps, i, this.timestamps, 0, length);
                        this.counterIndex = length;
                    }
                    return;
                }
                ++i;
            }
        }

        public Object getOldestElement() {
            return LRUCache.this.getOldestElement();
        }

        public long getOldestTimestamps() {
            return this.getTimestamps(LRUCache.this.getOldestTimestampCounter());
        }

        public synchronized void snapshot() {
            this.removeCountersOlderThan(LRUCache.this.getOldestTimestampCounter());
            this.add(LRUCache.this.getNewestTimestampCounter());
        }
    }
}

