/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.cheatsheet.comp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCS;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSModel;
import org.eclipse.pde.internal.core.icheatsheet.comp.ICompCSObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class CompCSObject
extends PlatformObject
implements ICompCSObject {
    private static final long serialVersionUID = 1L;
    private transient ICompCSModel fModel;
    private transient ICompCSObject fParent;
    protected static final HashSet DEFAULT_TAG_EXCEPTIONS = new HashSet(12);
    protected static final HashMap DEFAULT_SUBSTITUTE_CHARS = new HashMap(5);

    static {
        DEFAULT_TAG_EXCEPTIONS.add("b");
        DEFAULT_TAG_EXCEPTIONS.add("/b");
        DEFAULT_TAG_EXCEPTIONS.add("br/");
        DEFAULT_TAG_EXCEPTIONS.add("p");
        DEFAULT_TAG_EXCEPTIONS.add("/p");
        DEFAULT_TAG_EXCEPTIONS.add("li");
        DEFAULT_TAG_EXCEPTIONS.add("/li");
        DEFAULT_TAG_EXCEPTIONS.add("a");
        DEFAULT_TAG_EXCEPTIONS.add("/a");
        DEFAULT_TAG_EXCEPTIONS.add("span");
        DEFAULT_TAG_EXCEPTIONS.add("/span");
        DEFAULT_TAG_EXCEPTIONS.add("img");
        DEFAULT_SUBSTITUTE_CHARS.put(new Character('&'), "&amp;");
        DEFAULT_SUBSTITUTE_CHARS.put(new Character('<'), "&lt;");
        DEFAULT_SUBSTITUTE_CHARS.put(new Character('>'), "&gt;");
        DEFAULT_SUBSTITUTE_CHARS.put(new Character('\''), "&apos;");
        DEFAULT_SUBSTITUTE_CHARS.put(new Character('\"'), "&quot;");
    }

    public CompCSObject(ICompCSModel model, ICompCSObject parent) {
        this.fModel = model;
        this.fParent = parent;
    }

    public abstract List getChildren();

    public ICompCS getCompCS() {
        return this.fModel.getCompCS();
    }

    public ICompCSModel getModel() {
        return this.fModel;
    }

    public abstract String getName();

    public ICompCSObject getParent() {
        return this.fParent;
    }

    public abstract int getType();

    public void parse(Element element) {
        if (element.getNodeName().equals(this.getElement())) {
            this.parseAttributes(element);
            this.parseContent(element);
        }
    }

    public abstract void reset();

    public void setModel(ICompCSModel model) {
        this.fModel = model;
    }

    public void write(String indent, PrintWriter writer) {
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append(this.getElement());
            this.writeAttributes(buffer);
            XMLPrintHandler.printBeginElement(writer, buffer.toString(), indent, false);
            this.writeElements(indent, writer);
            XMLPrintHandler.printEndElement(writer, this.getElement(), indent);
        }
        catch (IOException iOException) {}
    }

    protected void firePropertyChanged(String property, Object oldValue, Object newValue) {
        this.firePropertyChanged(this, property, oldValue, newValue);
    }

    private void firePropertyChanged(ICompCSObject object, String property, Object oldValue, Object newValue) {
        if (this.fModel.isEditable()) {
            ICompCSModel provider = this.fModel;
            provider.fireModelObjectChanged(object, property, oldValue, newValue);
        }
    }

    protected void fireStructureChanged(ICompCSObject child, int changeType) {
        this.fireStructureChanged(new ICompCSObject[]{child}, changeType);
    }

    protected void fireStructureChanged(ICompCSObject newValue, ICompCSObject oldValue) {
        int changeType = -1;
        ICompCSObject object = null;
        if (newValue == null) {
            changeType = 2;
            object = oldValue;
        } else {
            changeType = 1;
            object = newValue;
        }
        this.fireStructureChanged(object, changeType);
    }

    private void fireStructureChanged(ICompCSObject[] children, int changeType) {
        if (this.fModel.isEditable()) {
            ICompCSModel provider = this.fModel;
            provider.fireModelChanged(new ModelChangedEvent(provider, changeType, children, null));
        }
    }

    protected boolean isEditable() {
        return this.getModel().isEditable();
    }

    protected abstract void parseAttributes(Element var1);

    protected void parseContent(Element element) {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.parseElement((Element)child);
            } else if (child.getNodeType() == 3) {
                this.parseText((Text)child);
            }
            ++i;
        }
    }

    protected abstract void parseElement(Element var1);

    protected abstract void parseText(Text var1);

    protected abstract void writeAttributes(StringBuffer var1);

    protected abstract void writeElements(String var1, PrintWriter var2);

    public abstract String getElement();
}

