/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.content_trafficking.authorization;

import com.tandbergtv.cms.content_trafficking.authorization.licensing.InvalidLicenseException;
import com.tandbergtv.cms.content_trafficking.authorization.licensing.LicenseManager;
import com.tandbergtv.neptune.authorization.entity.BasicModule;
import com.tandbergtv.neptune.authorization.entity.BasicPermission;
import com.tandbergtv.neptune.authorization.entity.IModule;
import com.tandbergtv.neptune.authorization.service.IModuleProvider;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.workflow.auth.AuthorizationConfReader;
import com.tandbergtv.workflow.auth.Module;
import com.tandbergtv.workflow.auth.Permission;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;

public class ContentTraffickingModuleProvider
implements IModuleProvider {
    private static final String AUTH_FILE_NAME = "auth.xml";
    private static final String PMM_FOLDER_NAME = "pmm";
    private static Logger logger = Logger.getLogger(ContentTraffickingModuleProvider.class);

    public Collection<IModule> getModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        try {
            if (LicenseManager.getInstance().isLicensed()) {
                IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
                File authFile = configReaderService.getFile(PMM_FOLDER_NAME, AUTH_FILE_NAME);
                Set pmmModules = AuthorizationConfReader.getInstance().read(authFile);
                for (Module module : pmmModules) {
                    String moduleName = module.getName();
                    BasicModule pmmModule = new BasicModule(moduleName, moduleName);
                    Collection authPermissions = module.getPermissions();
                    for (Permission authPerm : authPermissions) {
                        pmmModule.getPermissions().add(new BasicPermission(authPerm.getName(), authPerm.getName(), moduleName));
                    }
                    modules.add((IModule)pmmModule);
                }
            }
        }
        catch (InvalidLicenseException e) {
            logger.error((Object)"Error while obtaining the license.", (Throwable)e);
        }
        return modules;
    }
}

