/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.content_trafficking.authorization.licensing;

import com.tandbergtv.cms.content_trafficking.authorization.licensing.EncryptionUtil;
import com.tandbergtv.cms.content_trafficking.authorization.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;

public class LicenseManager {
    private static final String WORKFLOW_DIR = "workflow";
    private static final String ENCRYPTED_FILE_NAME = "licensekey.lic";
    public static String PMM_LICENSE = "PMMLicense";
    private static final String PASSWORD = "TandbergTelevisionPartOfTheEricssonGroup";

    public static LicenseManager getInstance() {
        LicenseManager licManager = new LicenseManager();
        return licManager;
    }

    private LicenseManager() {
    }

    public boolean isLicensed() throws InvalidLicenseException {
        IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        File file = configReaderService.getFile(WORKFLOW_DIR, ENCRYPTED_FILE_NAME);
        if (file == null) {
            throw new InvalidLicenseException("License file not found");
        }
        String encrLicenseFilePath = file.getAbsolutePath();
        EncryptionUtil encUtil = new EncryptionUtil();
        InputStream cis = encUtil.getEncryptedInputStream(PASSWORD, encrLicenseFilePath);
        Properties prop = new Properties();
        try {
            prop.loadFromXML(cis);
        }
        catch (Exception e) {
            throw new InvalidLicenseException("Could not read properties from the encrypted input stream", e);
        }
        String value = prop.getProperty(PMM_LICENSE);
        if (value == null || value.trim().isEmpty()) {
            return true;
        }
        return Boolean.getBoolean(value);
    }
}

