/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.pmm.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.pmm.client.Alert;
import com.tandbergtv.cms.pmm.client.AlertList;
import com.tandbergtv.cms.pmm.client.IListAlerts;
import com.tandbergtv.cms.pmm.client.IListAlertsAsync;
import com.tandbergtv.cms.pmm.client.i18n.ContentConstants;
import com.tandbergtv.cms.pmm.client.i18n.ContentMessages;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.HTMLWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class AlertListPortlet
extends Portlet {
    private NeptuneSecurity security;
    private VerticalContainer container;
    private IListAlertsAsync service;
    private ContentConstants constants;
    private ContentMessages messages;
    private String dateFormat;
    private int maxLength;
    private String TITLE_NAMES_DELIMITER = ":";
    private String STATUS_BEGINNING_DELIMITER = "(";
    private String STATUS_ENDING_DELIMITER = ")";
    private String TRUNCATED_MSG_SUFFIX = "...";
    private int ALERT_TEXT_MAX_LENGTH = 255;
    private String SCHEDULE_BOOKMARK_URL = "#PMM.Schedule.View?scheduleId=";
    private String ALERT_ROW_BORDER_STYLE = "border-bottom: outset 1px";

    public AlertListPortlet(NeptuneSecurity security, int refreshTimeMillis, String dateFormat, String maxLength) {
        this.security = security;
        this.service = (IListAlertsAsync)GWT.create(IListAlerts.class);
        this.constants = (ContentConstants)GWT.create(ContentConstants.class);
        this.messages = (ContentMessages)GWT.create(ContentMessages.class);
        this.dateFormat = dateFormat;
        this.maxLength = maxLength != null && !maxLength.isEmpty() ? Integer.valueOf(maxLength) : this.ALERT_TEXT_MAX_LENGTH;
        this.setTitle(this.constants.alertsTitle());
        this.container = new VerticalContainer();
        this.add((Widget)this.container);
        new Timer(){

            public void run() {
                AlertListPortlet.this.reload();
            }
        }.scheduleRepeating(refreshTimeMillis);
    }

    public void reload() {
        this.service.getAlerts((AsyncCallback<AlertList>)new NeptuneAsyncCallback<AlertList>(){

            public void onNeptuneFailure(Throwable caught) {
            }

            public void onNeptuneSuccess(AlertList alertList) {
                AlertListPortlet.this.container.clear();
                AlertListPortlet.this.container.setStyleName("portlet-alerts-alertRow");
                AlertListPortlet.this.setTitle(String.valueOf(AlertListPortlet.this.constants.alertsTitle()) + " (" + alertList.getAlerts().size() + "/" + alertList.getTotalAlerts() + ")");
                HTMLWidget html = new HTMLWidget();
                html.setStyleName("portlet-alerts-text");
                StringBuilder rows = new StringBuilder();
                for (Alert alert : alertList.getAlerts()) {
                    String alertMsg = AlertListPortlet.this.prepareScheduleHTML(alert);
                    rows.append("<tr><td style='" + AlertListPortlet.this.ALERT_ROW_BORDER_STYLE + "'>" + alertMsg + "</td></tr>");
                }
                html.setHTML("<table>" + rows.toString() + "</table>");
                AlertListPortlet.this.container.add((Widget)html);
            }
        });
    }

    private String prepareScheduleHTML(Alert alert) {
        String alertMsg;
        String dateLink = "";
        int allowedInvisibleTextLength = 0;
        String titles = this.getTitles(alert.getText());
        DateTimeFormat dateFormatter = DateTimeFormat.getFormat((String)this.dateFormat);
        String date = dateFormatter.format(alert.getDate());
        String status = this.getStatus(alert);
        if (!this.security.isUserInRole("Schedules_View")) {
            alertMsg = alert.isPitchSchedule() ? this.messages.pitchScheduleAlert(status, date, alert.getEntityName(), titles) : this.messages.plannerAlert(date, alert.getEntityName(), titles);
        } else {
            dateLink = "<a href='" + this.SCHEDULE_BOOKMARK_URL + alert.getScheduleId() + "'>" + date + "</a>";
            allowedInvisibleTextLength = dateLink.length() - date.length();
            alertMsg = alert.isPitchSchedule() ? this.messages.pitchScheduleAlert(status, dateLink, alert.getEntityName(), titles) : this.messages.plannerAlert(dateLink, alert.getEntityName(), titles);
        }
        if (alertMsg.length() - dateLink.length() > this.maxLength) {
            int visibleTextLength = this.maxLength - this.TRUNCATED_MSG_SUFFIX.length() + allowedInvisibleTextLength;
            alertMsg = alertMsg.substring(0, visibleTextLength);
            alertMsg = String.valueOf(alertMsg) + this.TRUNCATED_MSG_SUFFIX;
        }
        return alertMsg;
    }

    private String getStatus(Alert alert) {
        if (!alert.isPitchSchedule()) {
            return "";
        }
        return alert.getText().substring(alert.getText().indexOf(this.STATUS_BEGINNING_DELIMITER) + 1, alert.getText().indexOf(this.STATUS_ENDING_DELIMITER));
    }

    private String getTitles(String text) {
        return text.substring(text.indexOf(this.TITLE_NAMES_DELIMITER) + 1);
    }
}

