/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.pmm.client;

import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.pmm.client.AlertListPortlet;
import com.tandbergtv.cms.pmm.client.ScheduleAnchorChangeListener;
import com.tandbergtv.cms.pmm.client.uiservices.AddTitlesToSchedule;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.FrameWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ContentTraffickingComponent
extends ComponentBase {
    private String SPECIFICATION_KEY = "ContentComponent.Specification";
    private String spec = "";

    public void init(EventListenerRegistry eventListenerRegistry, EventSink eventSink, ServiceLoader serviceLoader, Map<String, String> info) {
        super.init(eventListenerRegistry, eventSink, serviceLoader, info);
        this.spec = info.get(this.SPECIFICATION_KEY);
    }

    public List<PortletFactory> listPortlets(NeptuneSecurity security) {
        if (!security.isUserInRole("Home_Dashboard")) {
            return null;
        }
        ArrayList<PortletFactory> portletFactories = new ArrayList<PortletFactory>();
        int confRefreshTimeMillis = -1;
        try {
            confRefreshTimeMillis = Integer.parseInt((String)this.info.get("pmm.portlets.refreshTime"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int refreshTimeMillis = confRefreshTimeMillis != -1 ? confRefreshTimeMillis : 10000;
        portletFactories.add(new PortletFactory(security, refreshTimeMillis){
            AlertListPortlet portlet;
            {
                this.portlet = new AlertListPortlet(neptuneSecurity, n, (String)ContentTraffickingComponent.this.info.get("pmm.portlets.alertDateFormat"), (String)ContentTraffickingComponent.this.info.get("pmm.portlets.alerts.maxLength"));
            }

            public Portlet getInstance() {
                this.portlet.reload();
                return this.portlet;
            }

            public void release(Portlet portlet) {
            }
        });
        return portletFactories;
    }

    public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
        if (clazz.getName().equalsIgnoreCase(ITitleService.class.getName())) {
            return this.getTitleServices(security);
        }
        return null;
    }

    private List<ITitleService> getTitleServices(NeptuneSecurity security) {
        ArrayList<ITitleService> titleServices = new ArrayList<ITitleService>();
        if (security.isUserInRole("Schedules_Create")) {
            AddTitlesToSchedule addToScheduleService = new AddTitlesToSchedule();
            titleServices.add(addToScheduleService);
        }
        return titleServices;
    }

    public List<MenuItemBase> listTabs(NeptuneSecurity security) {
        ArrayList<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
        ArrayList<MenuItemBase> pmmGroupTab = new ArrayList<MenuItemBase>();
        String specSuffix = "&spec=" + this.spec;
        this.addPartner(security, pmmGroupTab, specSuffix);
        this.addService(security, pmmGroupTab, specSuffix);
        this.addSchedule(security, pmmGroupTab, specSuffix);
        if (pmmGroupTab.size() > 0) {
            tabs.add((MenuItemBase)new GroupMenuItem("PMM", "Planning", pmmGroupTab));
        }
        return tabs;
    }

    private void addSchedule(NeptuneSecurity security, List<MenuItemBase> pmmGroupTab, String specSuffix) {
        if (security.isUserInRole("Schedules_View") || security.isUserInRole("Schedules_Create")) {
            WidgetMenuItem menuItem;
            ScheduleAnchorChangeListener listener;
            String url;
            ArrayList<WidgetMenuItem> scheduleGroup = new ArrayList<WidgetMenuItem>();
            Panel panel = this.createPanel();
            if (security.isUserInRole("Schedules_View")) {
                url = "/pmm/schedules.do?spec=" + this.spec;
                listener = new ScheduleAnchorChangeListener(url, panel, this.spec);
                menuItem = new WidgetMenuItem("View", (Widget)panel, (WidgetMenuItem.AnchorChangeListener)listener);
                scheduleGroup.add(menuItem);
            }
            if (security.isUserInRole("Schedules_Create")) {
                url = "/pmm/createschedule.do";
                listener = new ScheduleAnchorChangeListener(url, panel, this.spec);
                menuItem = new WidgetMenuItem("Create", (Widget)panel, (WidgetMenuItem.AnchorChangeListener)listener);
                scheduleGroup.add(menuItem);
            }
            pmmGroupTab.add((MenuItemBase)new GroupMenuItem("Schedule", scheduleGroup));
        }
    }

    private void addPartner(final NeptuneSecurity security, List<MenuItemBase> pmmGroupTab, final String specSuffix) {
        if (security.isUserInRole("Partners_View") || security.isUserInRole("Partners_Create")) {
            ArrayList<MenuItemBase> partnersGroup = new ArrayList<MenuItemBase>();
            if (security.isUserInRole("Partners_View")) {
                final Panel panel = this.createPanel();
                WidgetMenuItem.AnchorChangeListener anchorChangeListener = new WidgetMenuItem.AnchorChangeListener(){

                    public void anchorChanged(String anchor) {
                        if (anchor.startsWith("Modify")) {
                            if (anchor.startsWith("Modify.Job")) {
                                if (security.isUserInRole("Jobs_View")) {
                                    String jobId = anchor.substring("Modify.Job.Id=".length());
                                    String url = "/pmm/jobManagement.do?method=getJob&id=" + jobId + specSuffix;
                                    ContentTraffickingComponent.this.showFrame(panel, url);
                                }
                            } else {
                                String url = "/pmm/partnerManagement.do?method=getPartnerDetails&" + anchor.substring(7) + specSuffix;
                                ContentTraffickingComponent.this.showFrame(panel, url);
                            }
                        } else {
                            String url = "/pmm/partners.do?method=getPartnersView" + specSuffix;
                            ContentTraffickingComponent.this.showFrame(panel, url);
                        }
                    }
                };
                WidgetMenuItem partnersViewPanel = new WidgetMenuItem("View", (Widget)panel, anchorChangeListener);
                partnersGroup.add((MenuItemBase)partnersViewPanel);
            }
            if (security.isUserInRole("Partners_Create")) {
                String menuName = "Create";
                String url = "/pmm/partnerManagement.do?method=createPartnerSetup" + specSuffix;
                this.addPanelToGroup(partnersGroup, url, menuName);
            }
            pmmGroupTab.add((MenuItemBase)new GroupMenuItem("Partner", partnersGroup));
        }
    }

    private void addService(final NeptuneSecurity security, List<MenuItemBase> pmmGroupTab, final String specSuffix) {
        if (security.isUserInRole("Services_View") || security.isUserInRole("Services_Create")) {
            ArrayList<MenuItemBase> servicesGroup = new ArrayList<MenuItemBase>();
            pmmGroupTab.add((MenuItemBase)new GroupMenuItem("Services", servicesGroup));
            if (security.isUserInRole("Services_View")) {
                final Panel panel = this.createPanel();
                WidgetMenuItem.AnchorChangeListener anchorChangeListener = new WidgetMenuItem.AnchorChangeListener(){

                    public void anchorChanged(String anchor) {
                        if (anchor.startsWith("Modify")) {
                            if (anchor.startsWith("Modify.Job")) {
                                if (security.isUserInRole("Jobs_View")) {
                                    String jobId = anchor.substring("Modify.Job.Id=".length());
                                    String url = "/pmm/jobManagement.do?method=getJob&id=" + jobId + specSuffix;
                                    ContentTraffickingComponent.this.showFrame(panel, url);
                                }
                            } else {
                                String url = "/pmm/serviceManagement.do?method=getServiceDetails&" + anchor.substring(7) + specSuffix;
                                ContentTraffickingComponent.this.showFrame(panel, url);
                            }
                        } else {
                            String url = "/pmm/services.do?method=getServicesView" + specSuffix;
                            ContentTraffickingComponent.this.showFrame(panel, url);
                        }
                    }
                };
                WidgetMenuItem serviceViewPanel = new WidgetMenuItem("View", (Widget)panel, anchorChangeListener);
                servicesGroup.add((MenuItemBase)serviceViewPanel);
            }
            if (security.isUserInRole("Services_Create")) {
                this.addPanelToGroup(servicesGroup, "/pmm/serviceManagement.do?method=createServiceSetup" + specSuffix, "Create");
            }
        }
    }

    private void addPanelToGroup(List<MenuItemBase> group, final String url, String menuName) {
        final FrameWidget frame = new FrameWidget();
        frame.getElement().setAttribute("frameBorder", "0");
        WidgetMenuItem.AnchorChangeListener anchorChangeListener = new WidgetMenuItem.AnchorChangeListener(){

            public void anchorChanged(String anchor) {
                frame.setUrl(url);
            }
        };
        WidgetMenuItem panel = new WidgetMenuItem(menuName, (Widget)frame, anchorChangeListener);
        group.add((MenuItemBase)panel);
    }

    public String getSpec() {
        return this.spec;
    }

    private Panel createPanel() {
        SimpleContainer panel = new SimpleContainer();
        panel.setSize("100%", "100%");
        return panel;
    }

    private void showFrame(Panel frameHolder, String frameURL) {
        frameHolder.clear();
        FrameWidget frame = new FrameWidget();
        frame.getElement().setAttribute("frameBorder", "0");
        frame.setUrl(frameURL);
        frameHolder.add((Widget)frame);
    }
}

