/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.contentmgmt.ejb.titlelist;

import com.tandbergtv.cms.contentmgmt.service.titlelist.ITitleListSearch;
import com.tandbergtv.cms.contentmgmt.service.titlelist.TitleListSearchResult;
import com.tandbergtv.watchpoint.pmm.assetlist.AssetListSearchKey;
import com.tandbergtv.watchpoint.pmm.assetlist.AssetListSearchService;
import com.tandbergtv.watchpoint.pmm.entities.TitleList;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.workflow.core.service.ServiceRegistry;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.SortParameter;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import com.tandbergtv.workflow.util.SearchCriteria;
import com.tandbergtv.workflow.util.SortingOrder;
import java.util.Collection;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;

@Stateless
public class TitleListSearch
implements ITitleListSearch {
    private static String TITLELIST_SEARCH_SERVICE = "TitleList Search Service";

    @RolesAllowed(value={"AssetListManagement_View"})
    public TitleListSearchResult getTitleLists(int start, int length, String sortProperty, boolean isAscending) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("titleList", TitleList.class, "tl");
        e.addParameter((SearchParameterBase)new ValueParameter(AssetListSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        criteria.addParameter((SearchParameterBase)e);
        SortingOrder order = isAscending ? SortingOrder.ASCENDING : SortingOrder.DESCENDING;
        e.addParameter((SearchParameterBase)new SortParameter(sortProperty, order));
        criteria.setStartingRecordNumber(start);
        criteria.setRecordsCount(length);
        Collection lists = this.getSearchService().search(criteria);
        int totalCount = this.getSearchService().count(criteria);
        return new TitleListSearchResult(lists, totalCount);
    }

    @RolesAllowed(value={"AssetListManagement_View"})
    public TitleList getTitleList(String name) {
        SearchCriteria criteria = new SearchCriteria();
        Entity e = new Entity("titleList", TitleList.class, "tl");
        e.addParameter((SearchParameterBase)new ValueParameter(AssetListSearchKey.ACTIVE.toString(), SearchType.NUMERIC, (Object)1));
        e.addParameter((SearchParameterBase)new ValueParameter(AssetListSearchKey.NAME.toString(), SearchType.STRING, (Object)name));
        criteria.addParameter((SearchParameterBase)e);
        Collection matchingLists = this.getSearchService().search(criteria);
        if (matchingLists != null && matchingLists.size() > 0) {
            return (TitleList)matchingLists.iterator().next();
        }
        return null;
    }

    private AssetListSearchService<TitleList> getSearchService() {
        return (AssetListSearchService)ServiceRegistry.getDefault().lookup(TITLELIST_SEARCH_SERVICE);
    }
}

