/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.services.title.AddTitleToTitleList;
import com.tandbergtv.cms.portal.content.client.services.title.DeleteService;
import com.tandbergtv.cms.portal.content.client.services.title.RunTemplate;
import com.tandbergtv.cms.portal.content.client.services.titlelist.TitleListDeleteService;
import com.tandbergtv.cms.portal.content.client.services.titlelist.TitleListXportService;
import com.tandbergtv.cms.portal.content.client.tab.create.TitleCreateWidgetFactory;
import com.tandbergtv.cms.portal.content.client.tab.search.TitleSearchWidgetFactory;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.TitleListCreatePanel;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.TitleListsPanel;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleListService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleProgressService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ContentComponent
extends ComponentBase {
    private static final String THIS_COMPONENT_NAME = "Content Management";
    private String spec = "";
    private String titleHistoryRefreshRate = null;

    public void init(EventListenerRegistry eventListenerRegistry, EventSink eventSink, ServiceLoader serviceLoader, Map<String, String> info) {
        super.init(eventListenerRegistry, eventSink, serviceLoader, info);
        this.spec = info.get("ContentComponent.Specification");
        this.titleHistoryRefreshRate = info.get("ContentComponent.TitleView.HistoryRefreshRate");
    }

    public List<PortletFactory> listPortlets(NeptuneSecurity security) {
        return null;
    }

    public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
        if (clazz.getName().equalsIgnoreCase(ITitleService.class.getName())) {
            return this.getAssetServices(security);
        }
        if (clazz.getName().equalsIgnoreCase(ITitleListService.class.getName())) {
            return this.getTitleListsServices(security);
        }
        if (clazz.getName().equalsIgnoreCase(ITitleProgressService.class.getName())) {
            ArrayList<1> tpServices = new ArrayList<1>();
            tpServices.add(new ITitleProgressService(){

                public ITitleProgressService.Hyperlink getLink(String componentName, String entityName, String sourceId, String titleRevision) {
                    if (componentName != null && componentName.equals(ContentComponent.THIS_COMPONENT_NAME)) {
                        String targetHistoryToken = "Admin.User.Edit?userName=" + sourceId;
                        return new ITitleProgressService.Hyperlink(sourceId, targetHistoryToken);
                    }
                    return null;
                }
            });
            return tpServices;
        }
        return null;
    }

    private List<ITitleListService> getTitleListsServices(NeptuneSecurity security) {
        ArrayList<ITitleListService> titleListServices = new ArrayList<ITitleListService>();
        if (security.isUserInRole("AssetListManagement_Delete")) {
            titleListServices.add(new TitleListDeleteService());
        }
        if (security.isUserInRole("AssetListManagement_Modify")) {
            titleListServices.add(new TitleListXportService());
        }
        if (security.isUserInRole("WorkOrderManagement_Create")) {
            titleListServices.add(new com.tandbergtv.cms.portal.content.client.services.titlelist.RunTemplate());
        }
        return titleListServices;
    }

    private List<ITitleService> getAssetServices(NeptuneSecurity security) {
        ArrayList<ITitleService> assetServices = new ArrayList<ITitleService>();
        if (security.isUserInRole("AssetManagement_Delete")) {
            DeleteService deleteService = new DeleteService();
            assetServices.add(deleteService);
        }
        if (security.isUserInRole("WorkOrderManagement_Create")) {
            assetServices.add(new RunTemplate());
        }
        if (security.isUserInRole("AssetListManagement_Modify")) {
            assetServices.add(new AddTitleToTitleList());
        }
        return assetServices;
    }

    public List<MenuItemBase> listTabs(NeptuneSecurity security) {
        ArrayList<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
        ArrayList childMenuItems = new ArrayList();
        GroupMenuItem rootMenuItem = new GroupMenuItem("Content", childMenuItems);
        this.buildTitleMenuItems(rootMenuItem, security);
        this.buildTitleListMenuItems(rootMenuItem, security);
        if (rootMenuItem.getSubPanels().size() > 0) {
            tabs.add((MenuItemBase)rootMenuItem);
        }
        return tabs;
    }

    private void buildTitleMenuItems(GroupMenuItem parentMenuItem, NeptuneSecurity security) {
        WidgetMenuItem menuItem;
        WidgetMenuItem.AnchorChangeListener listener;
        Object factory;
        if (security.isUserInRole("AssetManagement_View")) {
            factory = new TitleSearchWidgetFactory(security);
            listener = ((TitleSearchWidgetFactory)factory).getAnchorChangeListener();
            menuItem = new WidgetMenuItem("Search", (WidgetFactory)factory, listener);
            ((TitleSearchWidgetFactory)factory).setAnchorChangeNotifier(menuItem.getReverseAnchorChangeListener());
            parentMenuItem.getSubPanels().add(menuItem);
        }
        if (security.isUserInRole("AssetManagement_Create") && security.isUserInRole("AssetManagement_View")) {
            factory = new TitleCreateWidgetFactory(security);
            listener = ((TitleCreateWidgetFactory)factory).getAnchorChangeListener();
            menuItem = new WidgetMenuItem("Create", (WidgetFactory)factory, listener);
            ((TitleCreateWidgetFactory)factory).setAnchorChangeNotifier(menuItem.getReverseAnchorChangeListener());
            parentMenuItem.getSubPanels().add(menuItem);
        }
    }

    private void buildTitleListMenuItems(GroupMenuItem parentMenuItem, NeptuneSecurity security) {
        if (!security.isUserInRole("AssetListManagement_View") && !security.isUserInRole("AssetListManagement_Create")) {
            return;
        }
        ArrayList<WidgetMenuItem> titleListsGroup = new ArrayList<WidgetMenuItem>();
        if (security.isUserInRole("AssetListManagement_View")) {
            final TitleListsPanel titleListPanel = new TitleListsPanel(this.spec, security, this.serviceLoader);
            WidgetMenuItem titleListsView = new WidgetMenuItem("View", new WidgetFactory(){

                public Widget getInstance() {
                    return titleListPanel;
                }

                public void release(Widget widget) {
                }
            }, titleListPanel.getAnchorChangeListener());
            titleListPanel.setReverseAnchorChangeListener(titleListsView.getReverseAnchorChangeListener());
            titleListsGroup.add(titleListsView);
        }
        if (security.isUserInRole("AssetListManagement_Create")) {
            WidgetMenuItem titleListsCreate = new WidgetMenuItem("Create", new WidgetFactory(){

                public Widget getInstance() {
                    return new TitleListCreatePanel(ContentComponent.this.spec);
                }

                public void release(Widget widget) {
                }
            });
            titleListsGroup.add(titleListsCreate);
        }
        GroupMenuItem titleListMenuItem = new GroupMenuItem("TitleLists", titleListsGroup);
        parentMenuItem.getSubPanels().add(titleListMenuItem);
    }

    public String getSpecificationName() {
        return this.spec;
    }

    public String getTitleHistoryViewRefreshRate() {
        return this.titleHistoryRefreshRate;
    }
}

