/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.UiServiceItem;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.tab.SucessPanel;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListViewInput;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ActionListDataProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ServiceMap;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TitleRecord;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.UiAssetTableDataProvider;
import com.tandbergtv.cms.portal.content.client.tab.list.goButton.ButtonClickListener;
import com.tandbergtv.cms.portal.content.client.title.view.TitleView;
import com.tandbergtv.cms.portal.content.client.title.view.TitleViewMessages;
import com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilter;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.TitleActionInput;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.List;

public class TitleListPanel
extends VerticalContainer
implements IView {
    private NeptuneSecurity security;
    private String specificationName;
    private UITitleFilter titleFilter;
    private ServiceLoader serviceLoader;
    private TitleListViewInput input;
    private Long requestKey;
    private String action;
    private String listOfAssetIds;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private ServiceMap serviceMap = new ServiceMap();
    private final WidgetMenuItem.AnchorChangeListener anchorChangeNotifier;
    private TitleViewMessages messages;
    private ContentConstants displayConstants;
    private int SPACING = 2;
    private ErrorPanel errorMessagePanel;
    private SucessPanel successMessagePanel;
    private boolean selectButtonVisible = false;
    private Table<Long, TitleRecord> assetTable;
    private UiAssetTableDataProvider dp;
    private ButtonWidget goButton;
    private ListBoxWidget<String> actionsListBox;
    private ListBoxWidget<String> parameterListBox;
    private HorizontalContainer actionListContainer;
    private static final String RESULTS_PAGE_ANCHOR = "Results";
    private static final String TITLE_ID_ANCHOR = "Id";

    public TitleListPanel(NeptuneSecurity security, String spec, ServiceLoader serviceLoader, WidgetMenuItem.AnchorChangeListener anchorChangeNotifier, UITitleFilter titleFilter, TitleListViewInput viewInput, Long requestKey, String action, String listOfAssetIds, boolean selectButtonVisible, String infoMessage) {
        this.showBusyIndicator();
        this.messages = (TitleViewMessages)GWT.create(TitleViewMessages.class);
        this.displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
        this.security = security;
        this.specificationName = spec;
        this.titleFilter = titleFilter;
        this.serviceLoader = serviceLoader;
        this.anchorChangeNotifier = anchorChangeNotifier;
        this.input = viewInput;
        this.requestKey = requestKey;
        this.action = action;
        this.listOfAssetIds = listOfAssetIds;
        this.selectButtonVisible = selectButtonVisible;
        this.initWidgets();
        this.setWidgets();
        this.initializeDataProvider(infoMessage);
    }

    protected void onUnload() {
        super.onUnload();
        this.busyIndicator.hide();
    }

    private void initWidgets() {
        this.setSpacing(this.SPACING);
        this.errorMessagePanel = new ErrorPanel();
        this.errorMessagePanel.setVisible(false);
        this.errorMessagePanel.setWidth("99%");
        this.successMessagePanel = new SucessPanel();
        this.successMessagePanel.setVisible(false);
        this.actionsListBox = new ListBoxWidget(false);
        this.parameterListBox = new ListBoxWidget(false);
        this.parameterListBox.setVisible(false);
        this.goButton = new ButtonWidget(this.displayConstants.goButtonName());
        this.goButton.addClickHandler((ClickHandler)new ButtonClickListener(this.actionsListBox, this.parameterListBox, this, this.serviceMap));
        this.goButton.addStyleDependentName("action-button");
        this.buildActionsListWidget();
    }

    private void setWidgets() {
        this.add((Widget)new HeaderPanel(this.messages.titleList()));
        this.add((Widget)this.errorMessagePanel);
        this.add((Widget)this.successMessagePanel);
    }

    private void initializeDataProvider(final String infoMessage) {
        this.dp = new UiAssetTableDataProvider(this);
        this.dp.init(new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                TitleListPanel.this.hideBusyIndicator();
                Window.alert((String)("Failed to initialize Asset Table Data Provider. Reason: " + (caught != null ? caught.getMessage() : "")));
            }

            public void onSuccess(Void result) {
                TitleListPanel.this.show(infoMessage);
                TitleListPanel.this.initializeTable();
            }
        });
    }

    private void initializeTable() {
        this.assetTable = new Table((DataProvider)this.dp);
        PageFeatureImpl pageFeature = new PageFeatureImpl();
        this.dp.setPageFeature(pageFeature);
        SortFeatureImpl sortFeature = new SortFeatureImpl(this.dp.getDefaultSortColumn(), this.dp.getDefaultSortOrder());
        for (Column<?, TitleRecord> sortableCol : this.dp.getSortableColumns()) {
            sortFeature.addSortableColumn(sortableCol);
        }
        this.dp.setSortFeature((SortFeatureImpl<Long, TitleRecord>)sortFeature);
        this.assetTable.addPageFeature((PageFeature)pageFeature);
        this.assetTable.addSortFeature((SortFeature)sortFeature);
        this.assetTable.registerWidgetOnActionContainer((Widget)this.actionListContainer);
        this.add((Widget)this.assetTable);
        this.assetTable.initialize((AsyncCallback)new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                TitleListPanel.this.hideBusyIndicator();
            }

            public void onSuccess(Void result) {
                TitleListPanel.this.assetTable.refresh();
            }
        });
    }

    private void buildActionsListWidget() {
        this.actionListContainer = new HorizontalContainer();
        ActionListDataProvider<ITitleService> listItemProvider = new ActionListDataProvider<ITitleService>(ITitleService.class, this.serviceLoader);
        for (UiServiceItem item : listItemProvider.getItems(this.serviceMap)) {
            this.actionsListBox.addItem(item.getName(), (Object)item.getClassName());
        }
        this.actionsListBox.setSelectedIndex(listItemProvider.getSelectedItemIndex(this.serviceMap, this.input));
        final TitleListPanel instance = this;
        this.actionsListBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TitleListPanel.this.parameterListBox.setVisible(false);
                TitleListPanel.this.goButton.setEnabled(false);
                int selectedIndex = TitleListPanel.this.actionsListBox.getSelectedIndex();
                String displayName = TitleListPanel.this.actionsListBox.getItemText(selectedIndex);
                ITitleActionService selectedAction = TitleListPanel.this.serviceMap.getService(displayName);
                selectedAction.getServiceParameters((NeptuneAsyncCallback)new NeptuneAsyncCallback<List<String>>(){

                    public void onNeptuneFailure(Throwable caught) {
                        TitleListPanel.this.parameterListBox.setVisible(false);
                        instance.reportFailure(caught);
                    }

                    public void onNeptuneSuccess(List<String> result) {
                        if (result != null) {
                            this.setParameterList(result);
                            TitleListPanel.this.parameterListBox.setVisible(true);
                        }
                        TitleListPanel.this.goButton.setEnabled(true);
                    }
                });
            }

            private void setParameterList(List<String> parameters) {
                TitleListPanel.this.parameterListBox.clear();
                for (String p : parameters) {
                    TitleListPanel.this.parameterListBox.addItem(p, (Object)p);
                }
            }
        });
        this.actionListContainer.add(this.actionsListBox);
        this.actionListContainer.add(this.parameterListBox);
        this.actionListContainer.add((Widget)this.goButton);
    }

    public NeptuneSecurity getSecurity() {
        return this.security;
    }

    public String getSpecificationName() {
        return this.specificationName;
    }

    public ServiceLoader getServiceLoader() {
        return this.serviceLoader;
    }

    public UITitleFilter getTitleFilter() {
        return this.titleFilter;
    }

    public void setTitleFilter(UITitleFilter titleFilter) {
        this.titleFilter = titleFilter;
    }

    public Table<Long, TitleRecord> getAssetTable() {
        return this.assetTable;
    }

    public Widget getParentContainer() {
        return this.getParent();
    }

    public void reportFailure(Throwable caught) {
        this.errorMessagePanel.showErrorMessage(caught.getMessage());
        this.errorMessagePanel.setVisible(true);
        this.successMessagePanel.setVisible(false);
    }

    public void cleanup() {
        this.input.resetInfo();
        this.errorMessagePanel.reset();
        this.successMessagePanel.reset();
    }

    public void refresh(String infoMessage) {
        this.clear();
        this.assetTable.getPageFeature().setPageNumber(1);
        this.assetTable.showListView();
        this.assetTable.refresh();
        this.setWidgets();
        this.add((Widget)this.assetTable);
        this.show(infoMessage);
        if (this.anchorChangeNotifier != null) {
            this.anchorChangeNotifier.anchorChanged(RESULTS_PAGE_ANCHOR);
        }
    }

    public void showTitleDetails(TitleView titleView) {
        this.clear();
        this.add((Widget)titleView);
        Long titleId = titleView.getViewInput().getTitleId();
        if (titleId != null && this.anchorChangeNotifier != null && this.isAttached() && this.isVisible()) {
            this.anchorChangeNotifier.anchorChanged("Id=" + titleId.toString());
        }
    }

    public void show(String infoMessage) {
        if (infoMessage != null && !infoMessage.isEmpty()) {
            this.successMessagePanel.setWidth(String.valueOf(String.valueOf(this.assetTable.getOffsetWidth())) + "px");
            this.successMessagePanel.showSuccessMessage(infoMessage);
            this.successMessagePanel.setVisible(true);
        } else {
            this.successMessagePanel.setVisible(false);
        }
        this.errorMessagePanel.setVisible(false);
    }

    public Long getRequestKey() {
        return this.requestKey;
    }

    public void setRequestKey(Long requestKey) {
        this.requestKey = requestKey;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getListOfAssetIds() {
        return this.listOfAssetIds;
    }

    public void setListOfAssetIds(String listOfAssetIds) {
        this.listOfAssetIds = listOfAssetIds;
    }

    public boolean isSelectButtonVisible() {
        return this.selectButtonVisible;
    }

    public void setSelectButtonVisible(boolean selectButtonVisible) {
        this.selectButtonVisible = selectButtonVisible;
    }

    public TitleListViewInput getInput() {
        return this.input;
    }

    public void setInput(TitleListViewInput input) {
        this.input = input;
    }

    public IActionInput getInputToExecution() {
        return new TitleActionInput(this.getSpecificationName(), this.getInput().getScheduleId(), this.getInput().getTitleListId());
    }

    public List<Long> getSeletedRecordIds() {
        List selectedIds = this.getAssetTable().getSelectedRecords();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (TitleRecord tr : selectedIds) {
            ids.add(tr.getKey());
        }
        return ids;
    }

    public void show(boolean readOnly) {
        this.goButton.setEnabled(readOnly);
        this.actionsListBox.setEnabled(readOnly);
        this.parameterListBox.setEnabled(readOnly);
    }

    public boolean hasActions() {
        return this.actionsListBox.getItemCount() > 0;
    }

    private void showBusyIndicator() {
        this.busyIndicator.center();
    }

    private void hideBusyIndicator() {
        this.busyIndicator.hide();
    }

    public void handleGetRecordsRequest() {
        this.showBusyIndicator();
    }

    public void handleGetRecordsSuccessResponse(List<TitleRecord> records) {
        this.hideBusyIndicator();
    }

    public void handleGetRecordsFailureResponse(Throwable caught) {
        this.hideBusyIndicator();
    }
}

