/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.list.goButton;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.i18n.ContentMessages;
import com.tandbergtv.cms.portal.content.client.tab.list.actionlist.ServiceMap;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IActionInput;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.ITitleActionService;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.IView;
import com.tandbergtv.cms.portal.ui.title.client.model.uiservice.OperationCompletedAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.List;

public class ButtonClickListener
implements ClickHandler {
    private ListBoxWidget<String> list;
    private ListBoxWidget<String> parameterList;
    private IView view;
    private ServiceMap serviceMap;
    private ContentConstants displayConstants = (ContentConstants)GWT.create(ContentConstants.class);
    private ContentMessages displayMessages = (ContentMessages)GWT.create(ContentMessages.class);

    public ButtonClickListener(ListBoxWidget<String> list, ListBoxWidget<String> parameterList, IView view, ServiceMap serviceMap) {
        this.list = list;
        this.parameterList = parameterList;
        this.view = view;
        this.serviceMap = serviceMap;
    }

    public void onClick(ClickEvent event) {
        int selectedIndex = this.list.getSelectedIndex();
        String displayName = this.list.getItemText(selectedIndex);
        ITitleActionService serviceImpl = this.serviceMap.getService(displayName);
        if (serviceImpl == null) {
            throw new RuntimeException("Service impl for : " + displayName + " could not be found.");
        }
        List ids = this.view.getSeletedRecordIds();
        OperationCompletedAsyncCallback callback = new OperationCompletedAsyncCallback(serviceImpl, this.view);
        if (ids.size() == 0) {
            callback.onFailure((Throwable)new RuntimeException(this.displayConstants.atLeastOneTitleSelectionRequired()));
            return;
        }
        IActionInput input = this.view.getInputToExecution();
        if (serviceImpl.getConfirmation()) {
            this.view.show(false);
            this.getConfirmation(serviceImpl, ids, input, callback);
        } else {
            serviceImpl.execute(ids, (String)this.parameterList.getSelectedItem(), input, (AsyncCallback)callback);
        }
    }

    private void getConfirmation(final ITitleActionService serviceImpl, final List<Long> ids, final IActionInput input, final OperationCompletedAsyncCallback callback) {
        final PopupContainer confirmation = new PopupContainer(false, true);
        VerticalContainer popContainer = new VerticalContainer();
        popContainer.add((Widget)new LabelWidget(this.displayMessages.confirmationMessage(serviceImpl.getName())));
        HorizontalContainer buttonContainer = new HorizontalContainer();
        ButtonWidget yesButton = new ButtonWidget(this.displayConstants.confirmationYes());
        yesButton.addStyleDependentName("commit-button");
        yesButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ButtonClickListener.this.view.show(true);
                confirmation.hide();
                serviceImpl.execute(ids, (String)ButtonClickListener.this.parameterList.getSelectedItem(), input, (AsyncCallback)callback);
            }
        });
        buttonContainer.add((Widget)yesButton);
        ButtonWidget noButton = new ButtonWidget(this.displayConstants.confirmationNo());
        noButton.addStyleDependentName("dataloss-button");
        noButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ButtonClickListener.this.view.show(true);
                ButtonClickListener.this.view.show(ButtonClickListener.this.displayConstants.cancelledOperation());
                confirmation.hide();
            }
        });
        buttonContainer.add((Widget)noButton);
        popContainer.add((Widget)buttonContainer);
        popContainer.setCellHorizontalAlignment((Widget)buttonContainer, VerticalContainer.ALIGN_CENTER);
        confirmation.add((Widget)popContainer);
        confirmation.center();
        confirmation.show();
    }
}

