/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.search;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.tab.list.TitleListViewInput;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchClickListener;
import com.tandbergtv.cms.portal.content.client.tab.search.SearchCriteriaPanel;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class TitleSearchPanel
extends SimpleContainer {
    private final NeptuneSecurity security;
    private final TitleListViewInput titleListViewInput;
    private String spec;
    private Long requestKey;
    private boolean selectButtonVisible = false;
    private String action = "";
    private String listOfAssetIds = "";
    private WidgetMenuItem.AnchorChangeListener anchorChangeNotifier;
    private SimpleContainer searchPanel;
    private SimpleContainer searchResultPanel;
    private SimpleContainer criteriaPanelWrapper;
    private SearchCriteriaPanel criteriaPanel;
    private ContentConstants myConstants = (ContentConstants)GWT.create(ContentConstants.class);

    public TitleSearchPanel(NeptuneSecurity security) {
        this.security = security;
        this.titleListViewInput = new TitleListViewInput(0L, 0L);
        this.initialize();
    }

    private void initialize() {
        this.searchPanel = new SimpleContainer();
        this.searchResultPanel = new SimpleContainer();
        VerticalContainer containerPanel = new VerticalContainer();
        containerPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        containerPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        containerPanel.setSpacing(5);
        containerPanel.add((Widget)new HeaderPanel(this.myConstants.advancedSearchLabel()));
        this.criteriaPanelWrapper = new SimpleContainer();
        this.criteriaPanelWrapper.setWidget((Widget)new LabelWidget());
        containerPanel.add((Widget)this.criteriaPanelWrapper);
        HorizontalContainer buttonBar = new HorizontalContainer();
        ButtonWidget searchButton = new ButtonWidget(this.myConstants.searchButtonName());
        searchButton.addClickHandler((ClickHandler)new SearchClickListener(this));
        searchButton.addStyleDependentName("action-button");
        buttonBar.add((Widget)searchButton);
        ButtonWidget cancelButton = new ButtonWidget(this.myConstants.resetSearch());
        cancelButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (TitleSearchPanel.this.criteriaPanel != null) {
                    TitleSearchPanel.this.criteriaPanel.reset();
                }
            }
        });
        cancelButton.addStyleDependentName("dataloss-button");
        buttonBar.add((Widget)cancelButton);
        containerPanel.add((Widget)buttonBar);
        this.searchPanel.setWidget((Widget)containerPanel);
        this.searchResultPanel.setWidget((Widget)new LabelWidget(""));
        this.setWidget((Widget)this.searchPanel);
    }

    public void reset() {
        this.titleListViewInput.resetInfo();
        this.requestKey = null;
        this.selectButtonVisible = false;
        this.action = "";
        this.listOfAssetIds = "";
        this.showSearchView(true);
    }

    SearchCriteriaPanel getCriteriaPanel() {
        return this.criteriaPanel;
    }

    public void showSearchView(boolean reset) {
        if (reset) {
            if (this.criteriaPanel != null) {
                this.criteriaPanel.reset();
            }
            this.searchResultPanel.setWidget((Widget)new LabelWidget(""));
        }
        this.setWidget((Widget)this.searchPanel);
    }

    public void showSearchResultsView() {
        this.setWidget((Widget)this.searchResultPanel);
    }

    void setSearchResultsView(Widget widget) {
        this.searchResultPanel.setWidget(widget);
    }

    public String getSpecificationName() {
        return this.spec;
    }

    public void setSpecificationName(String specificationName) {
        boolean isNewSpec = this.spec != specificationName && (this.spec == null || !this.spec.equals(specificationName));
        this.spec = specificationName;
        if (isNewSpec) {
            Object wrappedWidget = null;
            if (this.spec != null) {
                this.criteriaPanel = new SearchCriteriaPanel(this.spec);
                this.criteriaPanel.setBorderWidth(1);
                wrappedWidget = this.criteriaPanel;
            } else {
                this.criteriaPanel = null;
                wrappedWidget = new LabelWidget("");
            }
            this.criteriaPanelWrapper.setWidget((Widget)wrappedWidget);
        }
    }

    public Long getRequestKey() {
        return this.requestKey;
    }

    public void setRequestKey(Long requestKey) {
        this.requestKey = requestKey;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getListOfAssetIds() {
        return this.listOfAssetIds;
    }

    public void setListOfAssetIds(String listOfAssetIds) {
        this.listOfAssetIds = listOfAssetIds;
    }

    public boolean isSelectButtonVisible() {
        return this.selectButtonVisible;
    }

    public void setSelectButtonVisible(boolean selectButtonVisible) {
        this.selectButtonVisible = selectButtonVisible;
    }

    public TitleListViewInput getTitleListViewInput() {
        return this.titleListViewInput;
    }

    public NeptuneSecurity getSecurity() {
        return this.security;
    }

    public WidgetMenuItem.AnchorChangeListener getAnchorChangeNotifier() {
        return this.anchorChangeNotifier;
    }

    public void setAnchorChangeNotifier(WidgetMenuItem.AnchorChangeListener anchorChangeNotifier) {
        this.anchorChangeNotifier = anchorChangeNotifier;
    }
}

