/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.cms.portal.content.client.tab.titlelist;

import com.allen_sauer.gwt.dnd.client.DragHandler;
import com.allen_sauer.gwt.dnd.client.DragHandlerAdapter;
import com.allen_sauer.gwt.dnd.client.drop.DropController;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.cms.portal.content.client.i18n.ContentConstants;
import com.tandbergtv.cms.portal.content.client.model.UiColumn;
import com.tandbergtv.cms.portal.content.client.model.UiField;
import com.tandbergtv.cms.portal.content.client.model.UiTable;
import com.tandbergtv.cms.portal.content.client.model.UiTitle;
import com.tandbergtv.cms.portal.content.client.model.UiTitleList;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationService;
import com.tandbergtv.cms.portal.content.client.rpc.SpecificationServiceAsync;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchService;
import com.tandbergtv.cms.portal.content.client.rpc.title.TitleSearchServiceAsync;
import com.tandbergtv.cms.portal.content.client.rpc.titlelist.ITitleListService;
import com.tandbergtv.cms.portal.content.client.rpc.titlelist.ITitleListServiceAsync;
import com.tandbergtv.cms.portal.content.client.rpc.titlelist.UiValidationException;
import com.tandbergtv.cms.portal.content.client.tab.ErrorPanel;
import com.tandbergtv.cms.portal.content.client.tab.SucessPanel;
import com.tandbergtv.cms.portal.content.client.tab.list.assettable.TableColumnNameHelper;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.Permissions;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.UiTitleListKey;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.UiTitleListRecord;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.dnd.MoveCallback;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.dnd.RowDragController;
import com.tandbergtv.cms.portal.content.client.tab.titlelist.dnd.RowDropController;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextAreaWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedCornerContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TitleListDetailView
implements DetailView<UiTitleListKey, UiTitleListRecord> {
    private static final String DRAG_HANDLE_IMAGE_URL = "cms_contentmgmt_ui/resources/images/drag_drop_cue.gif";
    private String spec;
    private NeptuneSecurity security;
    private UiTitleListRecord record;
    private DetailViewCallback<UiTitleListKey, UiTitleListRecord> callback;
    private String previousName;
    private String previousDescription;
    private List<UiColumn> columns;
    private ContentConstants constants = (ContentConstants)GWT.create(ContentConstants.class);
    private ITitleListServiceAsync service = (ITitleListServiceAsync)GWT.create(ITitleListService.class);
    VerticalContainer formContainer;
    private int FORM_CONTAINER_BORDER_WIDTH = 1;
    private TextBoxWidget nameWidget;
    private TextAreaWidget descriptionWidget;
    private int DESCRIPTION_VISIBLE_COUNT = 5;
    private int DESCRIPTION_CHAR_WIDTH = 40;
    VerticalContainer mainContainer;
    private int SPACING_BETWEEN_MESSAGE_TABLE = 2;
    RoundedCornerContainer roundedContainer = new RoundedCornerContainer(15, 9);
    VerticalContainer tableButtonsContainer = new VerticalContainer();
    private BusyIndicator busyIndicator;
    ErrorPanel errorMessagePanel;
    SucessPanel successMessagePanel;
    private static String TABLE_NAME = "assetList";
    private static int CHECKBOX_COLUMN = 1;
    private static int TITLE_ID_COLUMN = 2;
    private static int DATA_ROW = 1;
    private static String ID_COLUMN_NAME = "id";

    public TitleListDetailView(String spec, NeptuneSecurity security, UiTitleListRecord record, DetailViewCallback<UiTitleListKey, UiTitleListRecord> callback) {
        this.init(spec, security, record, callback);
        this.showBusyIndicator();
        this.getColumns((AsyncCallback<List<UiColumn>>)new NeptuneAsyncCallback<List<UiColumn>>(){

            public void onNeptuneFailure(Throwable caught) {
                TitleListDetailView.this.hideBusyIndicator();
                TitleListDetailView.this.callback.cancel(null);
            }

            public void onNeptuneSuccess(List<UiColumn> columns) {
                TitleListDetailView.this.columns = columns;
                TitleListDetailView.this.fetchMetadata();
            }
        });
    }

    private void init(String spec, NeptuneSecurity security, UiTitleListRecord record, DetailViewCallback<UiTitleListKey, UiTitleListRecord> callback) {
        this.spec = spec;
        this.security = security;
        this.record = record;
        this.callback = callback;
        this.nameWidget = new TextBoxWidget(record.getTitleList().getName());
        this.descriptionWidget = new TextAreaWidget(record.getTitleList().getDescription());
        this.descriptionWidget.setCharacterWidth(this.DESCRIPTION_CHAR_WIDTH);
        this.descriptionWidget.setVisibleLines(this.DESCRIPTION_VISIBLE_COUNT);
        this.formContainer = new VerticalContainer();
        FormContainer form = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
        form.addRow(this.constants.titleListNameLabel(), (Widget)this.nameWidget, true);
        form.addRow(this.constants.titleListDescriptionLabel(), (Widget)this.descriptionWidget);
        this.formContainer.add((Widget)form);
        this.formContainer.setWidth("100%");
        this.formContainer.setBorderWidth(this.FORM_CONTAINER_BORDER_WIDTH);
        this.mainContainer = new VerticalContainer();
        this.mainContainer.setSpacing(this.SPACING_BETWEEN_MESSAGE_TABLE);
        this.roundedContainer.setCornerStyleName("table-panel");
        this.roundedContainer.setSize("100%", "100%");
        this.tableButtonsContainer = new VerticalContainer();
        this.tableButtonsContainer.addStyleName("table-panel");
        this.errorMessagePanel = new ErrorPanel();
        this.errorMessagePanel.setVisible(false);
        this.successMessagePanel = new SucessPanel();
        this.successMessagePanel.setVisible(false);
        this.busyIndicator = new BusyIndicator();
    }

    private void fetchMetadata() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (UiTitle t : this.record.getTitleList().getTitles()) {
            ids.add(t.getTitleId());
        }
        TitleSearchServiceAsync searchService = (TitleSearchServiceAsync)GWT.create(TitleSearchService.class);
        searchService.getTitles(ids, this.columns, (AsyncCallback<UiTitleList>)new NeptuneAsyncCallback<UiTitleList>(){

            public void onNeptuneFailure(Throwable caught) {
                TitleListDetailView.this.hideBusyIndicator();
                TitleListDetailView.this.callback.cancel(null);
            }

            public void onNeptuneSuccess(UiTitleList titles) {
                TitleListDetailView.this.buildView(titles);
                TitleListDetailView.this.hideBusyIndicator();
            }
        });
    }

    private void getColumns(final AsyncCallback<List<UiColumn>> callback) {
        SpecificationServiceAsync specService = (SpecificationServiceAsync)GWT.create(SpecificationService.class);
        specService.getTable(TABLE_NAME, this.spec, (AsyncCallback<UiTable>)new NeptuneAsyncCallback<UiTable>(){

            public void onNeptuneFailure(Throwable caught) {
                callback.onFailure(caught);
            }

            public void onNeptuneSuccess(UiTable table) {
                callback.onSuccess(table.getColumns());
            }
        });
    }

    public void refresh() {
        this.mainContainer.clear();
        this.tableButtonsContainer.clear();
        this.roundedContainer.clear();
        this.showBusyIndicator();
        this.fetchMetadata();
    }

    public void commit() {
        this.previousName = this.record.getTitleList().getName();
        this.previousDescription = this.record.getTitleList().getDescription();
        this.record.getTitleList().setName(this.nameWidget.getValue());
        this.record.getTitleList().setDescription(this.descriptionWidget.getValue());
    }

    private void removeTitlesFromRecord(List<Long> titleIds) {
        block0: for (long id : titleIds) {
            for (UiTitle t : this.record.getTitleList().getTitles()) {
                if (t.getTitleId() != id) continue;
                this.record.getTitleList().getTitles().remove(t);
                continue block0;
            }
        }
    }

    public UiTitleListRecord getRecord() {
        return this.record;
    }

    public void revert() {
        this.record.getTitleList().setName(this.previousName);
        this.record.getTitleList().setDescription(this.previousDescription);
    }

    public String getStyleName() {
        return null;
    }

    public Widget getWidget() {
        return this.mainContainer;
    }

    public void release() {
    }

    public void saveFailed(Throwable throwable) {
        if (throwable instanceof UiValidationException) {
            this.revert();
            this.errorMessagePanel.showErrorCodeMessages(((UiValidationException)((Object)throwable)).getErrorCodes());
            this.errorMessagePanel.setVisible(true);
            this.successMessagePanel.setVisible(false);
        }
    }

    private void buildView(UiTitleList titles) {
        this.mainContainer.add((Widget)new HeaderPanel(String.valueOf(this.constants.titleListTitlesHeader()) + this.record.getTitleList().getName()));
        this.mainContainer.add((Widget)this.errorMessagePanel);
        this.mainContainer.add((Widget)this.successMessagePanel);
        Widget titleTable = this.prepareTable(titles);
        this.tableButtonsContainer.add(titleTable);
        this.tableButtonsContainer.add(this.createButtonPanel((FlexTableContainer)titleTable));
        VerticalContainer propertyTableContainer = new VerticalContainer();
        propertyTableContainer.add((Widget)this.formContainer);
        propertyTableContainer.setCellHorizontalAlignment((Widget)this.formContainer, VerticalContainer.ALIGN_LEFT);
        propertyTableContainer.add((Widget)this.tableButtonsContainer);
        this.roundedContainer.add((Widget)propertyTableContainer);
        this.mainContainer.add((Widget)this.roundedContainer);
    }

    private Widget createButtonPanel(final FlexTableContainer titleTable) {
        SimplePanel buttonPanel = new SimplePanel();
        HorizontalContainer buttonContainer = new HorizontalContainer();
        if (this.security.isUserInRole(Permissions.ASSETLIST_MODIFY_PERMISSION)) {
            ButtonWidget saveButton = new ButtonWidget(this.constants.saveButtonName(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    TitleListDetailView.this.callback.save((DetailView)TitleListDetailView.this);
                }
            });
            saveButton.addStyleDependentName("commit-button");
            ButtonWidget addTitlesButton = new ButtonWidget(this.constants.addTitlesButtonName(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    History.newItem((String)("Content.Search?titleListId=" + TitleListDetailView.this.record.getKey().getId()));
                }
            });
            addTitlesButton.addStyleDependentName("commit-button");
            ButtonWidget removeTitlesButton = new ButtonWidget(this.constants.removeTitlesButtonName(), new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ArrayList<Long> titlesToRemove = new ArrayList<Long>();
                    int i = DATA_ROW;
                    while (i < titleTable.getRowCount()) {
                        if (((CheckBoxWidget)titleTable.getWidget(i, CHECKBOX_COLUMN)).getValue().booleanValue()) {
                            titlesToRemove.add(Long.parseLong(titleTable.getText(i, TITLE_ID_COLUMN)));
                        }
                        ++i;
                    }
                    if (titlesToRemove.size() == 0) {
                        TitleListDetailView.this.errorMessagePanel.showErrorMessage(TitleListDetailView.this.constants.titleSelectionRequired());
                        TitleListDetailView.this.errorMessagePanel.setVisible(true);
                        TitleListDetailView.this.successMessagePanel.setVisible(false);
                        TitleListDetailView.this.refresh();
                        return;
                    }
                    TitleListDetailView.this.removeTitles(TitleListDetailView.this.record.getKey().getId(), titlesToRemove);
                }
            });
            removeTitlesButton.addStyleDependentName("dataloss-button");
            buttonContainer.add((Widget)saveButton);
            buttonContainer.add((Widget)addTitlesButton);
            buttonContainer.add((Widget)removeTitlesButton);
        }
        ButtonWidget cancelTitlesButton = new ButtonWidget(this.constants.cancelButtonName(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                TitleListDetailView.this.callback.cancel((DetailView)TitleListDetailView.this);
            }
        });
        cancelTitlesButton.addStyleDependentName("action-button");
        buttonContainer.add((Widget)cancelTitlesButton);
        buttonPanel.add((Widget)buttonContainer);
        return buttonPanel;
    }

    private void removeTitles(long titleListId, final List<Long> titleIds) {
        this.service.removeTitlesFromTitleList(titleListId, titleIds, (AsyncCallback<?>)new NeptuneAsyncCallback<Void>(){

            public void onNeptuneFailure(Throwable caught) {
                StringBuilder sb = new StringBuilder();
                Iterator iterator = titleIds.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(id);
                }
                TitleListDetailView.this.errorMessagePanel.showErrorMessage(String.valueOf(TitleListDetailView.this.constants.removeTitlesFailureMessage()) + sb.toString());
                TitleListDetailView.this.errorMessagePanel.setVisible(true);
                TitleListDetailView.this.successMessagePanel.setVisible(false);
                TitleListDetailView.this.refresh();
            }

            public void onNeptuneSuccess(Void result) {
                StringBuilder sb = new StringBuilder();
                Iterator iterator = titleIds.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(id);
                }
                TitleListDetailView.this.removeTitlesFromRecord(titleIds);
                TitleListDetailView.this.successMessagePanel.showSuccessMessage(String.valueOf(TitleListDetailView.this.constants.removeTitlesSuccessMessage()) + " " + sb.toString());
                TitleListDetailView.this.successMessagePanel.setVisible(true);
                TitleListDetailView.this.errorMessagePanel.setVisible(false);
                TitleListDetailView.this.refresh();
            }
        });
    }

    private Widget prepareTable(UiTitleList titles) {
        RowDragController tableRowDragController = new RowDragController((AbsolutePanel)RootPanel.get());
        tableRowDragController.addDragHandler((DragHandler)new DragHandlerAdapter());
        final FlexTableContainer table = new FlexTableContainer();
        RowDropController flexTableRowDropController = new RowDropController(table, new MoveCallback(){

            @Override
            public void move(int currentIndex, int newIndex) {
                TitleListDetailView.this.record.getTitleList().move(--currentIndex, --newIndex);
            }
        });
        tableRowDragController.registerDropController((DropController)flexTableRowDropController);
        ArrayList<String> internalColumnNames = new ArrayList<String>();
        table.getRowFormatter().addStyleName(0, "table-header-row");
        int columnIndex = 0;
        table.setWidget(0, columnIndex++, (Widget)new LabelWidget(""));
        if (this.security.isUserInRole(Permissions.ASSETLIST_MODIFY_PERMISSION)) {
            final CheckBoxWidget headerChkBox = new CheckBoxWidget();
            headerChkBox.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    int i = 0;
                    while (i < table.getRowCount()) {
                        ((CheckBoxWidget)table.getWidget(i, CHECKBOX_COLUMN)).setValue(headerChkBox.getValue());
                        ++i;
                    }
                }
            });
            table.setWidget(0, columnIndex++, (Widget)headerChkBox);
        }
        for (UiColumn col : this.columns) {
            table.getRowFormatter().addStyleName(0, "table-body");
            LabelWidget label = new LabelWidget(col.getDisplayName());
            label.addStyleName("table-data-text");
            table.setWidget(0, columnIndex++, (Widget)label);
            internalColumnNames.add(TableColumnNameHelper.getColumnName(col.getName(), col.getSectionName()));
        }
        Iterator<Object> iterator = titles.getTitles().iterator();
        while (iterator.hasNext()) {
            UiTitle t;
            final UiTitle title = t = (UiTitle)iterator.next();
            int lastRow = table.getRowCount();
            table.insertRow(lastRow);
            ImageWidget handle = new ImageWidget(DRAG_HANDLE_IMAGE_URL);
            table.setWidget(lastRow, 0, (Widget)handle);
            tableRowDragController.makeDraggable((Widget)handle);
            if (this.security.isUserInRole(Permissions.ASSETLIST_MODIFY_PERMISSION)) {
                CheckBoxWidget dataRowChkbox = new CheckBoxWidget();
                dataRowChkbox.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (((CheckBoxWidget)table.getWidget(0, CHECKBOX_COLUMN)).getValue().booleanValue()) {
                            ((CheckBoxWidget)table.getWidget(0, CHECKBOX_COLUMN)).setValue(Boolean.valueOf(false));
                        }
                    }
                });
                table.setWidget(lastRow, 1, (Widget)dataRowChkbox);
            }
            String styleName = lastRow % 2 == 0 ? "table-data-even-row" : "table-data-odd-row";
            table.getRowFormatter().setStyleName(lastRow, styleName);
            for (UiField f : t.getAsset().getFields()) {
                int col;
                String fieldInternalColumnName = TableColumnNameHelper.getColumnName(f.getName(), f.getParentAssetType());
                int colIndex = this.find(internalColumnNames, fieldInternalColumnName);
                if (colIndex == -1) continue;
                int n = col = this.security.isUserInRole(Permissions.ASSETLIST_MODIFY_PERMISSION) ? colIndex + 2 : colIndex + 1;
                if (fieldInternalColumnName.equalsIgnoreCase(ID_COLUMN_NAME) && this.security.isUserInRole(Permissions.ASSET_VIEW_PERMISSION)) {
                    LabelWidget cellText = new LabelWidget(f.getValue());
                    cellText.setStyleName("table-data-link");
                    cellText.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            History.newItem((String)("Content.Search.Id=" + title.getTitleId()));
                        }
                    });
                    table.setWidget(lastRow, col, (Widget)cellText);
                    continue;
                }
                table.setText(lastRow, col, f.getValue());
            }
        }
        return table;
    }

    private int find(List<String> names, String name) {
        int i = 0;
        while (i < names.size()) {
            if (names.get(i).equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void showBusyIndicator() {
        this.busyIndicator.center();
    }

    private void hideBusyIndicator() {
        this.busyIndicator.hide();
    }
}

